/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.xml.CastorUtils;
import org.opennms.netmgt.config.SnmpAssetAdapterConfig;
import org.opennms.netmgt.config.snmpAsset.adapter.AssetField;
import org.opennms.netmgt.config.snmpAsset.adapter.Package;
import org.opennms.netmgt.config.snmpAsset.adapter.SnmpAssetAdapterConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnmpAssetAdapterConfigManager
implements SnmpAssetAdapterConfig {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpAssetAdapterConfigManager.class);
    private final ReadWriteLock m_globalLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_globalLock.readLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();
    private long m_lastModified;
    private SnmpAssetAdapterConfiguration m_config;

    public SnmpAssetAdapterConfigManager() {
    }

    public SnmpAssetAdapterConfigManager(long lastModified, InputStream reader) throws MarshalException, ValidationException, IOException {
        this.reloadXML(lastModified, reader);
    }

    @Override
    public Lock getReadLock() {
        return this.m_readLock;
    }

    @Override
    public Lock getWriteLock() {
        return this.m_writeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reloadXML(long lastModified, InputStream reader) throws MarshalException, ValidationException, IOException {
        this.getWriteLock().lock();
        try {
            this.m_config = (SnmpAssetAdapterConfiguration)CastorUtils.unmarshal(SnmpAssetAdapterConfiguration.class, (InputStream)reader);
            this.m_lastModified = lastModified;
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() throws IOException, MarshalException, ValidationException {
        this.getWriteLock().lock();
        try {
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.SNMP_ASSET_ADAPTER_CONFIG_FILE_NAME);
            long lastModified = cfgFile.lastModified();
            if (lastModified > this.m_lastModified) {
                LOG.debug("init: config file path: {}", (Object)cfgFile.getPath());
                this.reloadXML(lastModified, new FileInputStream(cfgFile));
                LOG.debug("init: finished loading config file: {}", (Object)cfgFile.getPath());
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SnmpAssetAdapterConfiguration getConfiguration() {
        this.getReadLock().lock();
        try {
            SnmpAssetAdapterConfiguration snmpAssetAdapterConfiguration = this.m_config;
            return snmpAssetAdapterConfiguration;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssetField[] getAssetFieldsForAddress(InetAddress address, String sysoid) {
        this.getReadLock().lock();
        try {
            if (sysoid == null) {
                LOG.debug("getAssetFieldsForAddress: SNMP sysoid was null for address {}, returning empty list", (Object)InetAddressUtils.str((InetAddress)address));
                AssetField[] assetFieldArray = new AssetField[]{};
                return assetFieldArray;
            }
            ArrayList retval = new ArrayList();
            for (Package pkg : this.m_config.getPackageCollection()) {
                String pkgSysoid = pkg.getPackageChoice().getSysoid();
                String pkgSysoidMask = pkg.getPackageChoice().getSysoidMask();
                if (pkgSysoid != null) {
                    if (!pkgSysoid.equals(sysoid)) continue;
                    retval.addAll(pkg.getAssetFieldCollection());
                    continue;
                }
                if (pkgSysoidMask != null) {
                    if (!sysoid.startsWith(pkgSysoidMask)) continue;
                    retval.addAll(pkg.getAssetFieldCollection());
                    continue;
                }
                LOG.warn("getAssetFieldsForAddress: Unexpected condition: both sysoid and sysoidMask are null on package {}", (Object)pkg.getName());
            }
            if (retval.size() == 0) {
                LOG.debug("getAssetFieldsForAddress: Zero AssetField matches returned for {} with sysoid: {}", (Object)InetAddressUtils.str((InetAddress)address), (Object)sysoid);
            }
            AssetField[] assetFieldArray = retval.toArray(new AssetField[0]);
            return assetFieldArray;
        }
        finally {
            this.getReadLock().unlock();
        }
    }
}

