/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.config.SnmpAssetAdapterConfig;
import org.opennms.netmgt.config.SnmpAssetAdapterConfigManager;

public class SnmpAssetAdapterConfigFactory {
    private final SnmpAssetAdapterConfigManager m_config;

    public SnmpAssetAdapterConfigFactory() throws MarshalException, ValidationException, IOException {
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.SNMP_ASSET_ADAPTER_CONFIG_FILE_NAME);
        LogUtils.debugf((Object)this, (String)"init: config file path: %s", (Object[])new Object[]{cfgFile.getPath()});
        FileInputStream reader = new FileInputStream(cfgFile);
        this.m_config = new SnmpAssetAdapterConfigManager(cfgFile.lastModified(), reader);
        IOUtils.closeQuietly((InputStream)reader);
    }

    public void reload() throws IOException, MarshalException, ValidationException {
        this.m_config.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(String xml) throws IOException {
        this.m_config.getWriteLock().lock();
        try {
            if (xml != null) {
                long timestamp = System.currentTimeMillis();
                File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.SNMP_ASSET_ADAPTER_CONFIG_FILE_NAME);
                LogUtils.debugf((Object)this, (String)"saveXml: saving config file at %d: %s", (Object[])new Object[]{timestamp, cfgFile.getPath()});
                OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(cfgFile), "UTF-8");
                fileWriter.write(xml);
                ((Writer)fileWriter).flush();
                ((Writer)fileWriter).close();
                LogUtils.debugf((Object)this, (String)"saveXml: finished saving config file: %s", (Object[])new Object[]{cfgFile.getPath()});
            }
        }
        finally {
            this.m_config.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnmpAssetAdapterConfig getInstance() {
        this.m_config.getReadLock().lock();
        try {
            SnmpAssetAdapterConfigManager snmpAssetAdapterConfigManager = this.m_config;
            return snmpAssetAdapterConfigManager;
        }
        finally {
            this.m_config.getReadLock().unlock();
        }
    }
}

