/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmpinterfacepoller.pollable;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.rpc.api.RpcClientFactory;
import org.opennms.core.rpc.mock.MockRpcClientFactory;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;
import org.opennms.netmgt.snmp.proxy.common.LocationAwareSnmpClientRpcImpl;
import org.opennms.netmgt.snmpinterfacepoller.SnmpPollInterfaceMonitor;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollableSnmpInterface;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-mockDao.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/applicationContext-proxy-snmp.xml"})
@JUnitConfigurationEnvironment
@JUnitSnmpAgent(host="192.168.2.2", resource="classpath:/snmpInterfacePollerTestData.properties")
public class SnmpInterfacePollerIT {
    private LocationAwareSnmpClient locationAwareSnmpClient;
    List<PollableSnmpInterface.SnmpMinimalPollInterface> interfacesResult = new ArrayList<PollableSnmpInterface.SnmpMinimalPollInterface>();
    private SnmpPollInterfaceMonitor snmpInterfaceMonitor;
    @Autowired
    private SnmpPeerFactory snmpPeerFactory;

    @Before
    public void setup() {
        this.locationAwareSnmpClient = new LocationAwareSnmpClientRpcImpl((RpcClientFactory)new MockRpcClientFactory());
        this.snmpInterfaceMonitor = new SnmpPollInterfaceMonitor(this.locationAwareSnmpClient);
        SnmpPeerFactory.setInstance((SnmpPeerFactory)this.snmpPeerFactory);
        PollableSnmpInterface.SnmpMinimalPollInterface iface = new PollableSnmpInterface.SnmpMinimalPollInterface(6, 0, 0);
        this.interfacesResult.add(iface);
    }

    @Test
    public void testSnmpInterfacePoll() throws UnknownHostException {
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.getInetAddress((String)"192.168.2.2"));
        this.interfacesResult = this.snmpInterfaceMonitor.poll(agentConfig, this.interfacesResult);
        Assert.assertEquals((long)1L, (long)this.interfacesResult.get(0).getStatus().getStatusCode());
        Assert.assertEquals((long)1L, (long)this.interfacesResult.get(0).getAdminstatus());
        Assert.assertEquals((long)2L, (long)this.interfacesResult.get(0).getOperstatus());
    }
}

