/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.pollables;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.opennms.core.rpc.api.RequestTimedOutException;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.collection.api.PersisterFactory;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.PollerConfigFactory;
import org.opennms.netmgt.config.dao.outages.api.OverrideablePollOutagesDao;
import org.opennms.netmgt.config.dao.outages.api.ReadablePollOutagesDao;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Service;
import org.opennms.netmgt.dao.mock.EventAnticipator;
import org.opennms.netmgt.dao.mock.MockEventIpcManager;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.filter.api.FilterDao;
import org.opennms.netmgt.mock.MockPersisterFactory;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.poller.LocationAwarePollerClient;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.PollerRequestBuilder;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.poller.ServiceMonitorAdaptor;
import org.opennms.netmgt.poller.mock.MockPollContext;
import org.opennms.netmgt.poller.pollables.PollContext;
import org.opennms.netmgt.poller.pollables.PollableInterface;
import org.opennms.netmgt.poller.pollables.PollableNetwork;
import org.opennms.netmgt.poller.pollables.PollableNode;
import org.opennms.netmgt.poller.pollables.PollableService;
import org.opennms.netmgt.poller.pollables.PollableServiceConfig;
import org.opennms.netmgt.scheduler.Schedule;
import org.opennms.netmgt.scheduler.Timer;
import org.opennms.netmgt.scheduler.mock.MockTimer;
import org.opennms.netmgt.threshd.api.ThresholdingService;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-pinger.xml", "classpath:/META-INF/opennms/applicationContext-rpc-client-mock.xml", "classpath:/META-INF/opennms/applicationContext-serviceMonitorRegistry.xml", "classpath:/META-INF/opennms/applicationContext-rpc-poller.xml", "classpath:/META-INF/opennms/applicationContext-mockDao.xml", "classpath:/META-INF/opennms/applicationContext-testPollerConfigDaos.xml"})
@JUnitConfigurationEnvironment(systemProperties={"org.opennms.netmgt.icmp.pingerClass=org.opennms.netmgt.icmp.jna.JnaPinger"})
public class PollableServiceConfigIT {
    @Autowired
    private LocationAwarePollerClient m_locationAwarePollerClient;
    @Autowired
    private OverrideablePollOutagesDao m_pollOutagesDao;

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
    }

    @Test
    public void testPollableServiceConfig() throws Exception {
        FilterDao fd = (FilterDao)Mockito.mock(FilterDao.class);
        FilterDaoFactory.setInstance((FilterDao)fd);
        FileInputStream is = new FileInputStream(new File("src/test/resources/etc/psm-poller-configuration.xml"));
        PollerConfigFactory factory = new PollerConfigFactory(0L, (InputStream)is);
        PollerConfigFactory.setInstance((PollerConfig)factory);
        IOUtils.closeQuietly((InputStream)is);
        MockPersisterFactory persisterFactory = new MockPersisterFactory();
        PollContext context = (PollContext)Mockito.mock(PollContext.class);
        PollableNetwork network = new PollableNetwork(context);
        PollableNode node = network.createNodeIfNecessary(1, "foo", null);
        PollableInterface iface = new PollableInterface(node, InetAddressUtils.addr((String)"127.0.0.1"));
        PollableService svc = new PollableService(iface, "MQ_API_DirectRte_v2");
        Package pkg = factory.getPackage("MapQuest");
        Timer timer = (Timer)Mockito.mock(Timer.class);
        ThresholdingService thresholdingService = (ThresholdingService)Mockito.mock(ThresholdingService.class);
        PollableServiceConfig psc = new PollableServiceConfig(svc, (PollerConfig)factory, pkg, timer, (PersisterFactory)persisterFactory, thresholdingService, this.m_locationAwarePollerClient, (ReadablePollOutagesDao)this.m_pollOutagesDao);
        PollStatus pollStatus = psc.poll();
        MatcherAssert.assertThat((Object)pollStatus.getReason(), (Matcher)org.hamcrest.Matchers.not((Matcher)org.hamcrest.Matchers.containsString((String)"Unexpected exception")));
    }

    @Test
    public void testPollableServiceConfigWithWildcard() throws Exception {
        FilterDao fd = (FilterDao)Mockito.mock(FilterDao.class);
        FilterDaoFactory.setInstance((FilterDao)fd);
        FileInputStream is = new FileInputStream(new File("src/test/resources/etc/wildcard-poller-configuration.xml"));
        PollerConfigFactory factory = new PollerConfigFactory(0L, (InputStream)is);
        PollerConfigFactory.setInstance((PollerConfig)factory);
        IOUtils.closeQuietly((InputStream)is);
        MockPersisterFactory persisterFactory = new MockPersisterFactory();
        PollContext context = (PollContext)Mockito.mock(PollContext.class);
        PollableNetwork network = new PollableNetwork(context);
        PollableNode node = network.createNodeIfNecessary(1, "foo", null);
        PollableInterface iface = new PollableInterface(node, InetAddressUtils.addr((String)"127.0.0.1"));
        Package pkg = factory.getPackage("Default");
        ThresholdingService thresholdingService = (ThresholdingService)Mockito.mock(ThresholdingService.class);
        Timer timer = (Timer)Mockito.mock(Timer.class);
        PollerRequestBuilder pollerRequestBuilder = (PollerRequestBuilder)Mockito.mock(PollerRequestBuilder.class);
        Mockito.when((Object)pollerRequestBuilder.withMonitor((ServiceMonitor)Matchers.any())).thenReturn((Object)pollerRequestBuilder);
        Mockito.when((Object)pollerRequestBuilder.withService((MonitoredService)Matchers.any())).thenReturn((Object)pollerRequestBuilder);
        Mockito.when((Object)pollerRequestBuilder.withTimeToLive((Long)Matchers.any())).thenReturn((Object)pollerRequestBuilder);
        Mockito.when((Object)pollerRequestBuilder.withAdaptor((ServiceMonitorAdaptor)Matchers.any())).thenReturn((Object)pollerRequestBuilder);
        LocationAwarePollerClient locationAwarePollerClient = (LocationAwarePollerClient)Mockito.mock(LocationAwarePollerClient.class);
        Mockito.when((Object)locationAwarePollerClient.poll()).thenReturn((Object)pollerRequestBuilder);
        PollableService svc = new PollableService(iface, "HTTP-www.example.com");
        PollableServiceConfig psc = new PollableServiceConfig(svc, (PollerConfig)factory, pkg, timer, (PersisterFactory)persisterFactory, thresholdingService, locationAwarePollerClient, (ReadablePollOutagesDao)this.m_pollOutagesDao);
        psc.poll();
        ((PollerRequestBuilder)Mockito.verify((Object)pollerRequestBuilder)).withMonitor(factory.getServiceMonitor("HTTP"));
    }

    @Test
    public void returnsUnknownOnRequestTimedOutException() throws Exception {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally((Throwable)new RequestTimedOutException((Throwable)new Exception("Test")));
        LocationAwarePollerClient client = (LocationAwarePollerClient)Mockito.mock(LocationAwarePollerClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)client.poll().withService((MonitoredService)Matchers.any()).withMonitor((ServiceMonitor)Matchers.any()).withTimeToLive((Long)Matchers.any()).withAttributes((Map)Matchers.any()).withAdaptor((ServiceMonitorAdaptor)Matchers.any()).withAdaptor((ServiceMonitorAdaptor)Matchers.any()).withPatternVariables((Map)Matchers.any()).execute()).thenReturn(future);
        PollableService pollableSvc = (PollableService)Mockito.mock(PollableService.class);
        Mockito.when((Object)pollableSvc.getSvcName()).thenReturn((Object)"SVC");
        Service configuredSvc = new Service();
        configuredSvc.setName("SVC");
        Package pkg = (Package)Mockito.mock(Package.class);
        Mockito.when((Object)pkg.findService("SVC")).thenReturn(Optional.of(new Package.ServiceMatch(configuredSvc)));
        PollerConfig pollerConfig = (PollerConfig)Mockito.mock(PollerConfig.class);
        Timer timer = (Timer)Mockito.mock(Timer.class);
        PersisterFactory persisterFactory = (PersisterFactory)Mockito.mock(PersisterFactory.class);
        ThresholdingService thresholdingService = (ThresholdingService)Mockito.mock(ThresholdingService.class);
        PollableServiceConfig psc = new PollableServiceConfig(pollableSvc, pollerConfig, pkg, timer, persisterFactory, thresholdingService, client, (ReadablePollOutagesDao)this.m_pollOutagesDao);
        PollStatus pollStatus = psc.poll();
        Assert.assertTrue((boolean)pollStatus.isUnknown());
    }

    @Test
    public void testDowntimeModelDeleteNever() throws Exception {
        MockTimer timer = new MockTimer();
        timer.setCurrentTime(0L);
        FilterDao fd = (FilterDao)Mockito.mock(FilterDao.class);
        FilterDaoFactory.setInstance((FilterDao)fd);
        FileInputStream is = new FileInputStream(new File("src/test/resources/etc/downtime-never-poller-configuration.xml"));
        PollerConfigFactory factory = new PollerConfigFactory(0L, (InputStream)is);
        PollerConfigFactory.setInstance((PollerConfig)factory);
        IOUtils.closeQuietly((InputStream)is);
        MockPersisterFactory persisterFactory = new MockPersisterFactory();
        MockEventIpcManager eventMgr = new MockEventIpcManager();
        MockPollContext context = new MockPollContext();
        context.setEventMgr((EventIpcManager)eventMgr);
        PollableNetwork network = new PollableNetwork((PollContext)context);
        PollableNode node = network.createNodeIfNecessary(1, "foo", null);
        PollableInterface iface = new PollableInterface(node, InetAddressUtils.UNPINGABLE_ADDRESS);
        PollableService svc = new PollableService(iface, "ICMP");
        Package pkg = factory.getPackage("DowntimeNever");
        Schedule sched = (Schedule)Mockito.mock(Schedule.class);
        ThresholdingService thresholdingService = (ThresholdingService)Mockito.mock(ThresholdingService.class);
        PollableServiceConfig psc = new PollableServiceConfig(svc, (PollerConfig)factory, pkg, (Timer)timer, (PersisterFactory)persisterFactory, thresholdingService, this.m_locationAwarePollerClient, (ReadablePollOutagesDao)this.m_pollOutagesDao);
        svc.setPollConfig(psc);
        svc.setSchedule(sched);
        svc.updateStatus(PollStatus.down((String)"so down right now"));
        Assert.assertTrue((boolean)svc.getStatus().isDown());
        timer.setCurrentTime(5L);
        Assert.assertEquals((long)20L, (long)psc.getInterval());
        timer.setCurrentTime(10L);
        Assert.assertEquals((long)20L, (long)psc.getInterval());
        timer.setCurrentTime(18L);
        Assert.assertEquals((long)20L, (long)psc.getInterval());
        timer.setCurrentTime(25L);
        Assert.assertEquals((long)20L, (long)psc.getInterval());
        timer.setCurrentTime(205L);
        Assert.assertEquals((long)0L, (long)psc.getInterval());
        eventMgr.getEventAnticipator().verifyAnticipated();
    }

    @Test
    public void testDowntimeModelDeleteManaged() throws Exception {
        MockTimer timer = new MockTimer();
        timer.setCurrentTime(0L);
        FilterDao fd = (FilterDao)Mockito.mock(FilterDao.class);
        FilterDaoFactory.setInstance((FilterDao)fd);
        FileInputStream is = new FileInputStream(new File("src/test/resources/etc/downtime-managed-poller-configuration.xml"));
        PollerConfigFactory factory = new PollerConfigFactory(0L, (InputStream)is);
        PollerConfigFactory.setInstance((PollerConfig)factory);
        IOUtils.closeQuietly((InputStream)is);
        MockPersisterFactory persisterFactory = new MockPersisterFactory();
        MockEventIpcManager eventMgr = new MockEventIpcManager();
        MockPollContext context = new MockPollContext();
        context.setEventMgr((EventIpcManager)eventMgr);
        PollableNetwork network = new PollableNetwork((PollContext)context);
        PollableNode node = network.createNodeIfNecessary(1, "foo", null);
        PollableInterface iface = new PollableInterface(node, InetAddressUtils.UNPINGABLE_ADDRESS);
        PollableService svc = new PollableService(iface, "ICMP");
        Package pkg = factory.getPackage("DowntimeNever");
        Schedule sched = (Schedule)Mockito.mock(Schedule.class);
        ThresholdingService thresholdingService = (ThresholdingService)Mockito.mock(ThresholdingService.class);
        PollableServiceConfig psc = new PollableServiceConfig(svc, (PollerConfig)factory, pkg, (Timer)timer, (PersisterFactory)persisterFactory, thresholdingService, this.m_locationAwarePollerClient, (ReadablePollOutagesDao)this.m_pollOutagesDao);
        svc.setPollConfig(psc);
        svc.setSchedule(sched);
        svc.updateStatus(PollStatus.down((String)"so down right now"));
        Assert.assertTrue((boolean)svc.getStatus().isDown());
        timer.setCurrentTime(5L);
        Assert.assertEquals((long)20L, (long)psc.getInterval());
        timer.setCurrentTime(10L);
        Assert.assertEquals((long)20L, (long)psc.getInterval());
        timer.setCurrentTime(18L);
        Assert.assertEquals((long)20L, (long)psc.getInterval());
        timer.setCurrentTime(25L);
        Assert.assertEquals((long)20L, (long)psc.getInterval());
        EventAnticipator anticipator = eventMgr.getEventAnticipator();
        Event expectedEvent = new EventBuilder("uei.opennms.org/nodes/deleteService", "Test").setNodeid(1L).setInterface(InetAddressUtils.UNPINGABLE_ADDRESS).setService("ICMP").getEvent();
        anticipator.anticipateEvent(expectedEvent);
        timer.setCurrentTime(205L);
        Assert.assertEquals((long)-1L, (long)psc.getInterval());
        Event sent = (Event)anticipator.getAnticipatedEventsReceived().get(0);
        Assert.assertNull((Object)sent.getParm("ignoreUnmanaged"));
        anticipator.verifyAnticipated();
    }

    @Test
    public void testDowntimeModelDeleteAlways() throws Exception {
        MockTimer timer = new MockTimer();
        timer.setCurrentTime(0L);
        FilterDao fd = (FilterDao)Mockito.mock(FilterDao.class);
        FilterDaoFactory.setInstance((FilterDao)fd);
        FileInputStream is = new FileInputStream(new File("src/test/resources/etc/downtime-always-poller-configuration.xml"));
        PollerConfigFactory factory = new PollerConfigFactory(0L, (InputStream)is);
        PollerConfigFactory.setInstance((PollerConfig)factory);
        IOUtils.closeQuietly((InputStream)is);
        MockPersisterFactory persisterFactory = new MockPersisterFactory();
        MockEventIpcManager eventMgr = new MockEventIpcManager();
        MockPollContext context = new MockPollContext();
        context.setEventMgr((EventIpcManager)eventMgr);
        PollableNetwork network = new PollableNetwork((PollContext)context);
        PollableNode node = network.createNodeIfNecessary(1, "foo", null);
        PollableInterface iface = new PollableInterface(node, InetAddressUtils.UNPINGABLE_ADDRESS);
        PollableService svc = new PollableService(iface, "ICMP");
        Package pkg = factory.getPackage("DowntimeNever");
        Schedule sched = (Schedule)Mockito.mock(Schedule.class);
        ThresholdingService thresholdingService = (ThresholdingService)Mockito.mock(ThresholdingService.class);
        PollableServiceConfig psc = new PollableServiceConfig(svc, (PollerConfig)factory, pkg, (Timer)timer, (PersisterFactory)persisterFactory, thresholdingService, this.m_locationAwarePollerClient, (ReadablePollOutagesDao)this.m_pollOutagesDao);
        svc.setPollConfig(psc);
        svc.setSchedule(sched);
        svc.updateStatus(PollStatus.down((String)"so down right now"));
        Assert.assertTrue((boolean)svc.getStatus().isDown());
        timer.setCurrentTime(5L);
        Assert.assertEquals((long)20L, (long)psc.getInterval());
        timer.setCurrentTime(10L);
        Assert.assertEquals((long)20L, (long)psc.getInterval());
        timer.setCurrentTime(18L);
        Assert.assertEquals((long)20L, (long)psc.getInterval());
        timer.setCurrentTime(25L);
        Assert.assertEquals((long)20L, (long)psc.getInterval());
        EventAnticipator anticipator = eventMgr.getEventAnticipator();
        Event expectedEvent = new EventBuilder("uei.opennms.org/nodes/deleteService", "Test").setNodeid(1L).setInterface(InetAddressUtils.UNPINGABLE_ADDRESS).setService("ICMP").getEvent();
        anticipator.anticipateEvent(expectedEvent);
        timer.setCurrentTime(205L);
        Assert.assertEquals((long)-1L, (long)psc.getInterval());
        Event sent = (Event)anticipator.getAnticipatedEventsReceived().get(0);
        Assert.assertNotNull((Object)sent.getParm("ignoreUnmanaged"));
        Assert.assertEquals((Object)"true", (Object)sent.getParm("ignoreUnmanaged").getValue().getContent());
        anticipator.verifyAnticipated();
    }
}

