/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.pollables;

import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.MockDatabase;
import org.opennms.core.test.db.TemporaryDatabaseAware;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.collection.api.PersisterFactory;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.dao.outages.api.OverrideablePollOutagesDao;
import org.opennms.netmgt.config.dao.thresholding.api.OverrideableThreshdDao;
import org.opennms.netmgt.config.dao.thresholding.api.OverrideableThresholdingDao;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Rrd;
import org.opennms.netmgt.config.poller.outages.Outages;
import org.opennms.netmgt.dao.mock.MockEventIpcManager;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.filter.api.FilterDao;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.pollables.LatencyStoringServiceMonitorAdaptor;
import org.opennms.netmgt.poller.support.AbstractServiceMonitor;
import org.opennms.netmgt.threshd.api.ThresholdingService;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.opennms.test.mock.EasyMockUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-thresholding.xml", "classpath:/META-INF/opennms/applicationContext-testPostgresBlobStore.xml", "classpath:/META-INF/opennms/applicationContext-testThresholdingDaos.xml", "classpath:/META-INF/opennms/applicationContext-testPollerConfigDaos.xml", "classpath:/META-INF/opennms/applicationContext-rpc-utils.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase(tempDbClass=MockDatabase.class)
public class LatencyStoringServiceMonitorAdaptorIT
implements TemporaryDatabaseAware<MockDatabase> {
    private EasyMockUtils m_mocks;
    private PollerConfig m_pollerConfig;
    private MockDatabase m_db;
    @Autowired
    private MockEventIpcManager m_eventIpcManager;
    @Autowired
    private ApplicationContext m_context;
    @Autowired
    private PersisterFactory m_persisterFactory;
    @Autowired
    private ThresholdingService m_thresholdingService;
    @Autowired
    private OverrideableThreshdDao m_threshdDao;
    @Autowired
    private OverrideableThresholdingDao m_thresholdingDao;
    @Autowired
    private OverrideablePollOutagesDao m_pollOutagesDao;

    public void setTemporaryDatabase(MockDatabase database) {
        this.m_db = database;
    }

    @Before
    public void setUp() throws Exception {
        BeanUtils.setStaticApplicationContext((ApplicationContext)this.m_context);
        this.m_mocks = new EasyMockUtils();
        this.m_pollerConfig = (PollerConfig)this.m_mocks.createMock(PollerConfig.class);
        MockLogAppender.setupLogging();
        String previousOpennmsHome = System.setProperty("opennms.home", "src/test/resources");
        this.m_pollOutagesDao.overrideConfig(this.getClass().getResourceAsStream("/etc/poll-outages.xml"));
        this.m_threshdDao.overrideConfig(this.getClass().getResourceAsStream("/etc/threshd-configuration.xml"));
        this.m_thresholdingDao.overrideConfig(this.getClass().getResourceAsStream("/etc/thresholds.xml"));
        System.setProperty("opennms.home", previousOpennmsHome);
        MockNetwork network = new MockNetwork();
        network.setCriticalService("ICMP");
        network.addNode(1, "testNode");
        network.addInterface("127.0.0.1");
        network.setIfAlias("eth0");
        network.addService("ICMP");
        network.addService("SNMP");
        this.m_db.populate(network);
    }

    @After
    public void tearDown() throws Throwable {
        MockLogAppender.assertNoWarningsOrGreater();
    }

    @Test
    @JUnitTemporaryDatabase(tempDbClass=MockDatabase.class)
    public void testThresholds() throws Exception {
        EventBuilder bldr = new EventBuilder("uei.opennms.org/threshold/highThresholdExceeded", "LatencyStoringServiceMonitorAdaptorTest");
        bldr.setNodeid(1L);
        bldr.setInterface(InetAddressUtils.addr((String)"127.0.0.1"));
        bldr.setService("ICMP");
        this.m_eventIpcManager.getEventAnticipator().anticipateEvent(bldr.getEvent());
        bldr = new EventBuilder("uei.opennms.org/threshold/highThresholdRearmed", "LatencyStoringServiceMonitorAdaptorTest");
        bldr.setNodeid(1L);
        bldr.setInterface(InetAddressUtils.addr((String)"127.0.0.1"));
        bldr.setService("ICMP");
        this.m_eventIpcManager.getEventAnticipator().anticipateEvent(bldr.getEvent());
        this.executeThresholdTest(new Double[]{100.0, 10.0});
        this.m_eventIpcManager.getEventAnticipator().verifyAnticipated();
    }

    @Test
    @JUnitTemporaryDatabase(tempDbClass=MockDatabase.class)
    public void testThresholdsWithScheduledOutage() throws Exception {
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        StringBuilder sb = new StringBuilder("<?xml version=\"1.0\"?>");
        sb.append("<outages>");
        sb.append("<outage name=\"junit outage\" type=\"specific\">");
        sb.append("<time begins=\"");
        sb.append(formatter.format(new Date(System.currentTimeMillis() - 3600000L)));
        sb.append("\" ends=\"");
        sb.append(formatter.format(new Date(System.currentTimeMillis() + 3600000L)));
        sb.append("\"/>");
        sb.append("<interface address=\"match-any\"/>");
        sb.append("</outage>");
        sb.append("</outages>");
        File file = new File("target/poll-outages.xml");
        FileWriter writer = new FileWriter(file);
        writer.write(sb.toString());
        writer.close();
        Outages oldConfig = (Outages)this.m_pollOutagesDao.getReadOnlyConfig();
        this.m_pollOutagesDao.overrideConfig(new FileSystemResource(file).getInputStream());
        this.executeThresholdTest(new Double[]{100.0});
        this.m_eventIpcManager.getEventAnticipator().verifyAnticipated();
        this.m_pollOutagesDao.overrideConfig((Object)oldConfig);
        file.delete();
    }

    private void executeThresholdTest(Double[] rtValues) throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("rrd-repository", "/tmp");
        parameters.put("ds-name", "icmp");
        parameters.put("rrd-base-name", "icmp");
        parameters.put("thresholding-enabled", "true");
        FilterDao filterDao = (FilterDao)this.m_mocks.createMock(FilterDao.class);
        EasyMock.expect((Object)filterDao.getActiveIPAddressList((String)EasyMock.anyObject())).andReturn(Collections.singletonList(InetAddressUtils.addr((String)"127.0.0.1"))).anyTimes();
        filterDao.flushActiveIpAddressListCache();
        EasyMock.expectLastCall().anyTimes();
        FilterDaoFactory.setInstance((FilterDao)filterDao);
        MonitoredService svc = (MonitoredService)this.m_mocks.createMock(MonitoredService.class);
        EasyMock.expect((Object)svc.getNodeId()).andReturn((Object)1).anyTimes();
        EasyMock.expect((Object)svc.getIpAddr()).andReturn((Object)"127.0.0.1").atLeastOnce();
        EasyMock.expect((Object)svc.getSvcName()).andReturn((Object)"ICMP").atLeastOnce();
        EasyMock.expect((Object)svc.getNodeLocation()).andReturn((Object)"Default").atLeastOnce();
        MockServiceMonitor service = new MockServiceMonitor(rtValues);
        int step = 1;
        List<String> rras = Collections.singletonList("RRA:AVERAGE:0.5:1:2016");
        Package pkg = new Package();
        Rrd rrd = new Rrd();
        rrd.setStep(Integer.valueOf(step));
        rrd.setRras(rras);
        pkg.setRrd(rrd);
        EasyMock.expect((Object)this.m_pollerConfig.getRRAList(pkg)).andReturn(rras).anyTimes();
        EasyMock.expect((Object)this.m_pollerConfig.getStep(pkg)).andReturn((Object)step).anyTimes();
        this.m_mocks.replayAll();
        LatencyStoringServiceMonitorAdaptor adaptor = new LatencyStoringServiceMonitorAdaptor(this.m_pollerConfig, pkg, this.m_persisterFactory, this.m_thresholdingService);
        String previousOpennmsHome = System.setProperty("opennms.home", "src/test/resources");
        this.m_threshdDao.rebuildPackageIpListMap();
        for (int i = 0; i < rtValues.length; ++i) {
            adaptor.handlePollResult(svc, parameters, service.poll(svc, parameters));
            Thread.sleep(1000 * step);
        }
        System.setProperty("opennms.home", previousOpennmsHome);
        this.m_mocks.verifyAll();
    }

    private class MockServiceMonitor
    extends AbstractServiceMonitor {
        private Double[] values;
        private int current = 0;

        public MockServiceMonitor(Double[] values) {
            this.values = values;
        }

        public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
            return PollStatus.get((int)1, (Double)this.values[this.current++]);
        }
    }
}

