/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.web.HttpClientWrapperConfigHelper;
import org.opennms.netmgt.model.notifd.Argument;
import org.opennms.netmgt.notifd.HttpNotificationStrategy;

public class HttpNotificationStrategyTest {
    @Test
    public void shouldExtractUrlFromArgument() {
        String url = "myUrl";
        HttpNotificationStrategy strategy = this.createNotificationStrategyWithSingleArgument("url", url);
        Assert.assertEquals((Object)url, (Object)strategy.getUrl());
    }

    @Test
    public void shouldExtractUrlFromArgumentAsPrefix() {
        String url = "myUrl";
        HttpNotificationStrategy strategy = this.createNotificationStrategyWithSingleArgument("urlWithSuffix", url);
        Assert.assertEquals((Object)url, (Object)strategy.getUrl());
    }

    @Test
    public void shouldExtractUseSystemProperty() {
        HttpNotificationStrategy strategy = this.createNotificationStrategyWithSingleArgument(HttpClientWrapperConfigHelper.PARAMETER_KEYS.useSystemProxy.name(), "true");
        Assert.assertEquals((Object)true, (Object)strategy.getUseSystemProxy());
    }

    @Test
    public void shouldExtractUseSystemPropertyAsPrefix() {
        HttpNotificationStrategy strategy = this.createNotificationStrategyWithSingleArgument(HttpClientWrapperConfigHelper.PARAMETER_KEYS.useSystemProxy.name() + "WithSuffix", "true");
        Assert.assertEquals((Object)true, (Object)strategy.getUseSystemProxy());
    }

    private HttpNotificationStrategy createNotificationStrategyWithSingleArgument(String name, String value) {
        ArrayList<Argument> arguments = new ArrayList<Argument>();
        arguments.add(new Argument(name, null, value, false));
        HttpNotificationStrategy strategy = new HttpNotificationStrategy();
        strategy.setArguments(arguments);
        return strategy;
    }
}

