/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import com.google.common.collect.Lists;
import com.jayway.awaitility.Awaitility;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.opennms.core.test.ConfigurationTestUtils;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.MockDatabase;
import org.opennms.core.test.db.TemporaryDatabaseAware;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.collectd.Collectd;
import org.opennms.netmgt.collectd.MockServiceCollector;
import org.opennms.netmgt.collection.api.AbstractServiceCollector;
import org.opennms.netmgt.collection.api.AttributeType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionException;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.LocationAwareCollectorClient;
import org.opennms.netmgt.collection.api.PersisterFactory;
import org.opennms.netmgt.collection.api.ServiceCollector;
import org.opennms.netmgt.collection.api.ServiceCollectorRegistry;
import org.opennms.netmgt.collection.support.DefaultServiceCollectorRegistry;
import org.opennms.netmgt.collection.support.builder.CollectionSetBuilder;
import org.opennms.netmgt.collection.support.builder.NodeLevelResource;
import org.opennms.netmgt.collection.support.builder.Resource;
import org.opennms.netmgt.config.CollectdConfigFactory;
import org.opennms.netmgt.config.dao.outages.api.OverrideablePollOutagesDao;
import org.opennms.netmgt.config.dao.outages.api.ReadablePollOutagesDao;
import org.opennms.netmgt.config.dao.thresholding.api.OverrideableThreshdDao;
import org.opennms.netmgt.config.dao.thresholding.api.OverrideableThresholdingDao;
import org.opennms.netmgt.dao.api.CategoryDao;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.dao.mock.EventAnticipator;
import org.opennms.netmgt.dao.mock.MockEventIpcManager;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.events.api.EventListener;
import org.opennms.netmgt.filter.api.FilterDao;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.mock.MockPersisterFactory;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.threshd.ThresholdingServiceImpl;
import org.opennms.netmgt.threshd.api.ThresholdingService;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.support.TransactionTemplate;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-pinger.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-thresholding.xml", "classpath:/META-INF/opennms/applicationContext-testPostgresBlobStore.xml", "classpath:/META-INF/opennms/applicationContext-proxy-snmp.xml", "classpath:/META-INF/opennms/applicationContext-rpc-collector.xml", "classpath:/META-INF/opennms/applicationContext-testThresholdingDaos.xml", "classpath:/META-INF/opennms/applicationContext-testPollerConfigDaos.xml"})
@JUnitConfigurationEnvironment(systemProperties={"org.opennms.netmgt.icmp.pingerClass=org.opennms.netmgt.icmp.NullPinger"})
@JUnitTemporaryDatabase(tempDbClass=MockDatabase.class, reuseDatabase=false)
@DirtiesContext
public class ThresholdIT
implements TemporaryDatabaseAware<MockDatabase> {
    private CollectdConfigFactory collectdConfigFactory;
    @Autowired
    private CategoryDao categoryDao;
    @Autowired
    private IpInterfaceDao ifaceDao;
    @Autowired
    private FilterDao filterDao;
    @Autowired
    private DefaultServiceCollectorRegistry serviceCollectorRegistry;
    @Autowired
    private LocationAwareCollectorClient locationAwareCollectorClient;
    @Autowired
    private TransactionTemplate transTemplate;
    @Autowired
    private SessionUtils sessionUtils;
    @Autowired
    private NodeDao nodeDao;
    @Autowired
    private MockEventIpcManager mockEventIpcManager;
    private PersisterFactory persisterFactory = new MockPersisterFactory();
    private MockDatabase mockDatabase;
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    @Autowired
    private ThresholdingService thresholdingService;
    @Autowired
    private OverrideableThreshdDao threshdDao;
    @Autowired
    private OverrideableThresholdingDao thresholdingDao;
    @Autowired
    private OverrideablePollOutagesDao pollOutagesDao;

    @Test
    public void canTriggerThreshold() throws Exception {
        try (InputStream in = ConfigurationTestUtils.getInputStreamForResource((Object)this, (String)"collectd-with-mock-collector.xml");){
            this.collectdConfigFactory = new CollectdConfigFactory(in);
        }
        MyServiceCollector collector = new MyServiceCollector(this.sessionUtils);
        MockServiceCollector.setDelegate((ServiceCollector)collector);
        this.initThreshdFactories("threshd-configuration.xml", "test-thresholds.xml");
        this.threshdDao.rebuildPackageIpListMap();
        this.mockEventIpcManager.addEventListener((EventListener)this.thresholdingService, (Collection)ThresholdingServiceImpl.UEI_LIST);
        Collectd collectd = new Collectd();
        collectd.setCollectdConfigFactory(this.collectdConfigFactory);
        collectd.setIpInterfaceDao(this.ifaceDao);
        collectd.setFilterDao(this.filterDao);
        collectd.setServiceCollectorRegistry((ServiceCollectorRegistry)this.serviceCollectorRegistry);
        collectd.setLocationAwareCollectorClient(this.locationAwareCollectorClient);
        collectd.setTransactionTemplate(this.transTemplate);
        collectd.setNodeDao(this.nodeDao);
        collectd.setEventIpcManager((EventIpcManager)this.mockEventIpcManager);
        collectd.setPersisterFactory(this.persisterFactory);
        collectd.setThresholdingService(this.thresholdingService);
        collectd.setPollOutagesDao((ReadablePollOutagesDao)this.pollOutagesDao);
        collectd.init();
        collectd.start();
        MockNetwork mockNetwork = new MockNetwork();
        mockNetwork.addNode(1, "Router");
        mockNetwork.addInterface("192.168.1.1");
        mockNetwork.addService("Mock");
        this.mockDatabase.populate(mockNetwork);
        this.transTemplate.execute(status -> {
            OnmsNode node = (OnmsNode)this.nodeDao.get((Serializable)Integer.valueOf(1));
            node.setSysObjectId(".1.3.6.1.4.1.8072.3.2.10");
            this.nodeDao.update((Object)node);
            return node;
        });
        EventAnticipator eventAnticipator = this.mockEventIpcManager.getEventAnticipator();
        EventBuilder bldr = new EventBuilder("uei.opennms.org/nodes/nodeGainedService", "Test");
        bldr.setNodeid(1L);
        bldr.setInterface(InetAddressUtils.addr((String)"192.168.1.1"));
        bldr.setService("Mock");
        Event nodeGainedServiceEvent = bldr.getEvent();
        eventAnticipator.anticipateEvent(nodeGainedServiceEvent);
        this.mockEventIpcManager.sendNow(nodeGainedServiceEvent);
        collector.resetLatch(2);
        if (!collector.getLatch().await(30L, TimeUnit.SECONDS)) {
            throw new IllegalStateException("Collector was not called!");
        }
        Assert.assertEquals((long)0L, (long)eventAnticipator.getUnanticipatedEvents().size());
        eventAnticipator.reset();
        EventBuilder threshBldr = new EventBuilder("uei.opennms.org/threshold/highThresholdExceeded", "Test");
        threshBldr.setNodeid(1L);
        threshBldr.setInterface(InetAddressUtils.addr((String)"192.168.1.1"));
        threshBldr.setService("Mock");
        eventAnticipator.anticipateEvent(threshBldr.getEvent());
        this.transTemplate.execute(status -> {
            OnmsNode node = (OnmsNode)this.nodeDao.get((Serializable)Integer.valueOf(1));
            node.addCategory(this.categoryDao.findByName("Development"));
            this.nodeDao.update((Object)node);
            return node;
        });
        bldr = new EventBuilder("uei.opennms.org/nodes/nodeCategoryMembershipChanged", "Test");
        bldr.setNodeid(1L);
        bldr.setInterface(InetAddressUtils.addr((String)"192.168.1.1"));
        Event nodeCategoryChangeEvent = bldr.getEvent();
        eventAnticipator.anticipateEvent(nodeCategoryChangeEvent);
        this.mockEventIpcManager.sendNow(nodeCategoryChangeEvent);
        collector.resetLatch(1);
        if (!collector.getLatch().await(30L, TimeUnit.SECONDS)) {
            throw new IllegalStateException("Collector was not called!");
        }
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> ((EventAnticipator)eventAnticipator).getAnticipatedEvents(), Matchers.hasSize((int)0));
        eventAnticipator.reset();
        this.transTemplate.execute(status -> {
            OnmsNode node = (OnmsNode)this.nodeDao.get((Serializable)Integer.valueOf(1));
            node.removeCategory(this.categoryDao.findByName("Development"));
            this.nodeDao.update((Object)node);
            return node;
        });
        bldr = new EventBuilder("uei.opennms.org/nodes/nodeCategoryMembershipChanged", "Test");
        bldr.setNodeid(1L);
        bldr.setInterface(InetAddressUtils.addr((String)"192.168.1.1"));
        nodeCategoryChangeEvent = bldr.getEvent();
        eventAnticipator.anticipateEvent(nodeCategoryChangeEvent);
        this.mockEventIpcManager.sendNow(nodeCategoryChangeEvent);
        eventAnticipator.reset();
        collector.resetLatch(2);
        if (!collector.getLatch().await(30L, TimeUnit.SECONDS)) {
            throw new IllegalStateException("Collector was not called!");
        }
        Assert.assertEquals((long)0L, (long)eventAnticipator.getUnanticipatedEvents().size());
        collectd.stop();
    }

    private void initThreshdFactories(String threshd, String thresholds) throws Exception {
        this.thresholdingDao.overrideConfig(this.getClass().getResourceAsStream(thresholds));
        this.threshdDao.overrideConfig(this.getClass().getResourceAsStream(threshd));
    }

    public void setTemporaryDatabase(MockDatabase database) {
        this.mockDatabase = database;
    }

    private static class MyServiceCollector
    extends AbstractServiceCollector {
        private final SessionUtils sessionUtils;
        private CountDownLatch latch = new CountDownLatch(1);

        public MyServiceCollector(SessionUtils sessionUtils) {
            this.sessionUtils = Objects.requireNonNull(sessionUtils);
        }

        public CollectionSet collect(CollectionAgent agent, Map<String, Object> parameters) throws CollectionException {
            CollectionSet collectionSet = (CollectionSet)this.sessionUtils.withReadOnlyTransaction(() -> {
                NodeLevelResource nodeLevelResource = new NodeLevelResource(agent.getNodeId());
                return new CollectionSetBuilder(agent).withNumericAttribute((Resource)nodeLevelResource, "systemMem", "freeMem", (Number)10001.0, AttributeType.GAUGE).build();
            });
            this.latch.countDown();
            return collectionSet;
        }

        public RrdRepository getRrdRepository(String collectionName) {
            RrdRepository rrdRepository = new RrdRepository();
            rrdRepository.setStep(5000);
            rrdRepository.setHeartBeat(2 * rrdRepository.getStep());
            rrdRepository.setRraList((List)Lists.newArrayList((Object[])new String[]{"RRA:AVERAGE:0.5:1:2016"}));
            rrdRepository.setRrdBaseDir(new File("snmp"));
            return rrdRepository;
        }

        public CountDownLatch getLatch() {
            return this.latch;
        }

        public void resetLatch(int count) {
            this.latch = new CountDownLatch(count);
        }
    }
}

