/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.opennms.netmgt.collectd.SnmpCollectorITCase;
import org.opennms.netmgt.collectd.SnmpNodeCollector;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.snmp.CollectionTracker;

@RunWith(value=Parameterized.class)
public class SnmpNodeCollectorIT
extends SnmpCollectorITCase {
    public SnmpNodeCollectorIT(int config) {
        this.setVersion(config);
        m_allowWarnings = true;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> params() {
        Object[][] retval = new Object[][]{{1}, {2}, {3}};
        return Arrays.asList(retval);
    }

    @Test
    public void testZeroVars() throws Exception {
        SnmpNodeCollector collector = this.createNodeCollector();
        SnmpNodeCollectorIT.assertMibObjectsPresent((CollectionResource)collector.getCollectionSet().getNodeInfo(), this.getAttributeList());
    }

    @Test
    public void testInvalidVar() throws Exception {
        this.addAttribute("invalid", ".1.3.6.1.2.1.2", "0", "string");
        SnmpNodeCollector collector = this.createNodeCollector();
        Assert.assertTrue((boolean)collector.getEntry().isEmpty());
    }

    @Test
    public void testInvalidInst() throws Exception {
        this.addAttribute("invalid", ".1.3.6.1.2.1.1.3", "1", "timeTicks");
        SnmpNodeCollector collector = this.createNodeCollector();
        Assert.assertTrue((boolean)collector.getEntry().isEmpty());
    }

    @Test
    public void testOneVar() throws Exception {
        this.addSysName();
        SnmpNodeCollector collector = this.createNodeCollector();
        SnmpNodeCollectorIT.assertMibObjectsPresent((CollectionResource)collector.getCollectionSet().getNodeInfo(), this.getAttributeList());
    }

    private SnmpNodeCollector createNodeCollector() throws Exception, InterruptedException {
        this.initializeAgent();
        SnmpNodeCollector collector = new SnmpNodeCollector(InetAddress.getLocalHost(), this.getCollectionSet().getAttributeList(), this.getCollectionSet());
        this.createWalker((CollectionTracker)collector);
        this.waitForSignal();
        Assert.assertNotNull((String)"No entry data", (Object)collector.getEntry());
        Assert.assertFalse((String)"Timeout collecting data", (boolean)collector.timedOut());
        Assert.assertFalse((String)"Collector failed to collect data", (boolean)collector.failed());
        return collector;
    }
}

