/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.collection.test.JUnitCollector;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.TestContextAware;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.test.http.annotations.JUnitHttpServer;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.collectd.Collectd;
import org.opennms.netmgt.collectd.HttpCollector;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionInstrumentation;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionStatus;
import org.opennms.netmgt.collection.api.ServiceCollector;
import org.opennms.netmgt.collection.core.CollectionSpecification;
import org.opennms.netmgt.collection.core.DefaultCollectdInstrumentation;
import org.opennms.netmgt.collection.core.DefaultCollectionAgent;
import org.opennms.netmgt.collection.test.api.CollectorTestUtils;
import org.opennms.netmgt.config.collectd.Filter;
import org.opennms.netmgt.config.collectd.Package;
import org.opennms.netmgt.config.collectd.Parameter;
import org.opennms.netmgt.config.collectd.Service;
import org.opennms.netmgt.config.dao.outages.api.ReadablePollOutagesDao;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.dao.api.ServiceTypeDao;
import org.opennms.netmgt.dao.support.FilesystemResourceStorageDao;
import org.opennms.netmgt.model.NetworkBuilder;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.test.FileAnticipator;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestContext;
import org.springframework.transaction.PlatformTransactionManager;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-pinger.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-thresholding.xml", "classpath:/META-INF/opennms/applicationContext-testPostgresBlobStore.xml", "classpath:/META-INF/opennms/applicationContext-collectdTest.xml", "classpath:/META-INF/opennms/applicationContext-rpc-client-mock.xml", "classpath:/META-INF/opennms/applicationContext-rpc-collector.xml", "classpath:/META-INF/opennms/applicationContext-testThresholdingDaos.xml", "classpath:/META-INF/opennms/applicationContext-testPollerConfigDaos.xml"})
@JUnitConfigurationEnvironment(systemProperties={"org.opennms.rrd.storeByGroup=false"})
@JUnitTemporaryDatabase
public class HttpCollectorIT
implements TestContextAware,
InitializingBean {
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    private ServiceTypeDao m_serviceTypeDao;
    @Autowired
    private Collectd m_collectd;
    @Autowired
    private RrdStrategy<Object, Object> m_rrdStrategy;
    @Autowired
    private FilesystemResourceStorageDao m_resourceStorageDao;
    @Autowired
    private ReadablePollOutagesDao m_pollOutagesDao;
    private TestContext m_context;
    private final String m_testHostName = "127.0.0.1";
    private HttpCollector m_collector;
    private CollectionSpecification m_collectionSpecification;
    private CollectionSpecification m_httpsCollectionSpecification;
    private CollectionAgent m_collectionAgent;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    public void setTestContext(TestContext t) {
        this.m_context = t;
    }

    private OnmsServiceType getServiceType(String name) {
        OnmsServiceType serviceType = this.m_serviceTypeDao.findByName(name);
        if (serviceType == null) {
            serviceType = new OnmsServiceType(name);
            this.m_serviceTypeDao.save((Object)serviceType);
            this.m_serviceTypeDao.flush();
        }
        return serviceType;
    }

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
        if (this.m_nodeDao.findByLabel("testnode").size() == 0) {
            NetworkBuilder builder = new NetworkBuilder();
            builder.addNode("testnode");
            builder.addInterface(InetAddressUtils.normalize((String)"127.0.0.1")).setIsManaged("M").setIsSnmpPrimary("P");
            builder.addService(this.getServiceType("ICMP"));
            builder.addService(this.getServiceType("HTTP"));
            builder.addService(this.getServiceType("HTTPS"));
            OnmsNode n = builder.getCurrentNode();
            Assert.assertNotNull((Object)n);
            this.m_nodeDao.save((Object)n);
            this.m_nodeDao.flush();
        }
        this.m_collector = new HttpCollector();
        List ifaces = this.m_ipInterfaceDao.findByIpAddress("127.0.0.1");
        Assert.assertEquals((long)1L, (long)ifaces.size());
        OnmsIpInterface iface = (OnmsIpInterface)ifaces.iterator().next();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("collection", "default");
        this.m_collector.initialize();
        this.m_collectionSpecification = CollectorTestUtils.createCollectionSpec((String)"HTTP", (ServiceCollector)this.m_collector, (String)"default", (ReadablePollOutagesDao)this.m_pollOutagesDao);
        this.m_httpsCollectionSpecification = CollectorTestUtils.createCollectionSpec((String)"HTTPS", (ServiceCollector)this.m_collector, (String)"default", (ReadablePollOutagesDao)this.m_pollOutagesDao);
        this.m_collectionAgent = DefaultCollectionAgent.create((Integer)iface.getId(), (IpInterfaceDao)this.m_ipInterfaceDao, (PlatformTransactionManager)this.m_transactionManager);
        File snmpRrdDirectory = (File)this.m_context.getAttribute("rrdDirectory");
        this.m_resourceStorageDao.setRrdDirectory(snmpRrdDirectory.getParentFile());
    }

    @After
    public void tearDown() {
        MockLogAppender.noWarningsOrHigherLogged();
    }

    @Test
    @JUnitHttpServer(port=10342, vhosts={"127.0.0.1"})
    @JUnitCollector(datacollectionConfig="/org/opennms/netmgt/config/http-datacollection-config.xml", datacollectionType="http", anticipateRrds={"1/documentCount", "1/greatAnswer", "1/someNumber"}, anticipateFiles={"1/strings.properties"})
    public final void testCollect() throws Exception {
        CollectionSet collectionSet = this.m_collectionSpecification.collect(this.m_collectionAgent);
        Assert.assertEquals((String)"collection status", (Object)CollectionStatus.SUCCEEDED, (Object)collectionSet.getStatus());
        CollectorTestUtils.persistCollectionSet(this.m_rrdStrategy, (ResourceStorageDao)this.m_resourceStorageDao, (CollectionSpecification)this.m_collectionSpecification, (CollectionSet)collectionSet);
    }

    @Test
    @JUnitHttpServer(port=10342, vhosts={"127.0.0.1"})
    @JUnitCollector(datacollectionConfig="/org/opennms/netmgt/config/http-datacollection-persist-test-config.xml", datacollectionType="http", anticipateRrds={"1/documentCount", "1/greatAnswer", "1/someNumber"}, anticipateFiles={"1/strings.properties"})
    public final void testPersist() throws Exception {
        this.doTestPersist(this.m_collectionSpecification);
    }

    @Test
    @JUnitHttpServer(port=10342, vhosts={"127.0.0.1"}, https=true)
    @JUnitCollector(datacollectionConfig="/org/opennms/netmgt/config/http-datacollection-persist-https-test-config.xml", datacollectionType="https", anticipateRrds={"1/documentCount", "1/greatAnswer", "1/someNumber"}, anticipateFiles={"1/strings.properties"})
    public final void testPersistHttps() throws Exception {
        this.doTestPersist(this.m_httpsCollectionSpecification);
    }

    public final void doTestPersist(CollectionSpecification spec) throws Exception {
        File snmpRrdDirectory = (File)this.m_context.getAttribute("rrdDirectory");
        FileAnticipator anticipator = (FileAnticipator)this.m_context.getAttribute("fileAnticipator");
        int numUpdates = 2;
        int stepSizeInSecs = 1;
        int stepSizeInMillis = stepSizeInSecs * 1000;
        int rangeSizeInMillis = stepSizeInMillis + 20000;
        CollectorTestUtils.collectNTimes(this.m_rrdStrategy, (ResourceStorageDao)this.m_resourceStorageDao, (CollectionSpecification)this.m_collectionSpecification, (CollectionAgent)this.m_collectionAgent, (int)numUpdates);
        File nodeDir = CollectorTestUtils.anticipatePath((FileAnticipator)anticipator, (File)snmpRrdDirectory, (String[])new String[]{"1"});
        File documentCountRrdFile = new File(nodeDir, CollectorTestUtils.rrd(this.m_rrdStrategy, (String)"documentCount"));
        File someNumberRrdFile = new File(nodeDir, CollectorTestUtils.rrd(this.m_rrdStrategy, (String)"someNumber"));
        File greatAnswerRrdFile = new File(nodeDir, CollectorTestUtils.rrd(this.m_rrdStrategy, (String)"greatAnswer"));
        Assert.assertEquals((String)"documentCount", (Object)5.0, (Object)this.m_rrdStrategy.fetchLastValueInRange(documentCountRrdFile.getAbsolutePath(), "documentCount", stepSizeInMillis, rangeSizeInMillis));
        Assert.assertEquals((String)"documentType", (Object)17.0, (Object)this.m_rrdStrategy.fetchLastValueInRange(someNumberRrdFile.getAbsolutePath(), "someNumber", stepSizeInMillis, rangeSizeInMillis));
        Assert.assertEquals((String)"greatAnswer", (Object)42.0, (Object)this.m_rrdStrategy.fetchLastValueInRange(greatAnswerRrdFile.getAbsolutePath(), "greatAnswer", stepSizeInMillis, rangeSizeInMillis));
    }

    @Test
    @JUnitHttpServer(port=10342, vhosts={"127.0.0.1"})
    @JUnitCollector(datacollectionConfig="/org/opennms/netmgt/config/http-datacollection-persist-apache-stats.xml", datacollectionType="http", anticipateRrds={"1/TotalAccesses", "1/TotalkBytes", "1/CPULoad", "1/Uptime", "1/ReqPerSec", "1/BytesPerSec", "1/BytesPerReq", "1/BusyWorkers", "1/IdleWorkers"})
    public final void testPersistApacheStats() throws Exception {
        File snmpRrdDirectory = (File)this.m_context.getAttribute("rrdDirectory");
        FileAnticipator anticipator = (FileAnticipator)this.m_context.getAttribute("fileAnticipator");
        int numUpdates = 2;
        int stepSizeInSecs = 1;
        int stepSizeInMillis = stepSizeInSecs * 1000;
        int rangeSizeInMillis = stepSizeInMillis + 20000;
        CollectorTestUtils.collectNTimes(this.m_rrdStrategy, (ResourceStorageDao)this.m_resourceStorageDao, (CollectionSpecification)this.m_collectionSpecification, (CollectionAgent)this.m_collectionAgent, (int)numUpdates);
        File nodeDir = CollectorTestUtils.anticipatePath((FileAnticipator)anticipator, (File)snmpRrdDirectory, (String[])new String[]{"1"});
        File documentCountRrdFile = new File(nodeDir, CollectorTestUtils.rrd(this.m_rrdStrategy, (String)"TotalAccesses"));
        File someNumberRrdFile = new File(nodeDir, CollectorTestUtils.rrd(this.m_rrdStrategy, (String)"IdleWorkers"));
        File cpuLoadRrdFile = new File(nodeDir, CollectorTestUtils.rrd(this.m_rrdStrategy, (String)"CPULoad"));
        Assert.assertEquals((String)"TotalAccesses", (Object)175483.0, (Object)this.m_rrdStrategy.fetchLastValueInRange(documentCountRrdFile.getAbsolutePath(), "TotalAccesses", stepSizeInMillis, rangeSizeInMillis));
        Assert.assertEquals((String)"IdleWorkers", (Object)12.0, (Object)this.m_rrdStrategy.fetchLastValueInRange(someNumberRrdFile.getAbsolutePath(), "IdleWorkers", stepSizeInMillis, rangeSizeInMillis));
        Assert.assertEquals((String)"CPULoad", (Object)0.497069, (Object)this.m_rrdStrategy.fetchLastValueInRange(cpuLoadRrdFile.getAbsolutePath(), "CPULoad", stepSizeInMillis, rangeSizeInMillis));
    }

    @Test
    @JUnitHttpServer(port=10342, vhosts={"127.0.0.1"})
    @JUnitCollector(datacollectionConfig="/org/opennms/netmgt/config/http-datacollection-broken-regex.xml", datacollectionType="http")
    public final void testBrokenRegex() throws Exception {
        int numUpdates = 2;
        CollectorTestUtils.failToCollectNTimes(this.m_rrdStrategy, (ResourceStorageDao)this.m_resourceStorageDao, (CollectionSpecification)this.m_collectionSpecification, (CollectionAgent)this.m_collectionAgent, (int)numUpdates);
    }

    @Test
    @JUnitHttpServer(port=10342, vhosts={"127.0.0.1"})
    @JUnitCollector(datacollectionConfig="/org/opennms/netmgt/config/http-datacollection-persist-apache-stats.xml", datacollectionType="http", anticipateRrds={"1/TotalAccesses", "1/TotalkBytes", "1/CPULoad", "1/Uptime", "1/ReqPerSec", "1/BytesPerSec", "1/BytesPerReq", "1/BusyWorkers", "1/IdleWorkers"})
    public void testPersistApacheStatsViaCapsd() throws Exception {
        this.m_collectd.setServiceCollector("HTTP", (ServiceCollector)this.m_collector);
        this.m_collectd.init();
        this.m_collectd.start();
        Thread.sleep(10000L);
        this.m_collectd.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void testPersistApacheStatsAlternateLocale() throws Exception {
        Locale defaultLocale = Locale.getDefault();
        try {
            Locale.setDefault(Locale.FRANCE);
            File snmpRrdDirectory = (File)this.m_context.getAttribute("rrdDirectory");
            FileAnticipator anticipator = (FileAnticipator)this.m_context.getAttribute("fileAnticipator");
            int numUpdates = 2;
            int stepSizeInSecs = 1;
            int stepSizeInMillis = stepSizeInSecs * 1000;
            int rangeSizeInMillis = stepSizeInMillis + 20000;
            CollectorTestUtils.collectNTimes(this.m_rrdStrategy, (ResourceStorageDao)this.m_resourceStorageDao, (CollectionSpecification)this.m_collectionSpecification, (CollectionAgent)this.m_collectionAgent, (int)numUpdates);
            File nodeDir = CollectorTestUtils.anticipatePath((FileAnticipator)anticipator, (File)snmpRrdDirectory, (String[])new String[]{"1"});
            File documentCountRrdFile = new File(nodeDir, CollectorTestUtils.rrd(this.m_rrdStrategy, (String)"TotalAccesses"));
            File someNumberRrdFile = new File(nodeDir, CollectorTestUtils.rrd(this.m_rrdStrategy, (String)"IdleWorkers"));
            File cpuLoadRrdFile = new File(nodeDir, CollectorTestUtils.rrd(this.m_rrdStrategy, (String)"CPULoad"));
            Assert.assertEquals((String)"TotalAccesses", (Object)175483.0, (Object)this.m_rrdStrategy.fetchLastValueInRange(documentCountRrdFile.getAbsolutePath(), "TotalAccesses", stepSizeInMillis, rangeSizeInMillis));
            Assert.assertEquals((String)"IdleWorkers", (Object)12.0, (Object)this.m_rrdStrategy.fetchLastValueInRange(someNumberRrdFile.getAbsolutePath(), "IdleWorkers", stepSizeInMillis, rangeSizeInMillis));
            Assert.assertEquals((String)"CPULoad", (Object)0.497069, (Object)this.m_rrdStrategy.fetchLastValueInRange(cpuLoadRrdFile.getAbsolutePath(), "CPULoad", stepSizeInMillis, rangeSizeInMillis));
        }
        finally {
            Locale.setDefault(defaultLocale);
        }
    }

    @Test
    @JUnitHttpServer(port=10342, vhosts={"127.0.0.1"})
    @JUnitCollector(datacollectionConfig="/org/opennms/netmgt/config/http-datacollection-config-NMS4886.xml", datacollectionType="http", anticipateRrds={"1/documentCount", "1/greatAnswer", "1/someNumber"}, anticipateFiles={"1/strings.properties"})
    public final void testNMS4886withHttp() throws Exception {
        this.doTestNMS4886("HTTP");
    }

    @Test
    @JUnitHttpServer(port=10342, vhosts={"127.0.0.1"}, https=true)
    @JUnitCollector(datacollectionConfig="/org/opennms/netmgt/config/http-datacollection-config-NMS4886-https.xml", datacollectionType="https", anticipateRrds={"1/documentCount", "1/greatAnswer", "1/someNumber"}, anticipateFiles={"1/strings.properties"})
    public final void testNMS4886withHttps() throws Exception {
        this.doTestNMS4886("HTTPS");
    }

    public final void doTestNMS4886(String svcName) throws Exception {
        HttpCollector collector = new HttpCollector();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("http-collection", "default");
        parameters.put("port", "10342");
        collector.initialize();
        Package pkg = new Package();
        Filter filter = new Filter();
        filter.setContent("IPADDR IPLIKE *.*.*.*");
        pkg.setFilter(filter);
        Service service = new Service();
        service.setName(svcName);
        Parameter collectionParm = new Parameter();
        collectionParm.setKey("http-collection");
        collectionParm.setValue("default");
        service.addParameter(collectionParm);
        Parameter portParm = new Parameter();
        portParm.setKey("port");
        portParm.setValue("10342");
        service.addParameter(portParm);
        pkg.addService(service);
        CollectionSpecification collectionSpecification = new CollectionSpecification(pkg, svcName, (ServiceCollector)collector, (CollectionInstrumentation)new DefaultCollectdInstrumentation(), CollectorTestUtils.createLocationAwareCollectorClient(), this.m_pollOutagesDao);
        CollectionSet collectionSet = collectionSpecification.collect(this.m_collectionAgent);
        Assert.assertEquals((String)"collection status", (Object)CollectionStatus.SUCCEEDED, (Object)collectionSet.getStatus());
        CollectorTestUtils.persistCollectionSet(this.m_rrdStrategy, (ResourceStorageDao)this.m_resourceStorageDao, (CollectionSpecification)collectionSpecification, (CollectionSet)collectionSet);
    }
}

