/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.spring.xml;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.opennms.netmgt.events.api.model.IEvent;
import org.springframework.core.Ordered;

@Aspect
public class AspectJTestEventHandlerInteceptor
implements Ordered {
    private int m_preEventCount;
    private int m_postEventCount;
    private int m_handledExceptionCount;
    private int m_order = 0;

    @Pointcut(value="execution(* *..AspectJTestEventHandler.*(..))")
    public void testMethods() {
    }

    @Pointcut(value="@annotation(org.opennms.netmgt.events.api.annotations.EventHandler)")
    public void eventHandlers() {
    }

    @Pointcut(value="testMethods() && eventHandlers()")
    public void testEventHandlers() {
    }

    public int getPreEventCount() {
        return this.m_preEventCount;
    }

    public int getPostEventCount() {
        return this.m_postEventCount;
    }

    public int getHandledExceptionCount() {
        return this.m_handledExceptionCount;
    }

    @Around(value="testEventHandlers() && args(event)")
    public void onEvent(ProceedingJoinPoint pjp, IEvent event) throws Throwable {
        this.preEvent(event);
        try {
            pjp.proceed();
            this.postEvent(event);
        }
        catch (RuntimeException ex) {
            this.handleException(event, ex);
        }
    }

    private void handleException(IEvent event, RuntimeException ex) {
        System.err.println("handleException");
        ++this.m_handledExceptionCount;
    }

    private void postEvent(IEvent event) {
        System.err.println("postEvent");
        ++this.m_postEventCount;
    }

    private void preEvent(IEvent event) {
        System.err.println("preEvent");
        ++this.m_preEventCount;
    }

    public void reset() {
        this.m_preEventCount = 0;
        this.m_postEventCount = 0;
        this.m_handledExceptionCount = 0;
    }

    public void setOrder(int order) {
        this.m_order = order;
    }

    public int getOrder() {
        return this.m_order;
    }
}

