/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.collectd.CollectableService;
import org.opennms.netmgt.collectd.Collectd;
import org.opennms.netmgt.collectd.CollectorUpdates;
import org.opennms.netmgt.dao.mock.MockTransactionTemplate;
import org.opennms.netmgt.events.api.model.IEvent;
import org.opennms.netmgt.events.api.model.ImmutableMapper;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.springframework.transaction.support.TransactionTemplate;

public class CollectdEventHandlingTest {
    private Collectd collectd = new Collectd();
    private CollectableService svc1;
    private CollectableService svc2;

    @Before
    public void setUp() {
        MockTransactionTemplate transactionTemplate = new MockTransactionTemplate();
        transactionTemplate.afterPropertiesSet();
        this.collectd.setTransactionTemplate((TransactionTemplate)transactionTemplate);
        CollectorUpdates svc1_udpates = new CollectorUpdates();
        this.svc1 = (CollectableService)EasyMock.createMock(CollectableService.class);
        EasyMock.expect((Object)this.svc1.getNodeId()).andReturn((Object)42).anyTimes();
        EasyMock.expect((Object)this.svc1.getAddress()).andReturn((Object)InetAddressUtils.ONE_TWENTY_SEVEN).anyTimes();
        EasyMock.expect((Object)this.svc1.getServiceName()).andReturn((Object)"JMX").anyTimes();
        EasyMock.expect((Object)this.svc1.getCollectorUpdates()).andReturn((Object)svc1_udpates).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.svc1});
        this.collectd.getCollectableServices().add(this.svc1);
        CollectorUpdates svc2_udpates = new CollectorUpdates();
        this.svc2 = (CollectableService)EasyMock.createMock(CollectableService.class);
        EasyMock.expect((Object)this.svc2.getNodeId()).andReturn((Object)43).anyTimes();
        EasyMock.expect((Object)this.svc2.getAddress()).andReturn((Object)InetAddressUtils.UNPINGABLE_ADDRESS).anyTimes();
        EasyMock.expect((Object)this.svc2.getServiceName()).andReturn((Object)"WS-Man").anyTimes();
        EasyMock.expect((Object)this.svc2.getCollectorUpdates()).andReturn((Object)svc2_udpates).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.svc2});
        this.collectd.getCollectableServices().add(this.svc2);
    }

    @Test
    public void canHandleNodeDeletedEvents() {
        Event e = new EventBuilder("uei.opennms.org/nodes/nodeDeleted", "test").setNodeid((long)this.svc1.getNodeId()).getEvent();
        this.collectd.onEvent((IEvent)ImmutableMapper.fromMutableEvent((Event)e));
        Assert.assertTrue((String)"deletion flag was not set on svc1!", (boolean)this.svc1.getCollectorUpdates().isDeletionFlagSet());
        Assert.assertFalse((String)"deletion flag was set on svc2!", (boolean)this.svc2.getCollectorUpdates().isDeletionFlagSet());
    }

    @Test
    public void canHandleInterfaceDeletedEvents() {
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(this.svc1.getNodeId()));
        OnmsIpInterface iface = new OnmsIpInterface();
        iface.setId(Integer.valueOf(99));
        iface.setNode(node);
        iface.setIpAddress(this.svc1.getAddress());
        Event e = new EventBuilder("uei.opennms.org/nodes/interfaceDeleted", "test").setIpInterface(iface).getEvent();
        this.collectd.onEvent((IEvent)ImmutableMapper.fromMutableEvent((Event)e));
        Assert.assertTrue((String)"deletion flag was not set on svc1!", (boolean)this.svc1.getCollectorUpdates().isDeletionFlagSet());
        Assert.assertFalse((String)"deletion flag was set on svc2!", (boolean)this.svc2.getCollectorUpdates().isDeletionFlagSet());
    }

    @Test
    public void canHandleServiceDeletedEvents() {
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(this.svc2.getNodeId()));
        OnmsIpInterface iface = new OnmsIpInterface();
        iface.setId(Integer.valueOf(101));
        iface.setNode(node);
        iface.setIpAddress(this.svc2.getAddress());
        Event e = new EventBuilder("uei.opennms.org/nodes/serviceDeleted", "test").setIpInterface(iface).setService(this.svc2.getServiceName()).getEvent();
        this.collectd.onEvent((IEvent)ImmutableMapper.fromMutableEvent((Event)e));
        Assert.assertFalse((String)"deletion flag was set on svc1!", (boolean)this.svc1.getCollectorUpdates().isDeletionFlagSet());
        Assert.assertTrue((String)"deletion flag was not set on svc2!", (boolean)this.svc2.getCollectorUpdates().isDeletionFlagSet());
    }
}

