/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDef;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.collection.test.JUnitCollector;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.TestContextAware;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.collectd.AbstractSnmpCollector;
import org.opennms.netmgt.collectd.DefaultSnmpCollectionAgent;
import org.opennms.netmgt.collectd.MockServiceCollector;
import org.opennms.netmgt.collectd.SnmpCollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionException;
import org.opennms.netmgt.collection.api.CollectionInitializationException;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionStatus;
import org.opennms.netmgt.collection.api.CollectionTimedOut;
import org.opennms.netmgt.collection.api.ServiceCollector;
import org.opennms.netmgt.collection.core.CollectionSpecification;
import org.opennms.netmgt.collection.test.api.CollectorTestUtils;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.config.dao.outages.api.ReadablePollOutagesDao;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.dao.support.FilesystemResourceStorageDao;
import org.opennms.netmgt.model.NetworkBuilder;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.rrd.RrdAttributeType;
import org.opennms.netmgt.rrd.RrdDataSource;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.jrobin.JRobinRrdStrategy;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.opennms.test.mock.MockUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestContext;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-mockDao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-pinger.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-proxy-snmp.xml", "classpath:/META-INF/opennms/applicationContext-testPollerConfigDaos.xml"})
@JUnitConfigurationEnvironment(systemProperties={"org.opennms.rrd.storeByGroup=false"})
@JUnitTemporaryDatabase(reuseDatabase=false)
public abstract class AbstractSnmpCollectorIT
implements InitializingBean,
TestContextAware {
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    private SnmpPeerFactory m_snmpPeerFactory;
    @Autowired
    private ReadablePollOutagesDao m_pollOutagesDao;
    private TestContext m_context;
    private String m_testHostName;
    private static final String TEST_NODE_LABEL = "TestNode";
    private CollectionSpecification m_collectionSpecification;
    private SnmpCollectionAgent m_collectionAgent;
    private SnmpAgentConfig m_agentConfig;
    private RrdStrategy<?, ?> m_rrdStrategy;
    private FilesystemResourceStorageDao m_resourceStorageDao;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() throws Exception {
        MockServiceCollector.setDelegate(null);
        MockLogAppender.setupLogging();
        this.m_rrdStrategy = new JRobinRrdStrategy();
        this.m_resourceStorageDao = new FilesystemResourceStorageDao();
        File snmpRrdDirectory = (File)this.m_context.getAttribute("rrdDirectory");
        this.m_resourceStorageDao.setRrdDirectory(snmpRrdDirectory.getParentFile());
        this.m_testHostName = InetAddressUtils.str((InetAddress)InetAddress.getLocalHost());
        OnmsIpInterface iface = null;
        OnmsNode testNode = null;
        List testNodes = this.m_nodeDao.findByLabel(TEST_NODE_LABEL);
        if (testNodes == null || testNodes.size() < 1) {
            NetworkBuilder builder = new NetworkBuilder();
            builder.addNode(TEST_NODE_LABEL).setId(Integer.valueOf(1)).setSysObjectId(".1.3.6.1.4.1.1588.2.1.1.1");
            builder.addSnmpInterface(1).setIfName("lo0").setPhysAddr("00:11:22:33:44");
            builder.addSnmpInterface(2).setIfName("gif0").setPhysAddr("00:11:22:33:45").setIfType(Integer.valueOf(55));
            builder.addSnmpInterface(3).setIfName("stf0").setPhysAddr("00:11:22:33:46").setIfType(Integer.valueOf(57));
            builder.addSnmpInterface(6).setIfName("fw0").setPhysAddr("44:33:22:11:00").setIfType(Integer.valueOf(144)).setCollectionEnabled(true).addIpInterface(this.m_testHostName).setIsSnmpPrimary("P");
            testNode = builder.getCurrentNode();
            Assert.assertNotNull((Object)testNode);
            this.m_nodeDao.save((Object)testNode);
            this.m_nodeDao.flush();
        } else {
            testNode = (OnmsNode)testNodes.iterator().next();
        }
        Set ifaces = testNode.getIpInterfaces();
        Assert.assertEquals((long)1L, (long)ifaces.size());
        iface = (OnmsIpInterface)ifaces.iterator().next();
        SnmpPeerFactory.setInstance((SnmpPeerFactory)this.m_snmpPeerFactory);
        AbstractSnmpCollector collector = this.createSnmpCollector();
        collector.initialize();
        this.m_collectionSpecification = CollectorTestUtils.createCollectionSpec((String)"SNMP", (ServiceCollector)collector, (String)"default", (ReadablePollOutagesDao)this.m_pollOutagesDao);
        this.m_collectionAgent = DefaultSnmpCollectionAgent.create((Integer)iface.getId(), (IpInterfaceDao)this.m_ipInterfaceDao, (PlatformTransactionManager)this.m_transactionManager);
        this.m_agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.getLocalHostAddress());
    }

    protected abstract AbstractSnmpCollector createSnmpCollector();

    @After
    public void tearDown() throws Exception {
        MockUtil.println((String)"------------ End Test --------------------------");
    }

    @Test
    @JUnitCollector(datacollectionConfig="/org/opennms/netmgt/config/datacollection-config.xml", datacollectionType="snmp", anticipateFiles={"1", "1/fw0"}, anticipateRrds={"1/tcpActiveOpens", "1/tcpAttemptFails", "1/tcpPassiveOpens", "1/tcpRetransSegs", "1/tcpCurrEstab", "1/tcpEstabResets", "1/tcpInErrors", "1/tcpInSegs", "1/tcpOutRsts", "1/tcpOutSegs", "1/fw0/ifInDiscards", "1/fw0/ifInErrors", "1/fw0/ifInNUcastpkts", "1/fw0/ifInOctets", "1/fw0/ifInUcastpkts", "1/fw0/ifOutErrors", "1/fw0/ifOutNUcastPkts", "1/fw0/ifOutOctets", "1/fw0/ifOutUcastPkts"})
    @JUnitSnmpAgent(resource="/org/opennms/netmgt/snmp/snmpTestData1.properties")
    public void testCollect() throws Exception {
        System.setProperty("org.opennms.netmgt.collectd.SnmpCollector.limitCollectionToInstances", "true");
        CollectionSet collectionSet = this.m_collectionSpecification.collect((CollectionAgent)this.m_collectionAgent);
        Assert.assertEquals((String)"collection status", (Object)CollectionStatus.SUCCEEDED, (Object)collectionSet.getStatus());
        CollectorTestUtils.persistCollectionSet(this.m_rrdStrategy, (ResourceStorageDao)this.m_resourceStorageDao, (CollectionSpecification)this.m_collectionSpecification, (CollectionSet)collectionSet);
        System.err.println("FIRST COLLECTION FINISHED");
        Thread.sleep(1000L);
        Assert.assertEquals((String)"collection status", (Object)CollectionStatus.SUCCEEDED, (Object)this.m_collectionSpecification.collect((CollectionAgent)this.m_collectionAgent).getStatus());
        System.err.println("SECOND COLLECTION FINISHED");
    }

    @Test
    @Transactional
    @JUnitCollector(datacollectionConfig="/org/opennms/netmgt/config/datacollection-persistTest-config.xml", datacollectionType="snmp", anticipateFiles={"1", "1/fw0"}, anticipateRrds={"1/tcpCurrEstab", "1/fw0/ifInOctets"})
    @JUnitSnmpAgent(resource="/org/opennms/netmgt/snmp/snmpTestData1.properties")
    public void testPersist() throws Exception {
        File snmpRrdDirectory = (File)this.m_context.getAttribute("rrdDirectory");
        File nodeDir = new File(snmpRrdDirectory, "1");
        File rrdFile = new File(nodeDir, this.rrd("tcpCurrEstab"));
        File ifDir = new File(nodeDir, "fw0");
        File ifRrdFile = new File(ifDir, this.rrd("ifInOctets"));
        int numUpdates = 2;
        int stepSizeInSecs = 1;
        int stepSizeInMillis = stepSizeInSecs * 1000;
        int rangeSizeInMillis = stepSizeInMillis + 20000;
        CollectorTestUtils.collectNTimes(this.m_rrdStrategy, (ResourceStorageDao)this.m_resourceStorageDao, (CollectionSpecification)this.m_collectionSpecification, (CollectionAgent)this.m_collectionAgent, (int)numUpdates);
        Assert.assertEquals((Object)123.0, (Object)this.m_rrdStrategy.fetchLastValueInRange(rrdFile.getAbsolutePath(), "tcpCurrEstab", stepSizeInMillis, rangeSizeInMillis));
        Assert.assertEquals((Object)1234567.0, (Object)this.m_rrdStrategy.fetchLastValueInRange(ifRrdFile.getAbsolutePath(), "ifInOctets", stepSizeInMillis, rangeSizeInMillis));
        SnmpUtils.set((SnmpAgentConfig)this.m_agentConfig, (SnmpObjId)SnmpObjId.get((String)".1.3.6.1.2.1.6.9.0"), (SnmpValue)SnmpUtils.getValueFactory().getInt32(456));
        SnmpUtils.set((SnmpAgentConfig)this.m_agentConfig, (SnmpObjId)SnmpObjId.get((String)".1.3.6.1.2.1.2.2.1.10.6"), (SnmpValue)SnmpUtils.getValueFactory().getCounter32(7654321L));
        CollectorTestUtils.collectNTimes(this.m_rrdStrategy, (ResourceStorageDao)this.m_resourceStorageDao, (CollectionSpecification)this.m_collectionSpecification, (CollectionAgent)this.m_collectionAgent, (int)numUpdates);
        Assert.assertEquals((Object)456.0, (Object)this.m_rrdStrategy.fetchLastValueInRange(rrdFile.getAbsolutePath(), "tcpCurrEstab", stepSizeInMillis, rangeSizeInMillis));
        Assert.assertEquals((Object)7654321.0, (Object)this.m_rrdStrategy.fetchLastValueInRange(ifRrdFile.getAbsolutePath(), "ifInOctets", stepSizeInMillis, rangeSizeInMillis));
    }

    @Test
    @Transactional
    @JUnitCollector(datacollectionConfig="/org/opennms/netmgt/config/datacollection-config.xml", datacollectionType="snmp", anticipateRrds={"test"}, anticipateMetaFiles=false)
    public void testUsingFetch() throws Exception {
        System.err.println("=== testUsingFetch ===");
        File snmpDir = (File)this.m_context.getAttribute("rrdDirectory");
        HashMap attributeMappings = new HashMap();
        int stepSize = 1;
        int numUpdates = 2;
        long start = System.currentTimeMillis();
        int stepSizeInMillis = stepSize * 1000;
        int rangeSizeInMillis = stepSizeInMillis + 20000;
        File rrdFile = new File(snmpDir, this.rrd("test"));
        JRobinRrdStrategy m_rrdStrategy = new JRobinRrdStrategy();
        RrdDataSource rrdDataSource = new RrdDataSource("testAttr", RrdAttributeType.GAUGE, stepSize * 2, "U", "U");
        RrdDef def = (RrdDef)m_rrdStrategy.createDefinition("test", snmpDir.getAbsolutePath(), "test", stepSize, Collections.singletonList(rrdDataSource), Collections.singletonList("RRA:AVERAGE:0.5:1:100"));
        m_rrdStrategy.createFile((Object)def);
        RrdDb rrdFileObject = (RrdDb)m_rrdStrategy.openFile(rrdFile.getAbsolutePath());
        for (int i = 0; i < numUpdates; ++i) {
            m_rrdStrategy.updateFile((Object)rrdFileObject, "test", start / 1000L - (long)(stepSize * (numUpdates - i)) + ":1");
        }
        m_rrdStrategy.closeFile((Object)rrdFileObject);
        Assert.assertEquals((Object)1.0, (Object)m_rrdStrategy.fetchLastValueInRange(rrdFile.getAbsolutePath(), "testAttr", stepSizeInMillis, rangeSizeInMillis));
    }

    @Test
    @Transactional
    @JUnitCollector(datacollectionConfig="/org/opennms/netmgt/config/datacollection-brocade-config.xml", datacollectionType="snmp", anticipateRrds={"1/brocadeFCPortIndex/1/swFCPortTxWords", "1/brocadeFCPortIndex/1/swFCPortRxWords", "1/brocadeFCPortIndex/2/swFCPortTxWords", "1/brocadeFCPortIndex/2/swFCPortRxWords", "1/brocadeFCPortIndex/3/swFCPortTxWords", "1/brocadeFCPortIndex/3/swFCPortRxWords", "1/brocadeFCPortIndex/4/swFCPortTxWords", "1/brocadeFCPortIndex/4/swFCPortRxWords", "1/brocadeFCPortIndex/5/swFCPortTxWords", "1/brocadeFCPortIndex/5/swFCPortRxWords", "1/brocadeFCPortIndex/6/swFCPortTxWords", "1/brocadeFCPortIndex/6/swFCPortRxWords", "1/brocadeFCPortIndex/7/swFCPortTxWords", "1/brocadeFCPortIndex/7/swFCPortRxWords", "1/brocadeFCPortIndex/8/swFCPortTxWords", "1/brocadeFCPortIndex/8/swFCPortRxWords"}, anticipateFiles={"1", "1/brocadeFCPortIndex", "1/brocadeFCPortIndex/1/strings.properties", "1/brocadeFCPortIndex/1", "1/brocadeFCPortIndex/2/strings.properties", "1/brocadeFCPortIndex/2", "1/brocadeFCPortIndex/3/strings.properties", "1/brocadeFCPortIndex/3", "1/brocadeFCPortIndex/4/strings.properties", "1/brocadeFCPortIndex/4", "1/brocadeFCPortIndex/5/strings.properties", "1/brocadeFCPortIndex/5", "1/brocadeFCPortIndex/6/strings.properties", "1/brocadeFCPortIndex/6", "1/brocadeFCPortIndex/7/strings.properties", "1/brocadeFCPortIndex/7", "1/brocadeFCPortIndex/8/strings.properties", "1/brocadeFCPortIndex/8"})
    @JUnitSnmpAgent(resource="/org/opennms/netmgt/snmp/brocadeTestData1.properties")
    public void testBrocadeCollect() throws Exception {
        CollectionSet collectionSet = this.m_collectionSpecification.collect((CollectionAgent)this.m_collectionAgent);
        Assert.assertEquals((String)"collection status", (Object)CollectionStatus.SUCCEEDED, (Object)collectionSet.getStatus());
        CollectorTestUtils.persistCollectionSet(this.m_rrdStrategy, (ResourceStorageDao)this.m_resourceStorageDao, (CollectionSpecification)this.m_collectionSpecification, (CollectionSet)collectionSet);
        System.err.println("FIRST COLLECTION FINISHED");
        Thread.sleep(1000L);
        Assert.assertEquals((String)"collection status", (Object)CollectionStatus.SUCCEEDED, (Object)this.m_collectionSpecification.collect((CollectionAgent)this.m_collectionAgent).getStatus());
        System.err.println("SECOND COLLECTION FINISHED");
    }

    @Test
    @Transactional
    @JUnitCollector(datacollectionConfig="/org/opennms/netmgt/config/datacollection-brocade-no-ifaces-config.xml", datacollectionType="snmp", anticipateRrds={"1/brocadeFCPortIndex/1/swFCPortTxWords", "1/brocadeFCPortIndex/1/swFCPortRxWords", "1/brocadeFCPortIndex/2/swFCPortTxWords", "1/brocadeFCPortIndex/2/swFCPortRxWords", "1/brocadeFCPortIndex/3/swFCPortTxWords", "1/brocadeFCPortIndex/3/swFCPortRxWords", "1/brocadeFCPortIndex/4/swFCPortTxWords", "1/brocadeFCPortIndex/4/swFCPortRxWords", "1/brocadeFCPortIndex/5/swFCPortTxWords", "1/brocadeFCPortIndex/5/swFCPortRxWords", "1/brocadeFCPortIndex/6/swFCPortTxWords", "1/brocadeFCPortIndex/6/swFCPortRxWords", "1/brocadeFCPortIndex/7/swFCPortTxWords", "1/brocadeFCPortIndex/7/swFCPortRxWords", "1/brocadeFCPortIndex/8/swFCPortTxWords", "1/brocadeFCPortIndex/8/swFCPortRxWords"}, anticipateFiles={"1", "1/brocadeFCPortIndex", "1/brocadeFCPortIndex/1/strings.properties", "1/brocadeFCPortIndex/1", "1/brocadeFCPortIndex/2/strings.properties", "1/brocadeFCPortIndex/2", "1/brocadeFCPortIndex/3/strings.properties", "1/brocadeFCPortIndex/3", "1/brocadeFCPortIndex/4/strings.properties", "1/brocadeFCPortIndex/4", "1/brocadeFCPortIndex/5/strings.properties", "1/brocadeFCPortIndex/5", "1/brocadeFCPortIndex/6/strings.properties", "1/brocadeFCPortIndex/6", "1/brocadeFCPortIndex/7/strings.properties", "1/brocadeFCPortIndex/7", "1/brocadeFCPortIndex/8/strings.properties", "1/brocadeFCPortIndex/8"})
    @JUnitSnmpAgent(resource="/org/opennms/netmgt/snmp/brocadeTestData1.properties")
    public void testBug2447_GenericIndexedOnlyCollect() throws Exception {
        CollectionSet collectionSet = this.m_collectionSpecification.collect((CollectionAgent)this.m_collectionAgent);
        Assert.assertEquals((String)"collection status", (Object)CollectionStatus.SUCCEEDED, (Object)collectionSet.getStatus());
        CollectorTestUtils.persistCollectionSet(this.m_rrdStrategy, (ResourceStorageDao)this.m_resourceStorageDao, (CollectionSpecification)this.m_collectionSpecification, (CollectionSet)collectionSet);
        System.err.println("FIRST COLLECTION FINISHED");
        Thread.sleep(1000L);
        Assert.assertEquals((String)"collection status", (Object)CollectionStatus.SUCCEEDED, (Object)this.m_collectionSpecification.collect((CollectionAgent)this.m_collectionAgent).getStatus());
        System.err.println("SECOND COLLECTION FINISHED");
    }

    @Test
    @Transactional
    @JUnitCollector(datacollectionConfig="/org/opennms/netmgt/config/datacollection-brocade-no-ifaces-config.xml", datacollectionType="snmp", anticipateRrds={"1/brocadeFCPortIndex/1/swFCPortTxWords", "1/brocadeFCPortIndex/1/swFCPortRxWords", "1/brocadeFCPortIndex/2/swFCPortTxWords", "1/brocadeFCPortIndex/2/swFCPortRxWords", "1/brocadeFCPortIndex/3/swFCPortTxWords", "1/brocadeFCPortIndex/3/swFCPortRxWords", "1/brocadeFCPortIndex/4/swFCPortTxWords", "1/brocadeFCPortIndex/4/swFCPortRxWords", "1/brocadeFCPortIndex/5/swFCPortTxWords", "1/brocadeFCPortIndex/5/swFCPortRxWords", "1/brocadeFCPortIndex/6/swFCPortTxWords", "1/brocadeFCPortIndex/6/swFCPortRxWords", "1/brocadeFCPortIndex/7/swFCPortTxWords", "1/brocadeFCPortIndex/7/swFCPortRxWords", "1/brocadeFCPortIndex/8/swFCPortTxWords", "1/brocadeFCPortIndex/8/swFCPortRxWords"}, anticipateFiles={"1", "1/brocadeFCPortIndex", "1/brocadeFCPortIndex/1/strings.properties", "1/brocadeFCPortIndex/1", "1/brocadeFCPortIndex/2/strings.properties", "1/brocadeFCPortIndex/2", "1/brocadeFCPortIndex/3/strings.properties", "1/brocadeFCPortIndex/3", "1/brocadeFCPortIndex/4/strings.properties", "1/brocadeFCPortIndex/4", "1/brocadeFCPortIndex/5/strings.properties", "1/brocadeFCPortIndex/5", "1/brocadeFCPortIndex/6/strings.properties", "1/brocadeFCPortIndex/6", "1/brocadeFCPortIndex/7/strings.properties", "1/brocadeFCPortIndex/7", "1/brocadeFCPortIndex/8/strings.properties", "1/brocadeFCPortIndex/8"})
    @JUnitSnmpAgent(resource="/org/opennms/netmgt/snmp/brocadeTestData1.properties")
    public void verifyPersistedStringProperties() throws Exception {
        CollectionSet collectionSet = this.m_collectionSpecification.collect((CollectionAgent)this.m_collectionAgent);
        Assert.assertEquals((String)"collection status", (Object)CollectionStatus.SUCCEEDED, (Object)collectionSet.getStatus());
        CollectorTestUtils.persistCollectionSet(this.m_rrdStrategy, (ResourceStorageDao)this.m_resourceStorageDao, (CollectionSpecification)this.m_collectionSpecification, (CollectionSet)collectionSet);
        Map properties = this.m_resourceStorageDao.getStringAttributes(ResourcePath.get((String[])new String[]{"snmp", "1", "brocadeFCPortIndex", "1"}));
        String value = (String)properties.get("swFCPortName");
        Assert.assertTrue((boolean)value.startsWith("..3DUfw"));
        value = (String)properties.get("swFCPortWwn");
        Assert.assertEquals((Object)"1100334455667788", (Object)value);
    }

    @Transactional
    @JUnitCollector(datacollectionConfig="/org/opennms/netmgt/config/datacollection-persistTest-config.xml", datacollectionType="snmp")
    public void collectionTimedOutExceptionOnAgentTimeout() throws CollectionInitializationException, CollectionException {
        CollectionException caught = null;
        try {
            this.m_collectionSpecification.collect((CollectionAgent)this.m_collectionAgent);
        }
        catch (CollectionException e) {
            caught = e;
        }
        Assert.assertNotNull((Object)((Object)caught));
        Assert.assertEquals(CollectionTimedOut.class, caught.getCause().getClass());
    }

    private String rrd(String file) {
        return file + this.m_rrdStrategy.getDefaultFileExtension();
    }

    public void setTestContext(TestContext context) {
        this.m_context = context;
    }
}

