/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.io.IOException;
import java.util.List;
import org.opennms.netmgt.model.notifd.Argument;
import org.opennms.netmgt.notifd.MicroblogNotificationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import twitter4j.DirectMessage;
import twitter4j.Twitter;
import twitter4j.TwitterException;

public class MicroblogDMNotificationStrategy
extends MicroblogNotificationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(MicroblogDMNotificationStrategy.class);

    public MicroblogDMNotificationStrategy() throws IOException {
    }

    public MicroblogDMNotificationStrategy(Resource configResource) {
        super(configResource);
    }

    @Override
    public int send(List<Argument> arguments) {
        DirectMessage response;
        Twitter svc = this.buildUblogService(arguments);
        String destUser = this.findDestName(arguments);
        if (destUser == null || "".equals(destUser)) {
            LOG.error("Cannot send a microblog DM notice to a user with no microblog username set. Either set a microblog username for this OpenNMS user or use the MicroblogUpdateNotificationStrategy instead.");
            return 1;
        }
        if (destUser.startsWith("@")) {
            destUser = destUser.substring(1);
        }
        String fullMessage = this.buildMessageBody(arguments);
        LOG.debug("Dispatching microblog DM notification at base URL '{}' with destination user '{}' and message '{}'", new Object[]{svc.getConfiguration().getClientURL(), destUser, fullMessage});
        try {
            response = svc.sendDirectMessage(destUser, fullMessage);
        }
        catch (TwitterException e) {
            LOG.error("Microblog notification failed at service URL '{}' to destination user '{}'", new Object[]{svc.getConfiguration().getClientURL(), destUser, e});
            return 1;
        }
        LOG.info("Microblog DM notification succeeded: DM sent with ID {}", (Object)response.getId());
        return 0;
    }
}

