/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.SnmpAttributeType;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.AttributeType;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.NumericCollectionAttributeType;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.config.datacollection.MibObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumericAttributeType
extends SnmpAttributeType
implements NumericCollectionAttributeType {
    private static final Logger LOG = LoggerFactory.getLogger(NumericAttributeType.class);
    private final AttributeType m_type;
    private static final String[] s_numericTypes = new String[]{"counter", "gauge", "timeticks", "integer", "octetstring"};

    public static boolean isNumericType(String rawType) {
        String type = rawType.toLowerCase();
        for (int i = 0; i < s_numericTypes.length; ++i) {
            String supportedType = s_numericTypes[i];
            if (!type.startsWith(supportedType)) continue;
            return true;
        }
        return false;
    }

    public static boolean supportsType(String rawType) {
        return NumericAttributeType.isNumericType(rawType);
    }

    public NumericAttributeType(ResourceType resourceType, String collectionName, MibObject mibObj, AttributeGroupType groupType) {
        super(resourceType, collectionName, mibObj, groupType);
        this.m_type = mibObj.getType().toLowerCase().startsWith("counter") ? AttributeType.COUNTER : AttributeType.GAUGE;
        LOG.debug("buildDataSourceList: ds_name: {} ds_oid: {}.{}", new Object[]{this.getName(), this.getOid(), this.getInstance()});
    }

    public AttributeType getType() {
        return this.m_type;
    }

    public String getMaxval() {
        return this.m_mibObj.getMaxval();
    }

    public String getMinval() {
        return this.m_mibObj.getMinval();
    }

    @Override
    public void storeAttribute(CollectionAttribute attribute, Persister persister) {
        persister.persistNumericAttribute(attribute);
    }
}

