/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.UnknownHostException;
import java.util.HashMap;
import org.junit.Assert;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.passive.PassiveStatusKeeper;
import org.opennms.netmgt.passive.PassiveStatusKeeperIT;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.mock.MockPollContext;
import org.opennms.netmgt.poller.monitors.PassiveServiceMonitor;
import org.opennms.netmgt.poller.pollables.PollContext;
import org.opennms.netmgt.poller.pollables.PollableInterface;
import org.opennms.netmgt.poller.pollables.PollableNetwork;
import org.opennms.netmgt.poller.pollables.PollableNode;
import org.opennms.netmgt.poller.pollables.PollableService;

public class PassiveServiceMonitorIT
extends PassiveStatusKeeperIT {
    public void testPoll() throws UnknownHostException {
        PassiveStatusKeeper psk = PassiveStatusKeeper.getInstance();
        psk.setStatus("localhost", "127.0.0.1", "my-passive-service", PollStatus.get((int)2, (String)"testing failure"));
        PassiveServiceMonitor sm = new PassiveServiceMonitor();
        PollableService ms = this.createMonitoredService(1, "localhost", null, "127.0.0.1", "my-passive-service");
        PollStatus ps = sm.poll((MonitoredService)ms, new HashMap());
        Assert.assertEquals((Object)PollStatus.down((String)"fail."), (Object)ps);
        psk.setStatus("localhost", "127.0.0.1", "my-passive-service", PollStatus.get((int)1, (String)"testing failure"));
        ps = sm.poll((MonitoredService)ms, new HashMap());
        Assert.assertEquals((Object)PollStatus.up(), (Object)ps);
    }

    private PollableService createMonitoredService(int nodeId, String nodeLabel, String nodeLocation, String ipAddr, String serviceName) throws UnknownHostException {
        return new PollableService(new PollableInterface(new PollableNode(new PollableNetwork((PollContext)new MockPollContext()), nodeId, nodeLabel, nodeLocation), InetAddressUtils.addr((String)ipAddr)), serviceName);
    }
}

