/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller;

import com.jayway.awaitility.Awaitility;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.MockDatabase;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.features.distributed.kvstore.api.JsonStore;
import org.opennms.netmgt.config.dao.outages.api.WriteablePollOutagesDao;
import org.opennms.netmgt.config.dao.outages.impl.OnmsPollOutagesDao;
import org.opennms.netmgt.config.poller.outages.Outages;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-postgresJsonStore.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase(tempDbClass=MockDatabase.class)
public class PollOutagesConfigPersistenceIT {
    private WriteablePollOutagesDao pollOutagesDao;
    @Autowired
    private JsonStore jsonStore;
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    private static final Resource BASE_CONFIG = new ClassPathResource("etc/poll-outages.xml");
    private File testDir;

    @Before
    public void setPollOutagesDao() throws IOException {
        this.testDir = this.tempFolder.newFolder("etc");
        Files.copy(Paths.get(BASE_CONFIG.getURI()), Paths.get(this.testDir.getAbsolutePath(), "poll-outages.xml"), new CopyOption[0]);
        System.setProperty("opennms.home", this.tempFolder.getRoot().getAbsolutePath());
        this.pollOutagesDao = new OnmsPollOutagesDao(this.jsonStore);
    }

    @Test
    public void canStoreInitialConfig() {
        this.waitForInitialConfig();
    }

    @Test
    public void configChangeIsPropogated() throws IOException {
        this.waitForInitialConfig();
        Path resource = Paths.get(this.testDir.getAbsolutePath(), "/poll-outages.xml");
        Outages fromFile = (Outages)JaxbUtils.unmarshal(Outages.class, (File)resource.toFile());
        Outages fromDB = (Outages)this.pollOutagesDao.getConfig();
        Assert.assertThat((Object)fromFile, (Matcher)CoreMatchers.equalTo((Object)fromDB));
        String newOutageConfig = "<?xml version=\"1.0\"?>\n<outages xmlns=\"http://xmlns.opennms.org/xsd/config/poller/outages\"></outages>";
        Files.write(resource, newOutageConfig.getBytes(), new OpenOption[0]);
        fromFile = (Outages)JaxbUtils.unmarshal(Outages.class, (File)resource.toFile());
        Assert.assertThat((Object)fromFile.getOutages().size(), (Matcher)CoreMatchers.equalTo((Object)0));
        this.pollOutagesDao.reload();
        fromDB = (Outages)this.pollOutagesDao.getConfig();
        Assert.assertThat((Object)fromFile, (Matcher)CoreMatchers.equalTo((Object)fromDB));
    }

    private void waitForInitialConfig() {
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> this.jsonStore.get("poll-outages", "config").isPresent());
    }
}

