/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.restrictions.InRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.collection.api.PersisterFactory;
import org.opennms.netmgt.config.PollOutagesConfig;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.api.OutageDao;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.netmgt.poller.LocationAwarePollerClient;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.PollerEventProcessor;
import org.opennms.netmgt.poller.QueryManager;
import org.opennms.netmgt.poller.pollables.DbPollEvent;
import org.opennms.netmgt.poller.pollables.PollableNetwork;
import org.opennms.netmgt.poller.pollables.PollableNode;
import org.opennms.netmgt.poller.pollables.PollableService;
import org.opennms.netmgt.poller.pollables.PollableServiceConfig;
import org.opennms.netmgt.poller.pollables.PollableVisitorAdaptor;
import org.opennms.netmgt.scheduler.LegacyScheduler;
import org.opennms.netmgt.scheduler.ReadyRunnable;
import org.opennms.netmgt.scheduler.Schedule;
import org.opennms.netmgt.scheduler.ScheduleInterval;
import org.opennms.netmgt.scheduler.ScheduleTimer;
import org.opennms.netmgt.scheduler.Scheduler;
import org.opennms.netmgt.scheduler.Timer;
import org.opennms.netmgt.threshd.api.ThresholdingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class Poller
extends AbstractServiceDaemon {
    private static final Logger LOG = LoggerFactory.getLogger(Poller.class);
    private static final String LOG4J_CATEGORY = "poller";
    private boolean m_initialized = false;
    private LegacyScheduler m_scheduler = null;
    private PollerEventProcessor m_eventProcessor;
    private PollableNetwork m_network;
    @Autowired
    private QueryManager m_queryManager;
    private PollerConfig m_pollerConfig;
    private PollOutagesConfig m_pollOutagesConfig;
    private EventIpcManager m_eventMgr;
    @Autowired
    private MonitoredServiceDao m_monitoredServiceDao;
    @Autowired
    private OutageDao m_outageDao;
    @Autowired
    private TransactionTemplate m_transactionTemplate;
    @Autowired
    private PersisterFactory m_persisterFactory;
    @Autowired
    private ThresholdingService m_thresholdingService;
    @Autowired
    private LocationAwarePollerClient m_locationAwarePollerClient;

    public void setPersisterFactory(PersisterFactory persisterFactory) {
        this.m_persisterFactory = persisterFactory;
    }

    public void setOutageDao(OutageDao outageDao) {
        this.m_outageDao = outageDao;
    }

    public void setMonitoredServiceDao(MonitoredServiceDao monitoredServiceDao) {
        this.m_monitoredServiceDao = monitoredServiceDao;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.m_transactionTemplate = transactionTemplate;
    }

    public void setEventIpcManager(EventIpcManager eventIpcManager) {
        this.m_eventMgr = eventIpcManager;
    }

    public EventIpcManager getEventIpcManager() {
        return this.m_eventMgr;
    }

    public Poller() {
        super(LOG4J_CATEGORY);
    }

    public EventIpcManager getEventManager() {
        return this.m_eventMgr;
    }

    public PollerEventProcessor getEventProcessor() {
        return this.m_eventProcessor;
    }

    public void setEventProcessor(PollerEventProcessor eventProcessor) {
        this.m_eventProcessor = eventProcessor;
    }

    public PollableNetwork getNetwork() {
        return this.m_network;
    }

    public void setNetwork(PollableNetwork network) {
        this.m_network = network;
    }

    void setQueryManager(QueryManager queryManager) {
        this.m_queryManager = queryManager;
    }

    public QueryManager getQueryManager() {
        return this.m_queryManager;
    }

    public PollerConfig getPollerConfig() {
        return this.m_pollerConfig;
    }

    public void setPollerConfig(PollerConfig pollerConfig) {
        this.m_pollerConfig = pollerConfig;
    }

    public PollOutagesConfig getPollOutagesConfig() {
        return this.m_pollOutagesConfig;
    }

    public void setPollOutagesConfig(PollOutagesConfig pollOutagesConfig) {
        this.m_pollOutagesConfig = pollOutagesConfig;
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setScheduler(LegacyScheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    public void setLocationAwarePollerClient(LocationAwarePollerClient locationAwarePollerClient) {
        this.m_locationAwarePollerClient = locationAwarePollerClient;
    }

    public ThresholdingService getThresholdingService() {
        return this.m_thresholdingService;
    }

    public void setThresholdingService(ThresholdingService thresholdingService) {
        this.m_thresholdingService = thresholdingService;
    }

    protected void onInit() {
        LOG.debug("init: serviceUnresponsive behavior: {}", (Object)(this.getPollerConfig().isServiceUnresponsiveEnabled() ? "enabled" : "disabled"));
        this.createScheduler();
        try {
            LOG.debug("init: Closing outages for unmanaged services");
            this.m_queryManager.closeOutagesForUnmanagedServices();
        }
        catch (Throwable e) {
            LOG.error("init: Failed to close ouates for unmanage services", e);
        }
        try {
            LOG.debug("start: Scheduling existing interfaces");
            this.scheduleExistingServices();
        }
        catch (Throwable sqlE) {
            LOG.error("start: Failed to schedule existing interfaces", sqlE);
        }
        try {
            LOG.debug("start: Creating event broadcast event processor");
            this.setEventProcessor(new PollerEventProcessor(this));
        }
        catch (Throwable t) {
            LOG.error("start: Failed to initialized the broadcast event receiver", t);
            throw new UndeclaredThrowableException(t);
        }
        this.m_initialized = true;
    }

    private void createScheduler() {
        try {
            LOG.debug("init: Creating poller scheduler");
            this.setScheduler(new LegacyScheduler("Poller", this.getPollerConfig().getThreads()));
        }
        catch (RuntimeException e) {
            LOG.error("init: Failed to create poller scheduler", (Throwable)e);
            throw e;
        }
    }

    protected void onStart() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("start: Starting poller scheduler");
            }
            this.getScheduler().start();
        }
        catch (RuntimeException e) {
            LOG.error("start: Failed to start scheduler", (Throwable)e);
            throw e;
        }
    }

    protected void onStop() {
        if (this.getScheduler() != null) {
            this.getScheduler().stop();
        }
        if (this.getEventProcessor() != null) {
            this.getEventProcessor().close();
        }
        this.setScheduler(null);
    }

    protected void onPause() {
        this.getScheduler().pause();
    }

    protected void onResume() {
        this.getScheduler().resume();
    }

    private void scheduleExistingServices() throws Exception {
        this.scheduleServices();
        this.getNetwork().recalculateStatus();
        this.getNetwork().propagateInitialCause();
        this.getNetwork().resetStatusChanged();
        LOG.debug("scheduleExistingServices: dumping content of pollable network: ");
        this.getNetwork().dump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleService(final int nodeId, String nodeLabel, String nodeLocation, final String ipAddr, final String svcName) {
        final String normalizedAddress = InetAddressUtils.normalize((String)ipAddr);
        try {
            PollableNode node;
            PollableNetwork pollableNetwork = this.getNetwork();
            synchronized (pollableNetwork) {
                node = this.getNetwork().getNode(nodeId);
                if (node == null) {
                    node = this.getNetwork().createNode(nodeId, nodeLabel, nodeLocation);
                }
            }
            final PollableNode svcNode = node;
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    Poller.this.m_transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                        protected void doInTransactionWithoutResult(TransactionStatus arg0) {
                            OnmsMonitoredService service = Poller.this.m_monitoredServiceDao.get(Integer.valueOf(nodeId), InetAddressUtils.addr((String)ipAddr), svcName);
                            if (Poller.this.scheduleService(service)) {
                                svcNode.recalculateStatus();
                                svcNode.processStatusChange(new Date());
                            } else {
                                LOG.warn("Attempt to schedule service {}/{}/{} found no active service", new Object[]{nodeId, normalizedAddress, svcName});
                            }
                        }
                    });
                }
            };
            node.withTreeLock(r);
        }
        catch (Throwable e) {
            LOG.error("Unable to schedule service {}/{}/{}", new Object[]{nodeId, normalizedAddress, svcName});
        }
    }

    private int scheduleServices() {
        final Criteria criteria = new Criteria(OnmsMonitoredService.class);
        criteria.addRestriction((Restriction)new InRestriction("status", Arrays.asList("A", "N")));
        return (Integer)this.m_transactionTemplate.execute((TransactionCallback)new TransactionCallback<Integer>(){

            public Integer doInTransaction(TransactionStatus arg0) {
                List services = Poller.this.m_monitoredServiceDao.findMatching(criteria);
                for (OnmsMonitoredService service : services) {
                    Poller.this.scheduleService(service);
                }
                return services.size();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scheduleService(OnmsMonitoredService service) {
        InetAddress addr;
        OnmsIpInterface iface = service.getIpInterface();
        Set outages = service.getCurrentOutages();
        OnmsOutage outage = outages == null || outages.size() < 1 ? null : (OnmsOutage)outages.iterator().next();
        OnmsEvent event = outage == null ? null : outage.getServiceLostEvent();
        String ipAddr = InetAddressUtils.str((InetAddress)iface.getIpAddress());
        String serviceName = service.getServiceName();
        boolean active = "A".equals(service.getStatus());
        Integer svcLostEventId = event == null ? null : event.getId();
        Date ifLostService = outage == null ? null : outage.getIfLostService();
        String svcLostUei = event == null ? null : event.getEventUei();
        this.closeOutageIfSvcLostEventIsMissing(outage);
        Package pkg = this.m_pollerConfig.findPackageForService(ipAddr, serviceName);
        if (pkg == null) {
            if (active) {
                LOG.warn("Active service {} on {} not configured for any package. Marking as Not Polled.", (Object)serviceName, (Object)ipAddr);
                this.updateServiceStatus(service, "N");
            }
            return false;
        }
        if (!active) {
            LOG.info("Active service {} on {} is now configured for a package. Marking as active.", (Object)serviceName, (Object)ipAddr);
            this.updateServiceStatus(service, "A");
        }
        if ((addr = InetAddressUtils.addr((String)ipAddr)) == null) {
            LOG.error("Could not convert {} as an InetAddress {}", (Object)ipAddr, (Object)ipAddr);
            return false;
        }
        PollableService svc = this.getNetwork().createService(service.getNodeId(), iface.getNode().getLabel(), iface.getNode().getLocation().getLocationName(), addr, serviceName);
        PollableServiceConfig pollConfig = new PollableServiceConfig(svc, this.m_pollerConfig, this.m_pollOutagesConfig, pkg, (Timer)this.getScheduler(), this.m_persisterFactory, this.m_thresholdingService, this.m_locationAwarePollerClient);
        svc.setPollConfig(pollConfig);
        PollableService pollableService = svc;
        synchronized (pollableService) {
            if (svc.getSchedule() == null) {
                Schedule schedule = new Schedule((ReadyRunnable)svc, (ScheduleInterval)pollConfig, (ScheduleTimer)this.getScheduler());
                svc.setSchedule(schedule);
            }
        }
        if (svcLostEventId == null) {
            if (svc.getParent().getStatus().isUnknown()) {
                svc.updateStatus(PollStatus.up());
            } else {
                svc.updateStatus(svc.getParent().getStatus());
            }
        } else {
            svc.updateStatus(PollStatus.down("Service has lost event : " + svcLostEventId));
            DbPollEvent cause = new DbPollEvent(svcLostEventId, svcLostUei, ifLostService);
            svc.setCause(cause);
        }
        svc.schedule();
        return true;
    }

    private void updateServiceStatus(OnmsMonitoredService service, String status) {
        service.setStatus(status);
        this.m_monitoredServiceDao.saveOrUpdate((Object)service);
    }

    private void closeOutageIfSvcLostEventIsMissing(OnmsOutage outage) {
        if (outage == null || outage.getServiceLostEvent() != null || outage.getIfRegainedService() != null) {
            return;
        }
        LOG.warn("Outage {} was left open without a lost service event. The outage will be closed.", (Object)outage);
        Date now = new Date();
        outage.setIfRegainedService(now);
        this.m_outageDao.update((Object)outage);
    }

    public void refreshServicePackages() {
        PollableVisitorAdaptor visitor = new PollableVisitorAdaptor(){

            @Override
            public void visitService(PollableService service) {
                service.refreshConfig();
            }
        };
        this.getNetwork().visit(visitor);
    }

    public long getNumPolls() {
        if (this.m_scheduler != null) {
            return this.m_scheduler.getNumTasksExecuted();
        }
        return 0L;
    }

    public static String getLoggingCategory() {
        return LOG4J_CATEGORY;
    }
}

