/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmpinterfacepoller;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollableSnmpInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnmpPollInterfaceMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpPollInterfaceMonitor.class);
    private static final String IF_ADMIN_STATUS_OID = ".1.3.6.1.2.1.2.2.1.7.";
    private static final String IF_OPER_STATUS_OID = ".1.3.6.1.2.1.2.2.1.8.";
    private final LocationAwareSnmpClient m_client;
    private String m_location;
    private long m_interval;

    public SnmpPollInterfaceMonitor(LocationAwareSnmpClient locationAwareSnmpClient) {
        this.m_client = locationAwareSnmpClient;
    }

    public List<PollableSnmpInterface.SnmpMinimalPollInterface> poll(SnmpAgentConfig agentConfig, List<PollableSnmpInterface.SnmpMinimalPollInterface> mifaces) {
        if (mifaces == null) {
            LOG.error("Null Interfaces passed to Monitor, exiting");
            return null;
        }
        LOG.debug("Got {} interfaces to poll", (Object)mifaces.size());
        if (agentConfig == null) {
            throw new RuntimeException("SnmpAgentConfig object not available");
        }
        SnmpObjId[] adminoids = new SnmpObjId[mifaces.size()];
        SnmpObjId[] operooids = new SnmpObjId[mifaces.size()];
        for (int i = 0; i < mifaces.size(); ++i) {
            PollableSnmpInterface.SnmpMinimalPollInterface miface = mifaces.get(i);
            miface.setStatus(PollStatus.unavailable());
            adminoids[i] = SnmpObjId.get((String)(IF_ADMIN_STATUS_OID + miface.getIfindex()));
            operooids[i] = SnmpObjId.get((String)(IF_OPER_STATUS_OID + miface.getIfindex()));
            LOG.debug("Adding Admin/Oper oids: {}/{}", (Object)adminoids[i], (Object)operooids[i]);
        }
        String ipAddress = agentConfig.getAddress().getCanonicalHostName();
        CompletableFuture adminValuesFuture = this.m_client.get(agentConfig, adminoids).withLocation(this.m_location).withDescription("SnmpInterfacePoller Admin Status for " + ipAddress).withTimeToLive(Long.valueOf(this.m_interval)).execute();
        CompletableFuture operationalValesFuture = this.m_client.get(agentConfig, operooids).withLocation(this.m_location).withDescription("SnmpInterfacePoller Operational Status for " + ipAddress).withTimeToLive(Long.valueOf(this.m_interval)).execute();
        List adminSnmpValues = new ArrayList();
        List operationalSnmpValues = new ArrayList();
        try {
            adminSnmpValues = (List)adminValuesFuture.get();
            operationalSnmpValues = (List)operationalValesFuture.get();
            if (adminSnmpValues.size() != mifaces.size()) {
                LOG.warn("Snmp Interface Admin statuses collection failed for interfaces in '{}' at location ", (Object)ipAddress, (Object)this.m_location);
                return mifaces;
            }
            if (operationalSnmpValues.size() != mifaces.size()) {
                LOG.warn("Snmp Interface Operational statuses collection failed for interfaces in '{}' at location {}", (Object)ipAddress, (Object)this.m_location);
                return mifaces;
            }
            LOG.debug("Received admin/operational statuses for interfaces in '{}' at location {}", (Object)ipAddress, (Object)this.m_location);
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Exception while retrieving admin/operational statuses for interfaces in '{}' at location", new Object[]{ipAddress, this.m_location, e});
            return null;
        }
        for (int i = 0; i < mifaces.size(); ++i) {
            PollableSnmpInterface.SnmpMinimalPollInterface miface = mifaces.get(i);
            SnmpValue adminSnmpValue = (SnmpValue)adminSnmpValues.get(i);
            SnmpValue operationalSnmpValue = (SnmpValue)operationalSnmpValues.get(i);
            if (adminSnmpValue != null && operationalSnmpValue != null) {
                try {
                    miface.setAdminstatus(adminSnmpValue.toInt());
                    miface.setOperstatus(operationalSnmpValue.toInt());
                    miface.setStatus(PollStatus.up());
                    LOG.debug("SNMP Value is {} for oid: {}", (Object)adminSnmpValue.toInt(), (Object)adminoids[i]);
                    LOG.debug("SNMP Value is {} for oid: {}", (Object)operationalSnmpValue.toInt(), (Object)operooids[i]);
                }
                catch (Exception e) {
                    LOG.warn("SNMP Value is {} for oid: {}", (Object)adminSnmpValue.toDisplayString(), (Object)adminoids[i]);
                    LOG.warn("SNMP Value is {} for oid: {}", (Object)operationalSnmpValue.toDisplayString(), (Object)operooids[i]);
                }
                continue;
            }
            LOG.info("SNMP Value is null for oid: {}/{}", (Object)adminoids[i], (Object)operooids[i]);
        }
        return mifaces;
    }

    public String getLocation() {
        return this.m_location;
    }

    public void setLocation(String location) {
        this.m_location = location;
    }

    public long getInterval() {
        return this.m_interval;
    }

    public void setInterval(long interval) {
        this.m_interval = interval;
    }
}

