/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.support.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable
public final class TcpMonitor
extends AbstractServiceMonitor {
    public static final Logger LOG = LoggerFactory.getLogger(TcpMonitor.class);
    private static final int DEFAULT_PORT = -1;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;
    public static final String PARAMETER_BANNER = "banner";
    public static final String PARAMETER_PORT = "port";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        int port = ParameterMap.getKeyedInteger(parameters, (String)PARAMETER_PORT, (int)-1);
        if (port == -1) {
            throw new RuntimeException("TcpMonitor: required parameter 'port' is not present in supplied properties.");
        }
        String strBannerMatch = ParameterMap.getKeyedString(parameters, (String)PARAMETER_BANNER, null);
        InetAddress ipAddr = svc.getAddress();
        String hostAddress = InetAddressUtils.str((InetAddress)ipAddr);
        LOG.debug("poll: address = {}, port = {}, {}", new Object[]{hostAddress, port, tracker});
        PollStatus serviceStatus = PollStatus.unavailable();
        tracker.reset();
        while (tracker.shouldRetry() && !serviceStatus.isAvailable()) {
            String reason;
            Socket socket = null;
            try {
                tracker.startAttempt();
                socket = new Socket();
                socket.connect(new InetSocketAddress(ipAddr, port), tracker.getConnectionTimeout());
                socket.setSoTimeout(tracker.getSoTimeout());
                LOG.debug("TcpMonitor: connected to host: {} on port: {}", (Object)ipAddr, (Object)port);
                serviceStatus = PollStatus.unresponsive();
                if (strBannerMatch == null || strBannerMatch.length() == 0 || strBannerMatch.equals("*")) {
                    serviceStatus = PollStatus.available(tracker.elapsedTimeInMillis());
                    break;
                }
                BufferedReader rdr = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                String response = rdr.readLine();
                double responseTime = tracker.elapsedTimeInMillis();
                if (response != null) {
                    LOG.debug("poll: banner = {}", (Object)response);
                    LOG.debug("poll: responseTime= {}ms", (Object)responseTime);
                    serviceStatus = strBannerMatch.charAt(0) == '~' ? (!response.matches(strBannerMatch.substring(1)) ? PollStatus.unavailable("Banner does not match Regex '" + strBannerMatch + "'") : PollStatus.available(responseTime)) : (response.indexOf(strBannerMatch) > -1 ? PollStatus.available(responseTime) : PollStatus.unavailable("Banner: '" + response + "' does not contain match string '" + strBannerMatch + "'"));
                }
            }
            catch (NoRouteToHostException e) {
                reason = "No route to host exception for address " + hostAddress;
                LOG.debug(reason, (Throwable)e);
                serviceStatus = PollStatus.unavailable(reason);
                break;
            }
            catch (InterruptedIOException e) {
                reason = "did not connect to host with " + tracker;
                LOG.debug(reason);
                serviceStatus = PollStatus.unavailable(reason);
            }
            catch (ConnectException e) {
                reason = "Connection exception for address: " + ipAddr;
                LOG.debug(reason, (Throwable)e);
                serviceStatus = PollStatus.unavailable(reason);
            }
            catch (IOException e) {
                reason = "IOException while polling address: " + ipAddr;
                LOG.debug(reason, (Throwable)e);
                serviceStatus = PollStatus.unavailable(reason);
            }
            finally {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException e) {
                    e.fillInStackTrace();
                    LOG.debug("poll: Error closing socket.", (Throwable)e);
                }
            }
            tracker.nextAttempt();
        }
        return serviceStatus;
    }
}

