/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.util.Map;
import java.util.StringTokenizer;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.support.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable
public final class Pop3Monitor
extends AbstractServiceMonitor {
    public static final Logger LOG = LoggerFactory.getLogger(Pop3Monitor.class);
    private static final int DEFAULT_PORT = 110;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        int port = ParameterMap.getKeyedInteger(parameters, (String)"port", (int)110);
        InetAddress ipAddr = svc.getAddress();
        LOG.debug("poll: address = {}, port = {}, {}", new Object[]{ipAddr, port, tracker});
        PollStatus serviceStatus = PollStatus.unavailable();
        tracker.reset();
        while (tracker.shouldRetry() && !serviceStatus.isAvailable()) {
            String reason;
            Socket socket = null;
            String hostAddress = InetAddressUtils.str((InetAddress)ipAddr);
            try {
                tracker.startAttempt();
                socket = new Socket();
                socket.connect(new InetSocketAddress(ipAddr, port), tracker.getConnectionTimeout());
                socket.setSoTimeout(tracker.getSoTimeout());
                LOG.debug("Pop3Monitor: connected to host: {} on port: {}", (Object)ipAddr, (Object)port);
                serviceStatus = PollStatus.unresponsive();
                BufferedReader rdr = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                String banner = rdr.readLine();
                double responseTime = tracker.elapsedTimeInMillis();
                if (banner != null) {
                    StringTokenizer t = new StringTokenizer(banner);
                    if (t.nextToken().equals("+OK")) {
                        String cmd = "QUIT\r\n";
                        socket.getOutputStream().write(cmd.getBytes());
                        t = new StringTokenizer(rdr.readLine());
                        if (t.nextToken().equals("+OK")) {
                            serviceStatus = PollStatus.available(responseTime);
                        }
                    }
                    if (!serviceStatus.isAvailable()) {
                        serviceStatus = PollStatus.unavailable();
                    }
                }
            }
            catch (NoRouteToHostException e) {
                reason = "No route to host exception for address " + hostAddress;
                LOG.debug(reason, (Throwable)e);
                serviceStatus = PollStatus.unavailable(reason);
            }
            catch (InterruptedIOException e) {
                reason = "did not connect to host with " + tracker;
                LOG.debug(reason);
                serviceStatus = PollStatus.unavailable(reason);
            }
            catch (ConnectException e) {
                reason = "Connection exception for address " + hostAddress;
                LOG.debug(reason, (Throwable)e);
                serviceStatus = PollStatus.unavailable(reason);
            }
            catch (IOException e) {
                reason = "IOException while polling address " + hostAddress;
                LOG.debug(reason, (Throwable)e);
                serviceStatus = PollStatus.unavailable(reason);
            }
            finally {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException e) {
                    LOG.debug("poll: Error closing socket.", (Throwable)e);
                }
            }
            tracker.nextAttempt();
        }
        return serviceStatus;
    }
}

