/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.support.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable(value={DistributionContext.DAEMON})
public class ActiveMQMonitor
extends AbstractServiceMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(ActiveMQMonitor.class);
    private static final int DEFAULT_RETRY = 3;
    private static final int DEFAULT_TIMEOUT = 3000;
    private static final String DEFAULT_BROKERURL = "vm://localhost?create=false&broker.persistent=false";
    private static final String PARAMETER_BROKERURL = "broker-url";
    private static final String PARAMETER_USER = "user";
    private static final String PARAMETER_PASSWORD = "password";
    private static final String PARAMETER_USE_NODELABEL = "use-nodelabel";
    private static final String PARAMETER_CLIENTID = "client-id";
    private static final String PARAMETER_CREATE_SESSION = "create-session";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        PollStatus status = PollStatus.unknown("polling never attempted");
        if (parameters == null) {
            throw new NullPointerException("parameter cannot be null");
        }
        String brokerURL = ParameterMap.getKeyedString(parameters, (String)PARAMETER_BROKERURL, (String)DEFAULT_BROKERURL);
        String userName = ParameterMap.getKeyedString(parameters, (String)PARAMETER_USER, null);
        String password = ParameterMap.getKeyedString(parameters, (String)PARAMETER_PASSWORD, null);
        Boolean useNodeLabel = ParameterMap.getKeyedBoolean(parameters, (String)PARAMETER_USE_NODELABEL, (boolean)false);
        Boolean createSession = ParameterMap.getKeyedBoolean(parameters, (String)PARAMETER_CREATE_SESSION, (boolean)false);
        String clientID = ParameterMap.getKeyedString(parameters, (String)PARAMETER_CLIENTID, null);
        URI uri = null;
        try {
            uri = new URI(brokerURL);
            LOG.debug("using brokerURL: {}", (Object)uri);
            if (useNodeLabel.booleanValue()) {
                uri = new URI(uri.getScheme(), uri.getUserInfo(), svc.getNodeLabel(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
                LOG.debug("using updated brokerURL: {}", (Object)uri);
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("broker URL cannot be parsed");
        }
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(uri);
        if (userName != null && !userName.isEmpty()) {
            connectionFactory.setUserName(userName);
        }
        if (password != null && !password.isEmpty()) {
            connectionFactory.setPassword(password);
        }
        connectionFactory.setClientID(clientID);
        TimeoutTracker timeoutTracker = new TimeoutTracker(parameters, 3, 3000);
        Connection connection = null;
        timeoutTracker.reset();
        while (timeoutTracker.shouldRetry()) {
            timeoutTracker.startAttempt();
            status = PollStatus.unknown("polling never attempted");
            try {
                connection = connectionFactory.createConnection();
                connection.start();
                if (createSession.booleanValue()) {
                    Session session = connection.createSession(false, 1);
                    session.close();
                }
                status = PollStatus.available(timeoutTracker.elapsedTimeInMillis());
                break;
            }
            catch (JMSException ex) {
                LOG.debug("Received a JMSException while connecting to the remote ActiveMQ Broker", (Throwable)ex);
            }
            finally {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (JMSException ex) {
                    LOG.debug("Received a JMSException while closing the connection to the remote ActiveMQ Broker", (Throwable)ex);
                }
            }
            timeoutTracker.nextAttempt();
        }
        return status;
    }
}

