/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.jmx;

import java.util.concurrent.ThreadPoolExecutor;
import org.opennms.netmgt.daemon.AbstractSpringContextJmxServiceDaemon;
import org.opennms.netmgt.poller.Poller;
import org.opennms.netmgt.poller.jmx.PollerdMBean;
import org.opennms.netmgt.scheduler.LegacyScheduler;

public class Pollerd
extends AbstractSpringContextJmxServiceDaemon<Poller>
implements PollerdMBean {
    protected String getLoggingPrefix() {
        return Poller.getLoggingCategory();
    }

    protected String getSpringContext() {
        return "pollerdContext";
    }

    @Override
    public long getActiveThreads() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getActiveCount();
        }
        return 0L;
    }

    @Override
    public long getTasksTotal() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getTaskCount();
        }
        return 0L;
    }

    @Override
    public long getTasksCompleted() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getCompletedTaskCount();
        }
        return 0L;
    }

    @Override
    public long getNumPolls() {
        return ((Poller)this.getDaemon()).getNumPolls();
    }

    @Override
    public double getTaskCompletionRatio() {
        if (this.getThreadPoolStatsStatus()) {
            if (this.getExecutor().getTaskCount() > 0L) {
                return new Double((double)this.getExecutor().getCompletedTaskCount() / new Double(this.getExecutor().getTaskCount()));
            }
            return new Double(0.0);
        }
        return new Double(0.0);
    }

    @Override
    public long getNumPoolThreads() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getPoolSize();
        }
        return 0L;
    }

    @Override
    public long getPeakPoolThreads() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getLargestPoolSize();
        }
        return 0L;
    }

    @Override
    public long getCorePoolThreads() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getCorePoolSize();
        }
        return 0L;
    }

    @Override
    public long getMaxPoolThreads() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getMaximumPoolSize();
        }
        return 0L;
    }

    @Override
    public long getTaskQueuePendingCount() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getQueue().size();
        }
        return 0L;
    }

    @Override
    public long getTaskQueueRemainingCapacity() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getQueue().remainingCapacity();
        }
        return 0L;
    }

    private ThreadPoolExecutor getExecutor() {
        return (ThreadPoolExecutor)((LegacyScheduler)((Poller)this.getDaemon()).getScheduler()).getRunner();
    }

    private boolean getThreadPoolStatsStatus() {
        return ((Poller)this.getDaemon()).getScheduler() instanceof LegacyScheduler;
    }
}

