/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.ConfigurationTestUtils;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.collectd.Collectd;
import org.opennms.netmgt.collectd.MockServiceCollector;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionInitializationException;
import org.opennms.netmgt.collection.api.PersisterFactory;
import org.opennms.netmgt.collection.api.ServiceCollector;
import org.opennms.netmgt.collection.api.ServiceCollectorRegistry;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.support.DefaultServiceCollectorRegistry;
import org.opennms.netmgt.collection.test.api.CollectorTestUtils;
import org.opennms.netmgt.config.CollectdConfigFactory;
import org.opennms.netmgt.config.collectd.CollectdConfiguration;
import org.opennms.netmgt.config.collectd.Collector;
import org.opennms.netmgt.config.collectd.Filter;
import org.opennms.netmgt.config.collectd.Package;
import org.opennms.netmgt.config.collectd.Parameter;
import org.opennms.netmgt.config.collectd.Service;
import org.opennms.netmgt.config.dao.outages.api.OverrideablePollOutagesDao;
import org.opennms.netmgt.config.dao.outages.api.ReadablePollOutagesDao;
import org.opennms.netmgt.config.dao.thresholding.api.OverrideableThresholdingDao;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.mock.MockTransactionTemplate;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.events.api.EventIpcManagerFactory;
import org.opennms.netmgt.events.api.EventListener;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.filter.api.FilterDao;
import org.opennms.netmgt.mock.MockPersisterFactory;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.scheduler.ReadyRunnable;
import org.opennms.netmgt.scheduler.Scheduler;
import org.opennms.netmgt.scheduler.mock.MockScheduler;
import org.opennms.netmgt.threshd.api.ThresholdingService;
import org.opennms.netmgt.threshd.api.ThresholdingSession;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.opennms.test.mock.EasyMockUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.SimpleTransactionStatus;
import org.springframework.transaction.support.TransactionTemplate;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-testThresholdingDaos.xml", "classpath:/META-INF/opennms/applicationContext-testPollerConfigDaos.xml"})
@JUnitConfigurationEnvironment
public class CollectdTest {
    private final EasyMockUtils m_easyMockUtils = new EasyMockUtils();
    private IpInterfaceDao m_ipIfDao;
    private FilterDao m_filterDao;
    private Collectd m_collectd;
    private MockScheduler m_scheduler;
    private CollectdConfiguration m_collectdConfig;
    private CollectdConfigFactory m_collectdConfigFactory;
    @Autowired
    private OverrideableThresholdingDao m_thresholdingDao;
    @Autowired
    private OverrideablePollOutagesDao m_pollOutagesDao;

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
        ClassPathResource threshdResource = new ClassPathResource("/etc/thresholds.xml");
        File homeDir = threshdResource.getFile().getParentFile().getParentFile();
        System.setProperty("opennms.home", homeDir.getAbsolutePath());
        EventIpcManager m_eventIpcManager = (EventIpcManager)this.m_easyMockUtils.createMock(EventIpcManager.class);
        EventIpcManagerFactory.setIpcManager((EventIpcManager)m_eventIpcManager);
        NodeDao m_nodeDao = (NodeDao)this.m_easyMockUtils.createMock(NodeDao.class);
        this.m_ipIfDao = (IpInterfaceDao)this.m_easyMockUtils.createMock(IpInterfaceDao.class);
        this.m_scheduler = new MockScheduler();
        m_eventIpcManager.addEventListener((EventListener)EasyMock.isA(EventListener.class));
        EasyMock.expectLastCall().anyTimes();
        m_eventIpcManager.addEventListener((EventListener)EasyMock.isA(EventListener.class), CollectdTest.isACollection(String.class));
        EasyMock.expectLastCall().anyTimes();
        m_eventIpcManager.addEventListener((EventListener)EasyMock.isA(EventListener.class), (String)EasyMock.isA(String.class));
        EasyMock.expectLastCall().anyTimes();
        m_eventIpcManager.removeEventListener((EventListener)EasyMock.isA(EventListener.class));
        EasyMock.expectLastCall().anyTimes();
        this.m_filterDao = (FilterDao)EasyMock.createMock(FilterDao.class);
        ArrayList<InetAddress> allIps = new ArrayList<InetAddress>();
        allIps.add(InetAddressUtils.addr((String)"192.168.1.1"));
        allIps.add(InetAddressUtils.addr((String)"192.168.1.2"));
        allIps.add(InetAddressUtils.addr((String)"192.168.1.3"));
        allIps.add(InetAddressUtils.addr((String)"192.168.1.4"));
        allIps.add(InetAddressUtils.addr((String)"192.168.1.5"));
        EasyMock.expect((Object)this.m_filterDao.getActiveIPAddressList("IPADDR IPLIKE *.*.*.*")).andReturn(allIps).anyTimes();
        EasyMock.expect((Object)this.m_filterDao.getActiveIPAddressList("IPADDR IPLIKE 1.1.1.1")).andReturn(new ArrayList(0)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.m_filterDao});
        FilterDaoFactory.setInstance((FilterDao)this.m_filterDao);
        ClassPathResource resource = new ClassPathResource("etc/poll-outages.xml");
        this.m_pollOutagesDao.overrideConfig(resource.getInputStream());
        MockTransactionTemplate transTemplate = new MockTransactionTemplate();
        transTemplate.afterPropertiesSet();
        this.m_collectd = new Collectd();
        this.m_collectd.setEventIpcManager(m_eventIpcManager);
        this.m_collectd.setNodeDao(m_nodeDao);
        this.m_collectd.setIpInterfaceDao(this.m_ipIfDao);
        this.m_collectd.setFilterDao(this.m_filterDao);
        this.m_collectd.setScheduler((Scheduler)this.m_scheduler);
        this.m_collectd.setTransactionTemplate((TransactionTemplate)transTemplate);
        this.m_collectd.setPersisterFactory((PersisterFactory)new MockPersisterFactory());
        this.m_collectd.setServiceCollectorRegistry((ServiceCollectorRegistry)new DefaultServiceCollectorRegistry());
        this.m_collectd.setLocationAwareCollectorClient(CollectorTestUtils.createLocationAwareCollectorClient());
        this.m_collectd.setPollOutagesDao((ReadablePollOutagesDao)this.m_pollOutagesDao);
        this.m_thresholdingDao.overrideConfig(ConfigurationTestUtils.getInputStreamForConfigFile((String)"thresholds.xml"));
    }

    private static Package getCollectionPackageThatMatchesSNMP() {
        Package pkg = new Package();
        pkg.setName("pkg");
        Filter filter = new Filter();
        filter.setContent("IPADDR IPLIKE *.*.*.*");
        pkg.setFilter(filter);
        Service svc = new Service();
        pkg.addService(svc);
        svc.setName("SNMP");
        svc.setStatus("on");
        Parameter parm = new Parameter();
        parm.setKey("collection");
        parm.setValue("default");
        svc.addParameter(parm);
        parm = new Parameter();
        parm.setKey("thresholding-enabled");
        parm.setValue("true");
        svc.addParameter(parm);
        svc.setStatus("on");
        return pkg;
    }

    @After
    public void tearDown() throws Exception {
        EasyMock.verify((Object[])new Object[]{this.m_filterDao});
    }

    private static OnmsIpInterface getInterface() {
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(1));
        OnmsIpInterface iface = new OnmsIpInterface(InetAddressUtils.getInetAddress((String)"192.168.1.1"), node);
        iface.setId(Integer.valueOf(1));
        return iface;
    }

    @Test
    public void testCreate() throws Exception {
        this.setupCollector("SNMP");
        this.setupTransactionManager();
        Scheduler m_scheduler = (Scheduler)this.m_easyMockUtils.createMock(Scheduler.class);
        this.m_collectd.setScheduler(m_scheduler);
        m_scheduler.schedule(EasyMock.eq((long)0L), (ReadyRunnable)EasyMock.isA(ReadyRunnable.class));
        m_scheduler.start();
        m_scheduler.stop();
        this.m_easyMockUtils.replayAll();
        this.m_collectd.afterPropertiesSet();
        this.m_collectd.start();
        this.m_collectd.stop();
        this.m_easyMockUtils.verifyAll();
    }

    @Test
    public void testOverrides() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("max-repetitions", "11");
        map.put("read-community", "notPublic");
        ServiceParameters params = new ServiceParameters(map);
        int reps = params.getSnmpMaxRepetitions(6);
        Assert.assertEquals((String)"Overriding max repetitions failed.", (long)11L, (long)reps);
        params = new ServiceParameters(map);
        map.remove("max-repetitions");
        map.put("maxRepetitions", "11");
        Assert.assertEquals((String)"Overriding max repetitions failed.", (long)11L, (long)reps);
        String s = params.getSnmpReadCommunity("public");
        Assert.assertEquals((String)"Overriding read community failed.", (Object)"notPublic", (Object)s);
        map.remove("read-community");
        map.put("readCommunity", "notPublic");
        params = new ServiceParameters(map);
        s = params.getSnmpReadCommunity("public");
        Assert.assertEquals((String)"Overriding read community failed.", (Object)"notPublic", (Object)s);
    }

    @Test
    public void testNoMatchingSpecs() throws Exception {
        this.setupCollector("SNMP");
        EasyMock.expect((Object)this.m_ipIfDao.findByServiceType("SNMP")).andReturn(new ArrayList(0));
        this.setupTransactionManager();
        this.m_easyMockUtils.replayAll();
        this.m_collectd.afterPropertiesSet();
        this.m_collectd.start();
        this.m_scheduler.next();
        Assert.assertEquals((long)0L, (long)this.m_scheduler.getEntryCount());
        this.m_collectd.stop();
        this.m_easyMockUtils.verifyAll();
    }

    @Test
    public void testOneMatchingSpec() throws Exception {
        OnmsIpInterface iface = CollectdTest.getInterface();
        this.setupCollector("SNMP");
        this.setupInterface(iface);
        this.setupTransactionManager();
        EasyMock.expect((Object)this.m_collectdConfig.getPackages()).andReturn(Collections.singletonList(CollectdTest.getCollectionPackageThatMatchesSNMP()));
        EasyMock.expect((Object)this.m_collectdConfigFactory.interfaceInPackage(iface, CollectdTest.getCollectionPackageThatMatchesSNMP())).andReturn((Object)true);
        ThresholdingService mockThresholdingService = (ThresholdingService)this.m_easyMockUtils.createMock(ThresholdingService.class);
        ThresholdingSession mockThresholdingSession = (ThresholdingSession)this.m_easyMockUtils.createMock(ThresholdingSession.class);
        EasyMock.expect((Object)mockThresholdingService.createSession(EasyMock.anyInt(), EasyMock.anyString(), EasyMock.anyString(), (RrdRepository)EasyMock.anyObject(), (ServiceParameters)EasyMock.anyObject())).andReturn((Object)mockThresholdingSession);
        this.m_collectd.setThresholdingService(mockThresholdingService);
        this.m_easyMockUtils.replayAll();
        Assert.assertEquals((String)"scheduler entry count", (long)0L, (long)this.m_scheduler.getEntryCount());
        this.m_collectd.afterPropertiesSet();
        this.m_collectd.start();
        this.m_scheduler.next();
        Assert.assertEquals((String)"scheduler entry count", (long)1L, (long)this.m_scheduler.getEntryCount());
        this.m_scheduler.next();
        this.m_collectd.stop();
        this.m_easyMockUtils.verifyAll();
    }

    @Test
    public void testInterfaceIsNotScheduledWhenValidationFails() throws Exception {
        ServiceCollector svcCollector = (ServiceCollector)this.m_easyMockUtils.createMock(ServiceCollector.class);
        svcCollector.initialize();
        svcCollector.validateAgent((CollectionAgent)EasyMock.isA(CollectionAgent.class), (Map)EasyMock.isA(Map.class));
        EasyMock.expectLastCall().andThrow((Throwable)new CollectionInitializationException("No!")).once();
        this.setupCollector("SNMP", svcCollector);
        OnmsIpInterface iface = CollectdTest.getInterface();
        this.setupInterface(iface);
        this.setupTransactionManager();
        EasyMock.expect((Object)this.m_collectdConfig.getPackages()).andReturn(Collections.singletonList(CollectdTest.getCollectionPackageThatMatchesSNMP()));
        EasyMock.expect((Object)this.m_collectdConfigFactory.interfaceInPackage(iface, CollectdTest.getCollectionPackageThatMatchesSNMP())).andReturn((Object)true);
        this.m_easyMockUtils.replayAll();
        Assert.assertEquals((String)"scheduler entry count", (long)0L, (long)this.m_scheduler.getEntryCount());
        this.m_collectd.afterPropertiesSet();
        this.m_collectd.start();
        this.m_scheduler.next();
        Assert.assertEquals((String)"scheduler entry count", (long)0L, (long)this.m_scheduler.getEntryCount());
        this.m_collectd.stop();
        this.m_easyMockUtils.verifyAll();
    }

    private static <K> Collection<K> isACollection(Class<K> innerClass) {
        return (Collection)EasyMock.isA(Collection.class);
    }

    private void setupTransactionManager() {
        PlatformTransactionManager m_transactionManager = (PlatformTransactionManager)this.m_easyMockUtils.createMock(PlatformTransactionManager.class);
        TransactionTemplate transactionTemplate = new TransactionTemplate(m_transactionManager);
        this.m_collectd.setTransactionTemplate(transactionTemplate);
        EasyMock.expect((Object)m_transactionManager.getTransaction((TransactionDefinition)EasyMock.isA(TransactionDefinition.class))).andReturn((Object)new SimpleTransactionStatus()).anyTimes();
        m_transactionManager.rollback((TransactionStatus)EasyMock.isA(TransactionStatus.class));
        EasyMock.expectLastCall().anyTimes();
        m_transactionManager.commit((TransactionStatus)EasyMock.isA(TransactionStatus.class));
        EasyMock.expectLastCall().anyTimes();
    }

    private void setupInterface(OnmsIpInterface iface) {
        EasyMock.expect((Object)this.m_ipIfDao.findByServiceType("SNMP")).andReturn(Collections.singletonList(iface));
        EasyMock.expect((Object)this.m_ipIfDao.load((Serializable)iface.getId())).andReturn((Object)iface).atLeastOnce();
    }

    private void setupCollector(String svcName) throws CollectionInitializationException {
        ServiceCollector svcCollector = (ServiceCollector)this.m_easyMockUtils.createMock(ServiceCollector.class);
        svcCollector.initialize();
        svcCollector.validateAgent((CollectionAgent)EasyMock.isA(CollectionAgent.class), (Map)EasyMock.isA(Map.class));
        EasyMock.expectLastCall().anyTimes();
        this.setupCollector(svcName, svcCollector);
    }

    private void setupCollector(String svcName, ServiceCollector svcCollector) throws CollectionInitializationException {
        MockServiceCollector.setDelegate(svcCollector);
        Collector collector = new Collector();
        collector.setService(svcName);
        collector.setClassName(MockServiceCollector.class.getName());
        this.m_collectdConfigFactory = (CollectdConfigFactory)this.m_easyMockUtils.createMock(CollectdConfigFactory.class);
        this.m_collectdConfig = (CollectdConfiguration)this.m_easyMockUtils.createMock(CollectdConfiguration.class);
        EasyMock.expect((Object)this.m_collectdConfigFactory.getCollectdConfig()).andReturn((Object)this.m_collectdConfig).anyTimes();
        EasyMock.expect((Object)this.m_collectdConfig.getCollectors()).andReturn(Collections.singletonList(collector)).anyTimes();
        EasyMock.expect((Object)this.m_collectdConfig.getThreads()).andReturn((Object)1).anyTimes();
        this.m_collectd.setCollectdConfigFactory(this.m_collectdConfigFactory);
    }
}

