/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.opennms.netmgt.collectd.CollectdIntegrationTest;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionInitializationException;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.ServiceCollector;
import org.opennms.netmgt.collection.support.builder.CollectionSetBuilder;
import org.opennms.netmgt.rrd.RrdRepository;

public class MockServiceCollector
implements ServiceCollector {
    private static ServiceCollector s_delegate = null;
    private static int s_collectCount = 0;

    public MockServiceCollector() {
        System.err.println("Created a MockServiceCollector");
    }

    public CollectionSet collect(CollectionAgent agent, Map<String, Object> parameters) {
        String testKey = (String)parameters.get("key");
        if (testKey != null) {
            CollectdIntegrationTest.setServiceCollectorInTest(testKey, this);
        }
        ++s_collectCount;
        if (s_delegate != null) {
            return s_delegate.collect(agent, parameters);
        }
        return new CollectionSetBuilder(agent).build();
    }

    public int getCollectCount() {
        return s_collectCount;
    }

    public static void setDelegate(ServiceCollector delegate) {
        s_delegate = delegate;
    }

    public RrdRepository getRrdRepository(String collectionName) {
        RrdRepository repo = new RrdRepository();
        repo.setRrdBaseDir(new File("target"));
        repo.setRraList(Collections.singletonList("RRA:AVERAGE:0.5:1:8928"));
        repo.setStep(300);
        repo.setHeartBeat(600);
        return repo;
    }

    public void initialize() throws CollectionInitializationException {
        if (s_delegate != null) {
            s_delegate.initialize();
        }
    }

    public void validateAgent(CollectionAgent agent, Map<String, Object> parameters) throws CollectionInitializationException {
        if (s_delegate != null) {
            s_delegate.validateAgent(agent, parameters);
        }
    }

    public Map<String, Object> getRuntimeAttributes(CollectionAgent agent, Map<String, Object> parameters) {
        if (s_delegate != null) {
            return s_delegate.getRuntimeAttributes(agent, parameters);
        }
        return Collections.emptyMap();
    }

    public String getEffectiveLocation(String location) {
        if (s_delegate != null) {
            return s_delegate.getEffectiveLocation(location);
        }
        return null;
    }

    public Map<String, String> marshalParameters(Map<String, Object> parameters) {
        if (s_delegate != null) {
            return s_delegate.marshalParameters(parameters);
        }
        throw new UnsupportedOperationException();
    }

    public Map<String, Object> unmarshalParameters(Map<String, String> parameters) {
        if (s_delegate != null) {
            return s_delegate.unmarshalParameters(parameters);
        }
        throw new UnsupportedOperationException();
    }
}

