/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rtc;

import com.google.common.collect.Lists;
import java.util.Date;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.MockDatabase;
import org.opennms.core.test.db.TemporaryDatabaseAware;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.api.OutageDao;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.mock.MockService;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.netmgt.rtc.AvailabilityService;
import org.opennms.netmgt.rtc.RTCUtils;
import org.opennms.netmgt.rtc.datablock.RTCCategory;
import org.opennms.netmgt.xml.rtc.Category;
import org.opennms.netmgt.xml.rtc.EuiLevel;
import org.opennms.netmgt.xml.rtc.Node;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.support.TransactionTemplate;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/applicationContext-rtc.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase(tempDbClass=MockDatabase.class, reuseDatabase=false)
public class AvailabilityServiceIT
implements TemporaryDatabaseAware<MockDatabase> {
    @Autowired
    private AvailabilityService m_availabilityService;
    @Autowired
    private OutageDao m_outageDao;
    @Autowired
    private MonitoredServiceDao m_monitoredServiceDao;
    @Autowired
    private TransactionTemplate m_transactionTemplate;
    private MockDatabase m_mockDatabase;

    public void setTemporaryDatabase(MockDatabase database) {
        this.m_mockDatabase = database;
    }

    @Before
    public void setUp() {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Test
    public void categoryIsFullyAvailableWhenNoServicesArePresent() throws Exception {
        RTCCategory rtcCat = (RTCCategory)EasyMock.createNiceMock(RTCCategory.class);
        EasyMock.expect((Object)rtcCat.getLabel()).andReturn((Object)"Routers");
        EasyMock.expect((Object)rtcCat.getNodes()).andReturn((Object)Lists.newArrayList((Object[])new Integer[]{99999}));
        EasyMock.replay((Object[])new Object[]{rtcCat});
        EuiLevel euiLevel = this.m_availabilityService.getEuiLevel(rtcCat);
        Assert.assertEquals((long)1L, (long)euiLevel.getCategory().size());
        Category category = (Category)euiLevel.getCategory().get(0);
        Assert.assertEquals((double)100.0, (double)category.getCatvalue(), (double)0.001);
        Assert.assertEquals((long)1L, (long)category.getNode().size());
        Node node = (Node)category.getNode().get(0);
        Assert.assertEquals((double)100.0, (double)node.getNodevalue(), (double)0.001);
        Assert.assertEquals((long)0L, (long)node.getNodesvccount());
        Assert.assertEquals((long)0L, (long)node.getNodesvcdowncount());
    }

    @Test
    public void canCalculateAvailability() throws Exception {
        MockNetwork mockNetwork = new MockNetwork();
        mockNetwork.createStandardNetwork();
        this.m_mockDatabase.populate(mockNetwork);
        RTCCategory rtcCat = (RTCCategory)EasyMock.createNiceMock(RTCCategory.class);
        EasyMock.expect((Object)rtcCat.getLabel()).andReturn((Object)"NOC").anyTimes();
        EasyMock.expect((Object)rtcCat.getNodes()).andReturn((Object)Lists.newArrayList((Object[])new Integer[]{1, 2})).anyTimes();
        EasyMock.replay((Object[])new Object[]{rtcCat});
        EuiLevel euiLevel = this.m_availabilityService.getEuiLevel(rtcCat);
        Assert.assertEquals((long)1L, (long)euiLevel.getCategory().size());
        Category category = (Category)euiLevel.getCategory().get(0);
        Assert.assertEquals((double)100.0, (double)category.getCatvalue(), (double)0.001);
        Assert.assertEquals((long)2L, (long)category.getNode().size());
        Assert.assertEquals((long)4L, (long)((Node)category.getNode().get(0)).getNodesvccount());
        Assert.assertEquals((long)2L, (long)((Node)category.getNode().get(1)).getNodesvccount());
        Date now = new Date();
        Date oneHourAgo = new Date(now.getTime() - 3600000L);
        Date thirtyMinutesAgo = new Date(now.getTime() - 1800000L);
        OnmsMonitoredService icmpService = this.toMonitoredService(mockNetwork.getService(1, "192.168.1.1", "ICMP"));
        OnmsOutage outage = new OnmsOutage();
        outage.setMonitoredService(icmpService);
        outage.setIfLostService(oneHourAgo);
        outage.setIfRegainedService(thirtyMinutesAgo);
        this.m_outageDao.save((Object)outage);
        this.m_outageDao.flush();
        euiLevel = this.m_availabilityService.getEuiLevel(rtcCat);
        Assert.assertEquals((long)1L, (long)euiLevel.getCategory().size());
        category = (Category)euiLevel.getCategory().get(0);
        Assert.assertEquals((double)RTCUtils.getOutagePercentage((double)1800000.0, (long)86400000L, (long)6L), (double)category.getCatvalue(), (double)1.0E-4);
        Assert.assertEquals((long)2L, (long)category.getNode().size());
    }

    private OnmsMonitoredService toMonitoredService(MockService svc) {
        return this.m_monitoredServiceDao.get(Integer.valueOf(svc.getNodeId()), svc.getAddress(), svc.getSvcName());
    }
}

