/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import com.jayway.awaitility.Awaitility;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.netmgt.mock.MockNode;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.notifd.NotificationsITCase;
import org.opennms.netmgt.notifd.ThreadLockingNotificationStrategy;
import org.opennms.test.ThreadLocker;

public class NotificationThreadsIT
extends NotificationsITCase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void canLimitThreads() throws Exception {
        int N = this.m_notifdConfig.getConfiguration().getMaxThreads();
        Assert.assertTrue((String)(N + " should be some positive value < max int."), (0 < N && N < Integer.MAX_VALUE ? 1 : 0) != 0);
        ThreadLocker threadLocker = ThreadLockingNotificationStrategy.getThreadLocker();
        CompletableFuture future = ThreadLockingNotificationStrategy.getThreadLocker().waitForThreads(N);
        int M = 2 * N;
        for (int i = 0; i < M; ++i) {
            MockNode node = this.m_network.getNode(1);
            EventBuilder eb = new EventBuilder("uei.opennms.org/test/notificationConcurrencyTest", "test");
            eb.setNodeid((long)node.getNodeId());
            this.m_eventMgr.sendEventToListeners(eb.getEvent());
        }
        future.get(1L, TimeUnit.MINUTES);
        Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
        Assert.assertEquals((long)0L, (long)threadLocker.getNumExtraThreadsWaiting());
        threadLocker.release();
        Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(ThreadLockingNotificationStrategy::getNotificationsSent, Matchers.equalTo((Object)M));
    }
}

