/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.util.ArrayList;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.test.http.JUnitHttpServerExecutionListener;
import org.opennms.core.test.http.annotations.JUnitHttpServer;
import org.opennms.core.test.http.annotations.Webapp;
import org.opennms.netmgt.model.notifd.Argument;
import org.opennms.netmgt.notifd.HttpNotificationStrategy;
import org.opennms.netmgt.notifd.HttpNotificationStrategyTestServlet;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-mockDao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-pinger.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class HttpNotificationStrategyIT {
    @Test
    @JUnitHttpServer(webapps={@Webapp(context="/cgi-bin/noauth", path="src/test/resources/HttpNotificationStrategyTest")})
    public void testSend() {
        int port = JUnitHttpServerExecutionListener.getPort();
        Assert.assertTrue((port > 0 ? 1 : 0) != 0);
        try {
            String message = "text message for unit testing";
            HttpNotificationStrategy ns = new HttpNotificationStrategy();
            ArrayList<Argument> arguments = new ArrayList<Argument>();
            arguments.add(new Argument("url", null, "http://localhost:" + port + "/cgi-bin/noauth/nmsgw.pl", false));
            arguments.add(new Argument("post-NodeID", null, "1", false));
            arguments.add(new Argument("result-match", null, "(?s).*OK\\s+([0-9]+).*", false));
            arguments.add(new Argument("post-message", null, "-tm", false));
            arguments.add(new Argument("-tm", null, "text message for unit testing", false));
            arguments.add(new Argument("sql", null, "UPDATE alarms SET tticketID=${1} WHERE lastEventID = 1", false));
            int statusCode = ns.send(arguments);
            Assert.assertEquals((long)200L, (long)statusCode);
            Map<String, String> parameters = HttpNotificationStrategyTestServlet.getRequestParameters();
            Assert.assertNotNull(parameters);
            Assert.assertEquals((long)2L, (long)parameters.size());
            Assert.assertEquals((Object)"1", (Object)parameters.get("NodeID"));
            Assert.assertEquals((Object)"text message for unit testing", (Object)parameters.get("message"));
        }
        catch (Throwable e) {
            e.printStackTrace();
            Assert.fail((String)("Caught Exception: " + e.getMessage()));
        }
    }
}

