/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.List;
import java.util.TreeMap;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.rpc.api.RpcClientFactory;
import org.opennms.core.rpc.mock.MockRpcClientFactory;
import org.opennms.core.test.MockPlatformTransactionManager;
import org.opennms.netmgt.collectd.DefaultSnmpCollectionAgent;
import org.opennms.netmgt.collectd.GenericIndexResource;
import org.opennms.netmgt.collectd.GenericIndexResourceType;
import org.opennms.netmgt.collectd.OnmsSnmpCollection;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.SnmpAttributeType;
import org.opennms.netmgt.collectd.SnmpCollectionAgent;
import org.opennms.netmgt.collectd.StringAttributeType;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.config.api.DataCollectionConfigDao;
import org.opennms.netmgt.config.collectd.Filter;
import org.opennms.netmgt.config.collectd.Package;
import org.opennms.netmgt.config.collectd.Parameter;
import org.opennms.netmgt.config.collectd.Service;
import org.opennms.netmgt.config.datacollection.MibObject;
import org.opennms.netmgt.config.datacollection.PersistenceSelectorStrategy;
import org.opennms.netmgt.config.datacollection.StorageStrategy;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.mock.MockDataCollectionConfigDao;
import org.opennms.netmgt.model.NetworkBuilder;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;
import org.opennms.netmgt.snmp.proxy.common.LocationAwareSnmpClientRpcImpl;
import org.opennms.netmgt.snmp.snmp4j.Snmp4JValueFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.transaction.PlatformTransactionManager;

public class PersistRegexSelectorStrategyTest {
    private IpInterfaceDao ipInterfaceDao;
    private GenericIndexResource resourceA;
    private GenericIndexResource resourceB;
    private ServiceParameters serviceParams;

    @Before
    public void setUp() throws Exception {
        this.ipInterfaceDao = (IpInterfaceDao)EasyMock.createMock(IpInterfaceDao.class);
        String localhost = InetAddress.getLocalHost().getHostAddress();
        NetworkBuilder builder = new NetworkBuilder();
        builder.addNode("myNode");
        builder.addInterface(localhost).setIsManaged("M").setIsSnmpPrimary("P");
        OnmsNode node = builder.getCurrentNode();
        node.setId(Integer.valueOf(1));
        OnmsIpInterface ipInterface = (OnmsIpInterface)node.getIpInterfaces().iterator().next();
        EasyMock.expect((Object)this.ipInterfaceDao.load((Serializable)Integer.valueOf(1))).andReturn((Object)ipInterface).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.ipInterfaceDao});
        Package pkg = new Package();
        pkg.setName("junitTestPackage");
        Filter filter = new Filter();
        filter.setContent("IPADDR != '0.0.0.0'");
        pkg.setFilter(filter);
        Service service = new Service();
        service.setName("SNMP");
        pkg.addService(service);
        TreeMap<String, String> map = new TreeMap<String, String>();
        List params = pkg.getService("SNMP").getParameters();
        for (Parameter p : params) {
            map.put(p.getKey(), p.getValue());
        }
        map.put("collection", "default");
        this.serviceParams = new ServiceParameters(map);
        LocationAwareSnmpClientRpcImpl locationAwareSnmpClient = new LocationAwareSnmpClientRpcImpl((RpcClientFactory)new MockRpcClientFactory());
        MockPlatformTransactionManager ptm = new MockPlatformTransactionManager();
        SnmpCollectionAgent agent = DefaultSnmpCollectionAgent.create((Integer)1, (IpInterfaceDao)this.ipInterfaceDao, (PlatformTransactionManager)ptm);
        OnmsSnmpCollection snmpCollection = new OnmsSnmpCollection(agent, this.serviceParams, (DataCollectionConfigDao)new MockDataCollectionConfigDao(), (LocationAwareSnmpClient)locationAwareSnmpClient);
        org.opennms.netmgt.config.datacollection.ResourceType rt = new org.opennms.netmgt.config.datacollection.ResourceType();
        rt.setName("myResourceType");
        StorageStrategy storageStrategy = new StorageStrategy();
        storageStrategy.setClazz("org.opennms.netmgt.collection.support.IndexStorageStrategy");
        rt.setStorageStrategy(storageStrategy);
        PersistenceSelectorStrategy persistenceSelectorStrategy = new PersistenceSelectorStrategy();
        persistenceSelectorStrategy.setClazz("org.opennms.netmgt.collectd.PersistRegexSelectorStrategy");
        org.opennms.netmgt.config.datacollection.Parameter param = new org.opennms.netmgt.config.datacollection.Parameter();
        param.setKey("match-expression");
        param.setValue("#name matches '^agalue.*$'");
        persistenceSelectorStrategy.addParameter((org.opennms.netmgt.collection.api.Parameter)param);
        rt.setPersistenceSelectorStrategy(persistenceSelectorStrategy);
        GenericIndexResourceType resourceType = new GenericIndexResourceType(agent, snmpCollection, rt);
        this.resourceA = new GenericIndexResource((ResourceType)resourceType, rt.getName(), new SnmpInstId("1.2.3.4.5.6.7.8.9.1.1"));
        AttributeGroupType groupType = new AttributeGroupType("mib2-interfaces", "all");
        MibObject mibObject = new MibObject();
        mibObject.setOid(".1.2.3.4.5.6.7.8.9.2.1");
        mibObject.setInstance("1");
        mibObject.setAlias("name");
        mibObject.setType("string");
        StringAttributeType attributeType = new StringAttributeType((ResourceType)resourceType, snmpCollection.getName(), mibObject, groupType);
        SnmpValue snmpValue = new Snmp4JValueFactory().getOctetString("agalue rules!".getBytes());
        this.resourceA.setAttributeValue((SnmpAttributeType)attributeType, snmpValue);
        this.resourceB = new GenericIndexResource((ResourceType)resourceType, rt.getName(), new SnmpInstId("1.2.3.4.5.6.7.8.9.1.2"));
    }

    @After
    public void tearDown() throws Exception {
        EasyMock.verify((Object[])new Object[]{this.ipInterfaceDao});
    }

    @Test
    public void testPersistSelector() throws Exception {
        Assert.assertTrue((boolean)this.resourceA.shouldPersist(this.serviceParams));
        Assert.assertFalse((boolean)this.resourceB.shouldPersist(this.serviceParams));
    }

    @Test
    public void testSpringEl() throws Exception {
        SpelExpressionParser parser = new SpelExpressionParser();
        Expression exp = parser.parseExpression("#name matches '^Alejandro.*'");
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.setVariable("name", (Object)"Alejandro Galue");
        boolean result = (Boolean)exp.getValue((EvaluationContext)context, Boolean.class);
        Assert.assertTrue((boolean)result);
    }
}

