/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.Map;
import org.opennms.core.utils.AlphaNumeric;
import org.opennms.netmgt.collectd.OnmsSnmpCollection;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.SNMPCollectorEntry;
import org.opennms.netmgt.collectd.SnmpCollectionResource;
import org.opennms.netmgt.collectd.SnmpIfData;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.model.ResourcePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IfInfo
extends SnmpCollectionResource {
    private static final Logger LOG = LoggerFactory.getLogger(IfInfo.class);
    private SNMPCollectorEntry m_entry;
    private String m_ifAlias;
    private final SnmpIfData m_snmpIfData;

    public IfInfo(ResourceType def, CollectionAgent agent, SnmpIfData snmpIfData) {
        super(def);
        this.m_snmpIfData = snmpIfData;
        this.m_ifAlias = snmpIfData.getIfAlias();
    }

    public int getNodeId() {
        return this.m_snmpIfData.getNodeId();
    }

    public int getIndex() {
        return this.m_snmpIfData.getIfIndex();
    }

    @Override
    public int getSnmpIfType() {
        return this.m_snmpIfData.getIfType();
    }

    public String getInterfaceLabel() {
        return this.m_snmpIfData.getLabelForRRD();
    }

    public void setIfAlias(String ifAlias) {
        this.m_ifAlias = ifAlias;
    }

    String getCurrentIfAlias() {
        return this.m_ifAlias;
    }

    public boolean isCollectionEnabled() {
        return this.m_snmpIfData.isCollectionEnabled();
    }

    public void setEntry(SNMPCollectorEntry ifEntry) {
        this.m_entry = ifEntry;
    }

    protected SNMPCollectorEntry getEntry() {
        return this.m_entry;
    }

    public Map<String, String> getAttributesMap() {
        return this.m_snmpIfData.getAttributesMap();
    }

    String getNewIfAlias() {
        if (this.getEntry() == null) {
            return this.getCurrentIfAlias();
        }
        return this.getEntry().getValueForBase(".1.3.6.1.2.1.31.1.1.1.18");
    }

    boolean currentAliasIsOutOfDate(String ifAlias) {
        LOG.debug("currentAliasIsOutOfDate: ifAlias from collection = {}, current ifAlias = {}", (Object)ifAlias, (Object)this.getCurrentIfAlias());
        return ifAlias != null && !ifAlias.equals(this.getCurrentIfAlias());
    }

    void logAlias(String ifAlias) {
        LOG.debug("Alias for RRD directory name = {}", (Object)ifAlias);
    }

    String getAliasDir(String ifAlias, String ifAliasComment) {
        if (ifAlias != null) {
            int si;
            if (ifAliasComment != null && (si = ifAlias.indexOf(ifAliasComment)) > -1) {
                ifAlias = ifAlias.substring(0, si).trim();
            }
            if (ifAlias != null) {
                ifAlias = AlphaNumeric.parseAndReplaceExcept((String)ifAlias, (char)'_', (String)"-._");
            }
        }
        this.logAlias(ifAlias);
        return ifAlias;
    }

    void logForceRescan(String ifAlias) {
        LOG.debug("Forcing rescan.  IfAlias {} for index {} does not match DB value: {}", new Object[]{ifAlias, this.getIndex(), this.getCurrentIfAlias()});
    }

    public boolean isScheduledForCollection() {
        LOG.debug("{} .collectionEnabled = {}", (Object)this, (Object)this.isCollectionEnabled());
        LOG.debug("selectCollectionOnly = {}", (Object)this.getCollection().isSelectCollectionOnly());
        boolean isScheduled = this.isCollectionEnabled() || !this.getCollection().isSelectCollectionOnly();
        LOG.debug("isScheduled = {}", (Object)isScheduled);
        return isScheduled;
    }

    private OnmsSnmpCollection getCollection() {
        return this.getResourceType().getCollection();
    }

    public ResourcePath getPath() {
        String label = this.getInterfaceLabel();
        if (label == null || "".equals(label)) {
            throw new IllegalStateException("Could not construct resource directory because interface label is null or blank: nodeId: " + this.getNodeId());
        }
        return ResourcePath.get((ResourcePath)this.getCollectionAgent().getStorageResourcePath(), (String[])new String[]{label});
    }

    public String toString() {
        return "node[" + this.getNodeId() + "].interfaceSnmp[" + this.getInterfaceLabel() + ']';
    }

    boolean shouldStore(ServiceParameters serviceParameters) {
        if ("normal".equalsIgnoreCase(serviceParameters.getStoreByNodeID())) {
            return this.isScheduledForCollection();
        }
        return "true".equalsIgnoreCase(serviceParameters.getStoreByNodeID());
    }

    @Override
    public boolean shouldPersist(ServiceParameters serviceParameters) {
        boolean shdprsist = this.shouldStore(serviceParameters) && (this.isScheduledForCollection() || serviceParameters.forceStoreByAlias(this.getCurrentIfAlias()));
        LOG.debug("shouldPersist = {}", (Object)shdprsist);
        return shdprsist;
    }

    public String getResourceTypeName() {
        return "if";
    }

    public String getInstance() {
        return Integer.toUnsignedString(this.getIndex());
    }

    public ResourcePath getParent() {
        return this.getCollectionAgent().getStorageResourcePath();
    }
}

