/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.poller.LatencyCollectionAttribute;
import org.opennms.netmgt.poller.LatencyCollectionAttributeType;
import org.opennms.netmgt.poller.LatencyCollectionResource;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.threshd.CollectionResourceWrapper;
import org.opennms.netmgt.threshd.ThresholdEntity;
import org.opennms.netmgt.threshd.ThresholdInitializationException;
import org.opennms.netmgt.threshd.ThresholdingSet;
import org.opennms.netmgt.xml.event.Event;

public class LatencyThresholdingSet
extends ThresholdingSet {
    private final String m_location;
    private final ResourceStorageDao m_resourceStorageDao;

    public LatencyThresholdingSet(int nodeId, String hostAddress, String serviceName, String location, RrdRepository repository, ResourceStorageDao resourceStorageDao) throws ThresholdInitializationException {
        super(nodeId, hostAddress, serviceName, repository);
        this.m_resourceStorageDao = resourceStorageDao;
        this.m_location = location;
    }

    public boolean hasThresholds(Map<String, Double> attributes) {
        if (this.hasThresholds()) {
            for (String ds : attributes.keySet()) {
                if (!this.hasThresholds("if", ds)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Event> applyThresholds(String svcName, Map<String, Double> attributes) {
        LatencyCollectionResource latencyResource = new LatencyCollectionResource(svcName, this.m_hostAddress, this.m_location);
        LatencyCollectionAttributeType latencyType = new LatencyCollectionAttributeType();
        HashMap<String, CollectionAttribute> attributesMap = new HashMap<String, CollectionAttribute>();
        for (Map.Entry<String, Double> entry : attributes.entrySet()) {
            String ds = entry.getKey();
            attributesMap.put(ds, new LatencyCollectionAttribute(latencyResource, latencyType, ds, entry.getValue()));
        }
        CollectionResourceWrapper resourceWrapper = new CollectionResourceWrapper(new Date(), this.m_nodeId, this.m_hostAddress, this.m_serviceName, this.m_repository, latencyResource, attributesMap, this.m_resourceStorageDao);
        return Collections.unmodifiableList(this.applyThresholds(resourceWrapper, attributesMap));
    }

    @Override
    protected boolean passedThresholdFilters(CollectionResourceWrapper resource, ThresholdEntity thresholdEntity) {
        return true;
    }
}

