/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.pollables;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.pollables.LockUnavailable;
import org.opennms.netmgt.poller.pollables.PollContext;
import org.opennms.netmgt.poller.pollables.PollableContainer;
import org.opennms.netmgt.poller.pollables.PollableElement;
import org.opennms.netmgt.poller.pollables.PollableInterface;
import org.opennms.netmgt.poller.pollables.PollableNetwork;
import org.opennms.netmgt.poller.pollables.PollableService;
import org.opennms.netmgt.poller.pollables.PollableVisitor;
import org.opennms.netmgt.poller.pollables.Scope;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollableNode
extends PollableContainer {
    private static final Logger LOG = LoggerFactory.getLogger(PollableNode.class);
    private final int m_nodeId;
    private String m_nodeLabel;
    private final String m_nodeLocation;
    private final ReentrantLock m_lock = new ReentrantLock(true);

    public PollableNode(PollableNetwork network, int nodeId, String nodeLabel, String nodeLocation) {
        super(network, Scope.NODE);
        this.m_nodeId = nodeId;
        this.m_nodeLabel = nodeLabel;
        this.m_nodeLocation = nodeLocation;
    }

    public int getNodeId() {
        return this.m_nodeId;
    }

    public String getNodeLabel() {
        return this.m_nodeLabel;
    }

    public void setNodeLabel(String label) {
        this.m_nodeLabel = label;
    }

    public String getNodeLocation() {
        return this.m_nodeLocation;
    }

    public PollableInterface createInterface(final InetAddress addr) {
        final PollableInterface[] retVal = new PollableInterface[1];
        Runnable r = new Runnable(){

            @Override
            public void run() {
                PollableInterface iface = new PollableInterface(PollableNode.this, addr);
                PollableNode.this.addMember(iface);
                retVal[0] = iface;
            }
        };
        this.withTreeLock(r);
        return retVal[0];
    }

    public PollableInterface getInterface(InetAddress addr) {
        return (PollableInterface)this.getMember(addr);
    }

    public List<PollableInterface> getInterfaces() {
        ArrayList<PollableInterface> ifaces = new ArrayList<PollableInterface>();
        for (PollableElement pe : this.getMembers()) {
            if (!(pe instanceof PollableInterface)) continue;
            ifaces.add((PollableInterface)pe);
        }
        return ifaces;
    }

    public PollableNetwork getNetwork() {
        return (PollableNetwork)this.getParent();
    }

    @Override
    public PollContext getContext() {
        return this.getNetwork().getContext();
    }

    @Override
    protected Object createMemberKey(PollableElement member) {
        PollableInterface iface = (PollableInterface)member;
        return iface.getAddress();
    }

    public PollableService createService(final InetAddress addr, final String svcName) {
        final PollableService[] retVal = new PollableService[1];
        Runnable r = new Runnable(){

            @Override
            public void run() {
                PollableInterface iface = PollableNode.this.getInterface(addr);
                if (iface == null) {
                    iface = PollableNode.this.createInterface(addr);
                }
                retVal[0] = iface.createService(svcName);
            }
        };
        this.withTreeLock(r);
        return retVal[0];
    }

    public PollableService getService(InetAddress addr, String svcName) {
        PollableInterface iface = this.getInterface(addr);
        return iface == null ? null : iface.getService(svcName);
    }

    @Override
    protected void visitThis(PollableVisitor v) {
        super.visitThis(v);
        v.visitNode(this);
    }

    @Override
    public Event createDownEvent(Date date) {
        return this.getContext().createEvent("uei.opennms.org/nodes/nodeDown", this.getNodeId(), null, null, date, this.getStatus().getReason());
    }

    @Override
    public Event createUpEvent(Date date) {
        return this.getContext().createEvent("uei.opennms.org/nodes/nodeUp", this.getNodeId(), null, null, date, this.getStatus().getReason());
    }

    public String toString() {
        return "PollableNode [" + this.getNodeId() + "]";
    }

    @Override
    protected PollableElement getLockRoot() {
        return this;
    }

    @Override
    protected void obtainTreeLock() {
        this.m_lock.lock();
    }

    @Override
    protected void obtainTreeLock(long timeout) throws LockUnavailable {
        if (timeout >= 1L) {
            try {
                if (this.m_lock.tryLock(timeout, TimeUnit.MILLISECONDS)) {
                    return;
                }
                throw new LockUnavailable("Unable to obtain lock for " + this + " within " + timeout + " milliseconds");
            }
            catch (InterruptedException e) {
                throw new LockUnavailable("Interrupted while waiting " + timeout + " milliseconds to obtain lock for " + this);
            }
        }
        this.obtainTreeLock();
    }

    @Override
    protected void releaseTreeLock() {
        this.m_lock.unlock();
    }

    @Override
    public PollStatus doPoll(final PollableElement elem) {
        final PollStatus[] retVal = new PollStatus[1];
        Runnable r = new Runnable(){

            @Override
            public void run() {
                PollableNode.this.resetStatusChanged();
                retVal[0] = PollableNode.this.poll(elem);
            }
        };
        this.withTreeLock(r);
        return retVal[0];
    }
}

