/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.HashMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.test.MockLogAppender;
import org.opennms.netmgt.config.threshd.Expression;
import org.opennms.netmgt.threshd.ExpressionConfigWrapper;

public class ExpressionConfigWrapperTest {
    private final String FORMULA = "ifSpeed > 0 and ifSpeed < 100000000 ? ((ifInOctets * 8 / ifSpeed) * 100) : (ifHighSpeed > 0 ? (((ifHCInOctets * 8) / (ifHighSpeed * 1000000)) * 100) : 0)";
    private ExpressionConfigWrapper wrapper;

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging((boolean)true, (String)"TRACE");
        Expression exp = new Expression();
        exp.setExpression("ifSpeed > 0 and ifSpeed < 100000000 ? ((ifInOctets * 8 / ifSpeed) * 100) : (ifHighSpeed > 0 ? (((ifHCInOctets * 8) / (ifHighSpeed * 1000000)) * 100) : 0)");
        this.wrapper = new ExpressionConfigWrapper(exp);
        Assert.assertEquals((long)4L, (long)this.wrapper.getRequiredDatasources().size());
    }

    @After
    public void tearDown() throws Exception {
        MockLogAppender.assertNoWarningsOrGreater();
    }

    @Test
    public void testSlowInterface() throws Exception {
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("ifInOctets", 200000.0);
        values.put("ifSpeed", 1.0E7);
        double value = this.wrapper.evaluate(values);
        Assert.assertTrue((value == 16.0 ? 1 : 0) != 0);
    }

    @Test
    public void testFastInterface() throws Exception {
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("ifHCInOctets", 2.0E7);
        values.put("ifSpeed", 1.0E8);
        values.put("ifHighSpeed", 1000.0);
        double value = this.wrapper.evaluate(values);
        Assert.assertTrue((value == 16.0 ? 1 : 0) != 0);
    }

    @Test
    public void testDivisionByZeroA() throws Exception {
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("ifHCInOctets", 2.0E7);
        values.put("ifSpeed", 1.0E8);
        values.put("ifHighSpeed", 1000.0);
        double value = this.wrapper.evaluate(values);
        Assert.assertTrue((value == 16.0 ? 1 : 0) != 0);
    }

    @Test
    public void testDivisionByZeroB() throws Exception {
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("ifInOctets", 200000.0);
        values.put("ifSpeed", 0.0);
        values.put("ifHighSpeed", 0.0);
        double value = this.wrapper.evaluate(values);
        Assert.assertTrue((value == 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testDivisionByZeroC() throws Exception {
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("ifHCInOctets", 2.0E7);
        values.put("ifSpeed", 0.0);
        values.put("ifHighSpeed", 0.0);
        double value = this.wrapper.evaluate(values);
        Assert.assertTrue((value == 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testMath() throws Exception {
        Expression exp = new Expression();
        exp.setExpression("math.max(data, 5)");
        this.wrapper = new ExpressionConfigWrapper(exp);
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("data", 10.0);
        Assert.assertTrue((10.0 == this.wrapper.evaluate(values) ? 1 : 0) != 0);
    }

    @Test
    public void testComplexExpression() throws Exception {
        Expression exp = new Expression();
        exp.setExpression("jnxOperatingState == 2.0 || jnxOperatingState == 3.0 || jnxOperatingState == 7.0 ? 1.0 : 0.0");
        ExpressionConfigWrapper wrapper = new ExpressionConfigWrapper(exp);
        Assert.assertEquals((long)1L, (long)wrapper.getRequiredDatasources().size());
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("jnxOperatingState", 1.0);
        Assert.assertEquals((double)0.0, (double)wrapper.evaluate(values), (double)0.0);
        values.put("jnxOperatingState", 2.0);
        Assert.assertEquals((double)1.0, (double)wrapper.evaluate(values), (double)0.0);
        values.put("jnxOperatingState", 3.0);
        Assert.assertEquals((double)1.0, (double)wrapper.evaluate(values), (double)0.0);
        values.put("jnxOperatingState", 4.0);
        Assert.assertEquals((double)0.0, (double)wrapper.evaluate(values), (double)0.0);
        values.put("jnxOperatingState", 5.0);
        Assert.assertEquals((double)0.0, (double)wrapper.evaluate(values), (double)0.0);
        values.put("jnxOperatingState", 6.0);
        Assert.assertEquals((double)0.0, (double)wrapper.evaluate(values), (double)0.0);
        values.put("jnxOperatingState", 7.0);
        Assert.assertEquals((double)1.0, (double)wrapper.evaluate(values), (double)0.0);
    }

    @Test
    public void testHandleInvalidDsNames() throws Exception {
        Expression exp = new Expression();
        exp.setExpression("datasources['ns-dskTotal'] - datasources['ns-dskUsed']");
        ExpressionConfigWrapper wrapper = new ExpressionConfigWrapper(exp);
        Assert.assertEquals((long)2L, (long)wrapper.getRequiredDatasources().size());
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("ns-dskTotal", 100.0);
        values.put("ns-dskUsed", 40.0);
        Assert.assertEquals((double)60.0, (double)wrapper.evaluate(values), (double)0.0);
    }

    @Test
    public void testFunctions() throws Exception {
        Expression exp = new Expression();
        exp.setExpression("math.max((ifInOctets*8/ifSpeed), (ifOutOctets*8/ifSpeed))");
        ExpressionConfigWrapper wrapper = new ExpressionConfigWrapper(exp);
        Assert.assertEquals((long)3L, (long)wrapper.getRequiredDatasources().size());
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("ifInOctets", 100.0);
        values.put("ifOutOctets", 200.0);
        values.put("ifSpeed", 10.0);
        Assert.assertEquals((double)160.0, (double)wrapper.evaluate(values), (double)0.0);
    }
}

