/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.enlinkd.EnLinkdBuilderITCase;
import org.opennms.netmgt.enlinkd.EnLinkdTestHelper;
import org.opennms.netmgt.enlinkd.Node;
import org.opennms.netmgt.model.BridgeBridgeLink;
import org.opennms.netmgt.model.BridgeElement;
import org.opennms.netmgt.model.BridgeMacLink;
import org.opennms.netmgt.model.IpNetToMedia;
import org.opennms.netmgt.model.NetworkBuilder;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.opennms.netmgt.model.topology.Bridge;
import org.opennms.netmgt.model.topology.BridgeForwardingTableEntry;
import org.opennms.netmgt.model.topology.BridgePort;
import org.opennms.netmgt.model.topology.BridgeTopologyException;
import org.opennms.netmgt.model.topology.BroadcastDomain;
import org.opennms.netmgt.model.topology.SharedSegment;
import org.opennms.netmgt.nb.Nms10205bNetworkBuilder;
import org.opennms.netmgt.nb.Nms17216NetworkBuilder;

public class EnLinkdIT
extends EnLinkdBuilderITCase {
    Nms10205bNetworkBuilder builder10205a = new Nms10205bNetworkBuilder();
    Nms17216NetworkBuilder builder = new Nms17216NetworkBuilder();

    @Test
    public void testGetSnmpNodeList() throws Exception {
        this.m_nodeDao.save((Object)this.builder10205a.getMumbai());
        this.m_nodeDao.save((Object)this.builder10205a.getDelhi());
        this.m_nodeDao.save((Object)this.builder.getSwitch1());
        this.m_nodeDao.flush();
        int mumbai = this.m_nodeDao.findByForeignId("linkd", "Mumbai").getId();
        int delhi = this.m_nodeDao.findByForeignId("linkd", "Delhi").getId();
        int switch1 = this.m_nodeDao.findByForeignId("linkd", "Switch1").getId();
        List linkablenodes = this.m_linkd.getQueryManager().getSnmpNodeList();
        Assert.assertNotNull((Object)linkablenodes);
        Assert.assertEquals((long)3L, (long)linkablenodes.size());
        for (Node linkablenode : linkablenodes) {
            if (linkablenode.getNodeId() == mumbai) {
                Assert.assertEquals((Object)InetAddressUtils.addr((String)"10.205.56.5"), (Object)linkablenode.getSnmpPrimaryIpAddr());
                Assert.assertEquals((Object)".1.3.6.1.4.1.2636.1.1.1.2.9", (Object)linkablenode.getSysoid());
                continue;
            }
            if (linkablenode.getNodeId() == delhi) {
                Assert.assertEquals((Object)InetAddressUtils.addr((String)"10.205.56.7"), (Object)linkablenode.getSnmpPrimaryIpAddr());
                Assert.assertEquals((Object)".1.3.6.1.4.1.2636.1.1.1.2.29", (Object)linkablenode.getSysoid());
                continue;
            }
            if (linkablenode.getNodeId() == switch1) {
                Assert.assertEquals((Object)InetAddressUtils.addr((String)"172.16.10.1"), (Object)linkablenode.getSnmpPrimaryIpAddr());
                Assert.assertEquals((Object)".1.3.6.1.4.1.9.1.614", (Object)linkablenode.getSysoid());
                continue;
            }
            Assert.assertTrue((boolean)false);
        }
        Node delhilinkablenode = this.m_linkd.getQueryManager().getSnmpNode(delhi);
        Assert.assertNotNull((Object)delhilinkablenode);
        Assert.assertEquals((long)delhi, (long)delhilinkablenode.getNodeId());
        Assert.assertEquals((Object)InetAddressUtils.addr((String)"10.205.56.7"), (Object)delhilinkablenode.getSnmpPrimaryIpAddr());
        Assert.assertEquals((Object)".1.3.6.1.4.1.2636.1.1.1.2.29", (Object)delhilinkablenode.getSysoid());
    }

    @Test
    public void testStoreBft() {
        EnLinkdTestHelper.OneBridgeCompleteTopology topology = new EnLinkdTestHelper.OneBridgeCompleteTopology();
        this.m_nodeDao.save((Object)topology.nodeA);
        this.m_linkd.getQueryManager().store(topology.nodeAId.intValue(), new ArrayList<BridgeForwardingTableEntry>(topology.bftA));
        Set links = this.m_linkd.getQueryManager().useBridgeTopologyUpdateBFT(topology.nodeAId.intValue());
        Assert.assertEquals((long)topology.bftA.size(), (long)links.size());
        for (BridgeForwardingTableEntry link : links) {
            Assert.assertEquals((Object)BridgeForwardingTableEntry.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
            System.err.println(link.printTopology());
        }
    }

    @Test
    public void testLoadFourLevelTopology() {
        OnmsMonitoringLocation location = new OnmsMonitoringLocation("Default", "Default");
        OnmsNode lnode1400 = new OnmsNode();
        lnode1400.setId(Integer.valueOf(1400));
        lnode1400.setForeignSource("linkd");
        lnode1400.setForeignId("lnode1400");
        lnode1400.setLabel("lnode1400");
        lnode1400.setLocation(location);
        OnmsNode lnode1544 = new OnmsNode();
        lnode1544.setId(Integer.valueOf(1544));
        lnode1544.setForeignSource("linkd");
        lnode1544.setForeignId("lnode1544");
        lnode1544.setLabel("lnode1544");
        lnode1544.setLocation(location);
        OnmsNode lnode1534 = new OnmsNode();
        lnode1534.setId(Integer.valueOf(1534));
        lnode1534.setForeignSource("linkd");
        lnode1534.setForeignId("lnode1534");
        lnode1534.setLabel("lnode1534");
        lnode1534.setLocation(location);
        OnmsNode lnode1364 = new OnmsNode();
        lnode1364.setId(Integer.valueOf(1364));
        lnode1364.setForeignSource("linkd");
        lnode1364.setForeignId("lnode1364");
        lnode1364.setLabel("lnode1364");
        lnode1364.setLocation(location);
        OnmsNode lnode1310 = new OnmsNode();
        lnode1310.setId(Integer.valueOf(1310));
        lnode1310.setForeignSource("linkd");
        lnode1310.setForeignId("lnode1310");
        lnode1310.setLabel("lnode1310");
        lnode1310.setLocation(location);
        OnmsNode lnode405 = new OnmsNode();
        lnode405.setId(Integer.valueOf(405));
        lnode405.setForeignSource("linkd");
        lnode405.setForeignId("lnode405");
        lnode405.setLabel("lnode405");
        lnode405.setLocation(location);
        OnmsNode lnode2965 = new OnmsNode();
        lnode2965.setId(Integer.valueOf(2965));
        lnode2965.setForeignSource("linkd");
        lnode2965.setForeignId("lnode2965");
        lnode2965.setLabel("lnode2965");
        lnode2965.setLocation(location);
        OnmsNode lnode5022 = new OnmsNode();
        lnode5022.setId(Integer.valueOf(5022));
        lnode5022.setForeignSource("linkd");
        lnode5022.setForeignId("lnode5022");
        lnode5022.setLabel("lnode5022");
        lnode5022.setLocation(location);
        this.m_nodeDao.save((Object)lnode1400);
        this.m_nodeDao.save((Object)lnode1544);
        this.m_nodeDao.save((Object)lnode1534);
        this.m_nodeDao.save((Object)lnode1364);
        this.m_nodeDao.save((Object)lnode1310);
        this.m_nodeDao.save((Object)lnode405);
        this.m_nodeDao.save((Object)lnode2965);
        this.m_nodeDao.save((Object)lnode5022);
        OnmsNode node1400 = this.m_nodeDao.findByForeignId("linkd", "lnode1400");
        OnmsNode node1544 = this.m_nodeDao.findByForeignId("linkd", "lnode1544");
        OnmsNode node1534 = this.m_nodeDao.findByForeignId("linkd", "lnode1534");
        OnmsNode node1364 = this.m_nodeDao.findByForeignId("linkd", "lnode1364");
        OnmsNode node1310 = this.m_nodeDao.findByForeignId("linkd", "lnode1310");
        OnmsNode node405 = this.m_nodeDao.findByForeignId("linkd", "lnode405");
        OnmsNode node2965 = this.m_nodeDao.findByForeignId("linkd", "lnode2965");
        OnmsNode node5022 = this.m_nodeDao.findByForeignId("linkd", "lnode5022");
        BridgeBridgeLink link7 = new BridgeBridgeLink();
        link7.setNode(node5022);
        link7.setBridgePort(Integer.valueOf(4));
        link7.setDesignatedNode(node2965);
        link7.setDesignatedPort(Integer.valueOf(5));
        link7.setBridgeBridgeLinkLastPollTime(link7.getBridgeBridgeLinkCreateTime());
        this.m_bridgeBridgeLinkDao.save((Object)link7);
        this.m_bridgeBridgeLinkDao.flush();
        BridgeBridgeLink link1 = new BridgeBridgeLink();
        link1.setNode(node1544);
        link1.setBridgePort(Integer.valueOf(15));
        link1.setDesignatedNode(node1400);
        link1.setDesignatedPort(Integer.valueOf(1));
        link1.setBridgeBridgeLinkLastPollTime(link1.getBridgeBridgeLinkCreateTime());
        this.m_bridgeBridgeLinkDao.save((Object)link1);
        this.m_bridgeBridgeLinkDao.flush();
        BridgeBridgeLink link3 = new BridgeBridgeLink();
        link3.setNode(node1310);
        link3.setBridgePort(Integer.valueOf(1));
        link3.setDesignatedNode(node1534);
        link3.setDesignatedPort(Integer.valueOf(1));
        link3.setBridgeBridgeLinkLastPollTime(link3.getBridgeBridgeLinkCreateTime());
        this.m_bridgeBridgeLinkDao.save((Object)link3);
        this.m_bridgeBridgeLinkDao.flush();
        BridgeBridgeLink link4 = new BridgeBridgeLink();
        link4.setNode(node1364);
        link4.setBridgePort(Integer.valueOf(24));
        link4.setDesignatedNode(node1534);
        link4.setDesignatedPort(Integer.valueOf(4));
        link4.setBridgeBridgeLinkLastPollTime(link4.getBridgeBridgeLinkCreateTime());
        this.m_bridgeBridgeLinkDao.save((Object)link4);
        this.m_bridgeBridgeLinkDao.flush();
        BridgeBridgeLink link2 = new BridgeBridgeLink();
        link2.setNode(node1534);
        link2.setBridgePort(Integer.valueOf(11));
        link2.setDesignatedNode(node1400);
        link2.setDesignatedPort(Integer.valueOf(11));
        link2.setBridgeBridgeLinkLastPollTime(link2.getBridgeBridgeLinkCreateTime());
        this.m_bridgeBridgeLinkDao.save((Object)link2);
        this.m_bridgeBridgeLinkDao.flush();
        BridgeBridgeLink link6 = new BridgeBridgeLink();
        link6.setNode(node2965);
        link6.setBridgePort(Integer.valueOf(2));
        link6.setDesignatedNode(node1364);
        link6.setDesignatedPort(Integer.valueOf(5));
        link6.setBridgeBridgeLinkLastPollTime(link6.getBridgeBridgeLinkCreateTime());
        this.m_bridgeBridgeLinkDao.save((Object)link6);
        this.m_bridgeBridgeLinkDao.flush();
        BridgeBridgeLink link5 = new BridgeBridgeLink();
        link5.setNode(node405);
        link5.setBridgePort(Integer.valueOf(1));
        link5.setDesignatedNode(node1534);
        link5.setDesignatedPort(Integer.valueOf(1));
        link5.setBridgeBridgeLinkLastPollTime(link5.getBridgeBridgeLinkCreateTime());
        this.m_bridgeBridgeLinkDao.save((Object)link5);
        this.m_bridgeBridgeLinkDao.flush();
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertEquals((long)7L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertNotNull((Object)this.m_bridgeTopologyDao);
        this.m_linkd.getQueryManager().loadBridgeTopology();
        Assert.assertEquals((long)1L, (long)this.m_linkd.getQueryManager().getAllBroadcastDomains().size());
        BroadcastDomain fourlevelDomain = (BroadcastDomain)this.m_linkd.getQueryManager().getAllBroadcastDomains().iterator().next();
        Assert.assertEquals((long)8L, (long)fourlevelDomain.getBridgeNodesOnDomain().size());
        System.err.println(fourlevelDomain.printTopology());
    }

    @Test
    public void testLoadTopology() throws BridgeTopologyException {
        OnmsMonitoringLocation location = new OnmsMonitoringLocation("Default", "Default");
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        OnmsNode lnodeA = topology.nodeA;
        lnodeA.setForeignSource("linkd");
        lnodeA.setForeignId("nodeA");
        lnodeA.setLabel("nodeA");
        lnodeA.setLocation(location);
        OnmsNode lnodeB = topology.nodeB;
        lnodeB.setForeignSource("linkd");
        lnodeB.setForeignId("nodeB");
        lnodeB.setLabel("nodeB");
        lnodeB.setLocation(location);
        OnmsNode lnodeC = topology.nodeC;
        lnodeC.setForeignSource("linkd");
        lnodeC.setForeignId("nodeC");
        lnodeC.setLabel("nodeC");
        lnodeC.setLocation(location);
        BridgeElement elementD = new BridgeElement();
        BridgeElement elementE = new BridgeElement();
        BridgeElement elementK = new BridgeElement();
        OnmsNode lnodeD = new OnmsNode();
        lnodeD.setId(Integer.valueOf(topology.nodeAId + 1234));
        lnodeD.setForeignSource("linkd");
        lnodeD.setForeignId("nodeD");
        lnodeD.setLabel("nodeD");
        lnodeD.setLocation(location);
        elementD.setNode(lnodeD);
        elementD.setBaseBridgeAddress("dddddddddddd");
        OnmsNode lnodeE = new OnmsNode();
        lnodeE.setId(Integer.valueOf(topology.nodeBId + 1234));
        lnodeE.setForeignSource("linkd");
        lnodeE.setForeignId("nodeE");
        lnodeE.setLabel("nodeE");
        lnodeE.setLocation(location);
        elementE.setNode(lnodeE);
        elementE.setBaseBridgeAddress("eeeeeeeeeeee");
        OnmsNode lnodeK = new OnmsNode();
        lnodeK.setId(Integer.valueOf(topology.nodeCId + 12345));
        lnodeK.setForeignSource("linkd");
        lnodeK.setForeignId("nodeK");
        lnodeK.setLabel("nodeK");
        lnodeK.setLocation(location);
        elementK.setNode(lnodeK);
        elementK.setBaseBridgeAddress("aaaabbbbcccc");
        this.m_nodeDao.save((Object)lnodeA);
        this.m_nodeDao.save((Object)lnodeB);
        this.m_nodeDao.save((Object)lnodeC);
        this.m_nodeDao.save((Object)lnodeD);
        this.m_nodeDao.save((Object)lnodeE);
        this.m_nodeDao.save((Object)lnodeK);
        OnmsNode nodeA = this.m_nodeDao.findByForeignId("linkd", "nodeA");
        OnmsNode nodeB = this.m_nodeDao.findByForeignId("linkd", "nodeB");
        OnmsNode nodeC = this.m_nodeDao.findByForeignId("linkd", "nodeC");
        OnmsNode nodeD = this.m_nodeDao.findByForeignId("linkd", "nodeD");
        OnmsNode nodeE = this.m_nodeDao.findByForeignId("linkd", "nodeE");
        OnmsNode nodeK = this.m_nodeDao.findByForeignId("linkd", "nodeK");
        topology.nodeAId = nodeA.getId();
        topology.nodeBId = nodeB.getId();
        topology.nodeCId = nodeC.getId();
        topology.nodeA = nodeA;
        topology.nodeB = nodeB;
        topology.nodeC = nodeC;
        BridgeBridgeLink delink = new BridgeBridgeLink();
        delink.setNode(nodeD);
        delink.setBridgePort(Integer.valueOf(45));
        delink.setDesignatedNode(nodeE);
        delink.setDesignatedPort(Integer.valueOf(54));
        delink.setBridgeBridgeLinkLastPollTime(delink.getBridgeBridgeLinkCreateTime());
        BridgeBridgeLink ablink = new BridgeBridgeLink();
        ablink.setNode(nodeA);
        ablink.setBridgePort(topology.portAB);
        ablink.setDesignatedNode(nodeB);
        ablink.setDesignatedPort(topology.portBA);
        ablink.setBridgeBridgeLinkLastPollTime(ablink.getBridgeBridgeLinkCreateTime());
        BridgeBridgeLink bclink = new BridgeBridgeLink();
        bclink.setNode(nodeC);
        bclink.setBridgePort(topology.portCB);
        bclink.setDesignatedNode(nodeB);
        bclink.setDesignatedPort(topology.portBC);
        bclink.setBridgeBridgeLinkLastPollTime(ablink.getBridgeBridgeLinkCreateTime());
        BridgeMacLink forward = new BridgeMacLink();
        forward.setNode(nodeB);
        forward.setBridgePort(topology.portBA);
        forward.setMacAddress(topology.macA);
        forward.setLinkType(BridgeMacLink.BridgeMacLinkType.BRIDGE_FORWARDER);
        forward.setBridgeMacLinkLastPollTime(forward.getBridgeMacLinkCreateTime());
        BridgeMacLink sharedB = new BridgeMacLink();
        sharedB.setNode(nodeB);
        sharedB.setBridgePort(topology.portBC);
        sharedB.setMacAddress(topology.shar);
        sharedB.setLinkType(BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK);
        sharedB.setBridgeMacLinkLastPollTime(sharedB.getBridgeMacLinkCreateTime());
        BridgeMacLink mac1 = new BridgeMacLink();
        mac1.setNode(nodeA);
        mac1.setBridgePort(topology.portA);
        mac1.setMacAddress(topology.mac1);
        mac1.setLinkType(BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK);
        mac1.setBridgeMacLinkLastPollTime(mac1.getBridgeMacLinkCreateTime());
        BridgeMacLink mac2 = new BridgeMacLink();
        mac2.setNode(nodeB);
        mac2.setBridgePort(topology.portB);
        mac2.setMacAddress(topology.mac2);
        mac2.setLinkType(BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK);
        mac2.setBridgeMacLinkLastPollTime(mac2.getBridgeMacLinkCreateTime());
        BridgeMacLink mac3 = new BridgeMacLink();
        mac3.setNode(nodeC);
        mac3.setBridgePort(topology.portC);
        mac3.setMacAddress(topology.mac3);
        mac3.setLinkType(BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK);
        mac3.setBridgeMacLinkLastPollTime(mac3.getBridgeMacLinkCreateTime());
        BridgeMacLink sharedE = new BridgeMacLink();
        sharedE.setNode(nodeE);
        sharedE.setBridgePort(Integer.valueOf(54));
        sharedE.setMacAddress(topology.shar);
        sharedE.setLinkType(BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK);
        sharedE.setBridgeMacLinkLastPollTime(sharedE.getBridgeMacLinkCreateTime());
        BridgeMacLink sharedK = new BridgeMacLink();
        sharedK.setNode(nodeK);
        sharedK.setBridgePort(Integer.valueOf(1099));
        sharedK.setMacAddress(topology.shar);
        sharedK.setLinkType(BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK);
        sharedK.setBridgeMacLinkLastPollTime(sharedK.getBridgeMacLinkCreateTime());
        BridgeMacLink macK = new BridgeMacLink();
        macK.setNode(nodeK);
        macK.setBridgePort(Integer.valueOf(1099));
        macK.setMacAddress("1234567800aa");
        macK.setLinkType(BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK);
        macK.setBridgeMacLinkLastPollTime(macK.getBridgeMacLinkCreateTime());
        this.m_bridgeBridgeLinkDao.save((Object)delink);
        this.m_bridgeBridgeLinkDao.save((Object)ablink);
        this.m_bridgeBridgeLinkDao.save((Object)bclink);
        this.m_bridgeBridgeLinkDao.flush();
        Assert.assertEquals((long)3L, (long)this.m_bridgeBridgeLinkDao.countAll());
        this.m_bridgeMacLinkDao.save((Object)forward);
        this.m_bridgeMacLinkDao.save((Object)sharedB);
        this.m_bridgeMacLinkDao.save((Object)mac1);
        this.m_bridgeMacLinkDao.save((Object)mac2);
        this.m_bridgeMacLinkDao.save((Object)mac3);
        this.m_bridgeMacLinkDao.save((Object)sharedE);
        this.m_bridgeMacLinkDao.save((Object)sharedK);
        this.m_bridgeMacLinkDao.save((Object)macK);
        this.m_bridgeMacLinkDao.flush();
        Assert.assertEquals((long)8L, (long)this.m_bridgeMacLinkDao.countAll());
        for (BridgeMacLink maclink : this.m_bridgeMacLinkDao.findAll()) {
            System.err.println(maclink.printTopology());
        }
        for (BridgeBridgeLink bblink : this.m_bridgeBridgeLinkDao.findAll()) {
            System.err.println(bblink.printTopology());
        }
        Assert.assertNotNull((Object)this.m_bridgeTopologyDao);
        this.m_linkd.getQueryManager().loadBridgeTopology();
        for (BroadcastDomain bd : this.m_linkd.getQueryManager().getAllBroadcastDomains()) {
            System.err.println(bd.printTopology());
        }
        Assert.assertEquals((long)3L, (long)this.m_linkd.getQueryManager().getAllBroadcastDomains().size());
        BroadcastDomain nodeAbd = this.m_linkd.getQueryManager().getBroadcastDomain(nodeA.getId().intValue());
        Assert.assertNotNull((Object)nodeAbd);
        BroadcastDomain nodeBbd = this.m_linkd.getQueryManager().getBroadcastDomain(nodeB.getId().intValue());
        BroadcastDomain nodeCbd = this.m_linkd.getQueryManager().getBroadcastDomain(nodeC.getId().intValue());
        Assert.assertEquals((Object)nodeAbd, (Object)nodeBbd);
        Assert.assertEquals((Object)nodeAbd, (Object)nodeCbd);
        BroadcastDomain.hierarchySetUp((BroadcastDomain)nodeAbd, (Bridge)nodeAbd.getBridge(nodeA.getId().intValue()));
        topology.checkwithshared(nodeAbd);
        Assert.assertEquals((long)0L, (long)nodeAbd.getForwarders(topology.nodeAId).size());
        Assert.assertEquals((long)1L, (long)nodeAbd.getForwarders(topology.nodeBId).size());
        Assert.assertEquals((long)0L, (long)nodeAbd.getForwarders(topology.nodeCId).size());
        List nodeASegments = this.m_bridgeTopologyDao.getBridgeSharedSegments(nodeA.getId().intValue());
        Assert.assertEquals((long)2L, (long)nodeASegments.size());
        List nodeCSegments = this.m_bridgeTopologyDao.getBridgeSharedSegments(nodeC.getId().intValue());
        Assert.assertEquals((long)2L, (long)nodeCSegments.size());
        List nodeBSegments = this.m_bridgeTopologyDao.getBridgeSharedSegments(nodeB.getId().intValue());
        Assert.assertEquals((long)3L, (long)nodeBSegments.size());
        BroadcastDomain nodeDbd = this.m_linkd.getQueryManager().getBroadcastDomain(nodeD.getId().intValue());
        Assert.assertNotNull((Object)nodeDbd);
        BroadcastDomain nodeEbd = this.m_linkd.getQueryManager().getBroadcastDomain(nodeE.getId().intValue());
        Assert.assertEquals((Object)nodeDbd, (Object)nodeEbd);
        Assert.assertEquals((long)2L, (long)nodeDbd.getBridges().size());
        Assert.assertEquals((long)1L, (long)nodeDbd.getSharedSegments().size());
        Assert.assertNotNull((Object)nodeDbd.getBridge(nodeD.getId().intValue()));
        Assert.assertNotNull((Object)nodeDbd.getBridge(nodeE.getId().intValue()));
        SharedSegment deSegment = (SharedSegment)nodeDbd.getSharedSegments().iterator().next();
        Assert.assertEquals((long)2L, (long)deSegment.getBridgePortsOnSegment().size());
        Assert.assertEquals((long)1L, (long)deSegment.getMacsOnSegment().size());
        Assert.assertEquals((long)45L, (long)deSegment.getBridgePort(nodeD.getId()).getBridgePort().intValue());
        Assert.assertEquals((long)54L, (long)deSegment.getBridgePort(nodeE.getId()).getBridgePort().intValue());
        Assert.assertTrue((boolean)deSegment.containsMac(topology.shar));
        BroadcastDomain nodeKbd = this.m_linkd.getQueryManager().getBroadcastDomain(nodeK.getId().intValue());
        Assert.assertNotNull((Object)nodeKbd);
        Assert.assertEquals((long)1L, (long)nodeKbd.getBridges().size());
        Assert.assertEquals((long)1L, (long)nodeKbd.getSharedSegments().size());
        Assert.assertNotNull((Object)nodeKbd.getBridge(nodeK.getId().intValue()));
        SharedSegment kSegment = (SharedSegment)nodeKbd.getSharedSegments().iterator().next();
        Assert.assertEquals((long)1L, (long)kSegment.getBridgePortsOnSegment().size());
        Assert.assertEquals((long)2L, (long)kSegment.getMacsOnSegment().size());
        Assert.assertEquals((long)1099L, (long)kSegment.getBridgePort(nodeK.getId()).getBridgePort().intValue());
        Assert.assertTrue((boolean)kSegment.containsMac(topology.shar));
        Assert.assertTrue((boolean)kSegment.containsMac("1234567800aa"));
        System.err.println(nodeKbd.printTopology());
    }

    @Test
    public void testDeleteBridgeC() throws BridgeTopologyException {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        NetworkBuilder nb = new NetworkBuilder();
        nb.addNode("nodeA").setForeignSource("linkd").setForeignId("nodeA").setSysObjectId("0.0").setSysName("nodeA").setType(OnmsNode.NodeType.ACTIVE);
        nb.addInterface("10.0.1.1").setIsSnmpPrimary("P").setIsManaged("M");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        nb.addNode("nodeB").setForeignSource("linkd").setForeignId("nodeB").setSysObjectId("0.0").setSysName("nodeB").setType(OnmsNode.NodeType.ACTIVE);
        nb.addInterface("10.0.1.2").setIsSnmpPrimary("P").setIsManaged("M");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        nb.addNode("nodeC").setForeignSource("linkd").setForeignId("nodeC").setSysObjectId("0.0").setSysName("nodeC").setType(OnmsNode.NodeType.ACTIVE);
        nb.addInterface("10.0.1.3").setIsSnmpPrimary("P").setIsManaged("M");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        OnmsNode nodeA = this.m_nodeDao.findByForeignId("linkd", "nodeA");
        OnmsNode nodeB = this.m_nodeDao.findByForeignId("linkd", "nodeB");
        OnmsNode nodeC = this.m_nodeDao.findByForeignId("linkd", "nodeC");
        topology.nodeAId = nodeA.getId();
        topology.nodeBId = nodeB.getId();
        topology.nodeCId = nodeC.getId();
        topology.nodeA = nodeA;
        topology.nodeB = nodeB;
        topology.nodeC = nodeC;
        BridgeBridgeLink ablink = new BridgeBridgeLink();
        ablink.setNode(nodeA);
        ablink.setBridgePort(topology.portAB);
        ablink.setDesignatedNode(nodeB);
        ablink.setDesignatedPort(topology.portBA);
        ablink.setBridgeBridgeLinkLastPollTime(ablink.getBridgeBridgeLinkCreateTime());
        this.m_bridgeBridgeLinkDao.save((Object)ablink);
        BridgeBridgeLink bclink = new BridgeBridgeLink();
        bclink.setNode(nodeC);
        bclink.setBridgePort(topology.portCB);
        bclink.setDesignatedNode(nodeB);
        bclink.setDesignatedPort(topology.portBC);
        bclink.setBridgeBridgeLinkLastPollTime(ablink.getBridgeBridgeLinkCreateTime());
        this.m_bridgeBridgeLinkDao.save((Object)bclink);
        BridgeMacLink mac1 = new BridgeMacLink();
        mac1.setNode(nodeA);
        mac1.setBridgePort(topology.portA);
        mac1.setMacAddress(topology.mac1);
        mac1.setLinkType(BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK);
        mac1.setBridgeMacLinkLastPollTime(mac1.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)mac1);
        BridgeMacLink mac2 = new BridgeMacLink();
        mac2.setNode(nodeB);
        mac2.setBridgePort(topology.portB);
        mac2.setMacAddress(topology.mac2);
        mac2.setLinkType(BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK);
        mac2.setBridgeMacLinkLastPollTime(mac2.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)mac2);
        BridgeMacLink mac3 = new BridgeMacLink();
        mac3.setNode(nodeC);
        mac3.setBridgePort(topology.portC);
        mac3.setMacAddress(topology.mac3);
        mac3.setLinkType(BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK);
        mac3.setBridgeMacLinkLastPollTime(mac3.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)mac3);
        this.m_bridgeMacLinkDao.flush();
        this.m_bridgeBridgeLinkDao.flush();
        Assert.assertEquals((long)3L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertEquals((long)2L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertNotNull((Object)this.m_bridgeTopologyDao);
        this.m_linkd.getQueryManager().loadBridgeTopology();
        Assert.assertEquals((long)1L, (long)this.m_linkd.getQueryManager().getAllBroadcastDomains().size());
        BroadcastDomain nodeAbd = this.m_linkd.getQueryManager().getBroadcastDomain(nodeA.getId().intValue());
        Assert.assertNotNull((Object)nodeAbd);
        BroadcastDomain nodeBbd = this.m_linkd.getQueryManager().getBroadcastDomain(nodeB.getId().intValue());
        Assert.assertNotNull((Object)nodeBbd);
        Assert.assertEquals((Object)nodeAbd, (Object)nodeBbd);
        BroadcastDomain nodeCbd = this.m_linkd.getQueryManager().getBroadcastDomain(nodeC.getId().intValue());
        Assert.assertNotNull((Object)nodeCbd);
        Assert.assertEquals((Object)nodeAbd, (Object)nodeCbd);
        Assert.assertNotNull((Object)nodeAbd.getRootBridge());
        Assert.assertEquals((long)nodeAbd.getRootBridge().getNodeId().intValue(), (long)nodeB.getId().intValue());
        Assert.assertNotNull((Object)nodeAbd.getBridge(nodeA.getId().intValue()));
        Assert.assertNotNull((Object)nodeAbd.getBridge(nodeB.getId().intValue()));
        Assert.assertNotNull((Object)nodeAbd.getBridge(nodeC.getId().intValue()));
        BroadcastDomain.hierarchySetUp((BroadcastDomain)nodeAbd, (Bridge)nodeAbd.getBridge(nodeA.getId().intValue()));
        Assert.assertNotNull((Object)nodeAbd.getRootBridge());
        topology.check(nodeAbd);
        this.m_linkd.deleteNode(nodeC.getId().intValue());
        Assert.assertEquals((long)1L, (long)this.m_linkd.getQueryManager().getAllBroadcastDomains().size());
        BroadcastDomain domain = (BroadcastDomain)this.m_linkd.getQueryManager().getAllBroadcastDomains().iterator().next();
        topology.checkAB(domain);
    }

    @Test
    public void testDeleteBridgeB() throws BridgeTopologyException {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        NetworkBuilder nb = new NetworkBuilder();
        nb.addNode("nodeA").setForeignSource("linkd").setForeignId("nodeA").setSysObjectId("0.0").setSysName("nodeA").setType(OnmsNode.NodeType.ACTIVE);
        nb.addInterface("10.0.1.1").setIsSnmpPrimary("P").setIsManaged("M");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        nb.addNode("nodeB").setForeignSource("linkd").setForeignId("nodeB").setSysObjectId("0.0").setSysName("nodeB").setType(OnmsNode.NodeType.ACTIVE);
        nb.addInterface("10.0.1.2").setIsSnmpPrimary("P").setIsManaged("M");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        nb.addNode("nodeC").setForeignSource("linkd").setForeignId("nodeC").setSysObjectId("0.0").setSysName("nodeC").setType(OnmsNode.NodeType.ACTIVE);
        nb.addInterface("10.0.1.3").setIsSnmpPrimary("P").setIsManaged("M");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        OnmsNode nodeA = this.m_nodeDao.findByForeignId("linkd", "nodeA");
        OnmsNode nodeB = this.m_nodeDao.findByForeignId("linkd", "nodeB");
        OnmsNode nodeC = this.m_nodeDao.findByForeignId("linkd", "nodeC");
        topology.nodeAId = nodeA.getId();
        topology.nodeBId = nodeB.getId();
        topology.nodeCId = nodeC.getId();
        topology.nodeA = nodeA;
        topology.nodeB = nodeB;
        topology.nodeC = nodeC;
        BridgeBridgeLink ablink = new BridgeBridgeLink();
        ablink.setNode(nodeB);
        ablink.setBridgePort(topology.portBA);
        ablink.setDesignatedNode(nodeA);
        ablink.setDesignatedPort(topology.portAB);
        ablink.setBridgeBridgeLinkLastPollTime(ablink.getBridgeBridgeLinkCreateTime());
        this.m_bridgeBridgeLinkDao.save((Object)ablink);
        BridgeBridgeLink bclink = new BridgeBridgeLink();
        bclink.setNode(nodeC);
        bclink.setBridgePort(topology.portCB);
        bclink.setDesignatedNode(nodeB);
        bclink.setDesignatedPort(topology.portBC);
        bclink.setBridgeBridgeLinkLastPollTime(ablink.getBridgeBridgeLinkCreateTime());
        this.m_bridgeBridgeLinkDao.save((Object)bclink);
        BridgeMacLink mac1 = new BridgeMacLink();
        mac1.setNode(nodeA);
        mac1.setBridgePort(topology.portA);
        mac1.setMacAddress(topology.mac1);
        mac1.setLinkType(BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK);
        mac1.setBridgeMacLinkLastPollTime(mac1.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)mac1);
        BridgeMacLink mac2 = new BridgeMacLink();
        mac2.setNode(nodeB);
        mac2.setBridgePort(topology.portB);
        mac2.setMacAddress(topology.mac2);
        mac2.setLinkType(BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK);
        mac2.setBridgeMacLinkLastPollTime(mac2.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)mac2);
        BridgeMacLink mac3 = new BridgeMacLink();
        mac3.setNode(nodeC);
        mac3.setBridgePort(topology.portC);
        mac3.setMacAddress(topology.mac3);
        mac3.setLinkType(BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK);
        mac3.setBridgeMacLinkLastPollTime(mac3.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)mac3);
        this.m_bridgeMacLinkDao.flush();
        this.m_bridgeBridgeLinkDao.flush();
        Assert.assertEquals((long)3L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertEquals((long)2L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertNotNull((Object)this.m_bridgeTopologyDao);
        this.m_linkd.getQueryManager().loadBridgeTopology();
        Assert.assertEquals((long)1L, (long)this.m_linkd.getQueryManager().getAllBroadcastDomains().size());
        BroadcastDomain nodeAbd = this.m_linkd.getQueryManager().getBroadcastDomain(nodeA.getId().intValue());
        Assert.assertNotNull((Object)nodeAbd);
        BroadcastDomain nodeBbd = this.m_linkd.getQueryManager().getBroadcastDomain(nodeB.getId().intValue());
        BroadcastDomain nodeCbd = this.m_linkd.getQueryManager().getBroadcastDomain(nodeC.getId().intValue());
        Assert.assertEquals((Object)nodeAbd, (Object)nodeBbd);
        Assert.assertEquals((Object)nodeAbd, (Object)nodeCbd);
        Assert.assertNotNull((Object)nodeAbd.getRootBridge());
        Assert.assertEquals((long)nodeAbd.getRootBridge().getNodeId().intValue(), (long)nodeA.getId().intValue());
        Assert.assertNotNull((Object)nodeAbd.getBridge(nodeA.getId().intValue()));
        Assert.assertNotNull((Object)nodeAbd.getBridge(nodeB.getId().intValue()));
        Assert.assertNotNull((Object)nodeAbd.getBridge(nodeC.getId().intValue()));
        BroadcastDomain.hierarchySetUp((BroadcastDomain)nodeAbd, (Bridge)nodeAbd.getBridge(nodeA.getId().intValue()));
        Assert.assertNotNull((Object)nodeAbd.getRootBridge());
        topology.check(nodeAbd);
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(nodeB.getId().intValue()));
        this.m_linkd.deleteNode(nodeB.getId().intValue());
        Assert.assertEquals((long)1L, (long)this.m_linkd.getQueryManager().getAllBroadcastDomains().size());
        BroadcastDomain domain = (BroadcastDomain)this.m_linkd.getQueryManager().getAllBroadcastDomains().iterator().next();
        topology.checkAC(domain);
    }

    @Test
    public void testDeleteBridgeA() throws BridgeTopologyException {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        NetworkBuilder nb = new NetworkBuilder();
        nb.addNode("nodeA").setForeignSource("linkd").setForeignId("nodeA").setSysObjectId("0.0").setSysName("nodeA").setType(OnmsNode.NodeType.ACTIVE);
        nb.addInterface("10.0.1.1").setIsSnmpPrimary("P").setIsManaged("M");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        nb.addNode("nodeB").setForeignSource("linkd").setForeignId("nodeB").setSysObjectId("0.0").setSysName("nodeB").setType(OnmsNode.NodeType.ACTIVE);
        nb.addInterface("10.0.1.2").setIsSnmpPrimary("P").setIsManaged("M");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        nb.addNode("nodeC").setForeignSource("linkd").setForeignId("nodeC").setSysObjectId("0.0").setSysName("nodeC").setType(OnmsNode.NodeType.ACTIVE);
        nb.addInterface("10.0.1.3").setIsSnmpPrimary("P").setIsManaged("M");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        OnmsNode nodeA = this.m_nodeDao.findByForeignId("linkd", "nodeA");
        OnmsNode nodeB = this.m_nodeDao.findByForeignId("linkd", "nodeB");
        OnmsNode nodeC = this.m_nodeDao.findByForeignId("linkd", "nodeC");
        topology.nodeAId = nodeA.getId();
        topology.nodeBId = nodeB.getId();
        topology.nodeCId = nodeC.getId();
        topology.nodeA = nodeA;
        topology.nodeB = nodeB;
        topology.nodeC = nodeC;
        BridgeBridgeLink ablink = new BridgeBridgeLink();
        ablink.setNode(nodeB);
        ablink.setBridgePort(topology.portBA);
        ablink.setDesignatedNode(nodeA);
        ablink.setDesignatedPort(topology.portAB);
        ablink.setBridgeBridgeLinkLastPollTime(ablink.getBridgeBridgeLinkCreateTime());
        this.m_bridgeBridgeLinkDao.save((Object)ablink);
        BridgeBridgeLink bclink = new BridgeBridgeLink();
        bclink.setNode(nodeC);
        bclink.setBridgePort(topology.portCB);
        bclink.setDesignatedNode(nodeB);
        bclink.setDesignatedPort(topology.portBC);
        bclink.setBridgeBridgeLinkLastPollTime(ablink.getBridgeBridgeLinkCreateTime());
        this.m_bridgeBridgeLinkDao.save((Object)bclink);
        BridgeMacLink mac1 = new BridgeMacLink();
        mac1.setNode(nodeA);
        mac1.setBridgePort(topology.portA);
        mac1.setMacAddress(topology.mac1);
        mac1.setLinkType(BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK);
        mac1.setBridgeMacLinkLastPollTime(mac1.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)mac1);
        BridgeMacLink mac2 = new BridgeMacLink();
        mac2.setNode(nodeB);
        mac2.setBridgePort(topology.portB);
        mac2.setMacAddress(topology.mac2);
        mac2.setLinkType(BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK);
        mac2.setBridgeMacLinkLastPollTime(mac2.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)mac2);
        BridgeMacLink mac3 = new BridgeMacLink();
        mac3.setNode(nodeC);
        mac3.setBridgePort(topology.portC);
        mac3.setMacAddress(topology.mac3);
        mac3.setLinkType(BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK);
        mac3.setBridgeMacLinkLastPollTime(mac3.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)mac3);
        this.m_bridgeMacLinkDao.flush();
        this.m_bridgeBridgeLinkDao.flush();
        Assert.assertEquals((long)3L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertEquals((long)2L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertNotNull((Object)this.m_bridgeTopologyDao);
        this.m_linkd.getQueryManager().loadBridgeTopology();
        Assert.assertEquals((long)1L, (long)this.m_linkd.getQueryManager().getAllBroadcastDomains().size());
        BroadcastDomain nodeAbd = this.m_linkd.getQueryManager().getBroadcastDomain(nodeA.getId().intValue());
        Assert.assertNotNull((Object)nodeAbd);
        BroadcastDomain nodeBbd = this.m_linkd.getQueryManager().getBroadcastDomain(nodeB.getId().intValue());
        BroadcastDomain nodeCbd = this.m_linkd.getQueryManager().getBroadcastDomain(nodeC.getId().intValue());
        Assert.assertEquals((Object)nodeAbd, (Object)nodeBbd);
        Assert.assertEquals((Object)nodeAbd, (Object)nodeCbd);
        Assert.assertNotNull((Object)nodeAbd.getRootBridge());
        Assert.assertEquals((long)nodeAbd.getRootBridge().getNodeId().intValue(), (long)nodeA.getId().intValue());
        Assert.assertNotNull((Object)nodeAbd.getBridge(nodeA.getId().intValue()));
        Assert.assertNotNull((Object)nodeAbd.getBridge(nodeB.getId().intValue()));
        Assert.assertNotNull((Object)nodeAbd.getBridge(nodeC.getId().intValue()));
        BroadcastDomain.hierarchySetUp((BroadcastDomain)nodeAbd, (Bridge)nodeAbd.getBridge(nodeA.getId().intValue()));
        Assert.assertNotNull((Object)nodeAbd.getRootBridge());
        topology.check(nodeAbd);
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(nodeA.getId().intValue()));
        this.m_linkd.deleteNode(nodeA.getId().intValue());
        Assert.assertEquals((long)1L, (long)this.m_linkd.getQueryManager().getAllBroadcastDomains().size());
        BroadcastDomain domain = (BroadcastDomain)this.m_linkd.getQueryManager().getAllBroadcastDomains().iterator().next();
        topology.checkBC(domain);
    }

    @Test
    public void checkBridgeTopologyDao() throws BridgeTopologyException {
        NetworkBuilder nb = new NetworkBuilder();
        nb.addNode("pe01").setForeignSource("linkd").setForeignId("pe01").setSysObjectId(".1.3.6.1.4.1.9.1.1252").setSysName("pe01").setType(OnmsNode.NodeType.ACTIVE);
        nb.addInterface("10.25.39.1").setIsSnmpPrimary("P").setIsManaged("M");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        nb.addNode("asw01").setForeignSource("linkd").setForeignId("asw01").setSysObjectId(".1.3.6.1.4.1.6486.800.1.1.2.1.10.1.1").setSysName("asw01").setType(OnmsNode.NodeType.ACTIVE);
        nb.addInterface("10.25.39.1").setIsSnmpPrimary("P").setIsManaged("M");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        nb.addNode("ess01").setForeignSource("linkd").setForeignId("ess01").setSysObjectId(".1.3.6.1.4.1.8072.3.2.10").setSysName("ess01").setType(OnmsNode.NodeType.ACTIVE);
        nb.addInterface("10.25.39.34").setIsSnmpPrimary("P").setIsManaged("M");
        nb.addInterface("10.25.139.61").setIsSnmpPrimary("N").setIsManaged("M");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        OnmsNode pe01 = this.m_nodeDao.findByForeignId("linkd", "pe01");
        OnmsNode asw01 = this.m_nodeDao.findByForeignId("linkd", "asw01");
        OnmsNode ess01 = this.m_nodeDao.findByForeignId("linkd", "ess01");
        String mac0 = "00176301092d";
        String mac1 = "54a050847462";
        String mac2 = "a0d3c1333de9";
        String mac3 = "e48d8c2e100c";
        String mac4 = "0012cf68d780";
        String mac5 = "e48d8cf17bcb";
        String mac6 = "4c0082245938";
        String mac7 = "4c0082245937";
        IpNetToMedia ip1mac0 = new IpNetToMedia();
        ip1mac0.setSourceNode(pe01);
        ip1mac0.setSourceIfIndex(Integer.valueOf(25));
        ip1mac0.setPhysAddress(mac0);
        ip1mac0.setNetAddress(InetAddressUtils.addr((String)"10.25.39.34"));
        ip1mac0.setLastPollTime(ip1mac0.getCreateTime());
        ip1mac0.setIpNetToMediaType(IpNetToMedia.IpNetToMediaType.IPNETTOMEDIA_TYPE_DYNAMIC);
        IpNetToMedia ip2mac0 = new IpNetToMedia();
        ip2mac0.setSourceNode(pe01);
        ip2mac0.setSourceIfIndex(Integer.valueOf(25));
        ip2mac0.setPhysAddress(mac0);
        ip2mac0.setNetAddress(InetAddressUtils.addr((String)"10.25.139.61"));
        ip2mac0.setIpNetToMediaType(IpNetToMedia.IpNetToMediaType.IPNETTOMEDIA_TYPE_DYNAMIC);
        ip2mac0.setLastPollTime(ip2mac0.getCreateTime());
        IpNetToMedia ip1mac1 = new IpNetToMedia();
        ip1mac1.setSourceNode(pe01);
        ip1mac1.setSourceIfIndex(Integer.valueOf(3001));
        ip1mac1.setPhysAddress(mac1);
        ip1mac1.setNetAddress(InetAddressUtils.addr((String)"172.22.128.109"));
        ip1mac1.setIpNetToMediaType(IpNetToMedia.IpNetToMediaType.IPNETTOMEDIA_TYPE_DYNAMIC);
        ip1mac1.setLastPollTime(ip1mac1.getCreateTime());
        IpNetToMedia ip1mac2 = new IpNetToMedia();
        ip1mac2.setSourceNode(pe01);
        ip1mac2.setSourceIfIndex(Integer.valueOf(3001));
        ip1mac2.setPhysAddress(mac2);
        ip1mac2.setNetAddress(InetAddressUtils.addr((String)"172.22.128.115"));
        ip1mac2.setIpNetToMediaType(IpNetToMedia.IpNetToMediaType.IPNETTOMEDIA_TYPE_DYNAMIC);
        ip1mac2.setLastPollTime(ip1mac2.getCreateTime());
        IpNetToMedia ip1mac3 = new IpNetToMedia();
        ip1mac3.setSourceNode(pe01);
        ip1mac3.setSourceIfIndex(Integer.valueOf(3072));
        ip1mac3.setPhysAddress(mac3);
        ip1mac3.setNetAddress(InetAddressUtils.addr((String)"10.125.39.18"));
        ip1mac3.setIpNetToMediaType(IpNetToMedia.IpNetToMediaType.IPNETTOMEDIA_TYPE_DYNAMIC);
        ip1mac3.setLastPollTime(ip1mac3.getCreateTime());
        IpNetToMedia ip2mac3 = new IpNetToMedia();
        ip2mac3.setSourceNode(pe01);
        ip2mac3.setSourceIfIndex(Integer.valueOf(3072));
        ip2mac3.setPhysAddress(mac3);
        ip2mac3.setNetAddress(InetAddressUtils.addr((String)"10.125.39.5"));
        ip2mac3.setIpNetToMediaType(IpNetToMedia.IpNetToMediaType.IPNETTOMEDIA_TYPE_DYNAMIC);
        ip2mac3.setLastPollTime(ip2mac3.getCreateTime());
        IpNetToMedia ip3mac3 = new IpNetToMedia();
        ip3mac3.setSourceNode(pe01);
        ip3mac3.setSourceIfIndex(Integer.valueOf(3072));
        ip3mac3.setPhysAddress(mac3);
        ip3mac3.setNetAddress(InetAddressUtils.addr((String)"10.125.39.133"));
        ip3mac3.setIpNetToMediaType(IpNetToMedia.IpNetToMediaType.IPNETTOMEDIA_TYPE_DYNAMIC);
        ip3mac3.setLastPollTime(ip3mac3.getCreateTime());
        IpNetToMedia ip1mac4 = new IpNetToMedia();
        ip1mac4.setSourceNode(pe01);
        ip1mac4.setSourceIfIndex(Integer.valueOf(3072));
        ip1mac4.setPhysAddress(mac4);
        ip1mac4.setNetAddress(InetAddressUtils.addr((String)"10.25.39.61"));
        ip1mac4.setIpNetToMediaType(IpNetToMedia.IpNetToMediaType.IPNETTOMEDIA_TYPE_DYNAMIC);
        ip1mac4.setLastPollTime(ip1mac4.getCreateTime());
        IpNetToMedia ip1mac6 = new IpNetToMedia();
        ip1mac6.setSourceNode(pe01);
        ip1mac6.setSourceIfIndex(Integer.valueOf(8011));
        ip1mac6.setPhysAddress(mac6);
        ip1mac6.setNetAddress(InetAddressUtils.addr((String)"10.101.39.2"));
        ip1mac6.setIpNetToMediaType(IpNetToMedia.IpNetToMediaType.IPNETTOMEDIA_TYPE_DYNAMIC);
        ip1mac6.setLastPollTime(ip1mac6.getCreateTime());
        this.m_ipNetToMediaDao.save((Object)ip1mac0);
        this.m_ipNetToMediaDao.save((Object)ip2mac0);
        this.m_ipNetToMediaDao.save((Object)ip1mac1);
        this.m_ipNetToMediaDao.save((Object)ip1mac2);
        this.m_ipNetToMediaDao.save((Object)ip1mac3);
        this.m_ipNetToMediaDao.save((Object)ip2mac3);
        this.m_ipNetToMediaDao.save((Object)ip3mac3);
        this.m_ipNetToMediaDao.save((Object)ip1mac4);
        this.m_ipNetToMediaDao.save((Object)ip1mac6);
        BridgeBridgeLink asw01pe01link = new BridgeBridgeLink();
        asw01pe01link.setNode(asw01);
        asw01pe01link.setBridgePort(Integer.valueOf(24));
        asw01pe01link.setBridgePort(Integer.valueOf(1024));
        asw01pe01link.setDesignatedNode(pe01);
        asw01pe01link.setDesignatedPort(Integer.valueOf(24));
        asw01pe01link.setDesignatedPortIfIndex(Integer.valueOf(10124));
        asw01pe01link.setDesignatedVlan(Integer.valueOf(25));
        asw01pe01link.setBridgeBridgeLinkLastPollTime(asw01pe01link.getBridgeBridgeLinkCreateTime());
        BridgeMacLink pe01mac1port3 = new BridgeMacLink();
        pe01mac1port3.setNode(pe01);
        pe01mac1port3.setBridgePort(Integer.valueOf(3));
        pe01mac1port3.setBridgePortIfIndex(Integer.valueOf(10103));
        pe01mac1port3.setVlan(Integer.valueOf(3001));
        pe01mac1port3.setMacAddress(mac1);
        pe01mac1port3.setLinkType(BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK);
        pe01mac1port3.setBridgeMacLinkLastPollTime(pe01mac1port3.getBridgeMacLinkCreateTime());
        BridgeMacLink pe01mac2port3 = new BridgeMacLink();
        pe01mac2port3.setNode(pe01);
        pe01mac2port3.setBridgePort(Integer.valueOf(3));
        pe01mac2port3.setBridgePortIfIndex(Integer.valueOf(10103));
        pe01mac2port3.setVlan(Integer.valueOf(3001));
        pe01mac2port3.setMacAddress(mac2);
        pe01mac2port3.setLinkType(BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK);
        pe01mac2port3.setBridgeMacLinkLastPollTime(pe01mac2port3.getBridgeMacLinkCreateTime());
        BridgeMacLink pe01mac3port7 = new BridgeMacLink();
        pe01mac3port7.setNode(pe01);
        pe01mac3port7.setBridgePort(Integer.valueOf(7));
        pe01mac3port7.setBridgePortIfIndex(Integer.valueOf(10107));
        pe01mac3port7.setVlan(Integer.valueOf(3072));
        pe01mac3port7.setMacAddress(mac3);
        pe01mac3port7.setLinkType(BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK);
        pe01mac3port7.setBridgeMacLinkLastPollTime(pe01mac3port7.getBridgeMacLinkCreateTime());
        BridgeMacLink asw01mac4port1 = new BridgeMacLink();
        asw01mac4port1.setNode(asw01);
        asw01mac4port1.setBridgePort(Integer.valueOf(1));
        asw01mac4port1.setBridgePortIfIndex(Integer.valueOf(1001));
        asw01mac4port1.setMacAddress(mac4);
        asw01mac4port1.setLinkType(BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK);
        asw01mac4port1.setBridgeMacLinkLastPollTime(asw01mac4port1.getBridgeMacLinkCreateTime());
        BridgeMacLink asw01mac5port1 = new BridgeMacLink();
        asw01mac5port1.setNode(asw01);
        asw01mac5port1.setBridgePort(Integer.valueOf(1));
        asw01mac5port1.setBridgePortIfIndex(Integer.valueOf(1001));
        asw01mac5port1.setMacAddress(mac5);
        asw01mac5port1.setLinkType(BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK);
        asw01mac5port1.setBridgeMacLinkLastPollTime(asw01mac5port1.getBridgeMacLinkCreateTime());
        BridgeMacLink asw01mac0port1 = new BridgeMacLink();
        asw01mac0port1.setNode(asw01);
        asw01mac0port1.setBridgePort(Integer.valueOf(1));
        asw01mac0port1.setBridgePortIfIndex(Integer.valueOf(1001));
        asw01mac0port1.setMacAddress(mac0);
        asw01mac0port1.setLinkType(BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK);
        asw01mac0port1.setBridgeMacLinkLastPollTime(asw01mac0port1.getBridgeMacLinkCreateTime());
        BridgeMacLink asw01mac6port19 = new BridgeMacLink();
        asw01mac6port19.setNode(asw01);
        asw01mac6port19.setBridgePort(Integer.valueOf(19));
        asw01mac6port19.setBridgePortIfIndex(Integer.valueOf(1019));
        asw01mac6port19.setMacAddress(mac6);
        asw01mac6port19.setLinkType(BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK);
        asw01mac6port19.setBridgeMacLinkLastPollTime(asw01mac6port19.getBridgeMacLinkCreateTime());
        BridgeMacLink shared = new BridgeMacLink();
        shared.setNode(pe01);
        shared.setBridgePort(Integer.valueOf(24));
        shared.setBridgePortIfIndex(Integer.valueOf(10124));
        shared.setMacAddress(mac7);
        shared.setLinkType(BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK);
        shared.setBridgeMacLinkLastPollTime(shared.getBridgeMacLinkCreateTime());
        this.m_bridgeBridgeLinkDao.save((Object)asw01pe01link);
        this.m_bridgeMacLinkDao.save((Object)shared);
        this.m_bridgeMacLinkDao.save((Object)pe01mac1port3);
        this.m_bridgeMacLinkDao.save((Object)pe01mac2port3);
        this.m_bridgeMacLinkDao.save((Object)pe01mac3port7);
        this.m_bridgeMacLinkDao.save((Object)asw01mac0port1);
        this.m_bridgeMacLinkDao.save((Object)asw01mac4port1);
        this.m_bridgeMacLinkDao.save((Object)asw01mac5port1);
        this.m_bridgeMacLinkDao.save((Object)asw01mac6port19);
        this.m_ipNetToMediaDao.flush();
        this.m_bridgeBridgeLinkDao.flush();
        this.m_bridgeMacLinkDao.flush();
        Assert.assertEquals((long)1L, (long)this.m_bridgeTopologyDao.load().size());
        Assert.assertEquals((long)3L, (long)this.m_bridgeTopologyDao.getBridgeSharedSegments(pe01.getId().intValue()).size());
        Assert.assertEquals((long)3L, (long)this.m_bridgeTopologyDao.getBridgeSharedSegments(asw01.getId().intValue()).size());
        Assert.assertEquals((long)0L, (long)this.m_bridgeTopologyDao.getBridgeSharedSegments(ess01.getId().intValue()).size());
        SharedSegment asw01port1segment = this.m_bridgeTopologyDao.getHostSharedSegment(mac0);
        Assert.assertEquals((long)3L, (long)asw01port1segment.getMacsOnSegment().size());
        Assert.assertTrue((boolean)asw01port1segment.containsMac(mac0));
        Assert.assertTrue((boolean)asw01port1segment.containsMac(mac4));
        Assert.assertTrue((boolean)asw01port1segment.containsMac(mac5));
        Assert.assertEquals((long)1L, (long)asw01port1segment.getBridgePortsOnSegment().size());
        BridgePort asw01port1 = (BridgePort)asw01port1segment.getBridgePortsOnSegment().iterator().next();
        Assert.assertEquals((Object)asw01.getId(), (Object)asw01port1.getNodeId());
        Assert.assertEquals((long)1L, (long)asw01port1.getBridgePort().intValue());
        Assert.assertEquals((long)1001L, (long)asw01port1.getBridgePortIfIndex().intValue());
        SharedSegment pe01port3 = this.m_bridgeTopologyDao.getHostSharedSegment(mac1);
        Assert.assertEquals((long)2L, (long)pe01port3.getMacsOnSegment().size());
        Assert.assertTrue((boolean)pe01port3.containsMac(mac1));
        Assert.assertTrue((boolean)pe01port3.containsMac(mac2));
        Assert.assertEquals((long)1L, (long)pe01port3.getBridgePortsOnSegment().size());
        SharedSegment pe01port7 = this.m_bridgeTopologyDao.getHostSharedSegment(mac3);
        Assert.assertEquals((long)1L, (long)pe01port7.getMacsOnSegment().size());
        Assert.assertTrue((boolean)pe01port7.containsMac(mac3));
        Assert.assertEquals((long)1L, (long)pe01port7.getBridgePortsOnSegment().size());
        SharedSegment asw01port19segment = this.m_bridgeTopologyDao.getHostSharedSegment(mac6);
        Assert.assertEquals((long)1L, (long)asw01port19segment.getMacsOnSegment().size());
        Assert.assertTrue((boolean)asw01port19segment.containsMac(mac6));
        Assert.assertEquals((long)1L, (long)asw01port19segment.getBridgePortsOnSegment().size());
        SharedSegment pe01asw01segment = this.m_bridgeTopologyDao.getHostSharedSegment(mac7);
        Assert.assertEquals((long)1L, (long)pe01asw01segment.getMacsOnSegment().size());
        Assert.assertTrue((boolean)pe01asw01segment.containsMac(mac7));
        Assert.assertEquals((long)2L, (long)pe01asw01segment.getBridgePortsOnSegment().size());
        SharedSegment emptysegment = this.m_bridgeTopologyDao.getHostSharedSegment("001763010920");
        Assert.assertEquals((long)0L, (long)emptysegment.getBridgePortsOnSegment().size());
        Assert.assertEquals((long)0L, (long)emptysegment.getMacsOnSegment().size());
        HashMap mactoIpNodeMap = new HashMap();
        this.m_ipInterfaceDao.findByNodeId(ess01.getId()).stream().forEach(ip -> this.m_ipNetToMediaDao.findByNetAddress(ip.getIpAddress()).stream().forEach(ipnettomedia -> {
            if (!mactoIpNodeMap.containsKey(ipnettomedia.getPhysAddress())) {
                mactoIpNodeMap.put(ipnettomedia.getPhysAddress(), new ArrayList());
            }
            ((List)mactoIpNodeMap.get(ipnettomedia.getPhysAddress())).add(ip);
        }));
        Assert.assertEquals((long)1L, (long)mactoIpNodeMap.size());
        Assert.assertEquals((Object)mac0, mactoIpNodeMap.keySet().iterator().next());
        HashSet ipsonmap = new HashSet();
        ((List)mactoIpNodeMap.get(mac0)).stream().forEach(onmsip -> ipsonmap.add(InetAddressUtils.str((InetAddress)onmsip.getIpAddress())));
        Assert.assertEquals((long)2L, (long)ipsonmap.size());
        Assert.assertTrue((boolean)ipsonmap.contains("10.25.39.34"));
        Assert.assertTrue((boolean)ipsonmap.contains("10.25.139.61"));
        HashSet<Integer> nodelinks = new HashSet<Integer>();
        for (String mac : mactoIpNodeMap.keySet()) {
            SharedSegment segment = this.m_bridgeTopologyDao.getHostSharedSegment(mac);
            if (segment.isEmpty()) continue;
            nodelinks.add(segment.getDesignatedBridge());
        }
        Assert.assertEquals((long)1L, (long)nodelinks.size());
        Assert.assertEquals((Object)asw01.getId(), nodelinks.iterator().next());
    }
}

