/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmpinterfacepoller.pollable;

import java.util.HashMap;
import java.util.Map;
import org.opennms.netmgt.scheduler.Schedule;
import org.opennms.netmgt.scheduler.Scheduler;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollContext;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollableInterface;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollableSnmpInterface;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollableSnmpInterfaceConfig;

public class PollableNetwork {
    private final Map<String, PollableInterface> m_members = new HashMap<String, PollableInterface>();
    private final Map<Integer, String> m_node = new HashMap<Integer, String>();
    private PollContext m_context;

    public PollableNetwork(PollContext context) {
        this.m_context = context;
    }

    public PollableInterface create(int nodeid, String ipaddress, String netMask, String packageName) {
        PollableInterface nodeGroup = new PollableInterface(this);
        nodeGroup.setNodeid(nodeid);
        nodeGroup.setIpaddress(ipaddress);
        nodeGroup.setNetMask(netMask);
        nodeGroup.setPackageName(packageName);
        nodeGroup.initialize();
        this.m_members.put(nodeGroup.getIpaddress(), nodeGroup);
        this.m_node.put(nodeGroup.getNodeid(), nodeGroup.getIpaddress());
        return nodeGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(PollableSnmpInterface node, long interval, Scheduler scheduler) {
        PollableSnmpInterfaceConfig nodeconfig = new PollableSnmpInterfaceConfig(scheduler, interval);
        node.setSnmppollableconfig(nodeconfig);
        PollableSnmpInterface pollableSnmpInterface = node;
        synchronized (pollableSnmpInterface) {
            if (node.getSchedule() == null) {
                Schedule schedule = new Schedule(node, nodeconfig, scheduler);
                node.setSchedule(schedule);
            }
        }
        node.schedule();
    }

    public void deleteAll() {
        for (PollableInterface pi : this.m_members.values()) {
            pi.delete();
        }
        this.m_members.clear();
        this.m_node.clear();
    }

    public void delete(String ipaddress) {
        PollableInterface pi = this.getInterface(ipaddress);
        if (pi != null) {
            this.m_members.remove(ipaddress);
            this.m_node.remove(pi.getNodeid());
            pi.delete();
        }
    }

    public void delete(int nodeid) {
        this.delete(this.getIp(nodeid));
    }

    public void refresh(int nodeid) {
        String ipaddress = this.getIp(nodeid);
        if (ipaddress != null) {
            this.getInterface(ipaddress).refresh();
        }
    }

    public void suspend(String ipaddress) {
        PollableInterface pi = this.getInterface(ipaddress);
        if (pi != null) {
            pi.suspend();
        }
    }

    public void activate(String ipaddress) {
        PollableInterface pi = this.getInterface(ipaddress);
        if (pi != null) {
            pi.activate();
        }
    }

    public void suspend(int nodeid) {
        String ipprimary = this.getIp(nodeid);
        if (ipprimary != null) {
            this.suspend(ipprimary);
        }
    }

    public void activate(int nodeid) {
        String ipprimary = this.getIp(nodeid);
        if (ipprimary != null) {
            this.activate(ipprimary);
        }
    }

    public String getIp(int nodeid) {
        return this.m_node.get(nodeid);
    }

    private PollableInterface getInterface(String ipaddress) {
        if (this.m_members.containsKey(ipaddress)) {
            return this.m_members.get(ipaddress);
        }
        return null;
    }

    public boolean hasPollableInterface(String ipaddr) {
        return this.m_members.containsKey(ipaddr);
    }

    public PollContext getContext() {
        return this.m_context;
    }

    public void setContext(PollContext context) {
        this.m_context = context;
    }
}

