/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.scheduler;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.opennms.core.test.MockLogAppender;
import org.opennms.netmgt.poller.mock.MockInterval;
import org.opennms.netmgt.poller.mock.MockScheduler;
import org.opennms.netmgt.scheduler.ReadyRunnable;
import org.opennms.netmgt.scheduler.Schedule;
import org.opennms.netmgt.scheduler.ScheduleInterval;
import org.opennms.netmgt.scheduler.ScheduleTimer;
import org.opennms.netmgt.scheduler.Timer;

public class ScheduleTest
extends TestCase {
    private MockSchedulable m_schedulable;
    private MockInterval m_interval;
    private MockScheduler m_scheduler;
    private Schedule m_sched;

    public static void main(String[] args) {
        TestRunner.run(ScheduleTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        MockLogAppender.setupLogging();
        this.m_schedulable = new MockSchedulable();
        this.m_scheduler = new MockScheduler();
        this.m_interval = new MockInterval((Timer)this.m_scheduler, 1000L);
        this.m_sched = new Schedule((ReadyRunnable)this.m_schedulable, (ScheduleInterval)this.m_interval, (ScheduleTimer)this.m_scheduler);
    }

    protected void tearDown() throws Exception {
        MockLogAppender.assertNoWarningsOrGreater();
        super.tearDown();
    }

    public void testSchedule() {
        this.m_sched.schedule();
        this.assertRunAndScheduled(0L, 0L, 0, 1);
        this.m_scheduler.next();
        this.assertRunAndScheduled(0L, 1000L, 1, 1);
        this.m_scheduler.next();
        this.assertRunAndScheduled(1000L, 1000L, 2, 1);
    }

    public void testAdjustSchedule() {
        this.m_sched.schedule();
        this.assertRunAndScheduled(0L, 0L, 0, 1);
        this.m_scheduler.next();
        this.m_interval.setInterval(900L);
        this.m_sched.adjustSchedule();
        this.assertRunAndScheduled(0L, 900L, 1, 2);
        this.m_scheduler.next();
        this.assertRunAndScheduled(900L, 900L, 2, 2);
        this.m_scheduler.next();
        this.assertRunAndScheduled(1000L, 800L, 2, 1);
        this.m_scheduler.next();
        this.assertRunAndScheduled(1800L, 900L, 3, 1);
        this.m_scheduler.next();
        this.assertRunAndScheduled(2700L, 900L, 4, 1);
        this.m_interval.setInterval(1000L);
        this.m_sched.adjustSchedule();
        this.m_scheduler.next();
        this.assertRunAndScheduled(3600L, 100L, 4, 1);
        this.m_scheduler.next();
        this.assertRunAndScheduled(3700L, 1000L, 5, 1);
    }

    public void testUnschedule() {
        this.m_sched.schedule();
        this.assertRunAndScheduled(0L, 0L, 0, 1);
        this.m_scheduler.next();
        this.assertRunAndScheduled(0L, 1000L, 1, 1);
        this.m_scheduler.next();
        this.assertRunAndScheduled(1000L, 1000L, 2, 1);
        this.m_sched.unschedule();
        this.m_scheduler.next();
        this.assertRunAndScheduled(2000L, -1L, 2, 0);
    }

    public void testTemporarilySuspend() {
        this.m_interval.addSuspension(1500L, 2500L);
        this.m_sched.schedule();
        this.assertRunAndScheduled(0L, 0L, 0, 1);
        this.m_scheduler.next();
        this.assertRunAndScheduled(0L, 1000L, 1, 1);
        this.m_scheduler.next();
        this.assertRunAndScheduled(1000L, 1000L, 2, 1);
        this.m_scheduler.next();
        this.assertRunAndScheduled(2000L, 1000L, 2, 1);
        this.m_scheduler.next();
        this.assertRunAndScheduled(3000L, 1000L, 3, 1);
    }

    public void testAdjustScheduleWithinRun() {
        this.m_schedulable.setCallingAdjustSchedule(true);
        this.m_sched.schedule();
        this.assertRunAndScheduled(0L, 0L, 0, 1);
        this.m_scheduler.next();
        this.assertRunAndScheduled(0L, 1000L, 1, 1);
        this.m_scheduler.next();
        this.assertRunAndScheduled(1000L, 1000L, 2, 1);
    }

    private void assertRunAndScheduled(long currentTime, long interval, int count, int entryCount) {
        ScheduleTest.assertEquals((int)count, (int)this.m_schedulable.getRunCount());
        ScheduleTest.assertEquals((long)currentTime, (long)this.m_scheduler.getCurrentTime());
        ScheduleTest.assertEquals((int)entryCount, (int)this.m_scheduler.getEntryCount());
        if (entryCount > 0) {
            ScheduleTest.assertNotNull(this.m_scheduler.getEntries().get(currentTime + interval));
        }
    }

    class MockSchedulable
    implements ReadyRunnable {
        private volatile int runCount = 0;
        private volatile boolean m_callingAdjustSchedule;

        MockSchedulable() {
        }

        public boolean isReady() {
            return true;
        }

        public void run() {
            ++this.runCount;
            if (this.isCallingAdjustSchedule()) {
                ScheduleTest.this.m_sched.adjustSchedule();
            }
        }

        public int getRunCount() {
            return this.runCount;
        }

        public void setCallingAdjustSchedule(boolean callingAdjustSchedule) {
            this.m_callingAdjustSchedule = callingAdjustSchedule;
        }

        public boolean isCallingAdjustSchedule() {
            return this.m_callingAdjustSchedule;
        }
    }
}

