/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgents;
import org.opennms.netmgt.enlinkd.EnLinkdBuilderITCase;
import org.opennms.netmgt.model.BridgeBridgeLink;
import org.opennms.netmgt.model.BridgeMacLink;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.topology.BridgeForwardingTableEntry;
import org.opennms.netmgt.nb.Nms7918NetworkBuilder;

public class Nms7918EnIT
extends EnLinkdBuilderITCase {
    private static String[] asw01port2forwarders = new String[]{"0012cf68f800", "0012cf3f4ee0"};
    private static String[] stcport11forwarders = new String[]{"0003ea017579"};
    private static String[] asw01port1 = new String[]{"00131971d480", "001319bdb440", "000c295cde87", "000c29f49b80", "000a5e540ee6"};
    private static String[] asw01port3 = new String[]{"001763010d4f"};
    private static String[] asw01port4 = new String[]{"4c5e0c891d93", "000c42f213af", "000c427bfee3", "00176301050f"};
    private static String[] samport23 = new String[]{"0025454ac907"};
    private static String[] stcport19 = new String[]{"4c00822458d2"};
    private static String[] stcport24 = new String[]{"000e83f6120a"};
    private static String[] samasw01shared = new String[]{"00e0b1bd265e", "00e0b1bd2652", "001d71d5e4e7"};
    private static String[] stcasw01shared = new String[]{"001763010792"};
    private static String[] stcsamshared = new String[]{"00e0b1bd2f5f", "00e0b1bd2f5c"};
    private static String[] shared = new String[]{"000c42f5d30a", "001d454777dc", "d4ca6ded84ce", "0022557fd894", "0021a4357254", "d4ca6dedd059", "c4641393f352", "d4ca6d954b3b", "d4ca6d88234f", "0012cf68f80f", "d4ca6ded84d6", "000c42ef1df6", "d4ca6d69c484", "d4ca6d954aed", "d4ca6df7f801", "000c429e3f3d", "4c5e0c246b08", "4c5e0c841245", "d4ca6da2d626", "d4ca6ded84c8", "000c42db4e11"};
    Nms7918NetworkBuilder builder = new Nms7918NetworkBuilder();

    @Before
    public void setUpNetwork4930() throws Exception {
        this.builder.setNodeDao(this.m_nodeDao);
        this.builder.setIpNetToMediaDao(this.m_ipNetToMediaDao);
        this.builder.buildNetwork7918();
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.25.19.216", port=161, resource="classpath:/linkd/nms7918/stc.asw01.txt")})
    public void testNms7918STCASW01BftCollection() throws Exception {
        OnmsNode stcasw01 = this.m_nodeDao.findByForeignId("linkd", "stc.asw01");
        this.m_linkdConfig.getConfiguration().setUseBridgeDiscovery(Boolean.valueOf(true));
        this.m_linkdConfig.getConfiguration().setUseCdpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseOspfDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseLldpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseIsisDiscovery(Boolean.valueOf(false));
        Assert.assertTrue((!this.m_linkdConfig.useLldpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useCdpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useOspfDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkdConfig.useBridgeDiscovery());
        Assert.assertTrue((!this.m_linkdConfig.useIsisDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(stcasw01.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(stcasw01.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.countAll());
        Set links = this.m_linkd.getQueryManager().useBridgeTopologyUpdateBFT(stcasw01.getId().intValue());
        Assert.assertEquals((long)34L, (long)links.size());
        for (BridgeForwardingTableEntry link : links) {
            System.err.println(link.printTopology());
        }
        this.m_linkd.runTopologyDiscovery();
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.countAll());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.25.19.216", port=161, resource="classpath:/linkd/nms7918/stc.asw01.txt")})
    public void testNms7918STCASW01Bft() throws Exception {
        OnmsNode stcasw01 = this.m_nodeDao.findByForeignId("linkd", "stc.asw01");
        this.m_linkdConfig.getConfiguration().setUseBridgeDiscovery(Boolean.valueOf(true));
        this.m_linkdConfig.getConfiguration().setUseCdpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseOspfDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseLldpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseIsisDiscovery(Boolean.valueOf(false));
        Assert.assertTrue((!this.m_linkdConfig.useLldpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useCdpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useOspfDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkdConfig.useBridgeDiscovery());
        Assert.assertTrue((!this.m_linkdConfig.useIsisDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(stcasw01.getId().intValue()));
        Assert.assertTrue((!this.m_linkd.scheduleNodeCollection(stcasw01.getId().intValue()) ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(stcasw01.getId().intValue()));
        Assert.assertEquals((long)1L, (long)this.m_bridgeElementDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeStpLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.countAll());
        this.m_linkd.runTopologyDiscovery();
        Assert.assertNull((Object)this.m_linkd.getQueryManager().useBridgeTopologyUpdateBFT(stcasw01.getId().intValue()));
        Assert.assertEquals((long)1L, (long)this.m_bridgeElementDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeStpLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)34L, (long)this.m_bridgeMacLinkDao.countAll());
        for (BridgeMacLink link : this.m_bridgeMacLinkDao.findAll()) {
            System.err.println(link.printTopology());
        }
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(stcasw01.getId().intValue()));
        Assert.assertEquals((long)1L, (long)this.m_bridgeElementDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeStpLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)34L, (long)this.m_bridgeMacLinkDao.countAll());
        Thread.sleep(5000L);
        this.m_linkd.runTopologyDiscovery();
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)34L, (long)this.m_bridgeMacLinkDao.countAll());
        for (BridgeMacLink link : this.m_bridgeMacLinkDao.findAll()) {
            System.err.println(link.printTopology());
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.25.19.211", port=161, resource="classpath:/linkd/nms7918/sam.asw01.txt")})
    public void testNms7918SAMASW01BftCollection() throws Exception {
        OnmsNode samasw01 = this.m_nodeDao.findByForeignId("linkd", "sam.asw01");
        this.m_linkdConfig.getConfiguration().setUseBridgeDiscovery(Boolean.valueOf(true));
        this.m_linkdConfig.getConfiguration().setUseCdpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseOspfDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseLldpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseIsisDiscovery(Boolean.valueOf(false));
        Assert.assertTrue((!this.m_linkdConfig.useLldpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useCdpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useOspfDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkdConfig.useBridgeDiscovery());
        Assert.assertTrue((!this.m_linkdConfig.useIsisDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(samasw01.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(samasw01.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.countAll());
        Set links = this.m_linkd.getQueryManager().useBridgeTopologyUpdateBFT(samasw01.getId().intValue());
        Assert.assertEquals((long)31L, (long)links.size());
        for (BridgeForwardingTableEntry link : links) {
            System.err.println(link.printTopology());
        }
        this.m_linkd.runTopologyDiscovery();
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.countAll());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.25.19.211", port=161, resource="classpath:/linkd/nms7918/sam.asw01.txt")})
    public void testNms7918SAMASW01Bft() throws Exception {
        OnmsNode samasw01 = this.m_nodeDao.findByForeignId("linkd", "sam.asw01");
        this.m_linkdConfig.getConfiguration().setUseBridgeDiscovery(Boolean.valueOf(true));
        this.m_linkdConfig.getConfiguration().setUseCdpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseOspfDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseLldpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseIsisDiscovery(Boolean.valueOf(false));
        Assert.assertTrue((!this.m_linkdConfig.useLldpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useCdpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useOspfDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkdConfig.useBridgeDiscovery());
        Assert.assertTrue((!this.m_linkdConfig.useIsisDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(samasw01.getId().intValue()));
        Assert.assertTrue((!this.m_linkd.scheduleNodeCollection(samasw01.getId().intValue()) ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(samasw01.getId().intValue()));
        Assert.assertEquals((long)1L, (long)this.m_bridgeElementDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeStpLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.countAll());
        this.m_linkd.runTopologyDiscovery();
        Assert.assertNull((Object)this.m_linkd.getQueryManager().useBridgeTopologyUpdateBFT(samasw01.getId().intValue()));
        Assert.assertEquals((long)1L, (long)this.m_bridgeElementDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeStpLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)31L, (long)this.m_bridgeMacLinkDao.countAll());
        for (BridgeMacLink link : this.m_bridgeMacLinkDao.findAll()) {
            System.err.println(link.printTopology());
        }
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(samasw01.getId().intValue()));
        Assert.assertEquals((long)1L, (long)this.m_bridgeElementDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeStpLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)31L, (long)this.m_bridgeMacLinkDao.countAll());
        Thread.sleep(5000L);
        this.m_linkd.runTopologyDiscovery();
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)31L, (long)this.m_bridgeMacLinkDao.countAll());
        for (BridgeMacLink link : this.m_bridgeMacLinkDao.findAll()) {
            System.err.println(link.printTopology());
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.25.19.2", port=161, resource="classpath:/linkd/nms7918/asw01.txt")})
    public void testNms7918ASW01BftCollection() throws Exception {
        OnmsNode asw01 = this.m_nodeDao.findByForeignId("linkd", "asw01");
        this.m_linkdConfig.getConfiguration().setUseBridgeDiscovery(Boolean.valueOf(true));
        this.m_linkdConfig.getConfiguration().setUseCdpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseOspfDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseLldpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseIsisDiscovery(Boolean.valueOf(false));
        Assert.assertTrue((!this.m_linkdConfig.useLldpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useCdpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useOspfDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkdConfig.useBridgeDiscovery());
        Assert.assertTrue((!this.m_linkdConfig.useIsisDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(asw01.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(asw01.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.countAll());
        Set links = this.m_linkd.getQueryManager().useBridgeTopologyUpdateBFT(asw01.getId().intValue());
        Assert.assertEquals((long)40L, (long)links.size());
        for (BridgeForwardingTableEntry link : links) {
            System.err.println(link.printTopology());
        }
        this.m_linkd.runTopologyDiscovery();
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.countAll());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.25.19.2", port=161, resource="classpath:/linkd/nms7918/asw01.txt")})
    public void testNms7918ASW01Bft() throws Exception {
        OnmsNode asw01 = this.m_nodeDao.findByForeignId("linkd", "asw01");
        this.m_linkdConfig.getConfiguration().setUseBridgeDiscovery(Boolean.valueOf(true));
        this.m_linkdConfig.getConfiguration().setUseCdpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseOspfDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseLldpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseIsisDiscovery(Boolean.valueOf(false));
        Assert.assertTrue((!this.m_linkdConfig.useLldpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useCdpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useOspfDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkdConfig.useBridgeDiscovery());
        Assert.assertTrue((!this.m_linkdConfig.useIsisDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(asw01.getId().intValue()));
        Assert.assertTrue((!this.m_linkd.scheduleNodeCollection(asw01.getId().intValue()) ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(asw01.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.countAll());
        this.m_linkd.runTopologyDiscovery();
        Assert.assertNull((Object)this.m_linkd.getQueryManager().useBridgeTopologyUpdateBFT(asw01.getId().intValue()));
        Assert.assertEquals((long)1L, (long)this.m_bridgeElementDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeStpLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)40L, (long)this.m_bridgeMacLinkDao.countAll());
        for (BridgeMacLink link : this.m_bridgeMacLinkDao.findAll()) {
            System.err.println(link.printTopology());
        }
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(asw01.getId().intValue()));
        Assert.assertEquals((long)1L, (long)this.m_bridgeElementDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeStpLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)40L, (long)this.m_bridgeMacLinkDao.countAll());
        Thread.sleep(5000L);
        this.m_linkd.runTopologyDiscovery();
        Assert.assertEquals((long)1L, (long)this.m_bridgeElementDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeStpLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)40L, (long)this.m_bridgeMacLinkDao.countAll());
        for (BridgeMacLink link : this.m_bridgeMacLinkDao.findAll()) {
            System.err.println(link.printTopology());
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.25.19.2", port=161, resource="classpath:/linkd/nms7918/asw01.txt"), @JUnitSnmpAgent(host="10.25.19.211", port=161, resource="classpath:/linkd/nms7918/sam.asw01.txt"), @JUnitSnmpAgent(host="10.25.19.216", port=161, resource="classpath:/linkd/nms7918/stc.asw01.txt")})
    public void testNms7918() throws Exception {
        OnmsNode stcasw01 = this.m_nodeDao.findByForeignId("linkd", "stc.asw01");
        OnmsNode samasw01 = this.m_nodeDao.findByForeignId("linkd", "sam.asw01");
        OnmsNode asw01 = this.m_nodeDao.findByForeignId("linkd", "asw01");
        this.m_linkdConfig.getConfiguration().setUseBridgeDiscovery(Boolean.valueOf(true));
        this.m_linkdConfig.getConfiguration().setUseCdpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseOspfDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseLldpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseIsisDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setMaxBft(Integer.valueOf(3));
        Assert.assertTrue((!this.m_linkdConfig.useLldpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useCdpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useOspfDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkdConfig.useBridgeDiscovery());
        Assert.assertTrue((!this.m_linkdConfig.useIsisDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(asw01.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(samasw01.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(stcasw01.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_bridgeElementDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeStpLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(asw01.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(samasw01.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(stcasw01.getId().intValue()));
        Assert.assertEquals((long)3L, (long)this.m_bridgeElementDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeStpLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.countAll());
        this.m_linkd.runTopologyDiscovery();
        this.checkTopology(asw01, stcasw01, samasw01);
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(asw01.getId().intValue()));
        this.m_linkd.runTopologyDiscovery();
        this.checkTopology(asw01, stcasw01, samasw01);
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(samasw01.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(stcasw01.getId().intValue()));
        this.m_linkd.runTopologyDiscovery();
        this.checkTopology(asw01, stcasw01, samasw01);
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(asw01.getId().intValue()));
        this.m_linkd.runTopologyDiscovery();
        this.checkTopology(asw01, stcasw01, samasw01);
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(stcasw01.getId().intValue()));
        this.m_linkd.runTopologyDiscovery();
        this.checkTopology(asw01, stcasw01, samasw01);
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.25.19.2", port=161, resource="classpath:/linkd/nms7918/asw01.txt"), @JUnitSnmpAgent(host="10.25.19.211", port=161, resource="classpath:/linkd/nms7918/sam.asw01.txt"), @JUnitSnmpAgent(host="10.25.19.216", port=161, resource="classpath:/linkd/nms7918/stc.asw01.txt")})
    public void testNms7918TwoSteps() throws Exception {
        OnmsNode stcasw01 = this.m_nodeDao.findByForeignId("linkd", "stc.asw01");
        OnmsNode samasw01 = this.m_nodeDao.findByForeignId("linkd", "sam.asw01");
        OnmsNode asw01 = this.m_nodeDao.findByForeignId("linkd", "asw01");
        this.m_linkdConfig.getConfiguration().setUseBridgeDiscovery(Boolean.valueOf(true));
        this.m_linkdConfig.getConfiguration().setUseCdpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseOspfDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseLldpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseIsisDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setMaxBft(Integer.valueOf(2));
        Assert.assertTrue((!this.m_linkdConfig.useLldpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useCdpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useOspfDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkdConfig.useBridgeDiscovery());
        Assert.assertTrue((!this.m_linkdConfig.useIsisDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(asw01.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(samasw01.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(stcasw01.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_bridgeElementDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeStpLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(asw01.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(samasw01.getId().intValue()));
        Assert.assertEquals((long)2L, (long)this.m_bridgeElementDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeStpLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.countAll());
        this.m_linkd.runTopologyDiscovery();
        this.checkAsw01SamAsw01Topology(asw01, samasw01);
        this.m_linkd.runTopologyDiscovery();
        this.checkAsw01SamAsw01Topology(asw01, samasw01);
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(stcasw01.getId().intValue()));
        this.m_linkd.runTopologyDiscovery();
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.25.19.2", port=161, resource="classpath:/linkd/nms7918/asw01.txt"), @JUnitSnmpAgent(host="10.25.19.211", port=161, resource="classpath:/linkd/nms7918/sam.asw01.txt"), @JUnitSnmpAgent(host="10.25.19.216", port=161, resource="classpath:/linkd/nms7918/stc.asw01.txt")})
    public void testNms7918ThreeSteps() throws Exception {
        OnmsNode stcasw01 = this.m_nodeDao.findByForeignId("linkd", "stc.asw01");
        OnmsNode samasw01 = this.m_nodeDao.findByForeignId("linkd", "sam.asw01");
        OnmsNode asw01 = this.m_nodeDao.findByForeignId("linkd", "asw01");
        this.m_linkdConfig.getConfiguration().setUseBridgeDiscovery(Boolean.valueOf(true));
        this.m_linkdConfig.getConfiguration().setUseCdpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseOspfDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseLldpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseIsisDiscovery(Boolean.valueOf(false));
        Assert.assertTrue((!this.m_linkdConfig.useLldpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useCdpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useOspfDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkdConfig.useBridgeDiscovery());
        Assert.assertTrue((!this.m_linkdConfig.useIsisDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(asw01.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(samasw01.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(stcasw01.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_bridgeElementDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeStpLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(asw01.getId().intValue()));
        Assert.assertEquals((long)1L, (long)this.m_bridgeElementDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeStpLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.countAll());
        this.m_linkd.runTopologyDiscovery();
        this.checkAsw01Topology(asw01);
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(samasw01.getId().intValue()));
        this.m_linkd.runTopologyDiscovery();
        this.checkAsw01SamAsw01Topology(asw01, samasw01);
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(stcasw01.getId().intValue()));
        this.m_linkd.runTopologyDiscovery();
        this.checkTopology(asw01, stcasw01, samasw01);
    }

    private void checkAsw01Topology(OnmsNode asw01) {
        BridgeMacLink link;
        List links;
        Assert.assertEquals((long)1L, (long)this.m_bridgeElementDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeStpLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        int count = 0;
        for (String mac : asw01port2forwarders) {
            links = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)1L, (long)links.size());
            link = (BridgeMacLink)links.iterator().next();
            Assert.assertEquals((Object)asw01.getId(), (Object)link.getNode().getId());
            Assert.assertEquals((long)2L, (long)link.getBridgePort().intValue());
            Assert.assertEquals((long)1002L, (long)link.getBridgePortIfIndex().intValue());
            Assert.assertEquals((Object)mac, (Object)link.getMacAddress());
            Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
        }
        count += asw01port2forwarders.length;
        for (String mac : stcport11forwarders) {
            links = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)0L, (long)links.size());
        }
        for (String mac : asw01port1) {
            links = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)1L, (long)links.size());
            link = (BridgeMacLink)links.iterator().next();
            Assert.assertEquals((Object)asw01.getId(), (Object)link.getNode().getId());
            Assert.assertEquals((long)1L, (long)link.getBridgePort().intValue());
            Assert.assertEquals((long)1001L, (long)link.getBridgePortIfIndex().intValue());
            Assert.assertEquals((Object)mac, (Object)link.getMacAddress());
            Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
        }
        count += asw01port1.length;
        for (String mac : asw01port3) {
            links = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)1L, (long)links.size());
            link = (BridgeMacLink)links.iterator().next();
            Assert.assertEquals((Object)asw01.getId(), (Object)link.getNode().getId());
            Assert.assertEquals((long)3L, (long)link.getBridgePort().intValue());
            Assert.assertEquals((long)1003L, (long)link.getBridgePortIfIndex().intValue());
            Assert.assertEquals((Object)mac, (Object)link.getMacAddress());
            Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
        }
        count += asw01port3.length;
        for (String mac : asw01port4) {
            links = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)1L, (long)links.size());
            link = (BridgeMacLink)links.iterator().next();
            Assert.assertEquals((Object)asw01.getId(), (Object)link.getNode().getId());
            Assert.assertEquals((long)4L, (long)link.getBridgePort().intValue());
            Assert.assertEquals((long)1004L, (long)link.getBridgePortIfIndex().intValue());
            Assert.assertEquals((Object)mac, (Object)link.getMacAddress());
            Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
        }
        count += asw01port4.length;
        for (String mac : samport23) {
            links = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)1L, (long)links.size());
            link = (BridgeMacLink)links.iterator().next();
            Assert.assertEquals((Object)asw01.getId(), (Object)link.getNode().getId());
            Assert.assertEquals((long)2L, (long)link.getBridgePort().intValue());
            Assert.assertEquals((long)1002L, (long)link.getBridgePortIfIndex().intValue());
            Assert.assertEquals((Object)mac, (Object)link.getMacAddress());
            Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
        }
        count += samport23.length;
        for (String mac : stcport19) {
            links = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)1L, (long)links.size());
            link = (BridgeMacLink)links.iterator().next();
            Assert.assertEquals((Object)asw01.getId(), (Object)link.getNode().getId());
            Assert.assertEquals((long)2L, (long)link.getBridgePort().intValue());
            Assert.assertEquals((long)1002L, (long)link.getBridgePortIfIndex().intValue());
            Assert.assertEquals((Object)mac, (Object)link.getMacAddress());
            Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
        }
        count += stcport19.length;
        for (String mac : stcport24) {
            links = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)1L, (long)links.size());
            link = (BridgeMacLink)links.iterator().next();
            Assert.assertEquals((Object)asw01.getId(), (Object)link.getNode().getId());
            Assert.assertEquals((long)2L, (long)link.getBridgePort().intValue());
            Assert.assertEquals((long)1002L, (long)link.getBridgePortIfIndex().intValue());
            Assert.assertEquals((Object)mac, (Object)link.getMacAddress());
            Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
        }
        count += stcport24.length;
        for (String mac : stcsamshared) {
            links = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)0L, (long)links.size());
        }
        for (String mac : samasw01shared) {
            links = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)1L, (long)links.size());
            link = (BridgeMacLink)links.iterator().next();
            Assert.assertEquals((Object)asw01.getId(), (Object)link.getNode().getId());
            Assert.assertEquals((long)2L, (long)link.getBridgePort().intValue());
            Assert.assertEquals((long)1002L, (long)link.getBridgePortIfIndex().intValue());
            Assert.assertEquals((Object)mac, (Object)link.getMacAddress());
            Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
        }
        count += samasw01shared.length;
        for (String mac : stcasw01shared) {
            links = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)1L, (long)links.size());
            link = (BridgeMacLink)links.iterator().next();
            Assert.assertEquals((Object)asw01.getId(), (Object)link.getNode().getId());
            Assert.assertEquals((long)2L, (long)link.getBridgePort().intValue());
            Assert.assertEquals((long)1002L, (long)link.getBridgePortIfIndex().intValue());
            Assert.assertEquals((Object)mac, (Object)link.getMacAddress());
            Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
        }
        count += stcasw01shared.length;
        for (String mac : shared) {
            links = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)1L, (long)links.size());
            link = (BridgeMacLink)links.iterator().next();
            Assert.assertEquals((Object)asw01.getId(), (Object)link.getNode().getId());
            Assert.assertEquals((long)2L, (long)link.getBridgePort().intValue());
            Assert.assertEquals((long)1002L, (long)link.getBridgePortIfIndex().intValue());
            Assert.assertEquals((Object)mac, (Object)link.getMacAddress());
            Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
        }
        Assert.assertEquals((long)(count += shared.length), (long)this.m_bridgeMacLinkDao.countAll());
    }

    private void checkAsw01SamAsw01Topology(OnmsNode asw01, OnmsNode samasw01) {
        BridgeMacLink link;
        List links;
        Assert.assertEquals((long)2L, (long)this.m_bridgeElementDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeStpLinkDao.countAll());
        Assert.assertEquals((long)1L, (long)this.m_bridgeBridgeLinkDao.countAll());
        for (BridgeBridgeLink bblink : this.m_bridgeBridgeLinkDao.findAll()) {
            Assert.assertNotNull((Object)bblink);
            Assert.assertEquals((Object)asw01.getId(), (Object)bblink.getDesignatedNode().getId());
            Assert.assertEquals((long)2L, (long)bblink.getDesignatedPort().intValue());
            Assert.assertEquals((long)1002L, (long)bblink.getDesignatedPortIfIndex().intValue());
            Assert.assertEquals((Object)samasw01.getId(), (Object)bblink.getNode().getId());
            Assert.assertEquals((long)3L, (long)bblink.getBridgePort().intValue());
            Assert.assertEquals((long)3L, (long)bblink.getBridgePortIfIndex().intValue());
        }
        int count = 0;
        for (String mac : asw01port2forwarders) {
            links = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)1L, (long)links.size());
            link = (BridgeMacLink)links.iterator().next();
            Assert.assertEquals((Object)asw01.getId(), (Object)link.getNode().getId());
            Assert.assertEquals((long)2L, (long)link.getBridgePort().intValue());
            Assert.assertEquals((long)1002L, (long)link.getBridgePortIfIndex().intValue());
            Assert.assertEquals((Object)mac, (Object)link.getMacAddress());
            Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_FORWARDER, (Object)link.getLinkType());
        }
        count += asw01port2forwarders.length;
        for (String mac : stcport11forwarders) {
            links = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)0L, (long)links.size());
        }
        for (String mac : asw01port1) {
            links = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)1L, (long)links.size());
            link = (BridgeMacLink)links.iterator().next();
            Assert.assertEquals((Object)asw01.getId(), (Object)link.getNode().getId());
            Assert.assertEquals((long)1L, (long)link.getBridgePort().intValue());
            Assert.assertEquals((long)1001L, (long)link.getBridgePortIfIndex().intValue());
            Assert.assertEquals((Object)mac, (Object)link.getMacAddress());
            Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
        }
        count += asw01port1.length;
        for (String mac : asw01port3) {
            links = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)1L, (long)links.size());
            link = (BridgeMacLink)links.iterator().next();
            Assert.assertEquals((Object)asw01.getId(), (Object)link.getNode().getId());
            Assert.assertEquals((long)3L, (long)link.getBridgePort().intValue());
            Assert.assertEquals((long)1003L, (long)link.getBridgePortIfIndex().intValue());
            Assert.assertEquals((Object)mac, (Object)link.getMacAddress());
            Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
        }
        count += asw01port3.length;
        for (String mac : asw01port4) {
            links = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)1L, (long)links.size());
            link = (BridgeMacLink)links.iterator().next();
            Assert.assertEquals((Object)asw01.getId(), (Object)link.getNode().getId());
            Assert.assertEquals((long)4L, (long)link.getBridgePort().intValue());
            Assert.assertEquals((long)1004L, (long)link.getBridgePortIfIndex().intValue());
            Assert.assertEquals((Object)mac, (Object)link.getMacAddress());
            Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
        }
        count += asw01port4.length;
        for (String mac : samport23) {
            links = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)1L, (long)links.size());
            link = (BridgeMacLink)links.iterator().next();
            Assert.assertEquals((Object)samasw01.getId(), (Object)link.getNode().getId());
            Assert.assertEquals((long)23L, (long)link.getBridgePort().intValue());
            Assert.assertEquals((long)23L, (long)link.getBridgePortIfIndex().intValue());
            Assert.assertEquals((Object)mac, (Object)link.getMacAddress());
            Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
        }
        count += samport23.length;
        for (String mac : stcport19) {
            links = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)1L, (long)links.size());
            for (BridgeMacLink link2 : links) {
                Assert.assertEquals((Object)asw01.getId(), (Object)link2.getNode().getId());
                Assert.assertEquals((Object)mac, (Object)link2.getMacAddress());
                Assert.assertEquals((long)2L, (long)link2.getBridgePort().intValue());
                Assert.assertEquals((long)1002L, (long)link2.getBridgePortIfIndex().intValue());
                Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link2.getLinkType());
            }
        }
        count += stcport19.length;
        for (String mac : stcport24) {
            links = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)1L, (long)links.size());
            for (BridgeMacLink link2 : links) {
                Assert.assertEquals((Object)asw01.getId(), (Object)link2.getNode().getId());
                Assert.assertEquals((Object)mac, (Object)link2.getMacAddress());
                Assert.assertEquals((long)2L, (long)link2.getBridgePort().intValue());
                Assert.assertEquals((long)1002L, (long)link2.getBridgePortIfIndex().intValue());
                Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_FORWARDER, (Object)link2.getLinkType());
            }
        }
        count += stcport24.length;
        for (String mac : samasw01shared) {
            links = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)1L, (long)links.size());
            for (BridgeMacLink link2 : links) {
                Assert.assertEquals((Object)asw01.getId(), (Object)link2.getNode().getId());
                Assert.assertEquals((Object)mac, (Object)link2.getMacAddress());
                Assert.assertEquals((long)2L, (long)link2.getBridgePort().intValue());
                Assert.assertEquals((long)1002L, (long)link2.getBridgePortIfIndex().intValue());
                Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link2.getLinkType());
            }
        }
        count += samasw01shared.length;
        for (String mac : stcasw01shared) {
            links = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)1L, (long)links.size());
            for (BridgeMacLink link2 : links) {
                Assert.assertEquals((Object)asw01.getId(), (Object)link2.getNode().getId());
                Assert.assertEquals((Object)mac, (Object)link2.getMacAddress());
                Assert.assertEquals((long)2L, (long)link2.getBridgePort().intValue());
                Assert.assertEquals((long)1002L, (long)link2.getBridgePortIfIndex().intValue());
                Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_FORWARDER, (Object)link2.getLinkType());
            }
        }
        count += stcasw01shared.length;
        for (String mac : stcsamshared) {
            links = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)1L, (long)links.size());
            for (BridgeMacLink link2 : links) {
                Assert.assertEquals((Object)samasw01.getId(), (Object)link2.getNode().getId());
                Assert.assertEquals((Object)mac, (Object)link2.getMacAddress());
                Assert.assertEquals((long)3L, (long)link2.getBridgePort().intValue());
                Assert.assertEquals((long)3L, (long)link2.getBridgePortIfIndex().intValue());
                Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_FORWARDER, (Object)link2.getLinkType());
            }
        }
        count += stcsamshared.length;
        for (String mac : shared) {
            links = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)1L, (long)links.size());
            for (BridgeMacLink link2 : links) {
                Assert.assertEquals((Object)asw01.getId(), (Object)link2.getNode().getId());
                Assert.assertEquals((Object)mac, (Object)link2.getMacAddress());
                Assert.assertEquals((Object)asw01.getId(), (Object)link2.getNode().getId());
                Assert.assertEquals((long)2L, (long)link2.getBridgePort().intValue());
                Assert.assertEquals((long)1002L, (long)link2.getBridgePortIfIndex().intValue());
                Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link2.getLinkType());
            }
        }
        Assert.assertEquals((long)(count += shared.length), (long)this.m_bridgeMacLinkDao.countAll());
    }

    private void checkTopology(OnmsNode asw01, OnmsNode stcasw01, OnmsNode samasw01) {
        BridgeMacLink link;
        List links;
        Assert.assertEquals((long)3L, (long)this.m_bridgeElementDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeStpLinkDao.countAll());
        Assert.assertEquals((long)2L, (long)this.m_bridgeBridgeLinkDao.countAll());
        for (BridgeBridgeLink bblink : this.m_bridgeBridgeLinkDao.findAll()) {
            Assert.assertNotNull((Object)bblink);
            Assert.assertEquals((Object)asw01.getId(), (Object)bblink.getDesignatedNode().getId());
            Assert.assertEquals((long)2L, (long)bblink.getDesignatedPort().intValue());
            Assert.assertEquals((long)1002L, (long)bblink.getDesignatedPortIfIndex().intValue());
            if (stcasw01.getId().intValue() == bblink.getNode().getId().intValue()) {
                Assert.assertEquals((long)11L, (long)bblink.getBridgePort().intValue());
                Assert.assertEquals((long)1011L, (long)bblink.getBridgePortIfIndex().intValue());
                continue;
            }
            if (samasw01.getId().intValue() == bblink.getNode().getId().intValue()) {
                Assert.assertEquals((long)3L, (long)bblink.getBridgePort().intValue());
                Assert.assertEquals((long)3L, (long)bblink.getBridgePortIfIndex().intValue());
                continue;
            }
            Assert.assertTrue((boolean)false);
        }
        int count = 0;
        for (String mac : asw01port2forwarders) {
            links = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)1L, (long)links.size());
            for (BridgeMacLink link2 : links) {
                Assert.assertEquals((Object)asw01.getId(), (Object)link2.getNode().getId());
                Assert.assertEquals((Object)mac, (Object)link2.getMacAddress());
                Assert.assertEquals((long)2L, (long)link2.getBridgePort().intValue());
                Assert.assertEquals((long)1002L, (long)link2.getBridgePortIfIndex().intValue());
                Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_FORWARDER, (Object)link2.getLinkType());
            }
        }
        count += asw01port2forwarders.length;
        for (String mac : stcport11forwarders) {
            links = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)1L, (long)links.size());
            for (BridgeMacLink link2 : links) {
                Assert.assertEquals((Object)stcasw01.getId(), (Object)link2.getNode().getId());
                Assert.assertEquals((Object)mac, (Object)link2.getMacAddress());
                Assert.assertEquals((long)11L, (long)link2.getBridgePort().intValue());
                Assert.assertEquals((long)1011L, (long)link2.getBridgePortIfIndex().intValue());
                Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_FORWARDER, (Object)link2.getLinkType());
            }
        }
        count += stcport11forwarders.length;
        for (String mac : asw01port1) {
            links = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)1L, (long)links.size());
            link = (BridgeMacLink)links.iterator().next();
            Assert.assertEquals((Object)asw01.getId(), (Object)link.getNode().getId());
            Assert.assertEquals((long)1L, (long)link.getBridgePort().intValue());
            Assert.assertEquals((long)1001L, (long)link.getBridgePortIfIndex().intValue());
            Assert.assertEquals((Object)mac, (Object)link.getMacAddress());
            Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
        }
        count += asw01port1.length;
        for (String mac : asw01port3) {
            links = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)1L, (long)links.size());
            link = (BridgeMacLink)links.iterator().next();
            Assert.assertEquals((Object)asw01.getId(), (Object)link.getNode().getId());
            Assert.assertEquals((long)3L, (long)link.getBridgePort().intValue());
            Assert.assertEquals((long)1003L, (long)link.getBridgePortIfIndex().intValue());
            Assert.assertEquals((Object)mac, (Object)link.getMacAddress());
            Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
        }
        count += asw01port3.length;
        for (String mac : asw01port4) {
            links = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)1L, (long)links.size());
            link = (BridgeMacLink)links.iterator().next();
            Assert.assertEquals((Object)asw01.getId(), (Object)link.getNode().getId());
            Assert.assertEquals((long)4L, (long)link.getBridgePort().intValue());
            Assert.assertEquals((long)1004L, (long)link.getBridgePortIfIndex().intValue());
            Assert.assertEquals((Object)mac, (Object)link.getMacAddress());
            Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
        }
        count += asw01port4.length;
        for (String mac : samport23) {
            links = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)1L, (long)links.size());
            link = (BridgeMacLink)links.iterator().next();
            Assert.assertEquals((Object)samasw01.getId(), (Object)link.getNode().getId());
            Assert.assertEquals((long)23L, (long)link.getBridgePort().intValue());
            Assert.assertEquals((long)23L, (long)link.getBridgePortIfIndex().intValue());
            Assert.assertEquals((Object)mac, (Object)link.getMacAddress());
            Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
        }
        count += samport23.length;
        for (String mac : stcport19) {
            links = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)1L, (long)links.size());
            link = (BridgeMacLink)links.iterator().next();
            Assert.assertEquals((Object)stcasw01.getId(), (Object)link.getNode().getId());
            Assert.assertEquals((long)19L, (long)link.getBridgePort().intValue());
            Assert.assertEquals((long)1019L, (long)link.getBridgePortIfIndex().intValue());
            Assert.assertEquals((Object)mac, (Object)link.getMacAddress());
            Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
        }
        count += stcport19.length;
        for (String mac : stcport24) {
            links = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)1L, (long)links.size());
            link = (BridgeMacLink)links.iterator().next();
            Assert.assertEquals((Object)stcasw01.getId(), (Object)link.getNode().getId());
            Assert.assertEquals((long)24L, (long)link.getBridgePort().intValue());
            Assert.assertEquals((long)1024L, (long)link.getBridgePortIfIndex().intValue());
            Assert.assertEquals((Object)mac, (Object)link.getMacAddress());
            Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
        }
        count += stcport24.length;
        for (String mac : samasw01shared) {
            links = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            for (BridgeMacLink link2 : links) {
                Assert.assertEquals((Object)mac, (Object)link2.getMacAddress());
                Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_FORWARDER, (Object)link2.getLinkType());
                if (link2.getNode().getId() == samasw01.getId()) {
                    Assert.assertEquals((long)3L, (long)link2.getBridgePort().intValue());
                    Assert.assertEquals((long)3L, (long)link2.getBridgePortIfIndex().intValue());
                    continue;
                }
                if (link2.getNode().getId() == asw01.getId()) {
                    Assert.assertEquals((long)2L, (long)link2.getBridgePort().intValue());
                    Assert.assertEquals((long)1002L, (long)link2.getBridgePortIfIndex().intValue());
                    continue;
                }
                Assert.assertEquals((long)0L, (long)1L);
            }
        }
        count += samasw01shared.length;
        count += samasw01shared.length;
        for (String mac : stcasw01shared) {
            links = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)2L, (long)links.size());
            for (BridgeMacLink link2 : links) {
                Assert.assertEquals((Object)mac, (Object)link2.getMacAddress());
                Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_FORWARDER, (Object)link2.getLinkType());
                if (link2.getNode().getId() == stcasw01.getId()) {
                    Assert.assertEquals((long)11L, (long)link2.getBridgePort().intValue());
                    Assert.assertEquals((long)1011L, (long)link2.getBridgePortIfIndex().intValue());
                    continue;
                }
                if (link2.getNode().getId() == asw01.getId()) {
                    Assert.assertEquals((long)2L, (long)link2.getBridgePort().intValue());
                    Assert.assertEquals((long)1002L, (long)link2.getBridgePortIfIndex().intValue());
                    continue;
                }
                Assert.assertEquals((long)0L, (long)1L);
            }
        }
        count += stcasw01shared.length;
        count += stcasw01shared.length;
        for (String mac : stcsamshared) {
            links = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)2L, (long)links.size());
            for (BridgeMacLink link2 : links) {
                Assert.assertEquals((Object)mac, (Object)link2.getMacAddress());
                Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_FORWARDER, (Object)link2.getLinkType());
                if (link2.getNode().getId() == stcasw01.getId()) {
                    Assert.assertEquals((long)11L, (long)link2.getBridgePort().intValue());
                    Assert.assertEquals((long)1011L, (long)link2.getBridgePortIfIndex().intValue());
                    continue;
                }
                if (link2.getNode().getId() == samasw01.getId()) {
                    Assert.assertEquals((long)3L, (long)link2.getBridgePort().intValue());
                    Assert.assertEquals((long)3L, (long)link2.getBridgePortIfIndex().intValue());
                    continue;
                }
                Assert.assertEquals((long)0L, (long)1L);
            }
        }
        count += stcsamshared.length;
        count += stcsamshared.length;
        for (String mac : shared) {
            links = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)1L, (long)links.size());
            for (BridgeMacLink link2 : links) {
                Assert.assertEquals((Object)asw01.getId(), (Object)link2.getNode().getId());
                Assert.assertEquals((Object)mac, (Object)link2.getMacAddress());
                Assert.assertEquals((long)2L, (long)link2.getBridgePort().intValue());
                Assert.assertEquals((long)1002L, (long)link2.getBridgePortIfIndex().intValue());
                Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link2.getLinkType());
            }
        }
        Assert.assertEquals((long)(count += shared.length), (long)this.m_bridgeMacLinkDao.countAll());
    }
}

