/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.test.MockLogAppender;
import org.opennms.netmgt.config.EnhancedLinkdConfig;
import org.opennms.netmgt.config.EnhancedLinkdConfigManager;
import org.opennms.netmgt.config.enlinkd.EnlinkdConfiguration;
import org.opennms.netmgt.enlinkd.DiscoveryBridgeTopology;
import org.opennms.netmgt.enlinkd.EnLinkdTestHelper;
import org.opennms.netmgt.enlinkd.EnhancedLinkd;
import org.opennms.netmgt.model.BridgeElement;
import org.opennms.netmgt.model.BridgeMacLink;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.topology.Bridge;
import org.opennms.netmgt.model.topology.BridgeForwardingTable;
import org.opennms.netmgt.model.topology.BridgeForwardingTableEntry;
import org.opennms.netmgt.model.topology.BridgePortWithMacs;
import org.opennms.netmgt.model.topology.BridgeTopologyException;
import org.opennms.netmgt.model.topology.BroadcastDomain;
import org.opennms.netmgt.model.topology.SharedSegment;

public class BroadcastDomainTest
extends EnLinkdTestHelper {
    EnhancedLinkd linkd;

    @Before
    public void setUp() throws Exception {
        Properties p = new Properties();
        p.setProperty("log4j.logger.org.opennms.netmgt.model.topology", "DEBUG");
        MockLogAppender.setupLogging((Properties)p);
        this.linkd = new EnhancedLinkd();
        EnhancedLinkdConfigManager config = new EnhancedLinkdConfigManager(){

            public void save() throws IOException {
            }

            public void reload() throws IOException {
                m_config = new EnlinkdConfiguration();
                m_config.setInitialSleepTime(Long.valueOf(1000L));
                m_config.setRescanInterval(Long.valueOf(10000L));
            }

            protected void saveXml(String xml) throws IOException {
            }
        };
        config.reload();
        this.linkd.setLinkdConfig((EnhancedLinkdConfig)config);
    }

    @Test
    public void testOneBridgeOnePortOneMac() throws Exception {
        EnLinkdTestHelper.OneBridgeOnePortOneMacTopology topology = new EnLinkdTestHelper.OneBridgeOnePortOneMacTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeAId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbt = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbt.addUpdatedBFT(topology.nodeAId, topology.bftA);
        ndbt.calculate();
        Assert.assertEquals((long)topology.nodeAId.intValue(), (long)domain.getRootBridge().getNodeId().intValue());
        topology.check(ndbt.getDomain());
    }

    @Test
    public void testOneBridgeMoreMacOnePort() throws Exception {
        EnLinkdTestHelper.OneBridgeMoreMacOnePortTopology topology = new EnLinkdTestHelper.OneBridgeMoreMacOnePortTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeAId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbt = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbt.addUpdatedBFT(topology.nodeAId, topology.bftA);
        ndbt.calculate();
        Assert.assertEquals((long)topology.nodeAId.intValue(), (long)domain.getRootBridge().getNodeId().intValue());
        topology.check(ndbt.getDomain());
        DiscoveryBridgeTopology ndbts = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbts.addUpdatedBFT(topology.nodeAId, topology.bftA);
        ndbts.calculate();
        Assert.assertEquals((long)topology.nodeAId.intValue(), (long)domain.getRootBridge().getNodeId().intValue());
        topology.check(ndbts.getDomain());
    }

    @Test
    public void testOneBridgeComplete() throws Exception {
        EnLinkdTestHelper.OneBridgeCompleteTopology topology = new EnLinkdTestHelper.OneBridgeCompleteTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeAId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbt = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbt.addUpdatedBFT(topology.nodeAId, topology.bftA);
        ndbt.calculate();
        Assert.assertEquals((long)topology.nodeAId.intValue(), (long)domain.getRootBridge().getNodeId().intValue());
        topology.check(ndbt.getDomain());
    }

    @Test
    public void testTwoConnectedBridge() throws Exception {
        EnLinkdTestHelper.TwoConnectedBridgeTopology topology = new EnLinkdTestHelper.TwoConnectedBridgeTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeAId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeBId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbt = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbt.addUpdatedBFT(topology.nodeAId, topology.bftA);
        ndbt.addUpdatedBFT(topology.nodeBId, topology.bftB);
        ndbt.calculate();
        Assert.assertEquals((long)topology.nodeAId.intValue(), (long)domain.getRootBridge().getNodeId().intValue());
        topology.check(ndbt.getDomain(), false);
        BroadcastDomain.hierarchySetUp((BroadcastDomain)domain, (Bridge)domain.getBridge(topology.nodeBId.intValue()));
        Assert.assertEquals((long)topology.nodeBId.intValue(), (long)domain.getRootBridge().getNodeId().intValue());
        topology.check(ndbt.getDomain(), true);
    }

    @Test
    public void testPrintTopologyFromLevel() throws Exception {
        EnLinkdTestHelper.TwoMergeBridgeTopology topology = new EnLinkdTestHelper.TwoMergeBridgeTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeAId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeBId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbt = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbt.addUpdatedBFT(topology.nodeAId, topology.bftA);
        ndbt.addUpdatedBFT(topology.nodeBId, topology.bftB);
        ndbt.calculate();
        domain.printTopologyFromLevel((Set)Sets.newHashSet((Object[])new Integer[]{topology.nodeAId, topology.nodeBId, 3333}), 5);
    }

    @Test
    public void testTwoSwitchWithOnlyOnePortcondition3() throws Exception {
        Integer portAB = 16;
        Integer portBA = 24;
        String mac1 = "000daaaa0001";
        String mac2 = "000daaaa0002";
        String maca = "000daaaa000a";
        String macb = "000daaaa000b";
        Integer nodeAId = 1100011;
        Integer nodeBId = 2200022;
        OnmsNode nodeA = new OnmsNode();
        OnmsNode nodeB = new OnmsNode();
        BridgeElement elementA = new BridgeElement();
        BridgeElement elementB = new BridgeElement();
        HashSet<BridgeForwardingTableEntry> bftA = new HashSet<BridgeForwardingTableEntry>();
        HashSet<BridgeForwardingTableEntry> bftB = new HashSet<BridgeForwardingTableEntry>();
        ArrayList<BridgeElement> elemlist = new ArrayList<BridgeElement>();
        nodeA.setId(nodeAId);
        elementA.setNode(nodeA);
        elementA.setBaseBridgeAddress(maca);
        elemlist.add(elementA);
        nodeB.setId(nodeBId);
        elementB.setNode(nodeB);
        elementB.setBaseBridgeAddress(macb);
        elemlist.add(elementB);
        bftA.add(this.addBridgeForwardingTableEntry(nodeA, portAB, mac1));
        bftA.add(this.addBridgeForwardingTableEntry(nodeA, portAB, mac2));
        bftA.add(this.addBridgeForwardingTableEntry(nodeA, portAB, maca));
        bftB.add(this.addBridgeForwardingTableEntry(nodeB, portBA, mac1));
        bftB.add(this.addBridgeForwardingTableEntry(nodeB, portBA, mac2));
        bftB.add(this.addBridgeForwardingTableEntry(nodeB, portBA, macb));
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)nodeAId);
        Bridge.create((BroadcastDomain)domain, (Integer)nodeBId);
        this.setBridgeElements(domain, elemlist);
        DiscoveryBridgeTopology ndbt = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbt.addUpdatedBFT(nodeAId, bftA);
        ndbt.addUpdatedBFT(nodeBId, bftB);
        ndbt.calculate();
        Assert.assertEquals((long)1L, (long)domain.getSharedSegments().size());
        SharedSegment shared = (SharedSegment)domain.getSharedSegments().iterator().next();
        Assert.assertEquals((long)2L, (long)shared.getBridgePortsOnSegment().size());
        Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
        Assert.assertTrue((boolean)shared.containsMac(mac1));
        Assert.assertTrue((boolean)shared.containsMac(mac2));
        Assert.assertEquals((long)0L, (long)domain.getForwarding().size());
    }

    @Test
    public void testTwoSwitchWithOnlyOnePortCondition2() throws Exception {
        Integer portAB = 16;
        Integer portBA = 24;
        String mac1 = "000daaaa0001";
        String mac2 = "000daaaa0002";
        String maca = "000daaaa000a";
        String macb = "000daaaa000b";
        Integer nodeAId = 1100011;
        Integer nodeBId = 2200022;
        OnmsNode nodeA = new OnmsNode();
        OnmsNode nodeB = new OnmsNode();
        BridgeElement elementA = new BridgeElement();
        BridgeElement elementB = new BridgeElement();
        HashSet<BridgeForwardingTableEntry> bftA = new HashSet<BridgeForwardingTableEntry>();
        HashSet<BridgeForwardingTableEntry> bftB = new HashSet<BridgeForwardingTableEntry>();
        ArrayList<BridgeElement> elemlist = new ArrayList<BridgeElement>();
        nodeA.setId(nodeAId);
        elementA.setNode(nodeA);
        elementA.setBaseBridgeAddress(maca);
        elemlist.add(elementA);
        nodeB.setId(nodeBId);
        elementB.setNode(nodeB);
        elementB.setBaseBridgeAddress(macb);
        elemlist.add(elementB);
        bftA.add(this.addBridgeForwardingTableEntry(nodeA, portAB, mac1));
        bftA.add(this.addBridgeForwardingTableEntry(nodeA, portAB, mac2));
        bftA.add(this.addBridgeForwardingTableEntry(nodeA, portAB, maca));
        bftB.add(this.addBridgeForwardingTableEntry(nodeB, portBA, mac1));
        bftB.add(this.addBridgeForwardingTableEntry(nodeB, portBA, mac2));
        bftB.add(this.addBridgeForwardingTableEntry(nodeB, portBA, maca));
        bftB.add(this.addBridgeForwardingTableEntry(nodeB, portBA, macb));
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)nodeAId);
        Bridge.create((BroadcastDomain)domain, (Integer)nodeBId);
        this.setBridgeElements(domain, elemlist);
        DiscoveryBridgeTopology ndbt = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbt.addUpdatedBFT(nodeAId, bftA);
        ndbt.addUpdatedBFT(nodeBId, bftB);
        ndbt.calculate();
        Assert.assertEquals((long)1L, (long)domain.getSharedSegments().size());
        SharedSegment shared = (SharedSegment)domain.getSharedSegments().iterator().next();
        Assert.assertEquals((long)2L, (long)shared.getBridgePortsOnSegment().size());
        Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
        Assert.assertTrue((boolean)shared.containsMac(mac1));
        Assert.assertTrue((boolean)shared.containsMac(mac2));
        Assert.assertEquals((long)1L, (long)domain.getForwarding().size());
        Assert.assertEquals((long)1L, (long)domain.getForwarders(nodeBId).size());
        BridgePortWithMacs forwarder = (BridgePortWithMacs)domain.getForwarders(nodeBId).iterator().next();
        Assert.assertEquals((long)1L, (long)forwarder.getMacs().size());
        Assert.assertEquals((Object)maca, forwarder.getMacs().iterator().next());
        Assert.assertEquals((Object)portBA, (Object)forwarder.getPort().getBridgePort());
        Assert.assertEquals((Object)nodeBId, (Object)forwarder.getPort().getNodeId());
    }

    @Test
    public void testTwoSwitchWithOnlyOnePortCondition1() throws Exception {
        Integer portAB = 16;
        Integer portBA = 24;
        String mac1 = "000daaaa0001";
        String mac2 = "000daaaa0002";
        String maca = "000daaaa000a";
        String macb = "000daaaa000b";
        Integer nodeAId = 1100011;
        Integer nodeBId = 2200022;
        OnmsNode nodeA = new OnmsNode();
        OnmsNode nodeB = new OnmsNode();
        BridgeElement elementA = new BridgeElement();
        BridgeElement elementB = new BridgeElement();
        HashSet<BridgeForwardingTableEntry> bftA = new HashSet<BridgeForwardingTableEntry>();
        HashSet<BridgeForwardingTableEntry> bftB = new HashSet<BridgeForwardingTableEntry>();
        ArrayList<BridgeElement> elemlist = new ArrayList<BridgeElement>();
        nodeA.setId(nodeAId);
        elementA.setNode(nodeA);
        elementA.setBaseBridgeAddress(maca);
        elemlist.add(elementA);
        nodeB.setId(nodeBId);
        elementB.setNode(nodeB);
        elementB.setBaseBridgeAddress(macb);
        elemlist.add(elementB);
        bftA.add(this.addBridgeForwardingTableEntry(nodeA, portAB, mac1));
        bftA.add(this.addBridgeForwardingTableEntry(nodeA, portAB, mac2));
        bftA.add(this.addBridgeForwardingTableEntry(nodeA, portAB, maca));
        bftA.add(this.addBridgeForwardingTableEntry(nodeA, portAB, macb));
        bftB.add(this.addBridgeForwardingTableEntry(nodeB, portBA, mac1));
        bftB.add(this.addBridgeForwardingTableEntry(nodeB, portBA, mac2));
        bftB.add(this.addBridgeForwardingTableEntry(nodeB, portBA, macb));
        bftB.add(this.addBridgeForwardingTableEntry(nodeB, portBA, maca));
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)nodeAId);
        Bridge.create((BroadcastDomain)domain, (Integer)nodeBId);
        this.setBridgeElements(domain, elemlist);
        DiscoveryBridgeTopology ndbt = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbt.addUpdatedBFT(nodeAId, bftA);
        ndbt.addUpdatedBFT(nodeBId, bftB);
        ndbt.calculate();
        Assert.assertEquals((long)1L, (long)domain.getSharedSegments().size());
        SharedSegment shared = (SharedSegment)domain.getSharedSegments().iterator().next();
        Assert.assertEquals((long)2L, (long)shared.getBridgePortsOnSegment().size());
        Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
        Assert.assertTrue((boolean)shared.containsMac(mac1));
        Assert.assertTrue((boolean)shared.containsMac(mac2));
        Assert.assertEquals((long)2L, (long)domain.getForwarding().size());
        Assert.assertEquals((long)1L, (long)domain.getForwarders(nodeAId).size());
        Assert.assertEquals((long)1L, (long)domain.getForwarders(nodeBId).size());
        BridgePortWithMacs forwarderA = (BridgePortWithMacs)domain.getForwarders(nodeAId).iterator().next();
        BridgePortWithMacs forwarderB = (BridgePortWithMacs)domain.getForwarders(nodeBId).iterator().next();
        Assert.assertEquals((long)1L, (long)forwarderA.getMacs().size());
        Assert.assertEquals((Object)macb, forwarderA.getMacs().iterator().next());
        Assert.assertEquals((Object)portAB, (Object)forwarderA.getPort().getBridgePort());
        Assert.assertEquals((Object)nodeAId, (Object)forwarderA.getPort().getNodeId());
        Assert.assertEquals((long)1L, (long)forwarderB.getMacs().size());
        Assert.assertEquals((Object)maca, forwarderB.getMacs().iterator().next());
        Assert.assertEquals((Object)portBA, (Object)forwarderB.getPort().getBridgePort());
        Assert.assertEquals((Object)nodeBId, (Object)forwarderB.getPort().getNodeId());
    }

    @Test
    public void testTwoMergeBridge() throws Exception {
        EnLinkdTestHelper.TwoMergeBridgeTopology topology = new EnLinkdTestHelper.TwoMergeBridgeTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeAId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeBId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbt = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbt.addUpdatedBFT(topology.nodeAId, topology.bftA);
        ndbt.addUpdatedBFT(topology.nodeBId, topology.bftB);
        ndbt.calculate();
        Assert.assertEquals((long)topology.nodeAId.intValue(), (long)domain.getRootBridge().getNodeId().intValue());
        topology.check(ndbt.getDomain());
    }

    @Test
    public void testTwoBridgeWithBackbonePorts() throws BridgeTopologyException {
        EnLinkdTestHelper.TwoBridgeWithBackbonePortsTopology topology = new EnLinkdTestHelper.TwoBridgeWithBackbonePortsTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeAId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeBId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbt = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbt.addUpdatedBFT(topology.nodeAId, topology.bftA);
        ndbt.addUpdatedBFT(topology.nodeBId, topology.bftB);
        ndbt.calculate();
        Assert.assertEquals((long)topology.nodeAId.intValue(), (long)domain.getRootBridge().getNodeId().intValue());
        topology.check(ndbt.getDomain());
    }

    @Test
    public void testCleanTopology() throws BridgeTopologyException {
        EnLinkdTestHelper.TwoBridgeWithBackbonePortsTopology topology = new EnLinkdTestHelper.TwoBridgeWithBackbonePortsTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeAId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeBId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbt = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbt.addUpdatedBFT(topology.nodeAId, topology.bftA);
        ndbt.addUpdatedBFT(topology.nodeBId, topology.bftB);
        ndbt.calculate();
        BroadcastDomain.clearTopologyForBridge((BroadcastDomain)domain, (Integer)topology.nodeBId);
        Assert.assertEquals((long)topology.nodeAId.intValue(), (long)domain.getRootBridge().getNodeId().intValue());
        Assert.assertEquals((long)2L, (long)domain.getSharedSegments().size());
        Assert.assertEquals((long)5L, (long)domain.getMacsOnSegments().size());
        for (SharedSegment segment : domain.getSharedSegments()) {
            Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)segment).size());
            Assert.assertEquals((long)1L, (long)segment.getBridgeIdsOnSegment().size());
            Assert.assertEquals((long)topology.nodeAId.intValue(), (long)((Integer)segment.getBridgeIdsOnSegment().iterator().next()).intValue());
            if (segment.containsMac(topology.macA11) && segment.containsMac(topology.macA12)) {
                Assert.assertEquals((long)2L, (long)segment.getMacsOnSegment().size());
                Assert.assertEquals((long)2L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)segment).size());
                for (BridgeMacLink link : SharedSegment.getBridgeMacLinks((SharedSegment)segment)) {
                    Assert.assertEquals((long)topology.portA1.intValue(), (long)link.getBridgePort().intValue());
                }
                continue;
            }
            if (segment.containsMac(topology.macB21) && segment.containsMac(topology.macB22) && segment.containsMac(topology.macAB)) {
                Assert.assertEquals((long)3L, (long)segment.getMacsOnSegment().size());
                Assert.assertEquals((long)3L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)segment).size());
                for (BridgeMacLink link : SharedSegment.getBridgeMacLinks((SharedSegment)segment)) {
                    Assert.assertEquals((long)topology.portAB.intValue(), (long)link.getBridgePort().intValue());
                }
                continue;
            }
            Assert.assertEquals((Object)true, (Object)false);
        }
    }

    @Test
    public void testCleanTopologyRoot() throws BridgeTopologyException {
        EnLinkdTestHelper.TwoBridgeWithBackbonePortsTopology topology = new EnLinkdTestHelper.TwoBridgeWithBackbonePortsTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeAId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeBId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbt = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbt.addUpdatedBFT(topology.nodeAId, topology.bftA);
        ndbt.addUpdatedBFT(topology.nodeBId, topology.bftB);
        ndbt.calculate();
        BroadcastDomain.clearTopologyForBridge((BroadcastDomain)domain, (Integer)topology.nodeAId);
        Assert.assertEquals((long)5L, (long)domain.getMacsOnSegments().size());
        Assert.assertEquals((long)topology.nodeBId.intValue(), (long)domain.getRootBridge().getNodeId().intValue());
        Assert.assertEquals((long)2L, (long)domain.getSharedSegments().size());
        for (SharedSegment segment : domain.getSharedSegments()) {
            Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)segment).size());
            Assert.assertEquals((long)1L, (long)segment.getBridgeIdsOnSegment().size());
            Assert.assertEquals((long)topology.nodeBId.intValue(), (long)((Integer)segment.getBridgeIdsOnSegment().iterator().next()).intValue());
            if (segment.containsMac(topology.macA11) && segment.containsMac(topology.macA12) && segment.containsMac(topology.macAB)) {
                Assert.assertEquals((long)3L, (long)segment.getMacsOnSegment().size());
                Assert.assertEquals((long)3L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)segment).size());
                for (BridgeMacLink link : SharedSegment.getBridgeMacLinks((SharedSegment)segment)) {
                    Assert.assertEquals((long)topology.portBA.intValue(), (long)link.getBridgePort().intValue());
                }
                continue;
            }
            if (segment.containsMac(topology.macB21) && segment.containsMac(topology.macB22)) {
                Assert.assertEquals((long)2L, (long)segment.getMacsOnSegment().size());
                Assert.assertEquals((long)2L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)segment).size());
                for (BridgeMacLink link : SharedSegment.getBridgeMacLinks((SharedSegment)segment)) {
                    Assert.assertEquals((long)topology.portB2.intValue(), (long)link.getBridgePort().intValue());
                }
                continue;
            }
            Assert.assertEquals((Object)true, (Object)false);
        }
    }

    @Test
    public void testTwoBridgeWithBackbonePortsUsingBridgeAddressInBft() throws BridgeTopologyException {
        EnLinkdTestHelper.TwoBridgeWithBackbonePortsTopologyWithBridgeinBft topology = new EnLinkdTestHelper.TwoBridgeWithBackbonePortsTopologyWithBridgeinBft();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeAId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeBId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbt = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbt.addUpdatedBFT(topology.nodeAId, topology.bftA);
        ndbt.addUpdatedBFT(topology.nodeBId, topology.bftB);
        ndbt.calculate();
        Assert.assertEquals((long)topology.nodeBId.intValue(), (long)domain.getRootBridge().getNodeId().intValue());
        topology.check(ndbt.getDomain());
    }

    @Test
    public void testTwoBridgeOneCalculation() throws BridgeTopologyException {
        EnLinkdTestHelper.TwoNodeTopology topology = new EnLinkdTestHelper.TwoNodeTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeAId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeBId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbt = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbt.addUpdatedBFT(topology.nodeAId, topology.bftA);
        ndbt.addUpdatedBFT(topology.nodeBId, topology.bftB);
        ndbt.calculate();
        Assert.assertEquals((Object)topology.nodeBId, (Object)ndbt.getDomain().getRootBridge().getNodeId());
        topology.check2nodeTopology(ndbt.getDomain(), true);
    }

    @Test
    public void testTwoBridgeTwoCalculation() throws BridgeTopologyException {
        EnLinkdTestHelper.TwoNodeTopology topology = new EnLinkdTestHelper.TwoNodeTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeBId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbt = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbt.addUpdatedBFT(topology.nodeBId, topology.bftB);
        ndbt.calculate();
        System.err.println(BridgeForwardingTableEntry.printTopology((Set)BroadcastDomain.calculateBFT((BroadcastDomain)domain, (Bridge)domain.getRootBridge())));
        List shsegs = ndbt.getDomain().getSharedSegments();
        Assert.assertEquals((long)3L, (long)shsegs.size());
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeAId);
        this.setBridgeElements(domain, topology.elemlist);
        ndbt.addUpdatedBFT(topology.nodeAId, topology.bftA);
        ndbt.calculate();
        topology.check2nodeTopology(ndbt.getDomain(), true);
        Assert.assertEquals((Object)topology.nodeBId, (Object)domain.getRootBridge().getNodeId());
        System.err.println(BridgeForwardingTableEntry.printTopology((Set)BroadcastDomain.calculateBFT((BroadcastDomain)domain, (Bridge)domain.getBridge(topology.nodeAId.intValue()))));
    }

    @Test
    public void testTwoBridgeTwoCalculationReverse() throws BridgeTopologyException {
        EnLinkdTestHelper.TwoNodeTopology topology = new EnLinkdTestHelper.TwoNodeTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeAId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbt = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbt.addUpdatedBFT(topology.nodeAId, topology.bftA);
        ndbt.calculate();
        List shsegs = ndbt.getDomain().getSharedSegments();
        Assert.assertEquals((long)3L, (long)shsegs.size());
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeBId);
        this.setBridgeElements(domain, topology.elemlist);
        ndbt.addUpdatedBFT(topology.nodeBId, topology.bftB);
        ndbt.calculate();
        topology.check2nodeTopology(ndbt.getDomain(), false);
        Assert.assertEquals((Object)topology.nodeAId, (Object)domain.getRootBridge().getNodeId());
        System.err.println(BridgeForwardingTableEntry.printTopology((Set)BroadcastDomain.calculateBFT((BroadcastDomain)domain, (Bridge)domain.getRootBridge())));
        System.err.println(BridgeForwardingTableEntry.printTopology((Set)BroadcastDomain.calculateBFT((BroadcastDomain)domain, (Bridge)domain.getBridge(topology.nodeBId.intValue()))));
    }

    @Test
    public void testAB() throws BridgeTopologyException {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeAId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeBId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbt = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbt.addUpdatedBFT(topology.nodeAId, topology.bftA);
        ndbt.addUpdatedBFT(topology.nodeBId, topology.bftB);
        ndbt.calculate();
        topology.checkAB(ndbt.getDomain());
    }

    @Test
    public void testBA() throws BridgeTopologyException {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeBId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeAId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbt = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbt.addUpdatedBFT(topology.nodeBId, topology.bftB);
        ndbt.addUpdatedBFT(topology.nodeAId, topology.bftA);
        ndbt.calculate();
        topology.checkAB(ndbt.getDomain());
    }

    @Test
    public void testAC() throws BridgeTopologyException {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeAId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeCId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbt = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbt.addUpdatedBFT(topology.nodeAId, topology.bftA);
        ndbt.addUpdatedBFT(topology.nodeCId, topology.bftC);
        ndbt.calculate();
        topology.checkAC(ndbt.getDomain());
    }

    @Test
    public void testCA() throws BridgeTopologyException {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeCId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeAId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbt = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbt.addUpdatedBFT(topology.nodeCId, topology.bftC);
        ndbt.addUpdatedBFT(topology.nodeAId, topology.bftA);
        ndbt.calculate();
        topology.checkAC(ndbt.getDomain());
    }

    @Test
    public void testBC() throws BridgeTopologyException {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeBId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeCId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbt = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbt.addUpdatedBFT(topology.nodeBId, topology.bftB);
        ndbt.addUpdatedBFT(topology.nodeCId, topology.bftC);
        ndbt.calculate();
        topology.checkBC(ndbt.getDomain());
    }

    @Test
    public void testCB() throws BridgeTopologyException {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeCId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeBId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbt = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbt.addUpdatedBFT(topology.nodeCId, topology.bftC);
        ndbt.addUpdatedBFT(topology.nodeBId, topology.bftB);
        ndbt.calculate();
        topology.checkBC(ndbt.getDomain());
    }

    @Test
    public void testElectRootBridge() throws BridgeTopologyException {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeAId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeBId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeCId);
        this.setBridgeElements(domain, topology.elemlist);
        Bridge elected = BroadcastDomain.electRootBridge((BroadcastDomain)domain);
        Assert.assertEquals(null, (Object)elected);
        domain.getBridge(topology.nodeAId.intValue()).setDesignated(topology.macB);
        domain.getBridge(topology.nodeCId.intValue()).setDesignated(topology.macB);
        elected = BroadcastDomain.electRootBridge((BroadcastDomain)domain);
        Assert.assertEquals((long)topology.nodeBId.intValue(), (long)elected.getNodeId().intValue());
        domain.getBridge(topology.nodeAId.intValue()).setDesignated(null);
        domain.getBridge(topology.nodeBId.intValue()).setDesignated(topology.macA);
        domain.getBridge(topology.nodeCId.intValue()).setDesignated(topology.macB);
        elected = BroadcastDomain.electRootBridge((BroadcastDomain)domain);
        Assert.assertEquals((long)topology.nodeAId.intValue(), (long)elected.getNodeId().intValue());
        domain.getBridge(topology.nodeAId.intValue()).setDesignated(topology.macB);
        domain.getBridge(topology.nodeBId.intValue()).setDesignated(topology.macC);
        domain.getBridge(topology.nodeCId.intValue()).setDesignated(null);
        elected = BroadcastDomain.electRootBridge((BroadcastDomain)domain);
        Assert.assertEquals((long)topology.nodeCId.intValue(), (long)elected.getNodeId().intValue());
        domain.getBridge(topology.nodeAId.intValue()).setDesignated(null);
        domain.getBridge(topology.nodeBId.intValue()).setDesignated(topology.macC);
        domain.getBridge(topology.nodeCId.intValue()).setDesignated(null);
        elected = BroadcastDomain.electRootBridge((BroadcastDomain)domain);
        Assert.assertEquals((long)topology.nodeCId.intValue(), (long)elected.getNodeId().intValue());
        domain.getBridge(topology.nodeAId.intValue()).setDesignated(null);
        domain.getBridge(topology.nodeBId.intValue()).setDesignated("dddddddddddd");
        domain.getBridge(topology.nodeCId.intValue()).setDesignated(null);
        elected = BroadcastDomain.electRootBridge((BroadcastDomain)domain);
        Assert.assertEquals((long)topology.nodeBId.intValue(), (long)elected.getNodeId().intValue());
        domain.getBridge(topology.nodeAId.intValue()).setDesignated(null);
        domain.getBridge(topology.nodeBId.intValue()).setDesignated(null);
        domain.getBridge(topology.nodeCId.intValue()).setDesignated(topology.macA);
        elected = BroadcastDomain.electRootBridge((BroadcastDomain)domain);
        Assert.assertEquals((long)topology.nodeAId.intValue(), (long)elected.getNodeId().intValue());
        domain.getBridge(topology.nodeAId.intValue()).setDesignated(topology.macC);
        domain.getBridge(topology.nodeBId.intValue()).setDesignated(null);
        domain.getBridge(topology.nodeCId.intValue()).setDesignated(topology.macA);
        try {
            elected = BroadcastDomain.electRootBridge((BroadcastDomain)domain);
        }
        catch (BridgeTopologyException e) {
            Assert.assertEquals((Object)"getUpperBridge, too many iterations", (Object)e.getMessage());
        }
        domain.getBridge(topology.nodeAId.intValue()).setDesignated(null);
        domain.getBridge(topology.nodeBId.intValue()).setDesignated(null);
        domain.getBridge(topology.nodeCId.intValue()).setDesignated(null);
        elected = BroadcastDomain.electRootBridge((BroadcastDomain)domain);
        Assert.assertEquals(null, (Object)elected);
    }

    @Test
    public void testABC() throws BridgeTopologyException {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeAId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeBId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeCId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbt = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbt.addUpdatedBFT(topology.nodeAId, topology.bftA);
        ndbt.addUpdatedBFT(topology.nodeBId, topology.bftB);
        ndbt.addUpdatedBFT(topology.nodeCId, topology.bftC);
        ndbt.calculate();
        topology.check(ndbt.getDomain());
    }

    @Test
    public void testAThenBC() throws BridgeTopologyException {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeAId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbt = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbt.addUpdatedBFT(topology.nodeAId, topology.bftA);
        ndbt.calculate();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeBId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeCId);
        this.setBridgeElements(domain, topology.elemlist);
        ndbt.addUpdatedBFT(topology.nodeBId, topology.bftB);
        ndbt.addUpdatedBFT(topology.nodeCId, topology.bftC);
        ndbt.calculate();
        topology.check(ndbt.getDomain());
    }

    @Test
    public void testACThenB() throws BridgeTopologyException {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeAId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeCId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbt = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbt.addUpdatedBFT(topology.nodeAId, topology.bftA);
        ndbt.addUpdatedBFT(topology.nodeCId, topology.bftC);
        ndbt.calculate();
        topology.checkAC(ndbt.getDomain());
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeBId);
        this.setBridgeElements(domain, topology.elemlist);
        ndbt.addUpdatedBFT(topology.nodeBId, topology.bftB);
        ndbt.calculate();
        topology.check(ndbt.getDomain());
    }

    @Test
    public void testBAThenC() throws BridgeTopologyException {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeBId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeAId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbt = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbt.addUpdatedBFT(topology.nodeBId, topology.bftB);
        ndbt.addUpdatedBFT(topology.nodeAId, topology.bftA);
        ndbt.calculate();
        topology.checkAB(ndbt.getDomain());
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeCId);
        this.setBridgeElements(domain, topology.elemlist);
        ndbt.addUpdatedBFT(topology.nodeCId, topology.bftC);
        ndbt.calculate();
        topology.check(ndbt.getDomain());
    }

    @Test
    public void testBThenCA() throws BridgeTopologyException {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeBId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbt = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbt.addUpdatedBFT(topology.nodeBId, topology.bftB);
        ndbt.calculate();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeCId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeAId);
        this.setBridgeElements(domain, topology.elemlist);
        ndbt.addUpdatedBFT(topology.nodeCId, topology.bftC);
        ndbt.addUpdatedBFT(topology.nodeAId, topology.bftA);
        ndbt.calculate();
        BroadcastDomain.hierarchySetUp((BroadcastDomain)domain, (Bridge)domain.getBridge(topology.nodeAId.intValue()));
        topology.check(ndbt.getDomain());
    }

    @Test
    public void testCThenAB() throws BridgeTopologyException {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeCId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbt = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbt.addUpdatedBFT(topology.nodeCId, topology.bftC);
        ndbt.calculate();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeAId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeBId);
        this.setBridgeElements(domain, topology.elemlist);
        ndbt.addUpdatedBFT(topology.nodeAId, topology.bftA);
        ndbt.addUpdatedBFT(topology.nodeBId, topology.bftB);
        ndbt.calculate();
        BroadcastDomain.hierarchySetUp((BroadcastDomain)domain, (Bridge)domain.getBridge(topology.nodeAId.intValue()));
        topology.check(ndbt.getDomain());
    }

    @Test
    public void testCBThenA() throws BridgeTopologyException {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeCId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeBId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbt = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbt.addUpdatedBFT(topology.nodeCId, topology.bftC);
        ndbt.addUpdatedBFT(topology.nodeBId, topology.bftB);
        ndbt.calculate();
        topology.checkBC(ndbt.getDomain());
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeAId);
        this.setBridgeElements(domain, topology.elemlist);
        ndbt.addUpdatedBFT(topology.nodeAId, topology.bftA);
        ndbt.calculate();
        BroadcastDomain.hierarchySetUp((BroadcastDomain)domain, (Bridge)domain.getBridge(topology.nodeAId.intValue()));
        topology.check(ndbt.getDomain());
    }

    @Test
    public void testDE() throws BridgeTopologyException {
        EnLinkdTestHelper.DEFGHILTopology topology = new EnLinkdTestHelper.DEFGHILTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeDId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeEId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbt = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbt.addUpdatedBFT(topology.nodeDId, topology.bftD);
        ndbt.addUpdatedBFT(topology.nodeEId, topology.bftE);
        ndbt.calculate();
        topology.checkDE(ndbt.getDomain());
    }

    @Test
    public void testDF() throws BridgeTopologyException {
        EnLinkdTestHelper.DEFGHILTopology topology = new EnLinkdTestHelper.DEFGHILTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeDId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeFId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbt = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbt.addUpdatedBFT(topology.nodeDId, topology.bftD);
        ndbt.addUpdatedBFT(topology.nodeFId, topology.bftF);
        ndbt.calculate();
        topology.checkDF(ndbt.getDomain());
    }

    @Test
    public void testEF() throws BridgeTopologyException {
        EnLinkdTestHelper.DEFGHILTopology topology = new EnLinkdTestHelper.DEFGHILTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeEId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeFId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbt = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbt.addUpdatedBFT(topology.nodeEId, topology.bftE);
        ndbt.addUpdatedBFT(topology.nodeFId, topology.bftF);
        ndbt.calculate();
        topology.checkEF(ndbt.getDomain());
    }

    @Test
    public void testDG() throws BridgeTopologyException {
        EnLinkdTestHelper.DEFGHILTopology topology = new EnLinkdTestHelper.DEFGHILTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeDId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeGId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbt = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbt.addUpdatedBFT(topology.nodeDId, topology.bftD);
        ndbt.addUpdatedBFT(topology.nodeGId, topology.bftG);
        ndbt.calculate();
        topology.checkDG(ndbt.getDomain());
    }

    @Test
    public void testDEF() throws BridgeTopologyException {
        EnLinkdTestHelper.DEFGHILTopology topology = new EnLinkdTestHelper.DEFGHILTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeDId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeEId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeFId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbt = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbt.addUpdatedBFT(topology.nodeDId, topology.bftD);
        ndbt.addUpdatedBFT(topology.nodeEId, topology.bftE);
        ndbt.addUpdatedBFT(topology.nodeFId, topology.bftF);
        ndbt.calculate();
        topology.checkDEF(ndbt.getDomain());
    }

    @Test
    public void testDFThenE() throws BridgeTopologyException {
        EnLinkdTestHelper.DEFGHILTopology topology = new EnLinkdTestHelper.DEFGHILTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeDId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeFId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbt = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbt.addUpdatedBFT(topology.nodeDId, topology.bftD);
        ndbt.addUpdatedBFT(topology.nodeFId, topology.bftF);
        ndbt.calculate();
        topology.checkDF(ndbt.getDomain());
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeEId);
        this.setBridgeElements(domain, topology.elemlist);
        ndbt.addUpdatedBFT(topology.nodeEId, topology.bftE);
        ndbt.calculate();
        topology.checkDEF(ndbt.getDomain());
    }

    @Test
    public void testDEFG() throws BridgeTopologyException {
        EnLinkdTestHelper.DEFGHILTopology topology = new EnLinkdTestHelper.DEFGHILTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeDId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeEId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeFId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeGId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbt = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbt.addUpdatedBFT(topology.nodeDId, topology.bftD);
        ndbt.addUpdatedBFT(topology.nodeEId, topology.bftE);
        ndbt.addUpdatedBFT(topology.nodeFId, topology.bftF);
        ndbt.addUpdatedBFT(topology.nodeGId, topology.bftG);
        ndbt.calculate();
        topology.checkDEFG(ndbt.getDomain());
    }

    @Test
    public void testDEFGThenI() throws BridgeTopologyException {
        EnLinkdTestHelper.DEFGHILTopology topology = new EnLinkdTestHelper.DEFGHILTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeDId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeEId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeFId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeGId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeIId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbt = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbt.addUpdatedBFT(topology.nodeDId, topology.bftD);
        ndbt.addUpdatedBFT(topology.nodeEId, topology.bftE);
        ndbt.addUpdatedBFT(topology.nodeFId, topology.bftF);
        ndbt.addUpdatedBFT(topology.nodeGId, topology.bftG);
        ndbt.calculate();
        topology.checkDEFG(ndbt.getDomain());
        ndbt.addUpdatedBFT(topology.nodeIId, topology.bftI);
        ndbt.calculate();
        for (BridgeForwardingTableEntry bftentry : BroadcastDomain.calculateBFT((BroadcastDomain)domain, (Bridge)domain.getBridge(topology.nodeIId.intValue()))) {
            Assert.assertEquals((long)topology.nodeIId.intValue(), (long)bftentry.getNodeId().intValue());
            if (bftentry.getMacAddress().equals(topology.mac1)) {
                Assert.assertEquals((long)topology.portII.intValue(), (long)bftentry.getBridgePort().intValue());
                continue;
            }
            if (bftentry.getMacAddress().equals(topology.mac2)) {
                Assert.assertEquals((long)topology.portII.intValue(), (long)bftentry.getBridgePort().intValue());
                continue;
            }
            if (bftentry.getMacAddress().equals(topology.mac3)) {
                Assert.assertEquals((long)topology.portI3.intValue(), (long)bftentry.getBridgePort().intValue());
                continue;
            }
            if (bftentry.getMacAddress().equals(topology.mac4)) {
                Assert.assertEquals((long)topology.portI4.intValue(), (long)bftentry.getBridgePort().intValue());
                continue;
            }
            if (bftentry.getMacAddress().equals(topology.mac5)) {
                Assert.assertEquals((long)topology.portII.intValue(), (long)bftentry.getBridgePort().intValue());
                continue;
            }
            if (bftentry.getMacAddress().equals(topology.mac6)) {
                Assert.assertEquals((long)topology.portII.intValue(), (long)bftentry.getBridgePort().intValue());
                continue;
            }
            if (bftentry.getMacAddress().equals(topology.mac7)) {
                Assert.assertEquals((long)topology.portII.intValue(), (long)bftentry.getBridgePort().intValue());
                continue;
            }
            if (bftentry.getMacAddress().equals(topology.mac8)) {
                Assert.assertEquals((long)topology.portII.intValue(), (long)bftentry.getBridgePort().intValue());
                continue;
            }
            Assert.assertEquals((long)0L, (long)1L);
        }
        for (BridgeForwardingTableEntry bftentry : BroadcastDomain.calculateBFT((BroadcastDomain)domain, (Bridge)domain.getBridge(topology.nodeGId.intValue()))) {
            Assert.assertEquals((long)topology.nodeGId.intValue(), (long)bftentry.getNodeId().intValue());
            if (bftentry.getMacAddress().equals(topology.mac1)) {
                Assert.assertEquals((long)topology.portGD.intValue(), (long)bftentry.getBridgePort().intValue());
                continue;
            }
            if (bftentry.getMacAddress().equals(topology.mac2)) {
                Assert.assertEquals((long)topology.portGD.intValue(), (long)bftentry.getBridgePort().intValue());
                continue;
            }
            if (bftentry.getMacAddress().equals(topology.mac3)) {
                Assert.assertEquals((long)topology.portGF.intValue(), (long)bftentry.getBridgePort().intValue());
                continue;
            }
            if (bftentry.getMacAddress().equals(topology.mac4)) {
                Assert.assertEquals((long)topology.portGF.intValue(), (long)bftentry.getBridgePort().intValue());
                continue;
            }
            if (bftentry.getMacAddress().equals(topology.mac5)) {
                Assert.assertEquals((long)topology.portGE.intValue(), (long)bftentry.getBridgePort().intValue());
                continue;
            }
            if (bftentry.getMacAddress().equals(topology.mac6)) {
                Assert.assertEquals((long)topology.portGE.intValue(), (long)bftentry.getBridgePort().intValue());
                continue;
            }
            if (bftentry.getMacAddress().equals(topology.mac7)) {
                Assert.assertEquals((long)topology.portG7.intValue(), (long)bftentry.getBridgePort().intValue());
                continue;
            }
            if (bftentry.getMacAddress().equals(topology.mac8)) {
                Assert.assertEquals((long)topology.portG8.intValue(), (long)bftentry.getBridgePort().intValue());
                continue;
            }
            Assert.assertEquals((long)0L, (long)1L);
        }
    }

    @Test
    public void testDEFGHIL() throws BridgeTopologyException {
        EnLinkdTestHelper.DEFGHILTopology topology = new EnLinkdTestHelper.DEFGHILTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeDId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeEId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeFId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeGId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeHId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeIId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeLId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbt = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbt.addUpdatedBFT(topology.nodeDId, topology.bftD);
        ndbt.addUpdatedBFT(topology.nodeEId, topology.bftE);
        ndbt.addUpdatedBFT(topology.nodeFId, topology.bftF);
        ndbt.addUpdatedBFT(topology.nodeGId, topology.bftG);
        ndbt.addUpdatedBFT(topology.nodeHId, topology.bftH);
        ndbt.addUpdatedBFT(topology.nodeIId, topology.bftI);
        ndbt.addUpdatedBFT(topology.nodeLId, topology.bftL);
        ndbt.calculate();
        topology.check(ndbt.getDomain());
    }

    @Test
    public void testHierarchySetUp() throws BridgeTopologyException {
        EnLinkdTestHelper.DEFGHILTopology topology = new EnLinkdTestHelper.DEFGHILTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeDId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeEId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeFId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeGId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeHId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeIId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeLId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbt = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbt.addUpdatedBFT(topology.nodeDId, topology.bftD);
        ndbt.addUpdatedBFT(topology.nodeEId, topology.bftE);
        ndbt.addUpdatedBFT(topology.nodeFId, topology.bftF);
        ndbt.addUpdatedBFT(topology.nodeGId, topology.bftG);
        ndbt.addUpdatedBFT(topology.nodeHId, topology.bftH);
        ndbt.addUpdatedBFT(topology.nodeIId, topology.bftI);
        ndbt.addUpdatedBFT(topology.nodeLId, topology.bftL);
        ndbt.calculate();
        topology.check(ndbt.getDomain());
        BroadcastDomain.hierarchySetUp((BroadcastDomain)domain, (Bridge)domain.getBridge(topology.nodeGId.intValue()));
        Assert.assertEquals((Object)topology.nodeGId, (Object)ndbt.getDomain().getRootBridge().getNodeId());
        Assert.assertEquals((Object)true, (Object)ndbt.getDomain().getBridge(topology.nodeGId.intValue()).isRootBridge());
        Assert.assertEquals(null, (Object)ndbt.getDomain().getBridge(topology.nodeGId.intValue()).getRootPort());
        Assert.assertEquals((Object)false, (Object)ndbt.getDomain().getBridge(topology.nodeDId.intValue()).isRootBridge());
        Assert.assertEquals((Object)topology.portDD, (Object)ndbt.getDomain().getBridge(topology.nodeDId.intValue()).getRootPort());
        Assert.assertEquals((Object)false, (Object)ndbt.getDomain().getBridge(topology.nodeEId.intValue()).isRootBridge());
        Assert.assertEquals((Object)topology.portEE, (Object)ndbt.getDomain().getBridge(topology.nodeEId.intValue()).getRootPort());
        Assert.assertEquals((Object)false, (Object)ndbt.getDomain().getBridge(topology.nodeFId.intValue()).isRootBridge());
        Assert.assertEquals((Object)topology.portFF, (Object)ndbt.getDomain().getBridge(topology.nodeFId.intValue()).getRootPort());
        Assert.assertEquals((Object)false, (Object)ndbt.getDomain().getBridge(topology.nodeHId.intValue()).isRootBridge());
        Assert.assertEquals((Object)topology.portHH, (Object)ndbt.getDomain().getBridge(topology.nodeHId.intValue()).getRootPort());
        Assert.assertEquals((Object)false, (Object)ndbt.getDomain().getBridge(topology.nodeIId.intValue()).isRootBridge());
        Assert.assertEquals((Object)topology.portII, (Object)ndbt.getDomain().getBridge(topology.nodeIId.intValue()).getRootPort());
        Assert.assertEquals((Object)false, (Object)ndbt.getDomain().getBridge(topology.nodeLId.intValue()).isRootBridge());
        Assert.assertEquals((Object)topology.portLL, (Object)ndbt.getDomain().getBridge(topology.nodeLId.intValue()).getRootPort());
    }

    @Test
    public void testFiveSwitchTopologyBCADE() throws BridgeTopologyException {
        EnLinkdTestHelper.FiveSwitchTopology topology = new EnLinkdTestHelper.FiveSwitchTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeAId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeBId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeCId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeDId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeEId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbtB = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.nodeBId), topology.bftB);
        ndbtB.calculate();
        Assert.assertEquals((long)0L, (long)domain.getForwarders(Integer.valueOf(topology.nodeAId)).size());
        Assert.assertEquals((long)0L, (long)domain.getForwarders(Integer.valueOf(topology.nodeBId)).size());
        Assert.assertEquals((long)0L, (long)domain.getForwarders(Integer.valueOf(topology.nodeCId)).size());
        Assert.assertEquals((long)0L, (long)domain.getForwarders(Integer.valueOf(topology.nodeDId)).size());
        Assert.assertEquals((long)0L, (long)domain.getForwarders(Integer.valueOf(topology.nodeEId)).size());
        DiscoveryBridgeTopology ndbtC = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtC.addUpdatedBFT(Integer.valueOf(topology.nodeCId), topology.bftC);
        ndbtC.calculate();
        topology.checkBC(domain);
        Assert.assertEquals((long)0L, (long)domain.getForwarders(Integer.valueOf(topology.nodeAId)).size());
        topology.checkBcalcBC(domain.getForwarders(Integer.valueOf(topology.nodeBId)));
        topology.checkCcalcBC(domain.getForwarders(Integer.valueOf(topology.nodeCId)));
        Assert.assertEquals((long)0L, (long)domain.getForwarders(Integer.valueOf(topology.nodeDId)).size());
        Assert.assertEquals((long)0L, (long)domain.getForwarders(Integer.valueOf(topology.nodeEId)).size());
        DiscoveryBridgeTopology ndbtA = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtA.addUpdatedBFT(Integer.valueOf(topology.nodeAId), topology.bftA);
        ndbtA.calculate();
        topology.checkAcalcBCA(domain.getForwarders(Integer.valueOf(topology.nodeAId)));
        topology.checkBcalcBCA(domain.getForwarders(Integer.valueOf(topology.nodeBId)));
        topology.checkCcalcBCA(domain.getForwarders(Integer.valueOf(topology.nodeCId)));
        Assert.assertEquals((long)0L, (long)domain.getForwarders(Integer.valueOf(topology.nodeDId)).size());
        Assert.assertEquals((long)0L, (long)domain.getForwarders(Integer.valueOf(topology.nodeEId)).size());
        DiscoveryBridgeTopology ndbtD = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtD.addUpdatedBFT(Integer.valueOf(topology.nodeDId), topology.bftD);
        ndbtD.calculate();
        topology.checkAcalcBCAD(domain.getForwarders(Integer.valueOf(topology.nodeAId)));
        topology.checkBcalcBCAD(domain.getForwarders(Integer.valueOf(topology.nodeBId)));
        topology.checkCcalcBCAD(domain.getForwarders(Integer.valueOf(topology.nodeCId)));
        topology.checkDcalcBCAD(domain.getForwarders(Integer.valueOf(topology.nodeDId)));
        Assert.assertEquals((long)0L, (long)domain.getForwarders(Integer.valueOf(topology.nodeEId)).size());
        DiscoveryBridgeTopology ndbtE = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtE.addUpdatedBFT(Integer.valueOf(topology.nodeEId), topology.bftE);
        ndbtE.calculate();
        topology.check(domain);
    }

    @Test
    public void testFiveSwitchTopologyBCAED() throws BridgeTopologyException {
        EnLinkdTestHelper.FiveSwitchTopology topology = new EnLinkdTestHelper.FiveSwitchTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeAId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeBId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeCId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeDId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeEId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbtB = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.nodeBId), topology.bftB);
        ndbtB.calculate();
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.nodeCId), topology.bftC);
        ndbtB.calculate();
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.nodeAId), topology.bftA);
        ndbtB.calculate();
        topology.checkAcalcBCA(domain.getForwarders(Integer.valueOf(topology.nodeAId)));
        topology.checkBcalcBCA(domain.getForwarders(Integer.valueOf(topology.nodeBId)));
        topology.checkCcalcBCA(domain.getForwarders(Integer.valueOf(topology.nodeCId)));
        Assert.assertEquals((long)0L, (long)domain.getForwarders(Integer.valueOf(topology.nodeDId)).size());
        Assert.assertEquals((long)0L, (long)domain.getForwarders(Integer.valueOf(topology.nodeEId)).size());
        DiscoveryBridgeTopology ndbtE = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtE.addUpdatedBFT(Integer.valueOf(topology.nodeEId), topology.bftE);
        ndbtE.calculate();
        topology.checkAcalcBCAE(domain.getForwarders(Integer.valueOf(topology.nodeAId)));
        topology.checkBcalcBCAE(domain.getForwarders(Integer.valueOf(topology.nodeBId)));
        topology.checkCcalcBCAE(domain.getForwarders(Integer.valueOf(topology.nodeCId)));
        Assert.assertEquals((long)0L, (long)domain.getForwarders(Integer.valueOf(topology.nodeDId)).size());
        topology.checkEcalcBCAE(domain.getForwarders(Integer.valueOf(topology.nodeEId)));
        DiscoveryBridgeTopology ndbtD = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtD.addUpdatedBFT(Integer.valueOf(topology.nodeDId), topology.bftD);
        ndbtD.calculate();
        topology.check(domain);
    }

    @Test
    public void testFiveSwitchTopologyBCAThenED() throws BridgeTopologyException {
        EnLinkdTestHelper.FiveSwitchTopology topology = new EnLinkdTestHelper.FiveSwitchTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeAId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeBId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeCId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeDId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeEId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbtB = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.nodeBId), topology.bftB);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.nodeCId), topology.bftC);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.nodeAId), topology.bftA);
        ndbtB.calculate();
        topology.checkAcalcBCA(domain.getForwarders(Integer.valueOf(topology.nodeAId)));
        topology.checkBcalcBCA(domain.getForwarders(Integer.valueOf(topology.nodeBId)));
        topology.checkCcalcBCA(domain.getForwarders(Integer.valueOf(topology.nodeCId)));
        Assert.assertEquals((long)0L, (long)domain.getForwarders(Integer.valueOf(topology.nodeDId)).size());
        Assert.assertEquals((long)0L, (long)domain.getForwarders(Integer.valueOf(topology.nodeEId)).size());
        DiscoveryBridgeTopology ndbtE = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtE.addUpdatedBFT(Integer.valueOf(topology.nodeEId), topology.bftE);
        ndbtE.addUpdatedBFT(Integer.valueOf(topology.nodeDId), topology.bftD);
        ndbtE.calculate();
        Bridge bridgeB = domain.getBridge(topology.nodeBId);
        BroadcastDomain.hierarchySetUp((BroadcastDomain)domain, (Bridge)bridgeB);
        topology.check(domain);
    }

    @Test
    public void testFiveSwitchTopologyEDCBA() throws BridgeTopologyException {
        EnLinkdTestHelper.FiveSwitchTopology topology = new EnLinkdTestHelper.FiveSwitchTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeAId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeBId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeCId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeDId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeEId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbtE = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtE.addUpdatedBFT(Integer.valueOf(topology.nodeEId), topology.bftE);
        ndbtE.calculate();
        DiscoveryBridgeTopology ndbtD = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtD.addUpdatedBFT(Integer.valueOf(topology.nodeDId), topology.bftD);
        ndbtD.calculate();
        DiscoveryBridgeTopology ndbtC = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtC.addUpdatedBFT(Integer.valueOf(topology.nodeCId), topology.bftC);
        ndbtC.calculate();
        DiscoveryBridgeTopology ndbtB = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.nodeBId), topology.bftB);
        ndbtB.calculate();
        DiscoveryBridgeTopology ndbtA = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtA.addUpdatedBFT(Integer.valueOf(topology.nodeAId), topology.bftA);
        ndbtA.calculate();
        Bridge bridgeB = domain.getBridge(topology.nodeBId);
        BroadcastDomain.hierarchySetUp((BroadcastDomain)domain, (Bridge)bridgeB);
        topology.check(domain);
    }

    @Test
    public void testFiveSwitchTopologyBEDCA() throws BridgeTopologyException {
        EnLinkdTestHelper.FiveSwitchTopology topology = new EnLinkdTestHelper.FiveSwitchTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeAId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeBId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeCId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeDId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeEId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbtB = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.nodeBId), topology.bftB);
        ndbtB.calculate();
        DiscoveryBridgeTopology ndbtE = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtE.addUpdatedBFT(Integer.valueOf(topology.nodeEId), topology.bftE);
        ndbtE.calculate();
        DiscoveryBridgeTopology ndbtD = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtD.addUpdatedBFT(Integer.valueOf(topology.nodeDId), topology.bftD);
        ndbtD.calculate();
        DiscoveryBridgeTopology ndbtC = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtC.addUpdatedBFT(Integer.valueOf(topology.nodeCId), topology.bftC);
        ndbtC.calculate();
        DiscoveryBridgeTopology ndbtA = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtA.addUpdatedBFT(Integer.valueOf(topology.nodeAId), topology.bftA);
        ndbtA.calculate();
        topology.check(domain);
    }

    @Test
    public void testFiveSwitchTopologyEDCAB() throws BridgeTopologyException {
        EnLinkdTestHelper.FiveSwitchTopology topology = new EnLinkdTestHelper.FiveSwitchTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeAId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeBId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeCId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeDId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeEId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbtE = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtE.addUpdatedBFT(Integer.valueOf(topology.nodeEId), topology.bftE);
        ndbtE.calculate();
        DiscoveryBridgeTopology ndbtD = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtD.addUpdatedBFT(Integer.valueOf(topology.nodeDId), topology.bftD);
        ndbtD.calculate();
        DiscoveryBridgeTopology ndbtC = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtC.addUpdatedBFT(Integer.valueOf(topology.nodeCId), topology.bftC);
        ndbtC.calculate();
        DiscoveryBridgeTopology ndbtA = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtA.addUpdatedBFT(Integer.valueOf(topology.nodeAId), topology.bftA);
        ndbtA.calculate();
        DiscoveryBridgeTopology ndbtB = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.nodeBId), topology.bftB);
        ndbtB.calculate();
        Bridge bridgeB = domain.getBridge(topology.nodeBId);
        BroadcastDomain.hierarchySetUp((BroadcastDomain)domain, (Bridge)bridgeB);
        topology.check(domain);
    }

    @Test
    public void testFiveSwitchTopologyBCADEBD() throws BridgeTopologyException {
        EnLinkdTestHelper.FiveSwitchTopology topology = new EnLinkdTestHelper.FiveSwitchTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeAId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeBId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeCId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeDId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeEId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbtB = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.nodeBId), topology.bftB);
        ndbtB.calculate();
        DiscoveryBridgeTopology ndbtC = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtC.addUpdatedBFT(Integer.valueOf(topology.nodeCId), topology.bftC);
        ndbtC.calculate();
        DiscoveryBridgeTopology ndbtA = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtA.addUpdatedBFT(Integer.valueOf(topology.nodeAId), topology.bftA);
        ndbtA.calculate();
        DiscoveryBridgeTopology ndbtD = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtD.addUpdatedBFT(Integer.valueOf(topology.nodeDId), topology.bftD);
        ndbtD.calculate();
        DiscoveryBridgeTopology ndbtE = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtE.addUpdatedBFT(Integer.valueOf(topology.nodeEId), topology.bftE);
        ndbtE.calculate();
        topology.check(domain);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.nodeBId), topology.bftB);
        ndbtB.calculate();
        topology.check(domain);
        ndbtD.addUpdatedBFT(Integer.valueOf(topology.nodeDId), topology.bftD);
        ndbtD.calculate();
        topology.check(domain);
    }

    @Test
    public void testFiveSwitchTopologyBEDCADBAEC() throws BridgeTopologyException {
        EnLinkdTestHelper.FiveSwitchTopology topology = new EnLinkdTestHelper.FiveSwitchTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeAId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeBId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeCId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeDId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeEId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbtB = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.nodeBId), topology.bftB);
        ndbtB.calculate();
        DiscoveryBridgeTopology ndbtE = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtE.addUpdatedBFT(Integer.valueOf(topology.nodeEId), topology.bftE);
        ndbtE.calculate();
        DiscoveryBridgeTopology ndbtD = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtD.addUpdatedBFT(Integer.valueOf(topology.nodeDId), topology.bftD);
        ndbtD.calculate();
        DiscoveryBridgeTopology ndbtC = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtC.addUpdatedBFT(Integer.valueOf(topology.nodeCId), topology.bftC);
        ndbtC.calculate();
        DiscoveryBridgeTopology ndbtA = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtA.addUpdatedBFT(Integer.valueOf(topology.nodeAId), topology.bftA);
        ndbtA.calculate();
        topology.check(domain);
        ndbtD.addUpdatedBFT(Integer.valueOf(topology.nodeDId), topology.bftD);
        ndbtD.calculate();
        topology.check(domain);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.nodeBId), topology.bftB);
        ndbtB.calculate();
        topology.check(domain);
        ndbtA.addUpdatedBFT(Integer.valueOf(topology.nodeAId), topology.bftA);
        ndbtA.calculate();
        topology.check(domain);
        ndbtE.addUpdatedBFT(Integer.valueOf(topology.nodeEId), topology.bftE);
        ndbtE.calculate();
        topology.check(domain);
        ndbtC.addUpdatedBFT(Integer.valueOf(topology.nodeCId), topology.bftC);
        ndbtC.calculate();
        topology.check(domain);
    }

    @Test
    public void testFiveSwitchTopologyBEDCABEDAC() throws BridgeTopologyException {
        EnLinkdTestHelper.FiveSwitchTopology topology = new EnLinkdTestHelper.FiveSwitchTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeAId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeBId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeCId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeDId);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.nodeEId);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbtB = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.nodeBId), topology.bftB);
        ndbtB.calculate();
        DiscoveryBridgeTopology ndbtE = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtE.addUpdatedBFT(Integer.valueOf(topology.nodeEId), topology.bftE);
        ndbtE.calculate();
        DiscoveryBridgeTopology ndbtD = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtD.addUpdatedBFT(Integer.valueOf(topology.nodeDId), topology.bftD);
        ndbtD.calculate();
        DiscoveryBridgeTopology ndbtC = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtC.addUpdatedBFT(Integer.valueOf(topology.nodeCId), topology.bftC);
        ndbtC.calculate();
        DiscoveryBridgeTopology ndbtA = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtA.addUpdatedBFT(Integer.valueOf(topology.nodeAId), topology.bftA);
        ndbtA.calculate();
        topology.check(domain);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.nodeBId), topology.bftB);
        ndbtB.calculate();
        topology.check(domain);
        ndbtE.addUpdatedBFT(Integer.valueOf(topology.nodeEId), topology.bftE);
        ndbtE.calculate();
        topology.check(domain);
        ndbtD.addUpdatedBFT(Integer.valueOf(topology.nodeDId), topology.bftD);
        ndbtD.calculate();
        topology.check(domain);
        ndbtA.addUpdatedBFT(Integer.valueOf(topology.nodeAId), topology.bftA);
        ndbtA.calculate();
        topology.check(domain);
        ndbtC.addUpdatedBFT(Integer.valueOf(topology.nodeCId), topology.bftC);
        ndbtC.calculate();
        topology.check(domain);
    }

    @Test
    public void testTwentySwitchTopology() throws BridgeTopologyException {
        EnLinkdTestHelper.TwentyNodeTopology topology = new EnLinkdTestHelper.TwentyNodeTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.spiazzofasw01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.spiasvigasw01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.daremunalv01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.villpizzasw01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.rsaspiazzowl1Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.vigrenmualv01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.vigrenmualv02Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.vigrenmuasw01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.vrendmunalv02Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.daremunasw01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.spiazzomepe01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.comunespiazzowl1Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.vrendmunasw01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.comunevillarendenawl1Id);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbtB = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.spiazzofasw01Id), topology.bftspiazzofasw01);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.spiasvigasw01Id), topology.bftspiasvigasw01);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.daremunalv01Id), topology.bftdaremunalv01);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.villpizzasw01Id), topology.bftvillpizzasw01);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.rsaspiazzowl1Id), topology.bftrsaspiazzowl1);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.vigrenmualv01Id), topology.bftvigrenmualv01);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.vigrenmualv02Id), topology.bftvigrenmualv02);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.vrendmunalv02Id), topology.bftvrendmunalv02);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.daremunasw01Id), topology.bftdaremunasw01);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.spiazzomepe01Id), topology.bftspiazzomepe01);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.comunespiazzowl1Id), topology.bftcomunespiazzowl1);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.vrendmunasw01Id), topology.bftvrendmunasw01);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.vigrenmuasw01Id), topology.bftvigrenmuasw01);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.comunevillarendenawl1Id), topology.bftcomunevillarendenawl1);
        ndbtB.calculate();
        Assert.assertEquals((long)0L, (long)ndbtB.getFailed().size());
    }

    @Test
    public void testTwentySwitchTopologySpiazzo() throws BridgeTopologyException {
        EnLinkdTestHelper.TwentyNodeTopology topology = new EnLinkdTestHelper.TwentyNodeTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.spiazzofasw01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.comunespiazzowl1Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.spiazzomepe01Id);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbtB = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.spiazzofasw01Id), topology.bftspiazzofasw01);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.spiazzomepe01Id), topology.bftspiazzomepe01);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.comunespiazzowl1Id), topology.bftcomunespiazzowl1);
        ndbtB.calculate();
        Assert.assertEquals((long)0L, (long)ndbtB.getFailed().size());
    }

    @Test
    public void testTwentySwitchTopologySpiazzoSVig() throws BridgeTopologyException {
        EnLinkdTestHelper.TwentyNodeTopology topology = new EnLinkdTestHelper.TwentyNodeTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.spiasvigasw01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.rsaspiazzowl1Id);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbtB = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.spiasvigasw01Id), topology.bftspiasvigasw01);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.rsaspiazzowl1Id), topology.bftrsaspiazzowl1);
        ndbtB.calculate();
        Assert.assertEquals((long)0L, (long)ndbtB.getFailed().size());
    }

    @Test
    public void testTwentySwitchTopologyVRendMun() throws BridgeTopologyException {
        EnLinkdTestHelper.TwentyNodeTopology topology = new EnLinkdTestHelper.TwentyNodeTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.vrendmunalv02Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.vrendmunasw01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.comunevillarendenawl1Id);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbtB = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.vrendmunalv02Id), topology.bftvrendmunalv02);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.vrendmunasw01Id), topology.bftvrendmunasw01);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.comunevillarendenawl1Id), topology.bftcomunevillarendenawl1);
        ndbtB.calculate();
        Assert.assertEquals((long)0L, (long)ndbtB.getFailed().size());
    }

    @Test
    public void testTwentySwitchTopologyVigReMun() throws BridgeTopologyException {
        EnLinkdTestHelper.TwentyNodeTopology topology = new EnLinkdTestHelper.TwentyNodeTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.vigrenmualv01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.vigrenmualv02Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.vigrenmuasw01Id);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbtB = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.vigrenmualv01Id), topology.bftvigrenmualv01);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.vigrenmualv02Id), topology.bftvigrenmualv02);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.vigrenmuasw01Id), topology.bftvigrenmuasw01);
        ndbtB.calculate();
    }

    @Test
    public void testTwentySwitchTopologyDareMun() throws BridgeTopologyException {
        EnLinkdTestHelper.TwentyNodeTopology topology = new EnLinkdTestHelper.TwentyNodeTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.daremunalv01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.daremunasw01Id);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbtB = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.daremunalv01Id), topology.bftdaremunalv01);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.daremunasw01Id), topology.bftdaremunasw01);
        ndbtB.calculate();
        Assert.assertEquals((long)0L, (long)ndbtB.getFailed().size());
    }

    @Test
    public void testTwentySwitchTopologyAlvarion() throws BridgeTopologyException {
        EnLinkdTestHelper.TwentyNodeTopology topology = new EnLinkdTestHelper.TwentyNodeTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.vrendmunalv02Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.vrendmunasw01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.comunevillarendenawl1Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.vigrenmualv01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.vigrenmualv02Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.vigrenmuasw01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.daremunalv01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.daremunasw01Id);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbtB = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.vrendmunalv02Id), topology.bftvrendmunalv02);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.vrendmunasw01Id), topology.bftvrendmunasw01);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.comunevillarendenawl1Id), topology.bftcomunevillarendenawl1);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.vigrenmualv01Id), topology.bftvigrenmualv01);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.vigrenmualv02Id), topology.bftvigrenmualv02);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.vigrenmuasw01Id), topology.bftvigrenmuasw01);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.daremunalv01Id), topology.bftdaremunalv01);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.daremunasw01Id), topology.bftdaremunasw01);
        ndbtB.calculate();
        Assert.assertEquals((long)0L, (long)ndbtB.getFailed().size());
    }

    @Test
    public void testTwentySwitchTopologyTwoSteps() throws BridgeTopologyException {
        EnLinkdTestHelper.TwentyNodeTopology topology = new EnLinkdTestHelper.TwentyNodeTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.spiazzofasw01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.spiasvigasw01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.daremunalv01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.villpizzasw01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.rsaspiazzowl1Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.vigrenmualv01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.vigrenmualv02Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.vigrenmuasw01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.vrendmunalv02Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.daremunasw01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.spiazzomepe01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.comunespiazzowl1Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.vrendmunasw01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.comunevillarendenawl1Id);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbtA = new DiscoveryBridgeTopology(this.linkd, domain);
        DiscoveryBridgeTopology ndbtB = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtA.addUpdatedBFT(Integer.valueOf(topology.spiazzofasw01Id), topology.bftspiazzofasw01);
        ndbtA.addUpdatedBFT(Integer.valueOf(topology.spiasvigasw01Id), topology.bftspiasvigasw01);
        ndbtA.addUpdatedBFT(Integer.valueOf(topology.daremunalv01Id), topology.bftdaremunalv01);
        ndbtA.addUpdatedBFT(Integer.valueOf(topology.villpizzasw01Id), topology.bftvillpizzasw01);
        ndbtA.addUpdatedBFT(Integer.valueOf(topology.rsaspiazzowl1Id), topology.bftrsaspiazzowl1);
        ndbtA.addUpdatedBFT(Integer.valueOf(topology.vigrenmualv01Id), topology.bftvigrenmualv01);
        ndbtA.addUpdatedBFT(Integer.valueOf(topology.vigrenmualv02Id), topology.bftvigrenmualv02);
        ndbtA.calculate();
        Assert.assertEquals((long)1L, (long)ndbtA.getFailed().size());
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.vrendmunalv02Id), topology.bftvrendmunalv02);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.daremunasw01Id), topology.bftdaremunasw01);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.spiazzomepe01Id), topology.bftspiazzomepe01);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.comunespiazzowl1Id), topology.bftcomunespiazzowl1);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.vrendmunasw01Id), topology.bftvrendmunasw01);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.vigrenmuasw01Id), topology.bftvigrenmuasw01);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.comunevillarendenawl1Id), topology.bftcomunevillarendenawl1);
        ndbtB.calculate();
        Assert.assertEquals((long)0L, (long)ndbtB.getFailed().size());
    }

    @Test
    public void testTwentySwitchTopologyVillpizzasw01B() throws BridgeTopologyException {
        EnLinkdTestHelper.TwentyNodeTopology topology = new EnLinkdTestHelper.TwentyNodeTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.spiasvigasw01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.villpizzasw01Id);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbtB = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.spiasvigasw01Id), topology.bftspiasvigasw01);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.villpizzasw01Id), topology.bftvillpizzasw01);
        ndbtB.calculate();
        Assert.assertEquals((long)1L, (long)ndbtB.getFailed().size());
    }

    @Test
    public void testTwentySwitchTopologyVillpizzasw01A() throws BridgeTopologyException {
        EnLinkdTestHelper.TwentyNodeTopology topology = new EnLinkdTestHelper.TwentyNodeTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.spiazzofasw01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.villpizzasw01Id);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbtB = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.spiazzofasw01Id), topology.bftspiazzofasw01);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.villpizzasw01Id), topology.bftvillpizzasw01);
        ndbtB.calculate();
        Assert.assertEquals((long)0L, (long)ndbtB.getFailed().size());
    }

    @Test
    public void testTwentySwitchTopologyLevel1() throws BridgeTopologyException {
        EnLinkdTestHelper.TwentyNodeTopology topology = new EnLinkdTestHelper.TwentyNodeTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.spiazzofasw01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.comunespiazzowl1Id);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbtB = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.spiazzofasw01Id), topology.bftspiazzofasw01);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.comunespiazzowl1Id), topology.bftcomunespiazzowl1);
        ndbtB.calculate();
        Assert.assertEquals((long)0L, (long)ndbtB.getFailed().size());
    }

    @Test
    public void testTwentySwitchTopologyLevel2() throws BridgeTopologyException {
        EnLinkdTestHelper.TwentyNodeTopology topology = new EnLinkdTestHelper.TwentyNodeTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.spiazzomepe01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.spiazzofasw01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.comunespiazzowl1Id);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbtB = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.spiazzofasw01Id), topology.bftspiazzofasw01);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.comunespiazzowl1Id), topology.bftcomunespiazzowl1);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.spiazzomepe01Id), topology.bftspiazzomepe01);
        ndbtB.calculate();
        Assert.assertEquals((long)0L, (long)ndbtB.getFailed().size());
    }

    @Test
    public void testTwentySwitchTopologyLevel3() throws BridgeTopologyException {
        EnLinkdTestHelper.TwentyNodeTopology topology = new EnLinkdTestHelper.TwentyNodeTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.spiazzomepe01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.spiazzofasw01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.comunespiazzowl1Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.spiasvigasw01Id);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbtB = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.spiazzofasw01Id), topology.bftspiazzofasw01);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.comunespiazzowl1Id), topology.bftcomunespiazzowl1);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.spiazzomepe01Id), topology.bftspiazzomepe01);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.spiasvigasw01Id), topology.bftspiasvigasw01);
        ndbtB.calculate();
        Assert.assertEquals((long)0L, (long)ndbtB.getFailed().size());
    }

    @Test
    public void testTwentySwitchTopologyLevel4() throws BridgeTopologyException {
        EnLinkdTestHelper.TwentyNodeTopology topology = new EnLinkdTestHelper.TwentyNodeTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.spiazzomepe01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.spiazzofasw01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.comunespiazzowl1Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.spiasvigasw01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.rsaspiazzowl1Id);
        this.setBridgeElements(domain, topology.elemlist);
        DiscoveryBridgeTopology ndbtB = new DiscoveryBridgeTopology(this.linkd, domain);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.spiazzofasw01Id), topology.bftspiazzofasw01);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.comunespiazzowl1Id), topology.bftcomunespiazzowl1);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.spiazzomepe01Id), topology.bftspiazzomepe01);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.spiasvigasw01Id), topology.bftspiasvigasw01);
        ndbtB.addUpdatedBFT(Integer.valueOf(topology.rsaspiazzowl1Id), topology.bftrsaspiazzowl1);
        ndbtB.calculate();
        Assert.assertEquals((long)0L, (long)ndbtB.getFailed().size());
    }

    @Test
    public void testDuplicatedMac() throws BridgeTopologyException {
        EnLinkdTestHelper.TwentyNodeTopology topology = new EnLinkdTestHelper.TwentyNodeTopology();
        BroadcastDomain domain = new BroadcastDomain();
        Bridge.create((BroadcastDomain)domain, (Integer)topology.spiazzofasw01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.spiasvigasw01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.daremunalv01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.villpizzasw01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.rsaspiazzowl1Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.vigrenmualv01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.vigrenmualv02Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.vigrenmuasw01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.vrendmunalv02Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.daremunasw01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.spiazzomepe01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.comunespiazzowl1Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.vrendmunasw01Id);
        Bridge.create((BroadcastDomain)domain, (Integer)topology.comunevillarendenawl1Id);
        this.setBridgeElements(domain, topology.elemlist);
        BridgeForwardingTable bridgeFtpe = BridgeForwardingTable.create((Bridge)domain.getBridge(topology.spiazzomepe01Id), topology.bftspiazzomepe01);
        Map duplicated = bridgeFtpe.getDuplicated();
        Assert.assertEquals((long)5L, (long)duplicated.size());
        Assert.assertTrue((boolean)duplicated.keySet().contains(topology.macdaremunasw01));
        Assert.assertTrue((boolean)duplicated.keySet().contains(topology.mac001ebe70cec0));
        Assert.assertTrue((boolean)duplicated.keySet().contains(topology.mac0022557fd68f));
        Assert.assertTrue((boolean)duplicated.keySet().contains(topology.macvrendmunasw01));
        Assert.assertTrue((boolean)duplicated.keySet().contains(topology.mac001906d5cf50));
        Assert.assertEquals((long)2L, (long)((Set)duplicated.get(topology.macdaremunasw01)).size());
        Assert.assertEquals((long)2L, (long)((Set)duplicated.get(topology.mac001ebe70cec0)).size());
        Assert.assertEquals((long)2L, (long)((Set)duplicated.get(topology.mac0022557fd68f)).size());
        Assert.assertEquals((long)2L, (long)((Set)duplicated.get(topology.macvrendmunasw01)).size());
        Assert.assertEquals((long)2L, (long)((Set)duplicated.get(topology.mac001906d5cf50)).size());
        System.err.println(BridgeForwardingTableEntry.printTopology((Set)bridgeFtpe.getEntries()));
        Assert.assertEquals((long)0L, (long)BridgeForwardingTable.create((Bridge)domain.getBridge(topology.daremunasw01Id), topology.bftdaremunasw01).getDuplicated().size());
        Assert.assertEquals((long)0L, (long)BridgeForwardingTable.create((Bridge)domain.getBridge(topology.vigrenmuasw01Id), topology.bftvigrenmuasw01).getDuplicated().size());
        Assert.assertEquals((long)0L, (long)BridgeForwardingTable.create((Bridge)domain.getBridge(topology.vrendmunasw01Id), topology.bftvrendmunasw01).getDuplicated().size());
        Assert.assertEquals((long)0L, (long)BridgeForwardingTable.create((Bridge)domain.getBridge(topology.spiazzofasw01Id), topology.bftspiazzofasw01).getDuplicated().size());
        Assert.assertEquals((long)0L, (long)BridgeForwardingTable.create((Bridge)domain.getBridge(topology.spiasvigasw01Id), topology.bftspiasvigasw01).getDuplicated().size());
        Assert.assertEquals((long)0L, (long)BridgeForwardingTable.create((Bridge)domain.getBridge(topology.villpizzasw01Id), topology.bftvillpizzasw01).getDuplicated().size());
        Assert.assertEquals((long)0L, (long)BridgeForwardingTable.create((Bridge)domain.getBridge(topology.daremunalv01Id), topology.bftdaremunalv01).getDuplicated().size());
        Assert.assertEquals((long)0L, (long)BridgeForwardingTable.create((Bridge)domain.getBridge(topology.vigrenmualv01Id), topology.bftvigrenmualv01).getDuplicated().size());
        Assert.assertEquals((long)0L, (long)BridgeForwardingTable.create((Bridge)domain.getBridge(topology.vigrenmualv02Id), topology.bftvigrenmualv02).getDuplicated().size());
        Assert.assertEquals((long)0L, (long)BridgeForwardingTable.create((Bridge)domain.getBridge(topology.vrendmunalv02Id), topology.bftvrendmunalv02).getDuplicated().size());
        Assert.assertEquals((long)0L, (long)BridgeForwardingTable.create((Bridge)domain.getBridge(topology.rsaspiazzowl1Id), topology.bftrsaspiazzowl1).getDuplicated().size());
        Assert.assertEquals((long)0L, (long)BridgeForwardingTable.create((Bridge)domain.getBridge(topology.comunespiazzowl1Id), topology.bftcomunespiazzowl1).getDuplicated().size());
        Assert.assertEquals((long)0L, (long)BridgeForwardingTable.create((Bridge)domain.getBridge(topology.comunevillarendenawl1Id), topology.bftcomunevillarendenawl1).getDuplicated().size());
    }
}

