/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.test.Level;
import org.opennms.core.test.LoggingEvent;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.InsufficientInformationException;
import org.opennms.netmgt.collectd.Collectd;
import org.opennms.netmgt.collectd.MockServiceCollector;
import org.opennms.netmgt.collection.api.PersisterFactory;
import org.opennms.netmgt.collection.api.ServiceCollectorRegistry;
import org.opennms.netmgt.collection.support.DefaultServiceCollectorRegistry;
import org.opennms.netmgt.collection.test.api.CollectorTestUtils;
import org.opennms.netmgt.config.CollectdConfigFactory;
import org.opennms.netmgt.config.PollOutagesConfigFactory;
import org.opennms.netmgt.config.collectd.CollectdConfiguration;
import org.opennms.netmgt.config.collectd.Collector;
import org.opennms.netmgt.config.collectd.Filter;
import org.opennms.netmgt.config.collectd.Package;
import org.opennms.netmgt.config.collectd.Service;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.mock.MockEventIpcManager;
import org.opennms.netmgt.dao.mock.MockTransactionTemplate;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.events.api.EventIpcManagerFactory;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.filter.api.FilterDao;
import org.opennms.netmgt.mock.MockPersisterFactory;
import org.opennms.netmgt.model.NetworkBuilder;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.test.mock.EasyMockUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.transaction.support.TransactionTemplate;

public class DuplicatePrimaryAddressIT {
    private static final Logger LOG = LoggerFactory.getLogger(DuplicatePrimaryAddressIT.class);
    private EventIpcManager m_eventIpcManager;
    private Collectd m_collectd;
    private EasyMockUtils m_mockUtils;
    private CollectdConfigFactory m_collectdConfigFactory;
    private CollectdConfiguration m_collectdConfiguration;
    private IpInterfaceDao m_ifaceDao;
    private NodeDao m_nodeDao;
    private FilterDao m_filterDao;

    @Before
    public void setUp() {
        MockServiceCollector.setDelegate(null);
    }

    @Test
    public void testExisting() throws Exception {
        this.initialize(true);
        this.verify();
    }

    @Test
    public void testOnDemand() throws Exception {
        this.initialize(false);
        EventBuilder nodeGained = new EventBuilder("uei.opennms.org/nodes/nodeGainedService", "Test");
        nodeGained.setInterface(InetAddressUtils.addr((String)"192.168.1.1"));
        nodeGained.setService("SNMP");
        EventBuilder reinitialize = new EventBuilder("uei.opennms.org/nodes/reinitializePrimarySnmpInterface", "Test");
        reinitialize.setInterface(InetAddressUtils.addr((String)"192.168.1.1"));
        nodeGained.setNodeid(1L);
        reinitialize.setNodeid(1L);
        this.m_collectd.onEvent(nodeGained.getEvent());
        this.m_collectd.onEvent(reinitialize.getEvent());
        nodeGained.setNodeid(3L);
        reinitialize.setNodeid(3L);
        this.m_collectd.onEvent(nodeGained.getEvent());
        this.m_collectd.onEvent(reinitialize.getEvent());
        this.verify();
    }

    private void initialize(boolean scheduleExistingNodes) throws Exception {
        MockLogAppender.setupLogging();
        this.m_eventIpcManager = new MockEventIpcManager();
        EventIpcManagerFactory.setIpcManager((EventIpcManager)this.m_eventIpcManager);
        this.m_mockUtils = new EasyMockUtils();
        this.m_filterDao = (FilterDao)this.m_mockUtils.createMock(FilterDao.class);
        FilterDaoFactory.setInstance((FilterDao)this.m_filterDao);
        ClassPathResource resource = new ClassPathResource("etc/poll-outages.xml");
        PollOutagesConfigFactory factory = new PollOutagesConfigFactory((Resource)resource);
        factory.afterPropertiesSet();
        PollOutagesConfigFactory.setInstance((PollOutagesConfigFactory)factory);
        File homeDir = resource.getFile().getParentFile().getParentFile();
        System.setProperty("opennms.home", homeDir.getAbsolutePath());
        Collector collector = new Collector();
        collector.setService("SNMP");
        collector.setClassName(MockServiceCollector.class.getName());
        this.m_collectdConfigFactory = (CollectdConfigFactory)this.m_mockUtils.createMock(CollectdConfigFactory.class);
        this.m_collectdConfiguration = (CollectdConfiguration)this.m_mockUtils.createMock(CollectdConfiguration.class);
        EasyMock.expect((Object)this.m_collectdConfigFactory.getCollectdConfig()).andReturn((Object)this.m_collectdConfiguration).anyTimes();
        EasyMock.expect((Object)this.m_collectdConfiguration.getCollectors()).andReturn(Collections.singletonList(collector)).anyTimes();
        EasyMock.expect((Object)this.m_collectdConfiguration.getThreads()).andReturn((Object)2).anyTimes();
        this.m_ifaceDao = (IpInterfaceDao)this.m_mockUtils.createMock(IpInterfaceDao.class);
        this.m_nodeDao = (NodeDao)this.m_mockUtils.createMock(NodeDao.class);
        this.m_collectd = new Collectd(){

            protected void handleInsufficientInfo(InsufficientInformationException e) {
                Assert.fail((String)("Invalid event received: " + e.getMessage()));
            }
        };
        OnmsServiceType snmp = new OnmsServiceType("SNMP");
        NetworkBuilder netBuilder = new NetworkBuilder();
        OnmsNode n1 = netBuilder.addNode("node1").setId(Integer.valueOf(1)).setForeignSource("TestA").setForeignId("node1").getNode();
        OnmsIpInterface ip1 = netBuilder.addSnmpInterface(1).addIpInterface("192.168.1.1").setId(2).setIsSnmpPrimary("P").getInterface();
        netBuilder.addService(snmp);
        OnmsNode n2 = netBuilder.addNode("node2").setId(Integer.valueOf(3)).setForeignSource("TestB").setForeignId("node2").getNode();
        OnmsIpInterface ip2 = netBuilder.addSnmpInterface(1).addIpInterface("192.168.1.1").setId(4).setIsSnmpPrimary("P").getInterface();
        netBuilder.addService(snmp);
        Assert.assertNotSame((Object)ip1.getNode().getId(), (Object)ip2.getNode().getId());
        ArrayList<OnmsIpInterface> initialIfs = new ArrayList<OnmsIpInterface>();
        if (scheduleExistingNodes) {
            initialIfs.add(ip1);
            initialIfs.add(ip2);
        }
        EasyMock.expect((Object)this.m_ifaceDao.findByServiceType(snmp.getName())).andReturn(initialIfs).anyTimes();
        this.m_filterDao.flushActiveIpAddressListCache();
        EasyMock.expectLastCall().anyTimes();
        EasyMock.expect((Object)this.m_nodeDao.load((Serializable)Integer.valueOf(1))).andReturn((Object)n1).anyTimes();
        EasyMock.expect((Object)this.m_nodeDao.load((Serializable)Integer.valueOf(3))).andReturn((Object)n2).anyTimes();
        this.createGetPackagesExpectation();
        EasyMock.expect((Object)this.m_ifaceDao.load((Serializable)Integer.valueOf(2))).andReturn((Object)ip1).anyTimes();
        EasyMock.expect((Object)this.m_ifaceDao.load((Serializable)Integer.valueOf(4))).andReturn((Object)ip2).anyTimes();
        this.m_mockUtils.replayAll();
        MockTransactionTemplate transTemplate = new MockTransactionTemplate();
        transTemplate.afterPropertiesSet();
        this.m_collectd.setCollectdConfigFactory(this.m_collectdConfigFactory);
        this.m_collectd.setEventIpcManager(this.m_eventIpcManager);
        this.m_collectd.setTransactionTemplate((TransactionTemplate)transTemplate);
        this.m_collectd.setIpInterfaceDao(this.m_ifaceDao);
        this.m_collectd.setNodeDao(this.m_nodeDao);
        this.m_collectd.setFilterDao(this.m_filterDao);
        this.m_collectd.setPersisterFactory((PersisterFactory)new MockPersisterFactory());
        this.m_collectd.setServiceCollectorRegistry((ServiceCollectorRegistry)new DefaultServiceCollectorRegistry());
        this.m_collectd.setLocationAwareCollectorClient(CollectorTestUtils.createLocationAwareCollectorClient());
        this.m_collectd.afterPropertiesSet();
        this.m_collectd.start();
    }

    private void verify() throws Exception {
        Thread.sleep(10000L);
        int successfulCollections = 5;
        this.m_collectd.stop();
        this.m_mockUtils.verifyAll();
        MockLogAppender.assertNoWarningsOrGreater();
        Assert.assertTrue((successfulCollections <= this.countMessages("collector.collect: begin:testPackage/1/192.168.1.1/SNMP") ? 1 : 0) != 0);
        Assert.assertTrue((successfulCollections <= this.countMessages("collector.collect: end:testPackage/1/192.168.1.1/SNMP") ? 1 : 0) != 0);
        Assert.assertTrue((successfulCollections <= this.countMessages("collector.collect: begin:testPackage/3/192.168.1.1/SNMP") ? 1 : 0) != 0);
        Assert.assertTrue((successfulCollections <= this.countMessages("collector.collect: end:testPackage/3/192.168.1.1/SNMP") ? 1 : 0) != 0);
    }

    private int countMessages(String message) {
        int c = 0;
        for (LoggingEvent event : MockLogAppender.getEventsAtLevel((Level)Level.INFO)) {
            if (!event.getLevel().eq(Level.INFO) || !event.getMessage().contains(message)) continue;
            ++c;
        }
        LOG.info("Message {} found {} times.", (Object)message, (Object)c);
        return c;
    }

    private void createGetPackagesExpectation() {
        Package pkg = new Package();
        pkg.setName("testPackage");
        Filter filter = new Filter();
        filter.setContent("ipaddr != '0.0.0.0'");
        pkg.setFilter(filter);
        Service collector = new Service();
        collector.setName("SNMP");
        collector.setStatus("on");
        collector.setInterval(Long.valueOf(1000L));
        collector.addParameter("thresholding-enabled", "false");
        pkg.addService(collector);
        EasyMock.expect((Object)this.m_collectdConfiguration.getPackages()).andReturn(Collections.singletonList(pkg)).anyTimes();
        EasyMock.expect((Object)this.m_collectdConfigFactory.interfaceInPackage((OnmsIpInterface)EasyMock.anyObject(OnmsIpInterface.class), (Package)EasyMock.eq((Object)pkg))).andReturn((Object)true).anyTimes();
    }
}

