/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.net.InetAddress;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.enlinkd.Discovery;
import org.opennms.netmgt.enlinkd.EnhancedLinkd;
import org.opennms.netmgt.enlinkd.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NodeDiscovery
extends Discovery {
    private static final Logger LOG = LoggerFactory.getLogger(NodeDiscovery.class);
    protected final Node m_node;

    public NodeDiscovery(EnhancedLinkd linkd, Node node) {
        super(linkd, linkd.getRescanInterval(), linkd.getInitialSleepTime());
        this.m_node = node;
    }

    protected abstract void runNodeDiscovery();

    @Override
    public void runDiscovery() {
        if (this.m_suspendCollection) {
            this.sendSuspendedEvent(this.getNodeId());
        } else {
            this.sendStartEvent(this.getNodeId());
            LOG.info("run: node [{}], start {} collection.", (Object)this.getNodeId(), (Object)this.getName());
            this.runNodeDiscovery();
            LOG.info("run: node [{}], end {} collection.", (Object)this.getNodeId(), (Object)this.getName());
            this.sendCompletedEvent(this.getNodeId());
        }
    }

    public InetAddress getPrimaryIpAddress() {
        return this.m_node.getSnmpPrimaryIpAddr();
    }

    public String getPrimaryIpAddressString() {
        return InetAddressUtils.str((InetAddress)this.m_node.getSnmpPrimaryIpAddr());
    }

    @Override
    public String getInfo() {
        return this.getName() + " node=" + this.getNodeId() + " ip=" + InetAddressUtils.str((InetAddress)this.getPrimaryIpAddress());
    }

    public int getNodeId() {
        return this.m_node.getNodeId();
    }

    public String getSysoid() {
        return this.m_node.getSysoid();
    }

    public String getSysname() {
        return this.m_node.getSysname();
    }

    public String getLocation() {
        return this.m_node.getLocation();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.m_initial_sleep_time ^ this.m_initial_sleep_time >>> 32);
        result = 31 * result + (this.m_node == null ? 0 : this.m_node.hashCode());
        result = 31 * result + (int)(this.m_poll_interval ^ this.m_poll_interval >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeDiscovery other = (NodeDiscovery)obj;
        if (this.m_initial_sleep_time != other.m_initial_sleep_time) {
            return false;
        }
        if (this.m_node == null ? other.m_node != null : !this.m_node.equals(other.m_node)) {
            return false;
        }
        return this.m_poll_interval == other.m_poll_interval;
    }
}

