/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmpinterfacepoller.pollable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.scheduler.ReadyRunnable;
import org.opennms.netmgt.scheduler.Schedule;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmpinterfacepoller.SnmpPollInterfaceMonitor;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollContext;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollableInterface;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollableSnmpInterfaceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollableSnmpInterface
implements ReadyRunnable {
    private static final Logger LOG = LoggerFactory.getLogger(PollableSnmpInterface.class);
    private volatile Schedule m_schedule;
    private Map<Integer, OnmsSnmpInterface> m_snmpinterfaces;
    private PollableSnmpInterfaceConfig m_snmppollableconfig;
    private PollableInterface m_parent;
    private String m_name;
    private String m_criteria;
    private SnmpAgentConfig m_agentConfig;

    public Collection<OnmsSnmpInterface> getSnmpinterfaces() {
        return this.m_snmpinterfaces.values();
    }

    public void setSnmpinterfaces(List<OnmsSnmpInterface> snmpinterfaces) {
        if (snmpinterfaces == null || snmpinterfaces.isEmpty()) {
            LOG.debug("setting snmpinterfaces: got null, thread instantiated but at moment no interface found");
            return;
        }
        HashMap<Integer, Integer> oldStatuses = new HashMap<Integer, Integer>();
        for (Integer ifIndex : this.m_snmpinterfaces.keySet()) {
            OnmsSnmpInterface iface = this.m_snmpinterfaces.get(ifIndex);
            if (iface == null || iface.getIfOperStatus() == null) continue;
            oldStatuses.put(ifIndex, iface.getIfOperStatus());
        }
        this.m_snmpinterfaces.clear();
        for (OnmsSnmpInterface iface : snmpinterfaces) {
            LOG.debug("setting snmpinterface:", (Object)iface.toString());
            if (iface == null || iface.getIfIndex() == null || iface.getIfIndex() <= 0) continue;
            Integer oldStatus = (Integer)oldStatuses.get(iface.getIfIndex());
            LOG.debug("setting snmpinterface (oldStatus={}):{}", (Object)oldStatus, (Object)iface.toString());
            this.m_snmpinterfaces.put(iface.getIfIndex(), iface);
            if (iface.getIfAdminStatus() == null || !iface.getIfAdminStatus().equals(1) || iface.getIfOperStatus() == null || !iface.getIfOperStatus().equals(2) || oldStatus != null && iface.getIfOperStatus().intValue() == oldStatus.intValue()) continue;
            this.sendOperDownEvent(iface);
        }
    }

    public PollableSnmpInterface(PollableInterface parent) {
        this.m_parent = parent;
        this.m_snmpinterfaces = new HashMap<Integer, OnmsSnmpInterface>();
    }

    public Schedule getSchedule() {
        return this.m_schedule;
    }

    public void setSchedule(Schedule schedule) {
        this.m_schedule = schedule;
    }

    public PollableSnmpInterfaceConfig getSnmppollableconfig() {
        return this.m_snmppollableconfig;
    }

    public void setSnmppollableconfig(PollableSnmpInterfaceConfig snmppollableconfig) {
        this.m_snmppollableconfig = snmppollableconfig;
    }

    public PollableInterface getParent() {
        return this.m_parent;
    }

    public PollContext getContext() {
        return this.getParent().getContext();
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public void run() {
        if (this.getParent().polling()) {
            String location = this.getContext().getLocation(this.getParent().getNodeid());
            LOG.info("run: polling SNMP interfaces on package/interface {}/{} on primary address: {} at location {}", new Object[]{this.getParent().getPackageName(), this.getName(), this.getParent().getIpaddress(), location});
            if (this.m_snmpinterfaces == null || this.m_snmpinterfaces.isEmpty()) {
                LOG.debug("No Interface found. Doing nothing");
            } else {
                LOG.debug("{} Interfaces found. Getting Statutes....", (Object)this.m_snmpinterfaces.size());
                SnmpPollInterfaceMonitor pollMonitor = new SnmpPollInterfaceMonitor(this.getContext().getLocationAwareSnmpClient());
                pollMonitor.setLocation(location);
                pollMonitor.setInterval(this.getSnmppollableconfig().getInterval());
                int maxiface = this.getMaxInterfacePerPdu();
                if (maxiface == 0) {
                    maxiface = this.m_snmpinterfaces.size();
                }
                LOG.debug("Max Interface Per Pdu is: {}", (Object)maxiface);
                List<SnmpMinimalPollInterface> mifaces = this.getSnmpMinimalPollInterface();
                int start = 0;
                while (start + maxiface < this.m_snmpinterfaces.size()) {
                    this.doPoll(pollMonitor, mifaces.subList(start, start + maxiface));
                    start += maxiface;
                }
                this.doPoll(pollMonitor, mifaces.subList(start, this.m_snmpinterfaces.size()));
            }
        } else {
            LOG.info("not polling: {}", (Object)this.getParent().getIpaddress());
        }
    }

    private void doPoll(SnmpPollInterfaceMonitor pollMonitor, List<SnmpMinimalPollInterface> mifaces) {
        LOG.info("doPoll: input interfaces number: {}", (Object)mifaces.size());
        mifaces = pollMonitor.poll(this.getAgentConfig(), mifaces);
        boolean refresh = false;
        Date now = this.getDate();
        if (mifaces != null) {
            LOG.info("doPoll: PollerMonitor return interfaces number: {}", (Object)mifaces.size());
            for (SnmpMinimalPollInterface miface : mifaces) {
                LOG.debug("Working on interface with ifindex: {}", (Object)miface.getIfindex());
                LOG.debug("Interface PollStatus is {}", (Object)miface.getStatus().getStatusName());
                if (miface.getStatus().isUp()) {
                    OnmsSnmpInterface iface = this.m_snmpinterfaces.get(miface.getIfindex());
                    LOG.debug("Previous status Admin/Oper: {}/{}", (Object)iface.getIfAdminStatus(), (Object)iface.getIfOperStatus());
                    LOG.debug("Current status Admin/Oper: {}/{}", (Object)miface.getAdminstatus(), (Object)miface.getOperstatus());
                    if (miface.getAdminstatus() == 1 && iface.getIfAdminStatus() == 1 && miface.getOperstatus() == 2 && iface.getIfOperStatus() == 1) {
                        this.sendOperDownEvent(iface);
                    }
                    if (miface.getAdminstatus() == 1 && iface.getIfAdminStatus() == 1 && miface.getOperstatus() == 1 && iface.getIfOperStatus() == 2) {
                        this.sendOperUpEvent(iface);
                    }
                    if (miface.getAdminstatus() == 2 && iface.getIfAdminStatus() == 1) {
                        this.sendAdminDownEvent(iface);
                    }
                    if (miface.getAdminstatus() == 1 && iface.getIfAdminStatus() == 2 && miface.getOperstatus() != 1) {
                        this.sendAdminUpEvent(iface);
                    }
                    if (miface.getAdminstatus() == 1 && iface.getIfAdminStatus() == 2 && miface.getOperstatus() == 1) {
                        this.sendAdminUpEvent(iface);
                        this.sendOperUpEvent(iface);
                    }
                    iface.setIfAdminStatus(Integer.valueOf(miface.getAdminstatus()));
                    iface.setIfOperStatus(Integer.valueOf(miface.getOperstatus()));
                    iface.setLastSnmpPoll(now);
                    try {
                        this.update(iface);
                    }
                    catch (Throwable e) {
                        LOG.warn("Failing updating Interface {} {}", (Object)iface.getIfName(), (Object)e.getLocalizedMessage());
                        refresh = true;
                    }
                    continue;
                }
                LOG.debug("No {} data available for interface.", (Object)this.getContext().getServiceName());
            }
            if (refresh) {
                this.getParent().getParent().refresh(this.getParent().getNodeid());
            }
        } else {
            LOG.error("the monitor return null object");
        }
    }

    private void update(OnmsSnmpInterface iface) {
        this.getContext().update(iface);
    }

    private void sendAdminUpEvent(OnmsSnmpInterface iface) {
        this.getContext().sendEvent(this.getContext().createEvent("uei.opennms.org/nodes/snmp/interfaceAdminUp", this.getParent().getNodeid(), this.getParent().getIpaddress(), this.getParent().getNetMask(), this.getDate(), iface));
    }

    private void sendAdminDownEvent(OnmsSnmpInterface iface) {
        this.getContext().sendEvent(this.getContext().createEvent("uei.opennms.org/nodes/snmp/interfaceAdminDown", this.getParent().getNodeid(), this.getParent().getIpaddress(), this.getParent().getNetMask(), this.getDate(), iface));
    }

    private void sendOperUpEvent(OnmsSnmpInterface iface) {
        this.getContext().sendEvent(this.getContext().createEvent("uei.opennms.org/nodes/snmp/interfaceOperUp", this.getParent().getNodeid(), this.getParent().getIpaddress(), this.getParent().getNetMask(), this.getDate(), iface));
    }

    private void sendOperDownEvent(OnmsSnmpInterface iface) {
        this.getContext().sendEvent(this.getContext().createEvent("uei.opennms.org/nodes/snmp/interfaceOperDown", this.getParent().getNodeid(), this.getParent().getIpaddress(), this.getParent().getNetMask(), this.getDate(), iface));
    }

    private Date getDate() {
        return new Date();
    }

    private SnmpMinimalPollInterface getMinimalFromOnmsSnmpInterface(OnmsSnmpInterface iface) {
        int adminStatus = 1;
        int operStatus = 1;
        if (iface.getIfAdminStatus() != null) {
            adminStatus = iface.getIfAdminStatus();
        } else {
            iface.setIfAdminStatus(Integer.valueOf(0));
        }
        if (iface.getIfOperStatus() != null) {
            operStatus = iface.getIfOperStatus();
        } else {
            iface.setIfOperStatus(Integer.valueOf(0));
        }
        return new SnmpMinimalPollInterface(iface.getIfIndex(), adminStatus, operStatus);
    }

    private List<SnmpMinimalPollInterface> getSnmpMinimalPollInterface() {
        ArrayList<SnmpMinimalPollInterface> mifaces = new ArrayList<SnmpMinimalPollInterface>();
        for (OnmsSnmpInterface iface : this.getSnmpinterfaces()) {
            mifaces.add(this.getMinimalFromOnmsSnmpInterface(iface));
        }
        return mifaces;
    }

    public void schedule() {
        if (this.m_schedule == null) {
            throw new IllegalStateException("Cannot schedule a service whose schedule is set to null");
        }
        this.m_schedule.schedule();
    }

    protected void delete() {
        this.m_schedule.unschedule();
    }

    public SnmpAgentConfig getAgentConfig() {
        return this.m_agentConfig;
    }

    public void setAgentConfig(SnmpAgentConfig config) {
        this.m_agentConfig = config;
    }

    public String getCriteria() {
        return this.m_criteria;
    }

    public void setCriteria(String m_criteria) {
        this.m_criteria = m_criteria;
    }

    public int getMaxInterfacePerPdu() {
        return this.getAgentConfig().getMaxVarsPerPdu();
    }

    public static class SnmpMinimalPollInterface {
        static final int IF_UP = 1;
        static final int IF_DOWN = 2;
        static final int IF_UNKNOWN = 0;
        private final String[] s_statusNames = new String[]{"Unknown", "InterfaceUp", "InterfaceDown"};
        int ifindex;
        int adminstatus;
        int operstatus;
        PollStatus m_status;

        public SnmpMinimalPollInterface(int ifindex, int adminstatus, int operstatus) {
            this.ifindex = ifindex;
            this.adminstatus = adminstatus;
            this.operstatus = operstatus;
            this.m_status = PollStatus.unknown();
        }

        public String decodeStatus(int status) {
            if (status >= 0 && status <= 2) {
                return this.s_statusNames[status];
            }
            return this.s_statusNames[0];
        }

        public int getIfindex() {
            return this.ifindex;
        }

        public void setIfindex(int ifindex) {
            this.ifindex = ifindex;
        }

        public int getAdminstatus() {
            return this.adminstatus;
        }

        public void setAdminstatus(int adminstatus) {
            this.adminstatus = adminstatus > 2 ? 0 : adminstatus;
        }

        public int getOperstatus() {
            return this.operstatus;
        }

        public void setOperstatus(int operstatus) {
            if (operstatus > 2) {
                this.operstatus = 0;
            }
            this.operstatus = operstatus;
        }

        public PollStatus getStatus() {
            return this.m_status;
        }

        public void setStatus(PollStatus status) {
            this.m_status = status;
        }
    }
}

