/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.pollables;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.pollables.PollContext;
import org.opennms.netmgt.poller.pollables.PollableContainer;
import org.opennms.netmgt.poller.pollables.PollableElement;
import org.opennms.netmgt.poller.pollables.PollableNetwork;
import org.opennms.netmgt.poller.pollables.PollableNode;
import org.opennms.netmgt.poller.pollables.PollableService;
import org.opennms.netmgt.poller.pollables.PollableVisitor;
import org.opennms.netmgt.poller.pollables.PollableVisitorAdaptor;
import org.opennms.netmgt.poller.pollables.Scope;
import org.opennms.netmgt.xml.event.Event;

public class PollableInterface
extends PollableContainer {
    private final InetAddress m_addr;

    public PollableInterface(PollableNode node, InetAddress addr) {
        super(node, Scope.INTERFACE);
        this.m_addr = addr;
    }

    public PollableNode getNode() {
        return (PollableNode)this.getParent();
    }

    private void setNode(PollableNode newNode) {
        this.setParent(newNode);
    }

    public PollableNetwork getNetwork() {
        return this.getNode().getNetwork();
    }

    @Override
    public PollContext getContext() {
        return this.getNode().getContext();
    }

    public String getIpAddr() {
        return InetAddressUtils.str((InetAddress)this.m_addr);
    }

    public InetAddress getAddress() {
        return this.m_addr;
    }

    public int getNodeId() {
        return this.getNode().getNodeId();
    }

    public String getNodeLabel() {
        return this.getNode().getNodeLabel();
    }

    public String getNodeLocation() {
        return this.getNode().getNodeLocation();
    }

    public PollableService createService(final String svcName) {
        return this.withTreeLock(new Callable<PollableService>(){

            @Override
            public PollableService call() {
                PollableService svc = new PollableService(PollableInterface.this, svcName);
                PollableInterface.this.addMember(svc);
                return svc;
            }
        });
    }

    public PollableService getService(String svcName) {
        return (PollableService)this.getMember(svcName);
    }

    public List<PollableService> getServices() {
        ArrayList<PollableService> services = new ArrayList<PollableService>();
        for (PollableElement pe : this.getMembers()) {
            if (!(pe instanceof PollableService)) continue;
            services.add((PollableService)pe);
        }
        return services;
    }

    @Override
    protected Object createMemberKey(PollableElement member) {
        PollableService svc = (PollableService)member;
        return svc.getSvcName();
    }

    @Override
    protected void visitThis(PollableVisitor v) {
        super.visitThis(v);
        v.visitInterface(this);
    }

    @Override
    public void recalculateStatus() {
        PollableService criticalSvc = this.getCriticalService();
        if (criticalSvc != null) {
            criticalSvc.recalculateStatus();
            this.updateStatus(criticalSvc.getStatus().isUp() ? PollStatus.up() : PollStatus.down());
        } else {
            super.recalculateStatus();
        }
    }

    private PollableService getCriticalService() {
        return this.getService(this.getContext().getCriticalServiceName());
    }

    @Override
    public PollableElement selectPollElement() {
        PollableService critSvc = this.getCriticalService();
        return critSvc != null ? critSvc : super.selectPollElement();
    }

    @Override
    protected PollStatus poll(PollableElement elem) {
        PollableService critSvc = this.getCriticalService();
        if (this.getStatus().isUp() || critSvc == null || elem == critSvc) {
            return super.poll(elem);
        }
        return PollStatus.down();
    }

    @Override
    public PollStatus pollRemainingMembers(PollableElement member) {
        PollableService critSvc = this.getCriticalService();
        if (critSvc != null && this.getStatus().isUp()) {
            if (member != critSvc) {
                critSvc.poll();
            }
            return critSvc.getStatus().isUp() ? PollStatus.up() : PollStatus.down();
        }
        if (this.getContext().isPollingAllIfCritServiceUndefined()) {
            return super.pollRemainingMembers(member);
        }
        return this.getMemberStatus();
    }

    @Override
    public Event createDownEvent(Date date) {
        return this.getContext().createEvent("uei.opennms.org/nodes/interfaceDown", this.getNodeId(), this.getAddress(), null, date, this.getStatus().getReason());
    }

    @Override
    public Event createUpEvent(Date date) {
        return this.getContext().createEvent("uei.opennms.org/nodes/interfaceUp", this.getNodeId(), this.getAddress(), null, date, this.getStatus().getReason());
    }

    public String toString() {
        return "PollableInterface [" + this.getNode() + ":" + this.getIpAddr() + "]";
    }

    public void reparentTo(final PollableNode newNode) {
        final PollableNode oldNode = this.getNode();
        if (oldNode.equals(newNode)) {
            return;
        }
        PollableNode firstNode = oldNode.getNodeId() <= newNode.getNodeId() ? oldNode : newNode;
        final PollableNode secondNode = oldNode.getNodeId() <= newNode.getNodeId() ? newNode : oldNode;
        final Runnable reparent = new Runnable(){

            @Override
            public void run() {
                oldNode.resetStatusChanged();
                newNode.resetStatusChanged();
                oldNode.removeMember(PollableInterface.this);
                newNode.addMember(PollableInterface.this);
                PollableInterface.this.setNode(newNode);
                if ((PollableInterface.this.getCause() == null || PollableInterface.this.getCause().equals(oldNode.getCause())) && newNode.getCause() != null) {
                    PollableVisitorAdaptor visitor = new PollableVisitorAdaptor(){

                        @Override
                        public void visitElement(PollableElement element) {
                            boolean matches;
                            boolean bl = element.getCause() == null ? oldNode.getCause() == null : (matches = element.getCause().equals(oldNode.getCause()));
                            if (matches) {
                                element.setCause(newNode.getCause());
                            }
                        }
                    };
                    PollableInterface.this.visit(visitor);
                }
                Date date = new Date();
                oldNode.recalculateStatus();
                oldNode.processStatusChange(date);
                newNode.recalculateStatus();
                newNode.processStatusChange(date);
            }
        };
        Runnable lockSecondNodeAndRun = new Runnable(){

            @Override
            public void run() {
                secondNode.withTreeLock(reparent);
            }
        };
        firstNode.withTreeLock(lockSecondNodeAndRun);
    }
}

