/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Map;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.support.NtpMessage;
import org.opennms.netmgt.poller.support.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable
public final class NtpMonitor
extends AbstractServiceMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(NtpMonitor.class);
    private static final int DEFAULT_PORT = 123;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 5000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 5000);
        int port = ParameterMap.getKeyedInteger(parameters, (String)"port", (int)123);
        InetAddress ipAddr = svc.getAddress();
        PollStatus serviceStatus = PollStatus.unavailable();
        double responseTime = -1.0;
        try (DatagramSocket socket = null;){
            socket = new DatagramSocket();
            socket.setSoTimeout(tracker.getSoTimeout());
            tracker.reset();
            while (tracker.shouldRetry() && !serviceStatus.isAvailable()) {
                try {
                    byte[] data = new NtpMessage().toByteArray();
                    DatagramPacket outgoing = new DatagramPacket(data, data.length, ipAddr, port);
                    tracker.startAttempt();
                    socket.send(outgoing);
                    DatagramPacket incoming = new DatagramPacket(data, data.length);
                    socket.receive(incoming);
                    responseTime = tracker.elapsedTimeInMillis();
                    double destinationTimestamp = (double)System.currentTimeMillis() / 1000.0 + 2.2089888E9;
                    NtpMessage msg = new NtpMessage(incoming.getData());
                    double localClockOffset = (msg.receiveTimestamp - msg.originateTimestamp + (msg.transmitTimestamp - destinationTimestamp)) / 2.0;
                    LOG.debug("poll: valid NTP request received the local clock offset is {}, responseTime= {}ms", (Object)localClockOffset, (Object)responseTime);
                    LOG.debug("poll: NTP message : {}", (Object)msg);
                    serviceStatus = PollStatus.available(responseTime);
                }
                catch (InterruptedIOException data) {
                    // empty catch block
                }
                tracker.nextAttempt();
            }
        }
        return serviceStatus;
    }
}

