/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller;

import org.opennms.netmgt.collection.api.AttributeType;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.poller.LatencyCollectionAttributeType;
import org.opennms.netmgt.poller.LatencyCollectionResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LatencyCollectionAttribute
implements CollectionAttribute {
    private static final Logger LOG = LoggerFactory.getLogger(LatencyCollectionAttribute.class);
    private LatencyCollectionResource m_resource;
    private LatencyCollectionAttributeType m_type;
    private Double m_value;
    private String m_name;

    public LatencyCollectionAttribute(LatencyCollectionResource resource, LatencyCollectionAttributeType type, String name, Double value) {
        this.m_resource = resource;
        this.m_type = type;
        this.m_name = name;
        this.m_value = value;
    }

    public LatencyCollectionAttributeType getAttributeType() {
        return this.m_type;
    }

    public String getName() {
        return this.m_name;
    }

    public Double getNumericValue() {
        return this.m_value;
    }

    public CollectionResource getResource() {
        return this.m_resource;
    }

    public String getStringValue() {
        return null;
    }

    public AttributeType getType() {
        return AttributeType.GAUGE;
    }

    public boolean shouldPersist(ServiceParameters params) {
        return true;
    }

    public void storeAttribute(Persister persister) {
        this.getAttributeType().storeAttribute(this, persister);
    }

    public void visit(CollectionSetVisitor visitor) {
        LOG.debug("Visiting attribute {}", (Object)this);
        visitor.visitAttribute((CollectionAttribute)this);
        visitor.completeAttribute((CollectionAttribute)this);
    }

    public String getMetricIdentifier() {
        return String.format("%s/%s", this.m_resource.getServiceName(), this.m_resource.getIpAddress());
    }

    public String toString() {
        return String.format("%s: %f", this.m_name, this.m_value);
    }
}

