/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.IOUtils;
import org.opennms.core.spring.BeanUtils;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.notifd.Argument;
import org.opennms.netmgt.model.notifd.NotificationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class BSFNotificationStrategy
implements NotificationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(BSFNotificationStrategy.class);
    private List<Argument> m_arguments;
    private Map<String, String> m_notifParams = new HashMap<String, String>();
    private static BSFManager s_bsfManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized int executeScript(String fileName, BSFNotificationStrategy obj) {
        String lang = obj.getLangClass();
        String engine = obj.getBsfEngine();
        String runType = obj.getBsfRunType();
        String[] extensions = obj.getFileExtensions();
        LOG.info("Loading notification script from file '{}'", (Object)fileName);
        File scriptFile = new File(fileName);
        int ret = -1;
        try {
            if (lang == null) {
                lang = BSFManager.getLangFromFilename((String)fileName);
            }
            HashMap<String, String> results = new HashMap<String, String>();
            s_bsfManager.declareBean("results", results, Map.class);
            BSFNotificationStrategy.declareBeans(obj);
            if (engine != null && lang != null && extensions != null && extensions.length > 0) {
                LOG.debug("Registering scripting engine '{}' for '{}'", (Object)engine, (Object)lang);
                BSFManager.registerScriptingEngine((String)lang, (String)engine, (String[])extensions);
            }
            if (scriptFile.exists() && scriptFile.canRead()) {
                String code = IOUtils.getStringFromReader((Reader)new InputStreamReader((InputStream)new FileInputStream(scriptFile), StandardCharsets.UTF_8));
                obj.checkAberrantScriptBehaviors(code);
                if ("eval".equals(runType)) {
                    results.put("status", s_bsfManager.eval(lang, "BSFNotificationStrategy", 0, 0, (Object)code).toString());
                } else if ("exec".equals(runType)) {
                    s_bsfManager.exec(lang, "BSFNotificationStrategy", 0, 0, (Object)code);
                } else {
                    LOG.warn("Invalid run-type parameter value '{}' for BSF notification script '{}'. Only 'eval' and 'exec' are supported.", (Object)runType, (Object)scriptFile);
                }
                if ("OK".equals(results.get("status"))) {
                    LOG.info("Execution succeeded and successful status passed back for script '{}'", (Object)scriptFile);
                    ret = 0;
                } else {
                    LOG.warn("Execution succeeded for script '{}', but script did not indicate successful notification by putting an entry into the 'results' bean with key 'status' and value 'OK'", (Object)scriptFile);
                    ret = -1;
                }
            } else {
                LOG.warn("Cannot locate or read BSF script file '{}'. Returning failure indication.", (Object)fileName);
                ret = -1;
            }
        }
        catch (BSFException e) {
            LOG.warn("Execution of script '{}' failed with BSFException: {}", new Object[]{scriptFile, e.getMessage(), e});
            ret = -1;
        }
        catch (FileNotFoundException e) {
            LOG.warn("Could not find BSF script file '{}'.", (Object)fileName);
            ret = -1;
        }
        catch (IOException e) {
            LOG.warn("Execution of script '{}' failed with IOException: {}", new Object[]{scriptFile, e.getMessage(), e});
            ret = -1;
        }
        catch (Throwable e) {
            LOG.warn("Execution of script '{}' failed with unexpected throwable: {}", new Object[]{scriptFile, e.getMessage(), e});
            ret = -1;
        }
        finally {
            BSFNotificationStrategy.undeclareBean("results");
            BSFNotificationStrategy.undeclareBeans(obj);
        }
        LOG.debug("Finished running BSF script notification.");
        return ret;
    }

    public int send(List<Argument> arguments) {
        this.m_arguments = arguments;
        String fileName = this.getFileName();
        int returnCode = BSFNotificationStrategy.executeScript(fileName, this);
        return returnCode;
    }

    private static void declareBeans(BSFNotificationStrategy obj) throws BSFException {
        Integer nodeId;
        obj.retrieveParams();
        try {
            nodeId = Integer.valueOf(obj.m_notifParams.get("-nodeid"));
        }
        catch (NumberFormatException nfe) {
            nodeId = null;
        }
        OnmsNode node = null;
        OnmsAssetRecord assets = null;
        final ArrayList categories = new ArrayList();
        String nodeLabel = null;
        String foreignSource = null;
        String foreignId = null;
        if (nodeId != null) {
            BeanFactoryReference bf = BeanUtils.getBeanFactory((String)"notifdContext");
            final NodeDao nodeDao = (NodeDao)BeanUtils.getBean((BeanFactoryReference)bf, (String)"nodeDao", NodeDao.class);
            TransactionTemplate transTemplate = (TransactionTemplate)BeanUtils.getBean((BeanFactoryReference)bf, (String)"transactionTemplate", TransactionTemplate.class);
            try {
                final int theNodeId = nodeId;
                node = (OnmsNode)transTemplate.execute((TransactionCallback)new TransactionCallback<OnmsNode>(){

                    public OnmsNode doInTransaction(TransactionStatus status) {
                        OnmsNode node = (OnmsNode)nodeDao.get((Serializable)Integer.valueOf(theNodeId));
                        if (node != null) {
                            for (OnmsCategory cat : node.getCategories()) {
                                categories.add(cat.getName());
                            }
                        }
                        return node;
                    }
                });
                if (node == null) {
                    LOG.error("Could not find a node with id: {}", (Object)theNodeId);
                } else {
                    nodeLabel = node.getLabel();
                    assets = node.getAssetRecord();
                    foreignSource = node.getForeignSource();
                    foreignId = node.getForeignId();
                }
            }
            catch (RuntimeException e) {
                LOG.error("Error while retrieving node with id {}", (Object)nodeId, (Object)e);
            }
        }
        s_bsfManager.declareBean("bsf_notif_strategy", (Object)obj, BSFNotificationStrategy.class);
        s_bsfManager.declareBean("logger", (Object)LOG, Logger.class);
        s_bsfManager.declareBean("notif_params", obj.m_notifParams, Map.class);
        s_bsfManager.declareBean("node_label", nodeLabel, String.class);
        s_bsfManager.declareBean("foreign_source", foreignSource, String.class);
        s_bsfManager.declareBean("foreign_id", foreignId, String.class);
        s_bsfManager.declareBean("node_assets", assets, OnmsAssetRecord.class);
        s_bsfManager.declareBean("node_categories", categories, List.class);
        s_bsfManager.declareBean("node", (Object)node, OnmsNode.class);
        for (Argument arg : obj.m_arguments) {
            if ("-tm".equals(arg.getSwitch())) {
                s_bsfManager.declareBean("text_message", (Object)arg.getValue(), String.class);
            }
            if ("-nm".equals(arg.getSwitch())) {
                s_bsfManager.declareBean("numeric_message", (Object)arg.getValue(), String.class);
            }
            if ("-nodeid".equals(arg.getSwitch())) {
                s_bsfManager.declareBean("node_id", (Object)arg.getValue(), String.class);
            }
            if ("-interface".equals(arg.getSwitch())) {
                s_bsfManager.declareBean("ip_addr", (Object)arg.getValue(), String.class);
            }
            if ("-service".equals(arg.getSwitch())) {
                s_bsfManager.declareBean("svc_name", (Object)arg.getValue(), String.class);
            }
            if ("-subject".equals(arg.getSwitch())) {
                s_bsfManager.declareBean("subject", (Object)arg.getValue(), String.class);
            }
            if ("-email".equals(arg.getSwitch())) {
                s_bsfManager.declareBean("email", (Object)arg.getValue(), String.class);
            }
            if ("-pemail".equals(arg.getSwitch())) {
                s_bsfManager.declareBean("pager_email", (Object)arg.getValue(), String.class);
            }
            if ("-xmpp".equals(arg.getSwitch())) {
                s_bsfManager.declareBean("xmpp_address", (Object)arg.getValue(), String.class);
            }
            if ("-tp".equals(arg.getSwitch())) {
                s_bsfManager.declareBean("text_pin", (Object)arg.getValue(), String.class);
            }
            if ("-np".equals(arg.getSwitch())) {
                s_bsfManager.declareBean("numeric_pin", (Object)arg.getValue(), String.class);
            }
            if ("-wphone".equals(arg.getSwitch())) {
                s_bsfManager.declareBean("work_phone", (Object)arg.getValue(), String.class);
            }
            if ("-hphone".equals(arg.getSwitch())) {
                s_bsfManager.declareBean("home_phone", (Object)arg.getValue(), String.class);
            }
            if ("-mphone".equals(arg.getSwitch())) {
                s_bsfManager.declareBean("mobile_phone", (Object)arg.getValue(), String.class);
            }
            if ("-tuipin".equals(arg.getSwitch())) {
                s_bsfManager.declareBean("phone_pin", (Object)arg.getValue(), String.class);
            }
            if (!"-ublog".equals(arg.getSwitch())) continue;
            s_bsfManager.declareBean("microblog_username", (Object)arg.getValue(), String.class);
        }
    }

    private static void undeclareBean(String beanName) {
        try {
            s_bsfManager.undeclareBean(beanName);
        }
        catch (BSFException e) {
            LOG.warn("Unable to undeclareBean '{}'", (Object)beanName);
        }
    }

    private static void undeclareBeans(BSFNotificationStrategy obj) {
        BSFNotificationStrategy.undeclareBean("logger");
        BSFNotificationStrategy.undeclareBean("bsf_notif_strategy");
        BSFNotificationStrategy.undeclareBean("notif_params");
        BSFNotificationStrategy.undeclareBean("node_label");
        BSFNotificationStrategy.undeclareBean("foreign_source");
        BSFNotificationStrategy.undeclareBean("foreign_id");
        BSFNotificationStrategy.undeclareBean("node_assets");
        BSFNotificationStrategy.undeclareBean("node_categories");
        BSFNotificationStrategy.undeclareBean("node");
        for (Argument arg : obj.m_arguments) {
            if ("-tm".equals(arg.getSwitch())) {
                BSFNotificationStrategy.undeclareBean("text_message");
            }
            if ("-nm".equals(arg.getSwitch())) {
                BSFNotificationStrategy.undeclareBean("numeric_message");
            }
            if ("-nodeid".equals(arg.getSwitch())) {
                BSFNotificationStrategy.undeclareBean("node_id");
            }
            if ("-interface".equals(arg.getSwitch())) {
                BSFNotificationStrategy.undeclareBean("ip_addr");
            }
            if ("-service".equals(arg.getSwitch())) {
                BSFNotificationStrategy.undeclareBean("svc_name");
            }
            if ("-subject".equals(arg.getSwitch())) {
                BSFNotificationStrategy.undeclareBean("subject");
            }
            if ("-email".equals(arg.getSwitch())) {
                BSFNotificationStrategy.undeclareBean("email");
            }
            if ("-pemail".equals(arg.getSwitch())) {
                BSFNotificationStrategy.undeclareBean("pager_email");
            }
            if ("-xmpp".equals(arg.getSwitch())) {
                BSFNotificationStrategy.undeclareBean("xmpp_address");
            }
            if ("-tp".equals(arg.getSwitch())) {
                BSFNotificationStrategy.undeclareBean("text_pin");
            }
            if ("-np".equals(arg.getSwitch())) {
                BSFNotificationStrategy.undeclareBean("numeric_pin");
            }
            if ("-wphone".equals(arg.getSwitch())) {
                BSFNotificationStrategy.undeclareBean("work_phone");
            }
            if ("-hphone".equals(arg.getSwitch())) {
                BSFNotificationStrategy.undeclareBean("home_phone");
            }
            if ("-mphone".equals(arg.getSwitch())) {
                BSFNotificationStrategy.undeclareBean("mobile_phone");
            }
            if ("-tuipin".equals(arg.getSwitch())) {
                BSFNotificationStrategy.undeclareBean("phone_pin");
            }
            if (!"-ublog".equals(arg.getSwitch())) continue;
            BSFNotificationStrategy.undeclareBean("microblog_username");
        }
    }

    private String getSwitchValue(String argSwitch) {
        String value = null;
        for (Argument arg : this.m_arguments) {
            if (!arg.getSwitch().equals(argSwitch)) continue;
            value = arg.getValue();
        }
        if (value != null && value.equals("")) {
            value = null;
        }
        return value;
    }

    private String getSwitchSubstitution(String argSwitch) {
        String value = null;
        for (Argument arg : this.m_arguments) {
            if (!arg.getSwitch().equals(argSwitch)) continue;
            value = arg.getSubstitution();
        }
        if (value != null && value.equals("")) {
            value = null;
        }
        return value;
    }

    private void checkAberrantScriptBehaviors(String script) {
        if (script.matches("(?s)\\.exec\\s*\\(")) {
            // empty if block
        }
    }

    private String getFileName() {
        return this.getSwitchValue("file-name");
    }

    private String getLangClass() {
        return this.getSwitchValue("lang-class");
    }

    private String getBsfEngine() {
        return this.getSwitchValue("bsf-engine");
    }

    private String[] getFileExtensions() {
        String exts = this.getSwitchValue("file-extensions");
        if (exts == null) {
            return null;
        }
        return exts.split(",");
    }

    private String getBsfRunType() {
        String runType = this.getSwitchValue("run-type");
        if (runType == null) {
            runType = "exec";
        }
        return runType;
    }

    private void retrieveParams() {
        for (Argument arg : this.m_arguments) {
            this.m_notifParams.put(arg.getSwitch(), arg.getValue());
        }
    }

    public void log(String level, String format, Object ... args) {
        if ("TRACE".equals(level)) {
            LOG.trace(format, args);
        }
        if ("DEBUG".equals(level)) {
            LOG.debug(format, args);
        }
        if ("INFO".equals(level)) {
            LOG.info(format, args);
        }
        if ("WARN".equals(level)) {
            LOG.warn(format, args);
        }
        if ("ERROR".equals(level)) {
            LOG.error(format, args);
        }
        if ("FATAL".equals(level)) {
            LOG.error(format, args);
        }
    }

    static {
        LOG.debug("creating static BSFManager");
        s_bsfManager = new BSFManager();
    }
}

