/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import org.opennms.netmgt.enlinkd.EnhancedLinkd;
import org.opennms.netmgt.enlinkd.Node;
import org.opennms.netmgt.enlinkd.NodeDiscovery;
import org.opennms.netmgt.enlinkd.snmp.CdpCacheTableTracker;
import org.opennms.netmgt.enlinkd.snmp.CdpGlobalGroupTracker;
import org.opennms.netmgt.enlinkd.snmp.CdpInterfacePortNameGetter;
import org.opennms.netmgt.model.CdpElement;
import org.opennms.netmgt.model.CdpLink;
import org.opennms.netmgt.model.OspfElement;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeDiscoveryCdp
extends NodeDiscovery {
    private static final Logger LOG = LoggerFactory.getLogger(NodeDiscoveryCdp.class);

    public NodeDiscoveryCdp(EnhancedLinkd linkd, Node node) {
        super(linkd, node);
    }

    @Override
    protected void runNodeDiscovery() {
        Date now = new Date();
        CdpGlobalGroupTracker cdpGlobalGroup = new CdpGlobalGroupTracker();
        SnmpAgentConfig peer = this.m_linkd.getSnmpAgentConfig(this.getPrimaryIpAddress(), this.getLocation());
        try {
            this.m_linkd.getLocationAwareSnmpClient().walk(peer, (CollectionTracker)cdpGlobalGroup).withDescription("cdpGlobalGroup").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.info("run: node [{}]: ExecutionException: CDP_MIB not supported {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        catch (InterruptedException e) {
            LOG.info("run: node [{}]: InterruptedException: CDP_MIB not supported {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        if (cdpGlobalGroup.getCdpDeviceId() == null) {
            LOG.info("run: node [{}]: CDP_MIB not supported", (Object)this.getNodeId());
            return;
        }
        CdpElement cdpElement = cdpGlobalGroup.getCdpElement();
        this.m_linkd.getQueryManager().store(this.getNodeId(), cdpElement);
        if (cdpElement.getCdpGlobalRun() == OspfElement.TruthValue.FALSE) {
            LOG.info("run: node [{}]. CDP_MIB disabled.", (Object)this.getNodeId());
            return;
        }
        final ArrayList links = new ArrayList();
        CdpCacheTableTracker cdpCacheTable = new CdpCacheTableTracker(){

            @Override
            public void processCdpCacheRow(CdpCacheTableTracker.CdpCacheRow row) {
                links.add(row.getLink());
            }
        };
        try {
            this.m_linkd.getLocationAwareSnmpClient().walk(peer, (CollectionTracker)cdpCacheTable).withDescription("cdpCacheTable").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.debug("run: node [{}]: ExecutionException: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        catch (InterruptedException e) {
            LOG.debug("run: node [{}]: InterruptedException: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        CdpInterfacePortNameGetter cdpInterfacePortNameGetter = new CdpInterfacePortNameGetter(peer, this.m_linkd.getLocationAwareSnmpClient(), this.getLocation(), this.getNodeId());
        for (CdpLink link : links) {
            this.m_linkd.getQueryManager().store(this.getNodeId(), cdpInterfacePortNameGetter.get(link));
        }
        this.m_linkd.getQueryManager().reconcileCdp(this.getNodeId(), now);
    }

    @Override
    public String getName() {
        return "NodeDiscoveryCdp";
    }
}

