/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.core.spring.BeanUtils;
import org.opennms.netmgt.config.EnhancedLinkdConfig;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.enlinkd.DiscoveryBridgeDomains;
import org.opennms.netmgt.enlinkd.DiscoveryBridgeTopology;
import org.opennms.netmgt.enlinkd.EnhancedLinkdService;
import org.opennms.netmgt.enlinkd.Node;
import org.opennms.netmgt.enlinkd.NodeDiscovery;
import org.opennms.netmgt.enlinkd.NodeDiscoveryBridge;
import org.opennms.netmgt.enlinkd.NodeDiscoveryCdp;
import org.opennms.netmgt.enlinkd.NodeDiscoveryIpNetToMedia;
import org.opennms.netmgt.enlinkd.NodeDiscoveryIsis;
import org.opennms.netmgt.enlinkd.NodeDiscoveryLldp;
import org.opennms.netmgt.enlinkd.NodeDiscoveryOspf;
import org.opennms.netmgt.enlinkd.scheduler.ReadyRunnable;
import org.opennms.netmgt.enlinkd.scheduler.Scheduler;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.model.topology.BridgeForwardingTableEntry;
import org.opennms.netmgt.model.topology.BridgeTopologyException;
import org.opennms.netmgt.model.topology.BroadcastDomain;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class EnhancedLinkd
extends AbstractServiceDaemon {
    private static final Logger LOG = LoggerFactory.getLogger(EnhancedLinkd.class);
    private static final String LOG_PREFIX = "enlinkd";
    private Scheduler m_scheduler;
    private EnhancedLinkdService m_queryMgr;
    private EnhancedLinkdConfig m_linkdConfig;
    private List<Node> m_nodes;
    private volatile EventForwarder m_eventForwarder;
    @Autowired
    private LocationAwareSnmpClient m_locationAwareSnmpClient;
    private volatile Set<Integer> m_bridgecollectionsscheduled = new HashSet<Integer>();

    public EnhancedLinkd() {
        super(LOG_PREFIX);
    }

    protected void onInit() {
        BeanUtils.assertAutowiring((Object)((Object)this));
        Assert.state((this.m_eventForwarder != null ? 1 : 0) != 0, (String)"must set the eventForwarder property");
        LOG.debug("init: Loading nodes.....");
        this.m_nodes = this.m_queryMgr.getSnmpNodeList();
        Assert.notNull(this.m_nodes);
        LOG.debug("init: Nodes loaded.");
        LOG.debug("init: Loading Bridge Topology.....");
        this.m_queryMgr.loadBridgeTopology();
        LOG.debug("init: Bridge Topology loaded.");
        this.scheduleCollection();
        if (this.m_nodes.size() > 0 && this.m_linkdConfig.useBridgeDiscovery()) {
            this.scheduleDiscoveryBridgeDomain();
        }
    }

    public void scheduleDiscoveryBridgeDomain() {
        DiscoveryBridgeDomains discoverbridge = new DiscoveryBridgeDomains(this);
        LOG.debug("scheduleDiscoveryBridgeDomain: Scheduling {}", (Object)discoverbridge.getInfo());
        discoverbridge.setScheduler(this.m_scheduler);
        discoverbridge.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleCollection() {
        List<Node> list = this.m_nodes;
        synchronized (list) {
            for (Node node : this.m_nodes) {
                this.scheduleCollectionForNode(node);
            }
        }
    }

    private void scheduleCollectionForNode(Node node) {
        for (NodeDiscovery snmpcoll : this.getSnmpCollections(node)) {
            LOG.debug("ScheduleCollectionForNode: Scheduling {}", (Object)snmpcoll.getInfo());
            snmpcoll.setScheduler(this.m_scheduler);
            snmpcoll.schedule();
        }
    }

    public List<NodeDiscovery> getSnmpCollections(Node node) {
        ArrayList<NodeDiscovery> snmpcolls = new ArrayList<NodeDiscovery>();
        if (this.m_linkdConfig.useLldpDiscovery()) {
            LOG.debug("getSnmpCollections: adding Lldp Discovery: {}", (Object)node);
            snmpcolls.add(new NodeDiscoveryLldp(this, node));
        }
        if (this.m_linkdConfig.useCdpDiscovery()) {
            LOG.debug("getSnmpCollections: adding Cdp Discovery: {}", (Object)node);
            snmpcolls.add(new NodeDiscoveryCdp(this, node));
        }
        if (this.m_linkdConfig.useBridgeDiscovery()) {
            LOG.debug("getSnmpCollections: adding IpNetToMedia Discovery: {}", (Object)node);
            snmpcolls.add(new NodeDiscoveryIpNetToMedia(this, node));
            LOG.debug("getSnmpCollections: adding Bridge Discovery: {}", (Object)node);
            snmpcolls.add(new NodeDiscoveryBridge(this, node));
        }
        if (this.m_linkdConfig.useOspfDiscovery()) {
            LOG.debug("getSnmpCollections: adding Ospf Discovery: {}", (Object)node);
            snmpcolls.add(new NodeDiscoveryOspf(this, node));
        }
        if (this.m_linkdConfig.useIsisDiscovery()) {
            LOG.debug("getSnmpCollections: adding Is-Is Discovery: {}", (Object)node);
            snmpcolls.add(new NodeDiscoveryIsis(this, node));
        }
        return snmpcolls;
    }

    public DiscoveryBridgeTopology getNodeBridgeDiscoveryTopology(BroadcastDomain domain) {
        return new DiscoveryBridgeTopology(this, domain);
    }

    protected synchronized void onStart() {
        this.m_scheduler.start();
    }

    protected synchronized void onStop() {
        this.m_scheduler.stop();
        this.m_scheduler = null;
    }

    protected synchronized void onPause() {
        this.m_scheduler.pause();
    }

    protected synchronized void onResume() {
        this.m_scheduler.resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Node> getLinkableNodes() {
        List<Node> list = this.m_nodes;
        synchronized (list) {
            return this.m_nodes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scheduleNodeCollection(int nodeid) {
        Node node = this.getNode(nodeid);
        if (node != null) {
            LOG.debug("scheduleNodeCollection: Found Scheduled Linkable node {}. Skipping ", (Object)nodeid);
            return false;
        }
        LOG.debug("scheduleNodeCollection: Loading node {} from database", (Object)nodeid);
        node = this.m_queryMgr.getSnmpNode(nodeid);
        if (node == null) {
            LOG.warn("scheduleNodeCollection: Failed to get linkable node from database with ID {}. Exiting", (Object)nodeid);
            return false;
        }
        List<Node> list = this.m_nodes;
        synchronized (list) {
            LOG.debug("scheduleNodeCollection: adding node {} to the collection", (Object)node);
            this.m_nodes.add(node);
        }
        this.scheduleCollectionForNode(node);
        if (this.m_nodes.size() == 1 && this.m_linkdConfig.useBridgeDiscovery()) {
            this.scheduleDiscoveryBridgeDomain();
        }
        return true;
    }

    public boolean runSingleSnmpCollection(int nodeId) {
        boolean allready = true;
        Node node = this.m_queryMgr.getSnmpNode(nodeId);
        for (NodeDiscovery snmpColl : this.getSnmpCollections(node)) {
            if (!snmpColl.isReady()) {
                allready = false;
                continue;
            }
            snmpColl.runDiscovery();
        }
        return allready;
    }

    public void runTopologyDiscovery() {
        DiscoveryBridgeDomains snmpColl = new DiscoveryBridgeDomains(this);
        snmpColl.runDiscovery();
    }

    public void scheduleNodeBridgeTopologyDiscovery(BroadcastDomain domain, Map<Integer, Set<BridgeForwardingTableEntry>> updateBfpMap) {
        DiscoveryBridgeTopology bridgediscovery = this.getNodeBridgeDiscoveryTopology(domain);
        for (Integer bridgeid : updateBfpMap.keySet()) {
            bridgediscovery.addUpdatedBFT(bridgeid, updateBfpMap.get(bridgeid));
        }
        LOG.debug("scheduleBridgeTopologyDiscovery: Scheduling {}", (Object)bridgediscovery.getInfo());
        bridgediscovery.setScheduler(this.m_scheduler);
        bridgediscovery.schedule();
    }

    void wakeUpNodeCollection(int nodeid) {
        Node node = this.getNode(nodeid);
        if (node == null) {
            LOG.warn("wakeUpNodeCollection: node not found during scheduling with ID {}", (Object)nodeid);
            this.scheduleNodeCollection(nodeid);
        } else {
            List<NodeDiscovery> collections = this.getSnmpCollections(node);
            LOG.info("wakeUpNodeCollection: fetched SnmpCollections from scratch, iterating over {} objects to wake them up", (Object)collections.size());
            for (NodeDiscovery collection : collections) {
                ReadyRunnable rr = this.getReadyRunnable(collection);
                if (rr == null) {
                    LOG.warn("wakeUpNodeCollection: found null ReadyRunnable for nodeid {}", (Object)nodeid);
                    continue;
                }
                rr.wakeUp();
            }
        }
    }

    void deleteNode(int nodeid) {
        LOG.info("deleteNode: deleting LinkableNode for node {}", (Object)nodeid);
        Node node = this.removeNode(nodeid);
        if (node == null) {
            LOG.warn("deleteNode: node not found: {}", (Object)nodeid);
        } else {
            List<NodeDiscovery> collections = this.getSnmpCollections(node);
            LOG.info("deleteNode: fetched SnmpCollections from scratch, iterating over {} objects to delete", (Object)collections.size());
            for (NodeDiscovery collection : collections) {
                ReadyRunnable rr = this.getReadyRunnable(collection);
                if (rr == null) {
                    LOG.warn("deleteNode: found null ReadyRunnable for {}", (Object)collection.getInfo());
                    continue;
                }
                rr.unschedule();
            }
        }
        try {
            this.m_queryMgr.delete(nodeid);
        }
        catch (BridgeTopologyException e) {
            LOG.error("deleteNode: {}", (Object)e.getMessage());
        }
    }

    void rescheduleNodeCollection(int nodeid) {
        LOG.info("rescheduleNodeCollection: suspend collection LinkableNode for node {}", (Object)nodeid);
        Node node = this.getNode(nodeid);
        if (node == null) {
            LOG.warn("rescheduleNodeCollection: node not found: {}", (Object)nodeid);
        } else {
            List<NodeDiscovery> collections = this.getSnmpCollections(node);
            LOG.info("rescheduleNodeCollection: fetched SnmpCollections from scratch, iterating over {} objects to rescheduling", (Object)collections.size());
            for (NodeDiscovery collection : collections) {
                ReadyRunnable rr = this.getReadyRunnable(collection);
                if (rr == null) {
                    LOG.warn("rescheduleNodeCollection: found null ReadyRunnable");
                    continue;
                }
                rr.unschedule();
                rr.schedule();
            }
        }
    }

    void suspendNodeCollection(int nodeid) {
        LOG.info("suspendNodeCollection: suspend collection LinkableNode for node {}", (Object)nodeid);
        Node node = this.getNode(nodeid);
        if (node == null) {
            LOG.warn("suspendNodeCollection: found null ReadyRunnable");
        } else {
            List<NodeDiscovery> collections = this.getSnmpCollections(node);
            LOG.info("suspendNodeCollection: fetched SnmpCollections from scratch, iterating over {} objects to suspend them down", (Object)collections.size());
            for (NodeDiscovery collection : collections) {
                ReadyRunnable rr = this.getReadyRunnable(collection);
                if (rr == null) {
                    LOG.warn("suspendNodeCollection: suspend: node not found: {}", (Object)nodeid);
                    continue;
                }
                rr.suspend();
            }
        }
    }

    private ReadyRunnable getReadyRunnable(ReadyRunnable runnable) {
        LOG.info("getReadyRunnable: getting {} from scheduler", (Object)runnable.getInfo());
        return this.m_scheduler.getReadyRunnable(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Node getNode(int nodeid) {
        List<Node> list = this.m_nodes;
        synchronized (list) {
            for (Node node : this.m_nodes) {
                if (node.getNodeId() != nodeid) continue;
                return node;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node removeNode(int nodeid) {
        List<Node> list = this.m_nodes;
        synchronized (list) {
            Iterator<Node> ite = this.m_nodes.iterator();
            while (ite.hasNext()) {
                Node curNode = ite.next();
                if (curNode.getNodeId() != nodeid) continue;
                ite.remove();
                return curNode;
            }
            return null;
        }
    }

    public EnhancedLinkdService getQueryManager() {
        return this.m_queryMgr;
    }

    public void setQueryManager(EnhancedLinkdService queryMgr) {
        this.m_queryMgr = queryMgr;
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    public EnhancedLinkdConfig getLinkdConfig() {
        return this.m_linkdConfig;
    }

    public void setLinkdConfig(EnhancedLinkdConfig config) {
        this.m_linkdConfig = config;
    }

    public EventForwarder getEventForwarder() {
        return this.m_eventForwarder;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.m_eventForwarder = eventForwarder;
    }

    public String getSource() {
        return LOG_PREFIX;
    }

    public SnmpAgentConfig getSnmpAgentConfig(InetAddress ipaddr, String location) {
        return SnmpPeerFactory.getInstance().getAgentConfig(ipaddr, location);
    }

    public long getInitialSleepTime() {
        return this.m_linkdConfig.getInitialSleepTime();
    }

    public long getRescanInterval() {
        return this.m_linkdConfig.getRescanInterval();
    }

    public long getBridgeTopologyInterval() {
        return this.m_linkdConfig.getBridgeTopologyInterval();
    }

    public int getDiscoveryBridgeThreads() {
        return this.m_linkdConfig.getDiscoveryBridgeThreads();
    }

    public LocationAwareSnmpClient getLocationAwareSnmpClient() {
        return this.m_locationAwareSnmpClient;
    }

    public int getMaxbft() {
        return this.m_linkdConfig.getMaxBft();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean collectBft(int nodeid) {
        if (this.getQueryManager().getUpdateBftMap().size() + this.m_bridgecollectionsscheduled.size() >= this.m_linkdConfig.getMaxBft()) {
            return false;
        }
        Set<Integer> set = this.m_bridgecollectionsscheduled;
        synchronized (set) {
            this.m_bridgecollectionsscheduled.add(nodeid);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void collectedBft(int nodeid) {
        Set<Integer> set = this.m_bridgecollectionsscheduled;
        synchronized (set) {
            this.m_bridgecollectionsscheduled.remove(nodeid);
        }
    }
}

