/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Date;
import java.util.Map;
import org.opennms.core.spring.BeanUtils;
import org.opennms.netmgt.collectd.ForceRescanState;
import org.opennms.netmgt.collectd.OnmsSnmpCollection;
import org.opennms.netmgt.collectd.SnmpCollectionAgent;
import org.opennms.netmgt.collectd.SnmpCollectionSet;
import org.opennms.netmgt.collection.api.AbstractServiceCollector;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionException;
import org.opennms.netmgt.collection.api.CollectionInitializationException;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.InvalidCollectionAgentException;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.config.DataCollectionConfigFactory;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.events.api.EventIpcManagerFactory;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnmpCollector
extends AbstractServiceCollector {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpCollector.class);
    static final String SERVICE_NAME = "SNMP";
    static final char nonAnRepl = '_';
    static final String AnReplEx = "-._";
    static final String IFALIAS_OID = ".1.3.6.1.2.1.31.1.1.1.18";
    static final String SQL_GET_SNMPIFALIASES = "SELECT snmpifalias FROM snmpinterface WHERE nodeid=? AND snmpifindex = ? AND snmpifalias != ''";
    static final String SQL_GET_LATEST_FORCED_RESCAN_EVENTID = "SELECT eventid FROM events WHERE (nodeid=? OR ipaddr=?) AND eventuei='uei.opennms.org/internal/capsd/forceRescan' ORDER BY eventid DESC LIMIT 1";
    static final String SQL_GET_LATEST_RESCAN_COMPLETED_EVENTID = "SELECT eventid FROM events WHERE nodeid=? AND eventuei='uei.opennms.org/internal/capsd/rescanCompleted' ORDER BY eventid DESC LIMIT 1";
    static final String INTERFACES_IFNUMBER = ".1.3.6.1.2.1.2.1";
    static final String NODE_SYSUPTIME = ".1.3.6.1.2.1.1.3";
    public static final String SNMP_STORAGE_PRIMARY = "primary";
    static final String SNMP_STORAGE_ALL = "all";
    static final String SNMP_STORAGE_SELECT = "select";
    static final int DEFAULT_MAX_VARS_PER_PDU = 30;
    static final String SNMP_PEER_KEY = "org.opennms.netmgt.collectd.SnmpCollector.SnmpPeer";
    static final String INTERFACE_COUNT_KEY = "org.opennms.netmgt.collectd.SnmpCollector.ifCount";
    static final String IF_MAP_KEY = "org.opennms.netmgt.collectd.SnmpCollector.ifMap";
    static final String NODE_INFO_KEY = "org.opennms.netmgt.collectd.SnmpCollector.nodeInfo";
    static final String SNMP_STORAGE_KEY = "org.opennms.netmgt.collectd.SnmpCollector.snmpStorage";
    private LocationAwareSnmpClient m_client;

    public String serviceName() {
        return SERVICE_NAME;
    }

    public void initialize() {
        this.initSnmpPeerFactory();
    }

    private void initSnmpPeerFactory() {
        try {
            SnmpPeerFactory.init();
        }
        catch (IOException e) {
            LOG.error("initSnmpPeerFactory: Failed to load SNMP configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    public void validateAgent(CollectionAgent agent, Map<String, Object> parameters) throws CollectionInitializationException {
        ((SnmpCollectionAgent)agent).validateAgent();
    }

    public CollectionSet collect(CollectionAgent agent, Map<String, Object> parameters) throws CollectionException {
        try {
            ServiceParameters params = new ServiceParameters(parameters);
            params.logIfAliasConfig();
            if (this.m_client == null) {
                this.m_client = (LocationAwareSnmpClient)BeanUtils.getBean((String)"daoContext", (String)"locationAwareSnmpClient", LocationAwareSnmpClient.class);
            }
            if (!(agent instanceof SnmpCollectionAgent)) {
                throw new InvalidCollectionAgentException(String.format("Expected agent of type: %s, but got: %s", SnmpCollectionAgent.class.getCanonicalName(), agent.getClass().getCanonicalName()));
            }
            OnmsSnmpCollection snmpCollection = new OnmsSnmpCollection((SnmpCollectionAgent)agent, params, this.m_client);
            EventIpcManager eventProxy = EventIpcManagerFactory.getIpcManager();
            ForceRescanState forceRescanState = new ForceRescanState(agent, (EventProxy)eventProxy);
            SnmpCollectionSet collectionSet = snmpCollection.createCollectionSet((SnmpCollectionAgent)agent);
            collectionSet.setCollectionTimestamp(new Date());
            if (!collectionSet.hasDataToCollect()) {
                LOG.info("agent {} defines no data to collect.  Skipping.", (Object)agent);
            }
            collectionSet.collect();
            if (System.getProperty("org.opennms.netmgt.collectd.SnmpCollector.forceRescan", "false").equalsIgnoreCase("true") && collectionSet.rescanNeeded()) {
                forceRescanState.rescanIndicated();
            } else {
                collectionSet.checkForSystemRestart();
            }
            return collectionSet;
        }
        catch (CollectionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CollectionException("Unexpected error during node SNMP collection for: " + agent.getHostAddress(), t);
        }
    }

    public RrdRepository getRrdRepository(String collectionName) {
        return DataCollectionConfigFactory.getInstance().getRrdRepository(collectionName);
    }
}

