/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgents;
import org.opennms.core.utils.LldpUtils;
import org.opennms.netmgt.enlinkd.EnLinkdBuilderITCase;
import org.opennms.netmgt.model.CdpLink;
import org.opennms.netmgt.model.LldpElement;
import org.opennms.netmgt.model.LldpLink;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.nb.Nms8000NetworkBuilder;

public class Nms8000EnIT
extends EnLinkdBuilderITCase {
    Nms8000NetworkBuilder builder = new Nms8000NetworkBuilder();

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.168.3.1", port=161, resource="classpath:/linkd/nms8000/NMM-R1.snmpwalk.txt"), @JUnitSnmpAgent(host="192.168.2.1", port=161, resource="classpath:/linkd/nms8000/NMM-R2.snmpwalk.txt"), @JUnitSnmpAgent(host="192.168.255.1", port=161, resource="classpath:/linkd/nms8000/NMM-R3.snmpwalk.txt"), @JUnitSnmpAgent(host="192.168.23.10", port=161, resource="classpath:/linkd/nms8000/NMM-SW1.snmpwalk.txt"), @JUnitSnmpAgent(host="192.168.42.10", port=161, resource="classpath:/linkd/nms8000/NMM-SW2.snmpwalk.txt")})
    public void testCdpLinks() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getNMMR1());
        this.m_nodeDao.save((Object)this.builder.getNMMR2());
        this.m_nodeDao.save((Object)this.builder.getNMMR3());
        this.m_nodeDao.save((Object)this.builder.getNMMSW1());
        this.m_nodeDao.save((Object)this.builder.getNMMSW2());
        this.m_nodeDao.flush();
        this.m_linkdConfig.getConfiguration().setUseBridgeDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseCdpDiscovery(Boolean.valueOf(true));
        this.m_linkdConfig.getConfiguration().setUseOspfDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseLldpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseIsisDiscovery(Boolean.valueOf(false));
        Assert.assertTrue((!this.m_linkdConfig.useLldpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkdConfig.useCdpDiscovery());
        Assert.assertTrue((!this.m_linkdConfig.useOspfDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useBridgeDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useIsisDiscovery() ? 1 : 0) != 0);
        OnmsNode nmmr1 = this.m_nodeDao.findByForeignId("linkd", "NMM-R1");
        OnmsNode nmmr2 = this.m_nodeDao.findByForeignId("linkd", "NMM-R2");
        OnmsNode nmmr3 = this.m_nodeDao.findByForeignId("linkd", "NMM-R3");
        OnmsNode nmmsw1 = this.m_nodeDao.findByForeignId("linkd", "NMM-SW1");
        OnmsNode nmmsw2 = this.m_nodeDao.findByForeignId("linkd", "NMM-SW2");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(nmmr1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(nmmr2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(nmmr3.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(nmmsw1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(nmmsw2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(nmmr1.getId().intValue()));
        Assert.assertEquals((long)3L, (long)this.m_cdpLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(nmmr2.getId().intValue()));
        Assert.assertEquals((long)6L, (long)this.m_cdpLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(nmmr3.getId().intValue()));
        Assert.assertEquals((long)9L, (long)this.m_cdpLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(nmmsw1.getId().intValue()));
        Assert.assertEquals((long)11L, (long)this.m_cdpLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(nmmsw2.getId().intValue()));
        Assert.assertEquals((long)13L, (long)this.m_cdpLinkDao.countAll());
        for (OnmsNode node : this.m_nodeDao.findAll()) {
            Assert.assertNotNull((Object)node.getCdpElement());
            Nms8000EnIT.printCdpElement(node.getCdpElement());
        }
        for (CdpLink link : this.m_cdpLinkDao.findAll()) {
            Nms8000EnIT.printCdpLink(link);
            Assert.assertEquals((Object)CdpLink.CiscoNetworkProtocolType.ip, (Object)link.getCdpCacheAddressType());
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.168.3.1", port=161, resource="classpath:/linkd/nms8003/NMM-R1.snmpwalk.txt"), @JUnitSnmpAgent(host="192.168.2.1", port=161, resource="classpath:/linkd/nms8003/NMM-R2.snmpwalk.txt"), @JUnitSnmpAgent(host="192.168.255.1", port=161, resource="classpath:/linkd/nms8003/NMM-R3.snmpwalk.txt"), @JUnitSnmpAgent(host="192.168.23.10", port=161, resource="classpath:/linkd/nms8003/NMM-SW1.snmpwalk.txt"), @JUnitSnmpAgent(host="192.168.42.10", port=161, resource="classpath:/linkd/nms8003/NMM-SW2.snmpwalk.txt")})
    public void testLldpLinks() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getNMMR1());
        this.m_nodeDao.save((Object)this.builder.getNMMR2());
        this.m_nodeDao.save((Object)this.builder.getNMMR3());
        this.m_nodeDao.save((Object)this.builder.getNMMSW1());
        this.m_nodeDao.save((Object)this.builder.getNMMSW2());
        this.m_nodeDao.flush();
        this.m_linkdConfig.getConfiguration().setUseBridgeDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseCdpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseOspfDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseLldpDiscovery(Boolean.valueOf(true));
        this.m_linkdConfig.getConfiguration().setUseIsisDiscovery(Boolean.valueOf(false));
        Assert.assertTrue((boolean)this.m_linkdConfig.useLldpDiscovery());
        Assert.assertTrue((!this.m_linkdConfig.useCdpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useOspfDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useBridgeDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useIsisDiscovery() ? 1 : 0) != 0);
        OnmsNode nmmr1 = this.m_nodeDao.findByForeignId("linkd", "NMM-R1");
        OnmsNode nmmr2 = this.m_nodeDao.findByForeignId("linkd", "NMM-R2");
        OnmsNode nmmr3 = this.m_nodeDao.findByForeignId("linkd", "NMM-R3");
        OnmsNode nmmsw1 = this.m_nodeDao.findByForeignId("linkd", "NMM-SW1");
        OnmsNode nmmsw2 = this.m_nodeDao.findByForeignId("linkd", "NMM-SW2");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(nmmr1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(nmmr2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(nmmr3.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(nmmsw1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(nmmsw2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(nmmr1.getId().intValue()));
        Assert.assertEquals((long)3L, (long)this.m_lldpLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(nmmr2.getId().intValue()));
        Assert.assertEquals((long)6L, (long)this.m_lldpLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(nmmr3.getId().intValue()));
        Assert.assertEquals((long)8L, (long)this.m_lldpLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(nmmsw1.getId().intValue()));
        Assert.assertEquals((long)10L, (long)this.m_lldpLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(nmmsw2.getId().intValue()));
        Assert.assertEquals((long)12L, (long)this.m_lldpLinkDao.countAll());
        for (OnmsNode node : this.m_nodeDao.findAll()) {
            Assert.assertNotNull((Object)node.getLldpElement());
            Nms8000EnIT.printLldpElement(node.getLldpElement());
        }
        for (LldpLink link : this.m_lldpLinkDao.findAll()) {
            Nms8000EnIT.printLldpLink(link);
        }
        List allLinks = this.m_lldpLinkDao.findAll();
        int combinedlinkfound = 0;
        HashSet<Integer> parsed = new HashSet<Integer>();
        for (LldpLink sourceLink : allLinks) {
            Criteria criteria;
            List nodes;
            System.err.println("loadtopology: parsing lldp link with id " + sourceLink.getId());
            if (parsed.contains(sourceLink.getId())) continue;
            parsed.add(sourceLink.getId());
            LldpElement sourceElement = ((OnmsNode)this.m_nodeDao.get((Serializable)sourceLink.getNode().getId())).getLldpElement();
            LldpLink targetLink = null;
            for (LldpLink link : allLinks) {
                boolean bool3;
                if (parsed.contains(link.getId())) continue;
                LldpElement element = ((OnmsNode)this.m_nodeDao.get((Serializable)link.getNode().getId())).getLldpElement();
                if (!sourceLink.getLldpRemChassisId().equals(element.getLldpChassisId()) || !link.getLldpRemChassisId().equals(sourceElement.getLldpChassisId())) continue;
                boolean bool1 = sourceLink.getLldpRemPortId().equals(link.getLldpPortId()) && link.getLldpRemPortId().equals(sourceLink.getLldpPortId());
                boolean bool2 = sourceLink.getLldpRemPortDescr().equals(link.getLldpPortDescr()) && link.getLldpRemPortDescr().equals(sourceLink.getLldpPortDescr());
                boolean bl = bool3 = sourceLink.getLldpRemPortIdSubType() == link.getLldpPortIdSubType() && link.getLldpRemPortIdSubType() == sourceLink.getLldpPortIdSubType();
                if (!bool1 || !bool2 || !bool3) continue;
                targetLink = link;
                parsed.add(targetLink.getId());
                System.err.println("loadtopology: lldp link with id " + link.getId() + " is target.");
                break;
            }
            if (targetLink == null && (nodes = this.m_nodeDao.findMatching(criteria = new Criteria(OnmsNode.class).addRestriction((Restriction)new EqRestriction("sysName", (Object)sourceLink.getLldpRemSysname())))).size() == 1) {
                targetLink = this.reverseLldpLink((OnmsNode)nodes.get(0), sourceLink.getNode().getLldpElement(), sourceLink);
                System.err.println("loadtopology: found using sysname: lldp link with id " + targetLink + " is target.");
            }
            if (targetLink == null) continue;
            ++combinedlinkfound;
        }
        Assert.assertEquals((long)6L, (long)combinedlinkfound);
    }

    private LldpLink reverseLldpLink(OnmsNode sourcenode, LldpElement element, LldpLink link) {
        LldpLink reverseLink = new LldpLink();
        reverseLink.setId(Integer.valueOf(-link.getId().intValue()));
        reverseLink.setNode(sourcenode);
        reverseLink.setLldpLocalPortNum(Integer.valueOf(0));
        reverseLink.setLldpPortId(link.getLldpRemPortId());
        reverseLink.setLldpPortIdSubType(link.getLldpRemPortIdSubType());
        reverseLink.setLldpPortDescr(link.getLldpRemPortDescr());
        if (link.getLldpRemPortIdSubType() == LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_LOCAL) {
            try {
                reverseLink.setLldpPortIfindex(Integer.getInteger(link.getLldpRemPortId()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        reverseLink.setLldpRemChassisId(element.getLldpChassisId());
        reverseLink.setLldpRemChassisIdSubType(element.getLldpChassisIdSubType());
        reverseLink.setLldpRemSysname(element.getLldpSysname());
        reverseLink.setLldpRemPortId(link.getLldpPortId());
        reverseLink.setLldpRemPortIdSubType(link.getLldpPortIdSubType());
        reverseLink.setLldpRemPortDescr(link.getLldpPortDescr());
        reverseLink.setLldpLinkCreateTime(link.getLldpLinkCreateTime());
        reverseLink.setLldpLinkLastPollTime(link.getLldpLinkLastPollTime());
        return reverseLink;
    }
}

