/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.HashMap;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.db.MockDatabase;
import org.opennms.netmgt.config.DatabaseSchemaConfigFactory;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.PollerConfigFactory;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Parameter;
import org.opennms.netmgt.config.poller.Service;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.poller.mock.MockMonitoredService;

@RunWith(value=MockitoJUnitRunner.class)
public class PollerConfigWithPSMIT {
    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
        DatabaseSchemaConfigFactory.init();
        MockNetwork network = new MockNetwork();
        network.setCriticalService("ICMP");
        network.addNode(1, "Router");
        network.addInterface("192.168.1.1");
        network.addService("ICMP");
        network.addService("SMTP");
        network.addInterface("192.168.1.2");
        network.addService("ICMP");
        network.addService("SMTP");
        network.addNode(2, "Server");
        network.addInterface("192.168.1.3");
        network.addService("ICMP");
        network.addService("HTTP");
        network.addNode(3, "Firewall");
        network.addInterface("192.168.1.4");
        network.addService("SMTP");
        network.addService("HTTP");
        network.addInterface("192.168.1.5");
        network.addService("SMTP");
        network.addService("HTTP");
        network.addInterface("192.169.1.5");
        network.addService("SMTP");
        network.addService("HTTP");
        network.addNode(4, "TestNode121");
        network.addInterface("123.12.123.121");
        network.addService("HTTP");
        network.addNode(5, "TestNode122");
        network.addInterface("123.12.123.122");
        network.addService("HTTP");
        MockDatabase db = new MockDatabase();
        db.populate(network);
        DataSourceFactory.setInstance((DataSource)db);
    }

    @After
    public void tearDown() throws Exception {
        MockLogAppender.assertNoWarningsOrGreater();
    }

    @Test
    public void testPSM() throws Exception {
        FileInputStream is = new FileInputStream(new File("src/test/resources/etc/psm-poller-configuration.xml"));
        PollerConfigFactory factory = new PollerConfigFactory(0L, (InputStream)is);
        PollerConfigFactory.setInstance((PollerConfig)factory);
        IOUtils.closeQuietly((InputStream)is);
        ServiceMonitor monitor = PollerConfigFactory.getInstance().getServiceMonitor("MQ_API_DirectRte_v2");
        Assert.assertNotNull((Object)monitor);
        Package pkg = PollerConfigFactory.getInstance().getPackage("MapQuest");
        Assert.assertNotNull((Object)pkg);
        Service svc = PollerConfigFactory.getInstance().getServiceInPackage("MQ_API_DirectRte_v2", pkg);
        Assert.assertNotNull((Object)svc);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (Parameter p : svc.getParameters()) {
            parameters.put(p.getKey(), p.getValue() == null ? p.getAnyObject() : p.getValue());
        }
        PollStatus status = monitor.poll((MonitoredService)new MockMonitoredService(1, "www.mapquest.com", InetAddress.getByName("www.mapquest.com"), "MQ_API_DirectRte_v2"), parameters);
        Assert.assertEquals((long)1L, (long)status.getStatusCode());
    }
}

