/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.collection.test.JUnitCollector;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.TestContextAware;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.collectd.DefaultSnmpCollectionAgent;
import org.opennms.netmgt.collectd.MockServiceCollector;
import org.opennms.netmgt.collectd.SnmpCollectionAgent;
import org.opennms.netmgt.collectd.SnmpCollector;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionStatus;
import org.opennms.netmgt.collection.api.ServiceCollector;
import org.opennms.netmgt.collection.core.CollectionSpecification;
import org.opennms.netmgt.collection.test.api.CollectorTestUtils;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.dao.support.FilesystemResourceStorageDao;
import org.opennms.netmgt.model.NetworkBuilder;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.jrobin.JRobinRrdStrategy;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.opennms.test.mock.MockUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestContext;
import org.springframework.transaction.PlatformTransactionManager;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-mockDao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-pinger.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-proxy-snmp.xml"})
@JUnitConfigurationEnvironment(systemProperties={"org.opennms.rrd.storeByGroup=false"})
@JUnitTemporaryDatabase(reuseDatabase=false)
public class SnmpCollectorWithMibPropertiesIT
implements InitializingBean,
TestContextAware {
    private static final String TEST_NODE_LABEL = "sample.local";
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    private SnmpPeerFactory m_snmpPeerFactory;
    private TestContext m_context;
    private String m_testHostName;
    private CollectionSpecification m_collectionSpecification;
    private SnmpCollectionAgent m_collectionAgent;
    private RrdStrategy<?, ?> m_rrdStrategy;
    private FilesystemResourceStorageDao m_resourceStorageDao;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() throws Exception {
        MockServiceCollector.setDelegate(null);
        MockLogAppender.setupLogging();
        this.m_rrdStrategy = new JRobinRrdStrategy();
        this.m_resourceStorageDao = new FilesystemResourceStorageDao();
        File snmpRrdDirectory = (File)this.m_context.getAttribute("rrdDirectory");
        this.m_resourceStorageDao.setRrdDirectory(snmpRrdDirectory.getParentFile());
        this.m_testHostName = InetAddressUtils.str((InetAddress)InetAddress.getLocalHost());
        OnmsIpInterface iface = null;
        OnmsNode testNode = null;
        List testNodes = this.m_nodeDao.findByLabel(TEST_NODE_LABEL);
        if (testNodes == null || testNodes.size() < 1) {
            NetworkBuilder builder = new NetworkBuilder();
            builder.addNode(TEST_NODE_LABEL).setId(Integer.valueOf(1)).setSysObjectId(".1.3.6.1.4.1.9.1.9999");
            builder.addSnmpInterface(1).setIfName("Fa0/0").setPhysAddr("44:33:22:11:00").setIfType(Integer.valueOf(6)).setCollectionEnabled(true).addIpInterface(this.m_testHostName).setIsSnmpPrimary("P");
            builder.addSnmpInterface(18).setIfName("Se1/0.102").setIfAlias("Conexion Valencia").setIfType(Integer.valueOf(32)).setCollectionEnabled(true).addIpInterface("10.0.0.1").setIsSnmpPrimary("N");
            testNode = builder.getCurrentNode();
            Assert.assertNotNull((Object)testNode);
            this.m_nodeDao.save((Object)testNode);
            this.m_nodeDao.flush();
        } else {
            testNode = (OnmsNode)testNodes.iterator().next();
        }
        Set ifaces = testNode.getIpInterfaces();
        Assert.assertEquals((long)2L, (long)ifaces.size());
        iface = (OnmsIpInterface)ifaces.iterator().next();
        SnmpPeerFactory.setInstance((SnmpPeerFactory)this.m_snmpPeerFactory);
        SnmpCollector collector = new SnmpCollector();
        collector.initialize();
        this.m_collectionSpecification = CollectorTestUtils.createCollectionSpec((String)"SNMP", (ServiceCollector)collector, (String)"default");
        this.m_collectionAgent = DefaultSnmpCollectionAgent.create((Integer)iface.getId(), (IpInterfaceDao)this.m_ipInterfaceDao, (PlatformTransactionManager)this.m_transactionManager);
    }

    @After
    public void tearDown() throws Exception {
        MockUtil.println((String)"------------ End Test --------------------------");
        MockLogAppender.assertNoWarningsOrGreater();
    }

    @Test
    @JUnitCollector(datacollectionType="snmp", datacollectionConfig="/org/opennms/netmgt/config/datacollection-config-NMS8484.xml")
    @JUnitSnmpAgent(resource="/org/opennms/netmgt/snmp/airespace.properties")
    public void testCollect() throws Exception {
        System.setProperty("org.opennms.netmgt.collectd.SnmpCollector.limitCollectionToInstances", "true");
        CollectionSet collectionSet = this.m_collectionSpecification.collect((CollectionAgent)this.m_collectionAgent);
        Assert.assertEquals((String)"collection status", (Object)CollectionStatus.SUCCEEDED, (Object)collectionSet.getStatus());
        CollectorTestUtils.persistCollectionSet(this.m_rrdStrategy, (ResourceStorageDao)this.m_resourceStorageDao, (CollectionSpecification)this.m_collectionSpecification, (CollectionSet)collectionSet);
        Map slot0 = this.m_resourceStorageDao.getStringAttributes(ResourcePath.get((String[])new String[]{"snmp", "1", "bsnAPIfLoadParametersEntry", "132.178.97.20.31.224.0"}));
        Assert.assertEquals((Object)"AP84b2.6111.29ac", slot0.get("bsnAPName"));
        Assert.assertEquals((Object)"0", slot0.get("slotNumber"));
        Map slot1 = this.m_resourceStorageDao.getStringAttributes(ResourcePath.get((String[])new String[]{"snmp", "1", "bsnAPIfLoadParametersEntry", "132.178.97.20.31.224.1"}));
        Assert.assertEquals((Object)"AP84b2.6111.29ac", slot1.get("bsnAPName"));
        Assert.assertEquals((Object)"1", slot1.get("slotNumber"));
    }

    @Test
    @JUnitCollector(datacollectionType="snmp", datacollectionConfig="/org/opennms/netmgt/config/datacollection-config-cisco-qos.xml")
    @JUnitSnmpAgent(resource="/org/opennms/netmgt/snmp/cisco-qos.properties")
    public void testCollectCiscoQoS() throws Exception {
        System.setProperty("org.opennms.netmgt.collectd.SnmpCollector.limitCollectionToInstances", "true");
        CollectionSet collectionSet = this.m_collectionSpecification.collect((CollectionAgent)this.m_collectionAgent);
        Assert.assertEquals((String)"collection status", (Object)CollectionStatus.SUCCEEDED, (Object)collectionSet.getStatus());
        CollectorTestUtils.persistCollectionSet(this.m_rrdStrategy, (ResourceStorageDao)this.m_resourceStorageDao, (CollectionSpecification)this.m_collectionSpecification, (CollectionSet)collectionSet);
        Map map = this.m_resourceStorageDao.getStringAttributes(ResourcePath.get((String[])new String[]{"snmp", "1", "cbQosCMStatsEntry", "290.508801"}));
        Assert.assertEquals((Object)"OUTBOUND-LLQ", map.get("cbQosClassMapPolicy"));
        Assert.assertEquals((Object)"GESTION-ROUTING", map.get("cbQosClassMapName"));
        Assert.assertEquals((Object)"Conexion Valencia", map.get("ifAlias"));
    }

    public void setTestContext(TestContext context) {
        this.m_context = context;
    }
}

